/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.correlation.CorrelationService;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.ObjectCache;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterInternalException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.CacheMap;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSConnectionEvent;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnection;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionMetaDataImpl;
import com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl;
import com.ibm.ws.rsadapter.spi.WSRdbSpiLocalTransactionImpl;
import com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl;
import com.ibm.ws.rsadapter.spi.WSStateManager;
import com.ibm.ws.security.util.AccessController;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import sqlj.runtime.ref.DefaultContext;

public class WSRdbManagedConnectionImpl
implements WSManagedConnection,
FFDCSelfIntrospectable {
    Connection sqlConn;
    private PooledConnection poolConn;
    private Reassociateable[] handlesInUse = new Reassociateable[maxHandlesInUse];
    private int numHandlesInUse;
    boolean mcStale;
    private static int maxHandlesInUse = 15;
    private com.ibm.websphere.j2c.ConnectionEventListener[] ivEventListeners;
    private int numListeners;
    private final int KNOWN_NUMBER_OF_CELS = 1;
    private final int CEL_ARRAY_INCREMENT_SIZE = 3;
    WSManagedConnectionFactoryImpl mcf;
    private WSConnectionEvent connEvent = new WSConnectionEvent(this);
    WSStateManager stateMgr;
    private LocalTransaction localTran;
    private XAResource xares;
    private WSConnectionRequestInfoImpl cri;
    private Subject subject;
    private boolean defaultAutoCommit;
    private boolean currentAutoCommit;
    private String defaultCatalog;
    private Map defaultTypeMap;
    private boolean defaultReadOnly;
    private int currentTransactionIsolation;
    private boolean isolationChanged;
    private boolean connectionPropertyChanged;
    private final DataStoreHelperMetaData mData;
    private CacheMap statementCache;
    private int statementCacheSize;
    private static final ObjectCache objectCache = ObjectCache.get();
    private boolean isStatementCachingEnabled;
    private WSManagedConnectionMetaDataImpl dbMetaData;
    private String databaseType;
    private PrintWriter logWriter;
    static final Object key = new byte[0];
    private J2CPerf pmi;
    private static final Class currClass = class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl == null ? (class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl = WSRdbManagedConnectionImpl.class$("com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl")) : class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl;
    private static final TraceComponent tc = Tr.register((Class)currClass, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private boolean is2Phase;
    boolean ivAlreadyProcessedInteractionPendingEvent;
    private boolean connectionErrorDetected;
    private boolean cleaningUpHandles;
    Object threadID;
    private DefaultContext defContext;
    boolean jdbcTraceEnabled = false;
    boolean supportIsolvlSwitching = false;
    static /* synthetic */ Class class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl;

    public void markMCStale() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"mark mc stale", (Object)this);
        }
        this.mcStale = true;
    }

    public boolean isMCStale() {
        return this.mcStale;
    }

    public WSRdbManagedConnectionImpl(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl, PooledConnection pooledConnection, Connection connection, Subject subject, WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, int n, String string) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{wSManagedConnectionFactoryImpl, AdapterUtil.toString(pooledConnection), AdapterUtil.toString(connection), wSConnectionRequestInfoImpl, new Integer(n), string});
        }
        this.sqlConn = connection;
        this.poolConn = pooledConnection;
        this.mcf = wSManagedConnectionFactoryImpl;
        this.pmi = wSManagedConnectionFactoryImpl.pmi;
        this.cri = wSConnectionRequestInfoImpl;
        this.statementCacheSize = n;
        this.databaseType = string;
        this.is2Phase = pooledConnection instanceof XAConnection;
        this.subject = subject == null ? null : this.copySubject(subject);
        this.ivEventListeners = new com.ibm.websphere.j2c.ConnectionEventListener[1];
        this.numListeners = 0;
        this.logWriter = wSManagedConnectionFactoryImpl.getLogWriter();
        this.threadID = wSManagedConnectionFactoryImpl.detectMultithreadedAccess ? Thread.currentThread() : this.threadID;
        this.mData = wSManagedConnectionFactoryImpl.dataStoreHelper.getMetaData();
        this.initializeConnectionProperties();
        this.synchronizePropertiesWithCRI();
        this.isStatementCachingEnabled = n > 0;
        if (this.isStatementCachingEnabled) {
            this.statementCache = new CacheMap(n);
        }
        this.stateMgr = new WSStateManager();
        this.supportIsolvlSwitching = wSManagedConnectionFactoryImpl.internalHelper.isIsolationLevelSwitchingSupport();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    private final void addHandle(Reassociateable reassociateable) {
        (this.numHandlesInUse < this.handlesInUse.length - 1 ? this.handlesInUse : this.resizeHandleList())[this.numHandlesInUse++] = reassociateable;
    }

    public final WSConnectionRequestInfoImpl createConnectionRequestInfo() throws ResourceException {
        try {
            return this.isolationChanged || this.connectionPropertyChanged ? new WSConnectionRequestInfoImpl(this.cri.ivUserName, this.cri.ivPassword, this.isolationChanged ? this.currentTransactionIsolation : this.cri.ivIsoLevel, this.connectionPropertyChanged && this.mData.supportsGetCatalog() ? this.getCatalog() : this.cri.ivCatalog, this.connectionPropertyChanged && this.mData.supportsIsReadOnly() ? new Boolean(this.isReadOnly()) : this.cri.ivReadOnly, this.connectionPropertyChanged && this.mData.supportsGetTypeMap() ? this.getTypeMap() : this.cri.ivTypeMap, this.cri.isJDBC, this.cri.supportIsolvlSwitching) : this.cri;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".createConnectionRequestInfo"), (String)"379", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
        }
    }

    private void destroyStatement(Object object) {
        block4: {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Statement cache at capacity. Discarding a statement.", (Object)AdapterUtil.toString(object));
                }
                if (this.pmi != null) {
                    this.pmi.statementDiscardedFromCache((Object)this);
                }
                ((Statement)object).close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".discardStatement"), (String)"511", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Error closing statement", (Object)new Object[]{AdapterUtil.toString(object), sQLException});
            }
        }
    }

    final void detectMultithreadedAccess() {
        Thread thread = Thread.currentThread();
        if (thread == this.threadID) {
            return;
        }
        if (this.threadID == null) {
            this.threadID = thread;
        } else {
            this.mcf.detectedMultithreadedAccess = true;
            StringWriter stringWriter = new StringWriter();
            new Error().printStackTrace(new PrintWriter(stringWriter));
            Tr.warning((TraceComponent)tc, (String)"MULTITHREADED_ACCESS_DETECTED", (Object)new Object[]{this, Integer.toHexString(this.threadID.hashCode()) + ' ' + this.threadID, Integer.toHexString(thread.hashCode()) + ' ' + thread, stringWriter.getBuffer().delete(0, "java.lang.Error".length())});
        }
    }

    public final void enforceAutoCommit(boolean bl) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enforceAutoCommit", (Object)new Boolean(bl));
        }
        if (bl != this.currentAutoCommit) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("currentAutoCommit: " + this.currentAutoCommit + " --> " + bl));
            }
            this.sqlConn.setAutoCommit(bl);
            this.currentAutoCommit = bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enforceAutoCommit");
        }
    }

    public final String getCatalog() throws SQLException {
        return this.sqlConn.getCatalog();
    }

    public final DataStoreHelperMetaData getDataStoreHelperMetaData() {
        return this.mData;
    }

    public final boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public final int getHandleCount() {
        return this.numHandlesInUse;
    }

    public final Map getTypeMap() throws SQLException {
        return this.sqlConn.getTypeMap();
    }

    public final boolean inGlobalTransaction() {
        int n = this.stateMgr.transtate;
        return n == 2 || n == 7 || this.ivAlreadyProcessedInteractionPendingEvent && n == 1;
    }

    private void initializeConnectionProperties() throws ResourceException {
        try {
            this.currentAutoCommit = this.defaultAutoCommit = this.sqlConn.getAutoCommit();
            this.defaultCatalog = this.mData.supportsGetCatalog() ? this.sqlConn.getCatalog() : null;
            this.defaultReadOnly = this.mData.supportsIsReadOnly() ? this.sqlConn.isReadOnly() : false;
            this.defaultTypeMap = this.mData.supportsGetTypeMap() ? this.sqlConn.getTypeMap() : null;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".initializeConnectionProperties"), (String)"381", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
        }
    }

    public String[] introspectSelf() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"introspectSelf", (Object)this);
        }
        FFDCLogger fFDCLogger = new FFDCLogger(200, this);
        fFDCLogger.append(this.is2Phase ? "TWO PHASE ENABLED" : "ONE PHASE ENABLED");
        fFDCLogger.append("Database Type:", this.databaseType);
        fFDCLogger.append("Transaction State:", this.getTransactionStateAsString());
        fFDCLogger.append("Statement Cache Size (maximum):", new Integer(this.statementCacheSize));
        fFDCLogger.append("Key:", key);
        fFDCLogger.append("Performance Monitoring Instrumentation:", this.pmi);
        fFDCLogger.append("Log Writer:", this.logWriter);
        fFDCLogger.append("Default AutoCommit:", new Boolean(this.defaultAutoCommit));
        fFDCLogger.append("Current AutoCommit:", new Boolean(this.currentAutoCommit));
        fFDCLogger.append("Current Isolation:", AdapterUtil.getIsolationLevelString(this.currentTransactionIsolation));
        fFDCLogger.append("Support isolation level switching: ", new Boolean(this.supportIsolvlSwitching));
        try {
            fFDCLogger.append("Current Catalog:", this.mData.supportsGetCatalog() ? this.getCatalog() : this.defaultCatalog);
        }
        catch (SQLException sQLException) {
            Tr.warning((TraceComponent)tc, (String)"DSA_ERROR", (Object)new Object[]{sQLException, currClass});
        }
        try {
            fFDCLogger.append("Current readOnly:", new Boolean(this.mData.supportsIsReadOnly() ? this.isReadOnly() : this.defaultReadOnly));
        }
        catch (SQLException sQLException) {
            Tr.warning((TraceComponent)tc, (String)"DSA_ERROR", (Object)new Object[]{sQLException, currClass});
        }
        try {
            fFDCLogger.append("Current TypeMap:", this.mData.supportsGetTypeMap() ? this.getTypeMap() : this.defaultTypeMap);
        }
        catch (SQLException sQLException) {
            Tr.warning((TraceComponent)tc, (String)"DSA_ERROR", (Object)new Object[]{sQLException, currClass});
        }
        fFDCLogger.append("Thread ID:", this.threadID);
        fFDCLogger.append("Already Processed Interaction Pending Event?", this.ivAlreadyProcessedInteractionPendingEvent ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("Underlying Connection Object: " + AdapterUtil.toString(this.sqlConn), this.sqlConn);
        fFDCLogger.append("Underlying PooledConnection Object: " + AdapterUtil.toString(this.poolConn), this.poolConn);
        fFDCLogger.append("SQLJ Default Context: " + AdapterUtil.toString(this.defContext), this.defContext);
        if (this.sqlConn != null) {
            try {
                fFDCLogger.append("Driver version:", this.sqlConn.getMetaData().getDriverVersion());
                fFDCLogger.append("Database version:", this.sqlConn.getMetaData().getDatabaseProductVersion());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        fFDCLogger.append("Connection Event Listeners:");
        for (n = 0; n < this.numListeners; ++n) {
            try {
                fFDCLogger.indent(this.ivEventListeners[n]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        fFDCLogger.eoln();
        fFDCLogger.append("Maximum Handle List Size: " + maxHandlesInUse);
        fFDCLogger.append("Handle Count: " + this.numHandlesInUse);
        fFDCLogger.append("Handles:");
        if (this.handlesInUse != null) {
            try {
                for (n = 0; n < this.handlesInUse.length; ++n) {
                    fFDCLogger.indent(this.handlesInUse[n]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        fFDCLogger.eoln();
        fFDCLogger.introspect("State Manager:", this.stateMgr);
        try {
            if (this.xares instanceof WSRdbXaResourceImpl) {
                ((WSRdbXaResourceImpl)this.xares).introspectThisClassOnly(fFDCLogger);
            } else if (this.xares instanceof WSRdbOnePhaseXaResourceImpl) {
                ((WSRdbOnePhaseXaResourceImpl)((Object)this.xares)).introspectThisClassOnly(fFDCLogger);
            } else {
                fFDCLogger.append("XA Resource:", this.xares);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.localTran == null) {
            fFDCLogger.append("SPI LocalTransaction :", "null");
        } else {
            try {
                ((WSRdbSpiLocalTransactionImpl)this.localTran).introspectThisClassOnly(fFDCLogger);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.dbMetaData == null) {
            fFDCLogger.append("ManagedConnectionMetaData:", "null");
        } else {
            try {
                this.dbMetaData.introspectThisClassOnly(fFDCLogger);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.statementCache == null) {
            fFDCLogger.append("Statement Cache:", "null");
        } else {
            try {
                fFDCLogger.append("Statement Cache:", this.statementCache.display());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        fFDCLogger.introspect("ConnectionRequestInfo", this.cri);
        fFDCLogger.introspect("ManagedConnectionFactory", this.mcf);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"introspectSelf");
        }
        return fFDCLogger.toStringArray();
    }

    public final boolean is2Phase() {
        return this.is2Phase;
    }

    public final boolean isReadOnly() throws SQLException {
        return this.sqlConn.isReadOnly();
    }

    public final boolean isStatementCachingEnabled() {
        return this.isStatementCachingEnabled;
    }

    private static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public void processConnectionClosedEvent(Reassociateable reassociateable) throws ResourceException {
        if (this.cleaningUpHandles) {
            return;
        }
        this.connEvent.recycle(1, null, reassociateable);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Firing CONNECTION CLOSED event for: " + reassociateable), (Object)this);
        }
        try {
            this.removeHandle(reassociateable);
        }
        catch (NullPointerException nullPointerException) {
            if (this.handlesInUse == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"ManagedConnection already closed", (Object)this);
                }
                return;
            }
            throw nullPointerException;
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].connectionClosed((ConnectionEvent)this.connEvent);
        }
    }

    public void processLocalTransactionStartedEvent(Object object) throws ResourceException {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processLocalTransactionStartedEvent", (Object)object);
        }
        if (tc.isDebugEnabled()) {
            object2 = null;
            try {
                object2 = this.mcf.getCorrelator(this.sqlConn);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object)sQLException);
            }
            if (object2 != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append((String)object2);
                if (this.xares != null) {
                    stringBuffer.append(" Transaction : ");
                    stringBuffer.append(this.xares);
                }
                stringBuffer.append(" BEGIN");
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
        }
        if ((object2 = this.stateMgr.isValid(1)) == null) {
            if (this.currentAutoCommit) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"current autocommit is true, set to false");
                    }
                    this.setAutoCommit(false);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".processLocalTransactionStartedEvent"), (String)"550", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                }
            }
        } else {
            throw object2;
        }
        this.stateMgr.transtate = 1;
        this.connEvent.recycle(2, null, object);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Firing LOCAL TRANSACTION STARTED event for: " + object), (Object)this);
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].localTransactionStarted((ConnectionEvent)this.connEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processLocalTransactionStartedEvent", (Object)object);
        }
    }

    public void processLocalTransactionCommittedEvent(Object object) throws ResourceException {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processLocalTransactionCommittedEvent", (Object)object);
        }
        if (tc.isDebugEnabled()) {
            object2 = null;
            try {
                object2 = this.mcf.getCorrelator(this.sqlConn);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object)sQLException);
            }
            if (object2 != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append((String)object2);
                if (this.xares != null) {
                    stringBuffer.append(" Transaction : ");
                    stringBuffer.append(this.xares);
                }
                stringBuffer.append(" COMMIT");
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
        }
        if ((object2 = this.stateMgr.isValid(2)) == null) {
            if (!this.currentAutoCommit) {
                try {
                    this.sqlConn.commit();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.processLocalTransactionCommittedEvent", (String)"554", (Object)this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
            }
        } else {
            throw object2;
        }
        this.stateMgr.transtate = 0;
        this.connEvent.recycle(3, null, object);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Firing LOCAL TRANSACTION COMMITTED event for: " + object), (Object)this);
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].localTransactionCommitted((ConnectionEvent)this.connEvent);
        }
        this.ivAlreadyProcessedInteractionPendingEvent = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processLocalTransactionCommittedEvent");
        }
    }

    public void processLocalTransactionRolledbackEvent(Object object) throws ResourceException {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processLocalTransactionRolledbackEvent");
        }
        if (tc.isDebugEnabled()) {
            object2 = null;
            try {
                object2 = this.mcf.getCorrelator(this.sqlConn);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object)sQLException);
            }
            if (object2 != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append((String)object2);
                if (this.xares != null) {
                    stringBuffer.append(" Transaction : ");
                    stringBuffer.append(this.xares);
                }
                stringBuffer.append(" ROLLBACK");
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
        }
        if ((object2 = this.stateMgr.isValid(3)) == null) {
            if (!this.currentAutoCommit) {
                try {
                    this.sqlConn.rollback();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.processLocalTransactionRolledbackEvent", (String)"595", (Object)this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
            }
        } else {
            throw object2;
        }
        this.stateMgr.transtate = 0;
        this.connEvent.recycle(4, null, object);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Firing LOCAL TRANSACTION ROLLEDBACK event for: " + object), (Object)this);
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].localTransactionRolledback((ConnectionEvent)this.connEvent);
        }
        this.ivAlreadyProcessedInteractionPendingEvent = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processLocalTransactionRolledbackEvent");
        }
    }

    public void processConnectionErrorOccurredEvent(Object object, Exception exception) {
        if (this.connectionErrorDetected) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"CONNECTION_ERROR_OCCURRED event already fired for connection:", (Object)this);
            }
            return;
        }
        this.connectionErrorDetected = true;
        this.closeHandles();
        this.connEvent.recycle(5, exception, object);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Firing CONNECTION_ERROR_OCCURRED event for handle: " + object), (Object)this);
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].connectionErrorOccurred((ConnectionEvent)this.connEvent);
        }
    }

    public void processInteractionPendingEvent(Object object) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processInteractionPendingEvent", (Object)object);
        }
        if (tc.isDebugEnabled()) {
            String string = null;
            try {
                string = this.mcf.getCorrelator(this.sqlConn);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object)sQLException);
            }
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append(string);
                if (this.xares != null) {
                    stringBuffer.append(" Transaction : ");
                    stringBuffer.append(this.xares);
                    stringBuffer.append(" BEGIN");
                }
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
        }
        if (this.ivAlreadyProcessedInteractionPendingEvent) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"INTERACTION_PENDING event already fired for connection:", (Object)this);
            }
            return;
        }
        this.connEvent.recycle(900, null, object);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Firing INTERACTION PENDING event for: " + object), (Object)this);
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].interactionPending((ConnectionEvent)this.connEvent);
        }
        boolean bl = this.ivAlreadyProcessedInteractionPendingEvent = this.ivAlreadyProcessedInteractionPendingEvent || this.stateMgr.transtate != 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processInteractionPendingEvent");
        }
    }

    private final boolean removeHandle(Reassociateable reassociateable) {
        int n = this.numHandlesInUse;
        while (n > 0) {
            if (reassociateable != this.handlesInUse[--n]) continue;
            this.handlesInUse[n] = this.handlesInUse[--this.numHandlesInUse];
            this.handlesInUse[this.numHandlesInUse] = null;
            return true;
        }
        return false;
    }

    private void replaceCRI(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"replaceCRI", (Object)new Object[]{"Current:", this.cri, "New:", wSConnectionRequestInfoImpl});
        }
        if (this.numHandlesInUse > 0 || !this.cri.hasSameUserAndPassword(wSConnectionRequestInfoImpl)) {
            if (this.numHandlesInUse > 0) {
                DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be changed on a ManagedConnection with active handles.", "\nExisting CRI: " + this.cri, "\nRequested CRI: " + wSConnectionRequestInfoImpl}, null, this.getClass());
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"replaceCRI", (Object)((Object)dataStoreAdapterException));
                }
                throw dataStoreAdapterException;
            }
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be changed because the users or passwords do not match.", "\nExisting CRI: " + this.cri, "\nRequested CRI: " + wSConnectionRequestInfoImpl}, null, this.getClass());
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"replaceCRI", (Object)((Object)dataStoreAdapterException));
            }
            throw dataStoreAdapterException;
        }
        this.cri = wSConnectionRequestInfoImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"replaceCRI");
        }
    }

    private void replaceCRIForCCI(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"replaceCRIForCCI", (Object)new Object[]{"Current:", this.cri, "New:", wSConnectionRequestInfoImpl});
        }
        if (this.numHandlesInUse > 0 && !this.supportIsolvlSwitching) {
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be changed on a ManagedConnection with active handles.", "\nExisting CRI: " + this.cri, "\nRequested CRI: " + wSConnectionRequestInfoImpl}, null, this.getClass());
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"replaceCRIForCCI", (Object)((Object)dataStoreAdapterException));
            }
            throw dataStoreAdapterException;
        }
        this.cri = wSConnectionRequestInfoImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"replaceCRIForCCI");
        }
    }

    private Reassociateable[] resizeHandleList() {
        this.handlesInUse = new Reassociateable[maxHandlesInUse > this.numHandlesInUse ? maxHandlesInUse : (maxHandlesInUse = this.numHandlesInUse * 2)];
        System.arraycopy(this.handlesInUse, 0, this.handlesInUse, 0, this.numHandlesInUse);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Handle limit increased to: " + maxHandlesInUse));
        }
        return this.handlesInUse;
    }

    private void synchronizePropertiesWithCRI() throws ResourceException {
        int n = -1;
        try {
            this.isolationChanged = false;
            this.connectionPropertyChanged = false;
            if (tc.isDebugEnabled()) {
                n = this.getTransactionIsolation();
            }
            if (this.currentTransactionIsolation != this.cri.ivIsoLevel) {
                this.setTransactionIsolation(this.cri.ivIsoLevel);
            }
            if (this.cri.ivCatalog != null && this.defaultCatalog != this.cri.ivCatalog && this.mData.supportsGetCatalog()) {
                this.setCatalog(this.cri.ivCatalog);
            }
            if (this.cri.ivReadOnly != null && this.defaultReadOnly != this.cri.ivReadOnly && this.mData.supportsIsReadOnly()) {
                this.setReadOnly(this.cri.ivReadOnly);
            }
            if (this.cri.ivTypeMap != null && this.defaultTypeMap != this.cri.ivTypeMap && this.mData.supportsGetTypeMap()) {
                this.setTypeMap(this.cri.ivTypeMap);
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".synchronizePropertiesWithCRI"), (String)"850", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"previous/current value:", (Object)new Object[]{"AutoCommit: " + this.currentAutoCommit + "/" + this.currentAutoCommit, "Isolation:  " + AdapterUtil.getIsolationLevelString(n) + "/" + AdapterUtil.getIsolationLevelString(this.currentTransactionIsolation), "Catalog:    " + this.defaultCatalog + "/" + (this.cri.ivCatalog == null ? this.defaultCatalog : this.cri.ivCatalog), "IsReadOnly: " + this.defaultReadOnly + "/" + (this.cri.ivReadOnly == null ? new Boolean(this.defaultReadOnly) : this.cri.ivReadOnly), "TypeMap:    " + this.defaultTypeMap + "/" + (this.cri.ivTypeMap == null ? this.defaultTypeMap : this.cri.ivTypeMap)});
        }
    }

    public final Object getStatement(StatementCacheKey statementCacheKey) {
        return this.statementCache.remove(statementCacheKey);
    }

    public final Object call(String string, Object[] objectArray, Class[] classArray, WSJdbcObject wSJdbcObject) throws SQLException {
        return WSJdbcUtil.call((Object)this.poolConn, string, objectArray, classArray, wSJdbcObject);
    }

    public final void cacheStatement(Statement statement, StatementCacheKey statementCacheKey) {
        Object object;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"cacheStatement", (Object)new Object[]{AdapterUtil.toString(statement), statementCacheKey});
        }
        if ((object = this.statementCache.add(statementCacheKey, statement)) != null) {
            this.destroyStatement(object);
        }
    }

    public final WSManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.mcf;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)new Object[]{this, subject == null ? null : "Subject is not null.", AdapterUtil.toString(connectionRequestInfo)});
        }
        if (this.mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale");
            }
            throw new DataStoreAdapterException("INVALID_CONNECTION", (Throwable)new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION")), class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl == null ? (class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl = WSRdbManagedConnectionImpl.class$("com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl")) : class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl);
        }
        int n = this.stateMgr.transtate;
        if (n != 1 && n != 2 && n != 7 && n != 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection - bad transaction state, throwing exception", (Object)this.getTransactionStateAsString());
            }
            String string = "Operation 'getConnection' is not permitted for transaction state: " + this.getTransactionStateAsString();
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", string, null, currClass);
            FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"939", (Object)this, (Object[])new Object[]{string, ". Possible components: Connection Manager"});
            throw dataStoreAdapterException;
        }
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = (WSConnectionRequestInfoImpl)connectionRequestInfo;
        if (!this.supportIsolvlSwitching) {
            if (!this.cri.equals(wSConnectionRequestInfoImpl)) {
                this.replaceCRI(wSConnectionRequestInfoImpl);
            }
        } else {
            this.replaceCRIForCCI(wSConnectionRequestInfoImpl);
        }
        if (this.numHandlesInUse == 0) {
            this.synchronizePropertiesWithCRI();
            if (PmiReqMetrics.isPassCorrelatorToDB() && this.stateMgr.getState() == 0) {
                this.mcf.internalHelper.setEwlmCorrelator(CorrelationService.getEwlmCorrelator(), this.sqlConn);
            }
        } else if (this.supportIsolvlSwitching && this.currentTransactionIsolation != this.cri.ivIsoLevel) {
            try {
                this.setTransactionIsolation(this.cri.ivIsoLevel);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".getConnection"), (String)"1867", (Object)this);
                throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
            }
        }
        Reassociateable reassociateable = wSConnectionRequestInfoImpl.isJDBC ? this.mcf.internalHelper.createJDBCConnectionWrapper(this) : objectCache.getCCIConnectionHandle(this, this.sqlConn, key);
        this.addHandle(reassociateable);
        try {
            this.jdbcTraceEnabled = this.mcf.internalHelper.enableJdbcTraceIfnecessary(this.sqlConn);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.getConnection", (String)"1621", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"setJCCLogWriter()", sQLException, ""});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)reassociateable);
        }
        return reassociateable;
    }

    public void destroy() throws ResourceException {
        ResourceException resourceException;
        block19: {
            DataStoreAdapterException dataStoreAdapterException;
            block18: {
                block17: {
                    block16: {
                        if (tc.isEntryEnabled()) {
                            Tr.entry((TraceComponent)tc, (String)"destroy", (Object)this);
                        }
                        resourceException = null;
                        try {
                            this.cleanupTransactions();
                            this.cleanupStates();
                        }
                        catch (ResourceException resourceException2) {
                            FFDCFilter.processException((Throwable)resourceException2, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", (String)"957", (Object)this);
                            Tr.warning((TraceComponent)tc, (String)"DSTRY_ERROR_EX", (Object)((Object)resourceException2));
                            if (resourceException != null) break block16;
                            resourceException = resourceException2;
                        }
                    }
                    ResourceException resourceException3 = this.closeHandles();
                    ResourceException resourceException4 = resourceException = resourceException == null ? resourceException3 : resourceException;
                    if (this.statementCache != null) {
                        this.clearStatementCache();
                    }
                    if (this.sqlConn != null) {
                        try {
                            this.sqlConn.close();
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", (String)"1005", (Object)this);
                            dataStoreAdapterException = new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                            if (resourceException != null) break block17;
                            resourceException = dataStoreAdapterException;
                        }
                    }
                }
                if (this.defContext != null) {
                    try {
                        this.mcf.internalHelper.closeDefaultContext(this.defContext);
                    }
                    catch (ResourceException resourceException5) {
                        FFDCFilter.processException((Throwable)resourceException5, (String)(this.getClass().getName() + ".destroy"), (String)"1439", (Object)this);
                        if (resourceException != null) break block18;
                        resourceException = resourceException5;
                    }
                }
            }
            if (this.poolConn != null) {
                try {
                    this.poolConn.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", (String)"1024", (Object)this);
                    dataStoreAdapterException = new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                    if (resourceException != null) break block19;
                    resourceException = dataStoreAdapterException;
                }
            }
        }
        this.defaultCatalog = null;
        this.defaultTypeMap = null;
        this.dbMetaData = null;
        this.handlesInUse = null;
        this.mcf = null;
        this.ivEventListeners = null;
        this.localTran = null;
        this.xares = null;
        this.cri = null;
        this.subject = null;
        this.sqlConn = null;
        this.poolConn = null;
        this.statementCache = null;
        this.pmi = null;
        this.defContext = null;
        if (resourceException != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"destroy - throwing exception caught during destroy() processing");
            }
            throw resourceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public void dissociateHandle(Reassociateable reassociateable) {
        if (!this.cleaningUpHandles && !this.removeHandle(reassociateable) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unable to dissociate Connection handle with current ManagedConnection because it is not currently associated with the ManagedConnection.", (Object)new Object[]{reassociateable, this});
        }
    }

    private ResourceException dissociateHandles() {
        DataStoreAdapterException dataStoreAdapterException = null;
        this.cleaningUpHandles = true;
        int n = this.numHandlesInUse;
        while (n > 0) {
            try {
                this.handlesInUse[--n].dissociate();
                this.handlesInUse[n] = null;
            }
            catch (ResourceException resourceException) {
                DataStoreAdapterException dataStoreAdapterException2;
                if (resourceException.getErrorCode().equals("HANDLE_IN_USE")) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Unable to dissociate handle because it is doing work in the database.  Closing it instead.");
                        }
                        ((WSJdbcConnection)this.handlesInUse[n]).close();
                        dataStoreAdapterException2 = null;
                    }
                    catch (SQLException sQLException) {
                        dataStoreAdapterException2 = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", sQLException, sQLException, currClass);
                    }
                }
                if (dataStoreAdapterException2 == null) continue;
                FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException2), (String)(currClass.getName() + ".dissociateHandles"), (String)"1225", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Error dissociating handle. Continuing...", (Object)this.handlesInUse[n]);
                }
                if (dataStoreAdapterException != null) continue;
                dataStoreAdapterException = dataStoreAdapterException2;
            }
        }
        this.numHandlesInUse = 0;
        this.cleaningUpHandles = false;
        return dataStoreAdapterException;
    }

    public final void cleanup() throws ResourceException {
        ResourceException resourceException;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"cleanup", (Object)this);
            }
            resourceException = this.numHandlesInUse < 1 || this.connectionErrorDetected ? null : this.dissociateHandles();
            try {
                this.cleanupTransactions();
            }
            catch (ResourceException resourceException2) {
                if (resourceException != null) break block6;
                resourceException = resourceException2;
            }
        }
        this.threadID = null;
        if (resourceException != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cleanup", (Object)((Object)resourceException));
            }
            throw resourceException;
        }
        this.cleanupStates();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup");
        }
    }

    private void cleanupStates() throws ResourceException {
        boolean bl;
        this.stateMgr.transtate = 0;
        try {
            if (this.jdbcTraceEnabled) {
                this.mcf.internalHelper.disableJdbcTraceIfnecessary(this.sqlConn);
                this.jdbcTraceEnabled = false;
            }
            bl = PmiReqMetrics.isPassCorrelatorToDB() || this.mcf.resetConnectionByDB2 ? this.mcf.internalHelper.resetConnection(this.sqlConn) : this.mcf.dataStoreHelper.doConnectionCleanup(this.sqlConn);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".cleanupStates"), (String)"1298", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", sQLException, class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl == null ? (class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl = WSRdbManagedConnectionImpl.class$("com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl")) : class$com$ibm$ws$rsadapter$spi$WSRdbManagedConnectionImpl);
        }
        if (this.connectionPropertyChanged || bl) {
            if (this.mData.supportsIsReadOnly()) {
                try {
                    this.setReadOnly(this.defaultReadOnly);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".cleanupStates"), (String)"1226", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                }
            }
            if (this.mData.supportsGetCatalog()) {
                try {
                    this.setCatalog(this.defaultCatalog);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".cleanupStates"), (String)"1227", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                }
            }
            if (this.mData.supportsGetTypeMap()) {
                try {
                    this.setTypeMap(this.defaultTypeMap);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".cleanupStates"), (String)"1228", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                }
            }
            this.connectionPropertyChanged = false;
            if (bl) {
                try {
                    this.currentAutoCommit = this.sqlConn.getAutoCommit();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".cleanupStates"), (String)"1308", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                }
                try {
                    this.currentTransactionIsolation = this.sqlConn.getTransactionIsolation();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".cleanupStates"), (String)"1318", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                }
            }
        }
        this.ivAlreadyProcessedInteractionPendingEvent = false;
    }

    private void cleanupTransactions() throws ResourceException {
        switch (this.stateMgr.transtate) {
            case 2: {
                try {
                    ((WSRdbXaResourceImpl)this.xares).end();
                }
                catch (XAException xAException) {
                    // empty catch block
                }
                try {
                    ((WSRdbXaResourceImpl)this.xares).rollback();
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"1200", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Failed to end or rollback XAResource during cleanup from failure state. Continuing with cleanup.", (Object)AdapterUtil.getXAExceptionCodeString(xAException.errorCode));
                    }
                    throw new DataStoreAdapterException("DSA_ERROR", xAException, currClass);
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Cleanup should not be invoked while ManagedConnection is still in a transaction. Continuing with cleanup.");
                }
                String string = "Cannot call 'cleanup' on a ManagedConnection while it is still in a transaction.";
                DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", string, null, currClass);
                FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"1562", (Object)this, (Object[])new Object[]{string, " Possible components: Connection Manager, Transactions"});
                throw dataStoreAdapterException;
            }
            case 1: 
            case 4: 
            case 7: {
                if (!this.currentAutoCommit) {
                    try {
                        this.sqlConn.rollback();
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"1223", (Object)this);
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Connection rollback failed. Continuing with cleanup.");
                        }
                        throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                    }
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Cleanup should not be invoked while ManagedConnection is still in a transaction. Continuing with cleanup.");
                }
                String string = "Cannot call 'cleanup' on a ManagedConnection while it is still in a transaction.";
                DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", string, null, currClass);
                FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"1592", (Object)this, (Object[])new Object[]{string, " Possible components: Connection Manager"});
                throw dataStoreAdapterException;
            }
        }
    }

    public final void clearStatementCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clearStatementCache");
        }
        Object[] objectArray = this.statementCache.removeAll();
        int n = objectArray.length;
        while (n > 0) {
            try {
                ((Statement)objectArray[--n]).close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".clearStatementCache"), (String)"2169", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Error closing statement", (Object)sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearStatementCache");
        }
    }

    private ResourceException closeHandles() {
        ResourceException resourceException = null;
        Reassociateable reassociateable = null;
        this.cleaningUpHandles = true;
        int n = this.numHandlesInUse;
        while (n > 0) {
            reassociateable = this.handlesInUse[--n];
            this.handlesInUse[n] = null;
            if (reassociateable instanceof WSJdbcConnection) {
                try {
                    ((WSJdbcConnection)reassociateable).close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)(currClass.getName() + ".closeHandles"), (String)"1414", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Error closing handle. Continuing...", (Object)reassociateable);
                    }
                    DataStoreAdapterException dataStoreAdapterException = new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
                    if (resourceException != null) continue;
                    resourceException = dataStoreAdapterException;
                }
                continue;
            }
            try {
                ((WSRdbConnectionImpl)reassociateable).close();
            }
            catch (ResourceException resourceException2) {
                FFDCFilter.processException((Throwable)resourceException2, (String)(currClass.getName() + ".closeHandles"), (String)"1822", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Error closing handle. Continuing...", (Object)reassociateable);
                }
                if (resourceException != null) continue;
                resourceException = resourceException2;
            }
        }
        this.numHandlesInUse = 0;
        this.cleaningUpHandles = false;
        return resourceException;
    }

    private Subject copySubject(final Subject subject) throws ResourceException {
        try {
            return (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Subject(subject.isReadOnly(), subject.getPrincipals(), subject.getPublicCredentials(), subject.getPrivateCredentials());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.copySubject", (String)"1796", (Object)this);
            throw (ResourceException)((Object)privilegedActionException.getException());
        }
    }

    public void associateConnection(Object object) throws ResourceException {
        Reassociateable reassociateable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"associateConnection", (Object)new Object[]{this, object});
        }
        try {
            reassociateable = (Reassociateable)object;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.associateConnection", (String)"1398", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to cast Connection handle to Reassociateable", (Object)new Object[]{AdapterUtil.toString(object), classCastException});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associateConnection - failed casting connection, throwing exception");
            }
            throw new DataStoreAdapterInternalException("WS_INTERNAL_ERROR", new Object[]{"Called \"associateConnection\" with a connection type that is not recognized " + object.getClass().getName(), classCastException}, "Called \"associateConnection\" with a connection type that is not recognized " + object.getClass().getName());
        }
        try {
            WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl;
            int n;
            WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = (WSRdbManagedConnectionImpl)reassociateable.getManagedConnection(key);
            int n2 = n = wSRdbManagedConnectionImpl == null ? 0 : wSRdbManagedConnectionImpl.stateMgr.transtate;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Old ManagedConnection transaction state:", (Object)(wSRdbManagedConnectionImpl == null ? null : wSRdbManagedConnectionImpl.getTransactionStateAsString()));
                Tr.debug((TraceComponent)tc, (String)"New ManagedConnection transaction state:", (Object)this.getTransactionStateAsString());
            }
            if (!(n != 2 && n != 7 && n != 1 || reassociateable.isReserved())) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Reassociation requested within a transaction; handle reassociation will be ignored.");
                }
                reassociateable.reserve(key);
                wSRdbManagedConnectionImpl.dissociateHandle(reassociateable);
                wSConnectionRequestInfoImpl = (WSConnectionRequestInfoImpl)reassociateable.getCRI();
            } else {
                if (reassociateable.getState() == 0) {
                    reassociateable.dissociate();
                }
                wSConnectionRequestInfoImpl = (WSConnectionRequestInfoImpl)reassociateable.getCRI();
                reassociateable.reassociate((ManagedConnection)this, this.sqlConn, key);
            }
            if (!this.cri.equals(wSConnectionRequestInfoImpl)) {
                this.replaceCRI(wSConnectionRequestInfoImpl);
            }
            if (this.numHandlesInUse == 0) {
                this.synchronizePropertiesWithCRI();
            }
            this.addHandle(reassociateable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associateConnection");
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.associateConnection", (String)"1981", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associateConnection", (Object)"Exception");
            }
            throw resourceException;
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addConnectionEventListener", (Object)new Object[]{this, connectionEventListener});
        }
        if (connectionEventListener == null) {
            throw new NullPointerException("Cannot add null ConnectionEventListener.");
        }
        if (this.numListeners >= this.ivEventListeners.length) {
            com.ibm.websphere.j2c.ConnectionEventListener[] connectionEventListenerArray = this.ivEventListeners;
            this.ivEventListeners = new com.ibm.websphere.j2c.ConnectionEventListener[this.numListeners + 3];
            System.arraycopy(connectionEventListenerArray, 0, this.ivEventListeners, 0, connectionEventListenerArray.length);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("received more ConnectionEventListeners than expected, increased array size to " + this.ivEventListeners.length));
            }
        }
        this.ivEventListeners[this.numListeners++] = (com.ibm.websphere.j2c.ConnectionEventListener)connectionEventListener;
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeConnectionEventListener", (Object)connectionEventListener);
        }
        if (connectionEventListener == null) {
            NullPointerException nullPointerException = new NullPointerException("Cannot remove null ConnectionEventListener.");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeConnectionEventListener", (Object)nullPointerException);
            }
            throw nullPointerException;
        }
        for (int i = 0; i < this.numListeners; ++i) {
            if (connectionEventListener != this.ivEventListeners[i]) continue;
            this.ivEventListeners[i] = this.ivEventListeners[--this.numListeners];
            this.ivEventListeners[this.numListeners] = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeConnectionEventListener");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeConnectionEventListener", (Object)"Listener not found for remove.");
        }
    }

    public XAResource getXAResource() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getXAResource", (Object)this);
        }
        if (this.xares != null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Returning existing XAResource", (Object)this.xares);
            }
        } else if (this.is2Phase) {
            try {
                XAResource xAResource = ((XAConnection)this.poolConn).getXAResource();
                this.xares = new WSRdbXaResourceImpl(xAResource, this);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.getXAResource", (String)"1638", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getXAResource - failed trying to create XAResource, throwing exception");
                }
                throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
            }
        } else {
            this.xares = new WSRdbOnePhaseXaResourceImpl(this.sqlConn, this.databaseType, this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getXAResource");
        }
        return this.xares;
    }

    public final LocalTransaction getLocalTransaction() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalTransaction", (Object)this);
        }
        WSRdbSpiLocalTransactionImpl wSRdbSpiLocalTransactionImpl = this.localTran = this.localTran == null ? new WSRdbSpiLocalTransactionImpl(this, this.sqlConn) : this.localTran;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalTransaction", (Object)this.localTran);
        }
        return this.localTran;
    }

    public final int getTransactionState() {
        return this.stateMgr.transtate;
    }

    public final WSStateManager getStateManager() {
        return this.stateMgr;
    }

    public final String getTransactionStateAsString() {
        return this.stateMgr.getStateAsString();
    }

    public final ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.dbMetaData == null ? (this.dbMetaData = new WSManagedConnectionMetaDataImpl(this.sqlConn, this)) : this.dbMetaData;
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (printWriter != this.logWriter) {
            throw new DataStoreAdapterInternalException("ManagedConnection.setLogWriter is not supported.");
        }
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public final boolean getAutoCommit() {
        return this.currentAutoCommit;
    }

    public final void setAutoCommit(boolean bl) throws SQLException {
        if (bl != this.currentAutoCommit) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set AutoCommit to " + bl));
            }
            this.currentAutoCommit = bl;
            this.sqlConn.setAutoCommit(this.currentAutoCommit);
        }
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        if (this.currentTransactionIsolation != n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set Isolation Level to " + AdapterUtil.getIsolationLevelString(n)));
            }
            this.isolationChanged = true;
            this.currentTransactionIsolation = n;
            this.sqlConn.setTransactionIsolation(this.currentTransactionIsolation);
        }
    }

    public final int getTransactionIsolation() {
        return this.currentTransactionIsolation;
    }

    public final void setCatalog(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set Catalog to " + string));
        }
        this.sqlConn.setCatalog(string);
        this.connectionPropertyChanged = true;
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set readOnly to " + bl));
        }
        this.sqlConn.setReadOnly(bl);
        this.connectionPropertyChanged = true;
    }

    public final WSConnectionRequestInfoImpl getCRI() {
        return this.cri;
    }

    public final Subject getSubject() {
        return this.subject;
    }

    public final void setTypeMap(Map map) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set TypeMap to " + map));
        }
        this.sqlConn.setTypeMap(map);
        this.connectionPropertyChanged = true;
    }

    public final DefaultContext getConnectionContext() throws SQLException {
        if (this.defContext == null) {
            try {
                this.defContext = new DefaultContext(this.sqlConn);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.getConnectionContext", (String)"2491", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getConnectionContext - failed trying to create SQLJ ConnectionContext, throwing exception");
                }
                throw sQLException;
            }
        }
        return this.defContext;
    }

    public void preTestConnection() throws ResourceException {
        block21: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"preTestConnection", (Object)new Object[]{this, "preTestSQLString: " + (this.mcf.preTestSQLString == null ? "null" : "\"" + this.mcf.preTestSQLString + "\"")});
            }
            String string = null;
            if (this.mcf.preTestSQLString == null || this.mcf.preTestSQLString.equals("") || this.mcf.preTestSQLString.trim().equals("")) {
                string = "SELECT 1 FROM TABLE1";
                Tr.warning((TraceComponent)tc, (String)"NO_EMPTY_PRE_TEST_SQL_STRING");
            } else {
                string = this.mcf.preTestSQLString;
            }
            Statement statement = null;
            try {
                statement = this.sqlConn.createStatement();
                statement.execute(string);
                if (!this.currentAutoCommit) {
                    this.sqlConn.rollback();
                }
                statement.close();
                statement = null;
                this.mcf.dataStoreHelper.doConnectionCleanup(this.sqlConn);
                this.sqlConn.clearWarnings();
            }
            catch (SQLException sQLException) {
                block20: {
                    SQLException sQLException2;
                    block19: {
                        block18: {
                            SQLException sQLException3 = this.mcf.dataStoreHelper.mapException(sQLException);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"preTestConnection", (Object)new Object[]{AdapterUtil.getStackTraceWithState(sQLException3)});
                            }
                            if (sQLException3 instanceof StaleConnectionException) {
                                throw new DataStoreAdapterException("DSA_ERROR", sQLException3, currClass);
                            }
                            if (!this.currentAutoCommit) {
                                try {
                                    this.sqlConn.rollback();
                                }
                                catch (SQLException sQLException4) {
                                    sQLException2 = this.mcf.dataStoreHelper.mapException(sQLException4);
                                    if (!(sQLException2 instanceof StaleConnectionException)) break block18;
                                    throw new DataStoreAdapterException("DSA_ERROR", sQLException2, currClass);
                                }
                            }
                        }
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                        catch (SQLException sQLException5) {
                            sQLException2 = this.mcf.dataStoreHelper.mapException(sQLException5);
                            if (!(sQLException2 instanceof StaleConnectionException)) break block19;
                            throw new DataStoreAdapterException("DSA_ERROR", sQLException2, currClass);
                        }
                    }
                    try {
                        this.mcf.dataStoreHelper.doConnectionCleanup(this.sqlConn);
                    }
                    catch (SQLException sQLException6) {
                        sQLException2 = this.mcf.dataStoreHelper.mapException(sQLException6);
                        if (!(sQLException2 instanceof StaleConnectionException)) break block20;
                        throw new DataStoreAdapterException("DSA_ERROR", sQLException2, currClass);
                    }
                }
                try {
                    this.sqlConn.clearWarnings();
                }
                catch (SQLException sQLException7) {
                    SQLException sQLException8 = this.mcf.dataStoreHelper.mapException(sQLException7);
                    if (!(sQLException8 instanceof StaleConnectionException)) break block21;
                    throw new DataStoreAdapterException("DSA_ERROR", sQLException8, currClass);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

