/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util.entity;

import com.ibm.xml.b2b.util.CharArrayStringBuffer;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;
import com.ibm.xml.b2b.util.entity.CharArrayParsedEntity;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import com.ibm.xml.b2b.util.entity.ParsedEntityRecognizer;
import java.io.InputStream;
import java.io.Reader;

public final class CharArrayParsedEntityFactory
extends ParsedEntityRecognizer
implements ParsedEntityFactory {
    private static final int FREE_ENTITY_COUNT = 8;
    private int fFreeEntityCount;
    private ParsedEntity[] fFreeEntities = new ParsedEntity[8];
    private ParsedEntity fEntityContent;
    private EntityInputSource fStringSource;

    public CharArrayParsedEntityFactory(boolean bl) {
        super(bl);
    }

    public void reset(boolean bl) {
        super.reset(bl);
        if (!bl) {
            while (this.fFreeEntityCount > 0) {
                --this.fFreeEntityCount;
                this.fFreeEntities[this.fFreeEntityCount] = null;
            }
            if (this.fStringSource != null) {
                this.fStringSource = null;
            }
        }
    }

    public ParsedEntity createParsedEntity(EntityInputSource entityInputSource, boolean bl) {
        this.fEntityContent = this.fFreeEntityCount > 0 ? this.fFreeEntities[--this.fFreeEntityCount] : new CharArrayParsedEntity(this);
        this.fEntityContent.clear();
        if (!super.setSource(entityInputSource, bl, true)) {
            return null;
        }
        return this.fEntityContent;
    }

    public ParsedEntity createParsedEntity(XMLString xMLString) {
        if (this.fStringSource == null) {
            this.fStringSource = new EntityInputSource();
        }
        this.fStringSource.setContent(xMLString);
        this.fEntityContent = this.fFreeEntityCount > 0 ? this.fFreeEntities[--this.fFreeEntityCount] : new CharArrayParsedEntity(this);
        this.fEntityContent.clear();
        if (!super.setSource(this.fStringSource, false, false)) {
            return null;
        }
        return this.fEntityContent;
    }

    public void releaseParsedEntity(ParsedEntity parsedEntity) {
        super.releaseCharacters(parsedEntity.chars);
        if (this.fFreeEntityCount < 8) {
            this.fFreeEntities[this.fFreeEntityCount++] = parsedEntity;
        }
    }

    public XMLStringBuffer createStringBuffer() {
        return new CharArrayStringBuffer();
    }

    protected XMLString getEntityContent() {
        return this.fEntityContent;
    }

    protected boolean setCharacterStreamSource(Reader reader) {
        return super.readCharacterStream(reader);
    }

    protected boolean setByteStreamSource(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStreamToUTF16(inputStream, encodingSupport, true);
    }

    protected boolean setByteArraySource(byte[] byArray, int n, int n2, EncodingSupport encodingSupport) {
        return super.convertBytesToUTF16(byArray, n, n2, encodingSupport);
    }

    protected boolean setCharArraySource(char[] cArray, int n, int n2) {
        this.fEntityContent.setValues(cArray, n, n2);
        return true;
    }

    protected boolean setStringSource(String string) {
        return super.convertStringToUTF16(string);
    }

    protected boolean readUTF8ByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStreamToUTF16(inputStream, encodingSupport, false);
    }

    protected boolean readUCSByteStreamWithBOM(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStreamToUTF16(inputStream, encodingSupport, false);
    }

    protected boolean readLatinByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStreamToUTF16(inputStream, encodingSupport, false);
    }

    protected boolean readEBCDICByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStreamToUTF16(inputStream, encodingSupport, false);
    }

    protected boolean readUCSByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStreamToUTF16(inputStream, encodingSupport, true);
    }
}

