/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.exception;

import com.ibm.websphere.exception.DistributedExceptionEnabled;
import com.ibm.websphere.exception.ExceptionInstantiationException;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DistributedExceptionInfo
implements Serializable {
    private String message;
    private String className;
    private transient DistributedExceptionEnabled currentException = null;
    private String stackTrace;
    private DistributedExceptionInfo previousExceptionInfo;
    private byte[] previousException = null;
    private transient Throwable previousExceptionObject = null;
    private String lineSeparator;
    private String resourceBundleName = null;
    private String resourceKey = null;
    private Object[] formatArguments;
    private String distExResourceBundleName = "com.ibm.websphere.exception.DistributedExceptionResource";
    private static final String DIST_EX_RESOURCE_BUNDLE_NAME = "com.ibm.websphere.exception.DistributedExceptionResource";

    public DistributedExceptionInfo(DistributedExceptionEnabled distributedExceptionEnabled) {
        if (distributedExceptionEnabled != null) {
            this.setExceptionInfo(distributedExceptionEnabled);
        }
    }

    public DistributedExceptionInfo(DistributedExceptionEnabled distributedExceptionEnabled, Throwable throwable) {
        if (distributedExceptionEnabled != null) {
            this.setExceptionInfo(distributedExceptionEnabled);
        }
        if (throwable != null) {
            this.setPreviousExceptionInfo(throwable);
            this.previousExceptionObject = throwable;
        }
    }

    public DistributedExceptionInfo(String string, DistributedExceptionEnabled distributedExceptionEnabled) {
        if (distributedExceptionEnabled != null) {
            this.setExceptionInfo(distributedExceptionEnabled);
        }
        this.message = string;
    }

    public DistributedExceptionInfo(String string, DistributedExceptionEnabled distributedExceptionEnabled, Throwable throwable) {
        if (distributedExceptionEnabled != null) {
            this.setExceptionInfo(distributedExceptionEnabled);
        }
        if (throwable != null) {
            this.setPreviousExceptionInfo(throwable);
            this.previousExceptionObject = throwable;
        }
        this.message = string;
    }

    public DistributedExceptionInfo(String string, String string2, Object[] objectArray, String string3, DistributedExceptionEnabled distributedExceptionEnabled) {
        this.resourceBundleName = string;
        this.resourceKey = string2;
        this.formatArguments = objectArray;
        this.setMessage(string3);
        if (distributedExceptionEnabled != null) {
            this.setExceptionInfo(distributedExceptionEnabled);
        }
    }

    public DistributedExceptionInfo(String string, String string2, Object[] objectArray, String string3, DistributedExceptionEnabled distributedExceptionEnabled, Throwable throwable) {
        this.resourceBundleName = string;
        this.resourceKey = string2;
        this.formatArguments = objectArray;
        this.setMessage(string3);
        if (distributedExceptionEnabled != null) {
            this.setExceptionInfo(distributedExceptionEnabled);
        }
        if (throwable != null) {
            this.setPreviousExceptionInfo(throwable);
            this.previousExceptionObject = throwable;
        }
    }

    private DistributedExceptionInfo(Throwable throwable) {
        if (throwable != null) {
            this.setClassName(throwable.getClass().getName());
            this.message = throwable.getMessage();
            this.previousExceptionObject = throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.previousExceptionObject != null) {
            this.serializePreviousException();
            if (this.currentException == null) {
                this.setStackTrace(this.previousExceptionObject);
            }
        }
        if (this.currentException != null) {
            this.serializeCurrentException();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public String getClassName() {
        return this.className;
    }

    public String getDefaultMessage() {
        return this.message;
    }

    private String getErrorMsg(String string, String string2, String string3) {
        ResourceBundle resourceBundle = null;
        String string4 = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            string4 = string3;
        }
        if (resourceBundle != null) {
            try {
                string4 = resourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                string4 = string3;
            }
        }
        return string4;
    }

    public Throwable getException(String string) throws ExceptionInstantiationException {
        if (string == null) {
            return null;
        }
        Throwable throwable = null;
        if (this.previousExceptionInfo != null) {
            throwable = this.previousExceptionInfo.getClassName().equals(string) ? this.getPreviousException() : this.previousExceptionInfo.getException(string);
        }
        return throwable;
    }

    public Object[] getFormatArguments() {
        return this.formatArguments;
    }

    private String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getMessage() {
        if (this.resourceBundleName != null && this.resourceKey != null) {
            Object[] objectArray;
            String string = null;
            String string2 = null;
            String string3 = null;
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
            }
            catch (MissingResourceException missingResourceException) {
                objectArray = null;
                if (this.message == null) {
                    objectArray = "missingResourceBundleNoDft";
                    string3 = "There was an error retrieving resource bundle {0}. \nThere is no default message.";
                } else {
                    objectArray = "missingResourceBundleWithDft";
                    string3 = "There was an error retrieving resource bundle {0}. \nThe default exception message is: {2}.";
                }
                string2 = this.getErrorMsg(DIST_EX_RESOURCE_BUNDLE_NAME, (String)objectArray, string3);
            }
            if (resourceBundle != null) {
                try {
                    string = resourceBundle.getString(this.resourceKey);
                }
                catch (MissingResourceException missingResourceException) {
                    objectArray = null;
                    if (this.message == null) {
                        objectArray = "missingResourceKeyNoDft";
                        string3 = "There was an error retrieving resource key {1} in resource bundle {0}. \nThere is no default message.";
                    } else {
                        objectArray = "missingResourceKeyWithDft";
                        string3 = "There was an error retrieving resource key {1} in resource bundle {0}. \nThe default exception message is: {2}.";
                    }
                    string2 = this.getErrorMsg(DIST_EX_RESOURCE_BUNDLE_NAME, (String)objectArray, string3);
                }
            }
            String string4 = null;
            if (string != null) {
                string4 = this.formatArguments != null ? MessageFormat.format(string, this.formatArguments) : string;
            } else if (string2 != null) {
                objectArray = new Object[]{this.resourceBundleName, this.resourceKey, this.message};
                string4 = MessageFormat.format(string2, objectArray);
            } else {
                return this.message;
            }
            return string4;
        }
        return this.message;
    }

    public Throwable getOriginalException() throws ExceptionInstantiationException {
        Throwable throwable = null;
        if (this.previousExceptionInfo != null && (throwable = this.previousExceptionInfo.getOriginalException()) == null) {
            throwable = this.getPreviousException();
        }
        return throwable;
    }

    public Throwable getPreviousException() throws ExceptionInstantiationException {
        Throwable throwable = null;
        if (this.previousExceptionObject != null) {
            return this.previousExceptionObject;
        }
        if (this.previousException != null) {
            try {
                final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.previousException);
                ObjectInputStream objectInputStream = (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new ObjectInputStream(byteArrayInputStream);
                    }
                });
                throwable = (Throwable)objectInputStream.readObject();
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new ExceptionInstantiationException(privilegedActionException.getException());
            }
            catch (Exception exception) {
                throw new ExceptionInstantiationException(exception);
            }
        }
        return throwable;
    }

    public DistributedExceptionInfo getPreviousExceptionInfo() {
        return this.previousExceptionInfo;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    private String getResourceText(String string) {
        String string2 = null;
        if (string != null) {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(DIST_EX_RESOURCE_BUNDLE_NAME);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resourceBundle != null) {
                try {
                    string2 = resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        return string2;
    }

    public void printStackTrace(PrintWriter printWriter) {
        String string = this.getLineSeparatorProperty();
        this.printText(printWriter, "currentException", "Current exception:");
        this.printStackTrace(string, printWriter);
        this.printText(printWriter, "endOfExTraces", "End of exception traces");
    }

    void printStackTrace(String string, PrintWriter printWriter) {
        this.printText(printWriter, "msg", "Message:");
        printWriter.println("   " + this.getMessage());
        this.printText(printWriter, "stackTrace", "Stack trace:");
        if (this.stackTrace == null) {
            if (this.currentException != null) {
                this.serializeCurrentException();
            }
            if (this.stackTrace == null && this.previousExceptionObject != null) {
                this.setStackTrace(this.previousExceptionObject);
            }
        }
        if (this.stackTrace != null) {
            if (string.equals(this.lineSeparator)) {
                printWriter.println(this.stackTrace);
            } else {
                char c = string.charAt(0);
                char c2 = this.lineSeparator.charAt(0);
                StringBuffer stringBuffer = new StringBuffer(this.stackTrace);
                for (int i = 0; i < stringBuffer.length(); ++i) {
                    if (stringBuffer.charAt(i) != c) continue;
                    stringBuffer.setCharAt(i, c2);
                }
                printWriter.println(this.stackTrace);
            }
        }
        if (this.previousExceptionInfo != null) {
            this.printText(printWriter, "previousException", "Previous exception:");
            this.previousExceptionInfo.printStackTrace(string, printWriter);
        }
    }

    private void printText(PrintWriter printWriter, String string, String string2) {
        String string3 = null;
        if (string != null) {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(DIST_EX_RESOURCE_BUNDLE_NAME);
            }
            catch (MissingResourceException missingResourceException) {
                string3 = string2;
            }
            if (resourceBundle != null) {
                try {
                    string3 = resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    string3 = string2;
                }
            }
        } else {
            string3 = string2;
        }
        printWriter.println(string3);
    }

    private void setClassName(String string) {
        this.className = string;
    }

    public void setDefaultMessage(String string) {
        this.setMessage(string);
    }

    private String getLineSeparatorProperty() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("line.separator");
            }
        });
    }

    private void setExceptionInfo(DistributedExceptionEnabled distributedExceptionEnabled) {
        if (distributedExceptionEnabled != null) {
            this.setClassName(distributedExceptionEnabled.getClass().getName());
        }
        this.currentException = distributedExceptionEnabled;
    }

    private void serializeCurrentException() {
        this.setLineSeparator(this.getLineSeparatorProperty());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.currentException.printSuperStackTrace(printWriter);
        this.setStackTrace(stringWriter.toString());
    }

    private void setExceptionInfo(Throwable throwable) {
        if (throwable != null) {
            this.setClassName(throwable.getClass().getName());
        }
    }

    private void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public void setLocalizationInfo(String string, String string2, Object[] objectArray) {
        this.resourceBundleName = string;
        this.resourceKey = string2;
        this.formatArguments = objectArray;
    }

    private void setMessage(String string) {
        this.message = string;
    }

    private void serializePreviousException() {
        try {
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new ObjectOutputStream(byteArrayOutputStream);
                }
            });
            objectOutputStream.writeObject(this.previousExceptionObject);
            this.previousException = byteArrayOutputStream.toByteArray();
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Unexpected exception in setPreviousException()");
            privilegedActionException.getException().printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Unexpected exception in setPreviousException()");
            exception.printStackTrace();
        }
    }

    private void setPreviousExceptionInfo(Throwable throwable) {
        this.previousExceptionInfo = throwable instanceof DistributedExceptionEnabled ? ((DistributedExceptionEnabled)((Object)throwable)).getExceptionInfo() : new DistributedExceptionInfo(throwable);
    }

    private void setStackTrace(String string) {
        this.stackTrace = string;
    }

    private void setStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        this.stackTrace = stringWriter.toString();
        this.setLineSeparator(this.getLineSeparatorProperty());
    }
}

