/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.help.eclipse.webclient;

import com.ibm.storage.console.help.eclipse.webclient.HTMLClient;
import com.ibm.storage.console.help.eclipse.webclient.HelpDescriptor;

public class HTMLRequestor
extends HTMLClient {
    protected static final String REQUESTOR_SCRIPT = "requestor.js";
    protected static final String JS_NOTIFY_START = "window.setHelp(\"";
    protected static final String JS_SHOW_START = "window.showHelp(\"";
    protected static final String JS_VIEW_START = "window.viewHelp(\"";
    protected static final String JS_VIEW_INCLUDE = "javascript:";
    protected String pluginID = null;

    public HTMLRequestor(HelpDescriptor descriptor) {
        super(descriptor);
    }

    public void setPluginID(String id) {
        this.pluginID = id;
    }

    public String getPluginID() {
        if (this.pluginID != null) {
            return this.pluginID;
        }
        return this.descriptor.getDefaultPlugin();
    }

    public String getRequest(String topicPath) {
        String plugin = this.getPluginID();
        if (plugin != null) {
            return this.getRequest(plugin, topicPath);
        }
        return this.getRequestorInclude() + this.getRequestScript(topicPath);
    }

    public String getRequest(String pluginID, String topicPath) {
        return this.getRequestorInclude() + this.getRequestScript(pluginID, topicPath);
    }

    public String getRequestCall(String topicPath) {
        String plugin = this.getPluginID();
        if (plugin != null) {
            return this.getRequestCall(plugin, topicPath);
        }
        return JS_NOTIFY_START + topicPath + "\");\n";
    }

    public String getRequestCall(String pluginID, String topicPath) {
        return JS_NOTIFY_START + pluginID + "\", \"" + topicPath + "\");\n";
    }

    public String getRequestScript(String topicPath) {
        String str = this.makeScript(this.getRequestCall(topicPath));
        return str;
    }

    public String getRequestScript(String pluginID, String topicPath) {
        return this.makeScript(this.getRequestCall(pluginID, topicPath));
    }

    public String getRequestorInclude() {
        String str = this.getFinderInclude() + "<script language=\"JavaScript\" src=\"" + this.getEclipsePath() + "webclient/" + REQUESTOR_SCRIPT + "\"></script>\n";
        return str;
    }

    public String getShowCall(String topicPath) {
        String plugin = this.getPluginID();
        if (plugin != null) {
            return this.getShowCall(plugin, topicPath);
        }
        return JS_SHOW_START + topicPath + "\");\n";
    }

    public String getShowCall(String pluginID, String topicPath) {
        return JS_SHOW_START + pluginID + "\", \"" + topicPath + "\");\n";
    }

    public String getViewCall(String topicPath) {
        String plugin = this.getPluginID();
        if (plugin != null) {
            return this.getViewCall(plugin, topicPath);
        }
        return JS_VIEW_START + topicPath + "\");\n";
    }

    public String getViewCall(String pluginID, String topicPath) {
        return JS_VIEW_START + pluginID + "\", \"" + topicPath + "\");\n";
    }

    public String getViewHref(String topicPath) {
        String str = JS_VIEW_INCLUDE + this.getViewCall(topicPath);
        return str;
    }

    public String getViewHref(String pluginID, String topicPath) {
        String str = JS_VIEW_INCLUDE + this.getViewCall(pluginID, topicPath);
        return str;
    }

    public String getViewScript(String topicPath) {
        return this.makeScript(this.getViewCall(topicPath));
    }

    public String getViewScript(String pluginID, String topicPath) {
        return this.makeScript(this.getViewCall(pluginID, topicPath));
    }

    protected String makeScript(String js_call) {
        if (js_call == null) {
            return null;
        }
        return "<script language=\"JavaScript\">\n" + js_call + "</script>\n";
    }
}

