/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ConfigServiceHelper {
    public static ConfigDataId getConfigDataId(AttributeList attributeList) {
        Object object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Id");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException((Throwable)attributeNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", (String)"39");
        }
        ConfigDataId configDataId = (ConfigDataId)object;
        if (configDataId == null) {
            configDataId = ConfigDataId.createLocalId();
            ConfigServiceHelper.setAttributeValue(attributeList, "_Websphere_Config_Data_Id", configDataId);
        }
        return configDataId;
    }

    public static Object getAttributeValue(AttributeList attributeList, String string) throws AttributeNotFoundException {
        Object object = null;
        boolean bl = false;
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getName().equals(string)) continue;
            object = attribute.getValue();
            bl = true;
            break;
        }
        if (!bl) {
            throw new AttributeNotFoundException("attribute " + string + " not found");
        }
        return object;
    }

    public static void setAttributeValue(AttributeList attributeList, String string, Object object) {
        ConfigServiceHelper.removeAttribute(attributeList, string);
        attributeList.add(new Attribute(string, object));
    }

    public static Object removeAttribute(AttributeList attributeList, String string) {
        Object object = null;
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            if (!attribute.getName().equals(string)) continue;
            object = attribute.getValue();
            attributeList.remove(i);
            break;
        }
        return object;
    }

    public static AttributeList lookup(AttributeList attributeList, ConfigDataId configDataId) {
        AttributeList attributeList2 = null;
        if (ConfigServiceHelper.getConfigDataId(attributeList).equals(configDataId)) {
            attributeList2 = attributeList;
        } else {
            Iterator iterator = attributeList.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                Object object = attribute.getValue();
                if (object == null || !(object instanceof AttributeList)) continue;
                attributeList2 = ConfigServiceHelper.lookup((AttributeList)object, configDataId);
            }
        }
        return attributeList2;
    }

    public static ObjectName createObjectName(AttributeList attributeList) {
        ConfigDataId configDataId = null;
        try {
            configDataId = (ConfigDataId)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Id");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException((Throwable)attributeNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceHelper.createObjectName", (String)"124");
        }
        String string = null;
        try {
            string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException((Throwable)attributeNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceHelper.createObjectName", (String)"130");
        }
        String string2 = null;
        try {
            string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Display_Name");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException((Throwable)attributeNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceHelper.createObjectName", (String)"136");
        }
        return ConfigServiceHelper.createObjectName(configDataId, string);
    }

    public static ObjectName createObjectName(ConfigDataId configDataId) {
        return ConfigServiceHelper.createObjectName(configDataId, null);
    }

    public static ObjectName createObjectName(ConfigDataId configDataId, String string) {
        return ConfigServiceHelper.createObjectName(configDataId, string, null);
    }

    public static ObjectName createObjectName(ConfigDataId configDataId, String string, String string2) {
        ObjectName objectName = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (configDataId != null) {
            hashtable.put("_Websphere_Config_Data_Id", configDataId.toString());
        }
        if (string != null) {
            hashtable.put("_Websphere_Config_Data_Type", string);
        }
        if (string2 != null && !string2.trim().equals("")) {
            hashtable.put("_Websphere_Config_Data_Display_Name", string2);
        }
        try {
            objectName = new ObjectName("Websphere", hashtable);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.websphere.management.configservice.ConfigServiceHelper.createObjectName", (String)"171");
        }
        return objectName;
    }

    public static ConfigDataId getConfigDataId(ObjectName objectName) {
        String string = objectName.getKeyProperty("_Websphere_Config_Data_Id");
        return string == null ? null : new ConfigDataId(string);
    }

    public static String getConfigDataType(ObjectName objectName) {
        return objectName.getKeyProperty("_Websphere_Config_Data_Type");
    }

    public static String getDisplayName(ObjectName objectName) {
        return objectName.getKeyProperty("_Websphere_Config_Data_Display_Name");
    }

    public static boolean checkIfNameValid(String string) {
        boolean bl = true;
        if (string == null || string.trim().length() == 0) {
            bl = false;
        } else if (string.startsWith(".")) {
            bl = false;
        } else if (string.indexOf("]]>") != -1) {
            bl = false;
        } else if (string.endsWith(" ") || string.startsWith(" ")) {
            bl = false;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/,:;\"*?<>|=+&%'");
            if (stringTokenizer.hasMoreTokens() && !stringTokenizer.nextToken().equals(string)) {
                bl = false;
            }
        }
        return bl;
    }

    public static Properties getObjectLocation(ObjectName objectName) {
        String string = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            if (string2.equals("cells")) {
                string3 = "cell";
            } else if (string2.equals("nodes")) {
                string3 = "node";
            } else if (string2.equals("servers")) {
                string3 = "server";
            } else if (string2.equals("clusters")) {
                string3 = "cluster";
            } else if (string2.equals("applications")) {
                string3 = "application";
            }
            if (string3 == null || !stringTokenizer.hasMoreTokens()) continue;
            properties.setProperty(string3, stringTokenizer.nextToken());
        }
        return properties;
    }

    public ConfigDataId convertObjectNameToConfigDataId(ObjectName objectName) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = objectName.getKeyProperty("mbeanIdentifier");
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n >= 0 && string.substring(n, string.length()).indexOf(".xml") >= 0) {
                stringBuffer.append(string.substring(0, n));
                stringBuffer.append(":");
                stringBuffer.append(string.substring(n + 1));
            } else {
                stringBuffer.append(string);
            }
        }
        return new ConfigDataId(stringBuffer.toString());
    }
}

