/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ServerInfo
implements Serializable {
    static final long serialVersionUID = 3198058148218818720L;
    private String pid;
    private String cell;
    private String node;
    private String name;
    private String role;
    private String version;
    private Vector connectors;
    private Vector endPoints;
    private Vector services;

    public ServerInfo(String string, String string2, String string3) {
        this.cell = string;
        this.node = string2;
        this.role = string3;
    }

    public ServerInfo(String string, String string2, String string3, String string4, String string5, String string6, Vector vector) {
        this.pid = string;
        this.cell = string2;
        this.node = string3;
        this.name = string4;
        this.role = string5;
        this.version = string6;
        this.services = vector;
    }

    public AdminClient getAdminClient() throws ConnectorException {
        return AdminClientFactory.createAdminClient(this.getPreferredConnectorProps());
    }

    public String getCell() {
        return this.cell;
    }

    public String getNode() {
        return this.node;
    }

    public String getPid() {
        return this.pid;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public List getConnectors() {
        this.convert();
        return Collections.unmodifiableList(this.connectors);
    }

    public List getEndPoints() {
        this.convert();
        return Collections.unmodifiableList(this.endPoints);
    }

    public String toString() {
        Properties properties = new Properties();
        if (this.pid != null) {
            properties.setProperty("pid", this.pid);
        }
        if (this.cell != null) {
            properties.setProperty("cell", this.cell);
        }
        if (this.node != null) {
            properties.setProperty("node", this.node);
        }
        if (this.name != null) {
            properties.setProperty("name", this.name);
        }
        if (this.role != null) {
            properties.setProperty("role", this.role);
        }
        if (this.version != null) {
            properties.setProperty("version", this.version);
        }
        return properties.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServerInfo)) {
            return false;
        }
        ServerInfo serverInfo = (ServerInfo)object;
        return serverInfo.cell.equals(this.cell) && serverInfo.node.equals(this.node) && serverInfo.name.equals(this.name);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.cell.hashCode();
        n = 37 * n + this.node.hashCode();
        n = 37 * n + this.name.hashCode();
        return n;
    }

    boolean match(ServerInfo serverInfo) {
        return this.cell != null && this.cell.equalsIgnoreCase(serverInfo.getCell()) && this.node != null && this.node.equalsIgnoreCase(serverInfo.getNode()) && this.role != null && this.role.equalsIgnoreCase(serverInfo.getRole());
    }

    Vector getServices() {
        return this.services;
    }

    private void convert() {
        if (this.connectors == null || this.endPoints == null) {
            this.connectors = new Vector();
            this.endPoints = new Vector();
            Iterator iterator = this.services.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = string.indexOf(58);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                Properties properties = this.convert(string3);
                if (string2.equalsIgnoreCase("connector")) {
                    this.connectors.addElement(properties);
                    continue;
                }
                if (!string2.equalsIgnoreCase("endpoint")) continue;
                this.endPoints.addElement(properties);
            }
        }
    }

    private Properties convert(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=");
        while (stringTokenizer.hasMoreTokens()) {
            properties.setProperty(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        return properties;
    }

    private Properties getPreferredConnectorProps() {
        Properties properties = null;
        Iterator iterator = this.connectors.iterator();
        while (iterator.hasNext()) {
            properties = (Properties)iterator.next();
            if (properties.getProperty("preferred") == null) continue;
            return properties;
        }
        return properties;
    }
}

