/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.ServerInfo;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;

public class Utils {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$management$discovery$Utils == null ? (class$com$ibm$ws$management$discovery$Utils = Utils.class$("com.ibm.ws.management.discovery.Utils")) : class$com$ibm$ws$management$discovery$Utils);
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$Utils;

    public static AdminClient getDmgrAdminClient() throws ConnectorException {
        AdminService adminService;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDmgrAdminClient");
        }
        if ((adminService = AdminServiceFactory.getAdminService()) == null) {
            throw new ConnectorNotAvailableException();
        }
        String string = adminService.getProcessType();
        AdminClient adminClient = null;
        if (string.equals("NodeAgent")) {
            adminClient = Utils.getParentAdminClient();
        } else if (string.equals("ManagedProcess")) {
            AdminClient adminClient2 = Utils.getParentAdminClient();
            ObjectName objectName = adminClient2.getServerMBean();
            if (objectName == null) {
                throw new ConnectorNotAvailableException();
            }
            String string2 = ObjectNameHelper.getProcessName(objectName);
            ObjectName objectName2 = Utils.getDiscoveryMBean(adminClient2, string2);
            if (objectName2 == null) {
                throw new ConnectorNotAvailableException();
            }
            ServerInfo serverInfo = null;
            try {
                serverInfo = (ServerInfo)adminClient2.invoke(objectName2, "getParent", null, null);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, (String)"getDmgrAdminClient", (String)"55");
            }
            if (serverInfo == null) {
                throw new ConnectorNotAvailableException();
            }
            adminClient = serverInfo.getAdminClient();
        }
        if (adminClient == null) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDmgrAdminClient");
        }
        return adminClient;
    }

    public static AdminClient getParentAdminClient() throws ConnectorException {
        AdminService adminService;
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentAdminClient");
        }
        if ((objectName = Utils.getDiscoveryMBean(adminService = AdminServiceFactory.getAdminService(), adminService.getProcessName())) == null) {
            throw new ConnectorNotAvailableException();
        }
        ServerInfo serverInfo = null;
        try {
            serverInfo = (ServerInfo)adminService.invoke(objectName, "getParent", null, null);
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, (String)"getParentAdminClient", (String)"89");
        }
        if (serverInfo == null) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentAdminClient");
        }
        return serverInfo.getAdminClient();
    }

    private static ObjectName getDiscoveryMBean(AdminService adminService, String string) {
        ObjectName objectName;
        block2: {
            objectName = null;
            try {
                String string2 = "WebSphere:type=Discovery,process=" + string + ",*";
                objectName = new ObjectName(string2);
                Set set = adminService.queryNames(objectName, null);
                Iterator iterator = set.iterator();
                objectName = (ObjectName)iterator.next();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "getDiscoveryMBean(AdminService)", exception);
            }
        }
        return objectName;
    }

    private static ObjectName getDiscoveryMBean(AdminClient adminClient, String string) {
        ObjectName objectName;
        block2: {
            objectName = null;
            try {
                String string2 = "WebSphere:type=Discovery,process=" + string + ",*";
                objectName = new ObjectName(string2);
                Set set = adminClient.queryNames(objectName, null);
                Iterator iterator = set.iterator();
                objectName = (ObjectName)iterator.next();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "getDiscoveryMBean(AdminClient)", exception);
            }
        }
        return objectName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

