/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformClusterConfigHelper;
import com.ibm.ws.management.util.PlatformClusterMemberConfigHelper;
import com.ibm.ws.management.util.PlatformServerConfigHelper;
import com.ibm.ws.util.ImplFactory;

public class ConfigHelperFactory {
    public static PlatformServerConfigHelper getPlatformServerConfigHelper(Node node) {
        PlatformServerConfigHelper platformServerConfigHelper = null;
        String string = null;
        String string2 = ConfigHelperFactory.normalizePlatform(node);
        string = string2 != null && string2.length() > 0 ? "com.ibm.ws.management.util." + string2 + ".PlatformServerConfigHelperImpl" : "com.ibm.ws.management.util.PlatformServerConfigHelperImpl";
        platformServerConfigHelper = (PlatformServerConfigHelper)ConfigHelperFactory.getImplFromClass(string);
        if (platformServerConfigHelper == null) {
            platformServerConfigHelper = (PlatformServerConfigHelper)ConfigHelperFactory.getImplFromImplFactory(string);
        }
        if (platformServerConfigHelper == null) {
            platformServerConfigHelper = (PlatformServerConfigHelper)ConfigHelperFactory.getDefaultHelper("PlatformServerConfigHelperImpl");
        }
        return platformServerConfigHelper;
    }

    public static PlatformClusterConfigHelper getPlatformClusterConfigHelper(Node node) {
        PlatformClusterConfigHelper platformClusterConfigHelper = null;
        String string = null;
        String string2 = ConfigHelperFactory.normalizePlatform(node);
        string = string2 != null && string2.length() > 0 ? "com.ibm.ws.management.util." + string2 + ".PlatformClusterConfigHelperImpl" : "com.ibm.ws.management.util.PlatformClusterConfigHelperImpl";
        platformClusterConfigHelper = (PlatformClusterConfigHelper)ConfigHelperFactory.getImplFromClass(string);
        if (platformClusterConfigHelper == null) {
            platformClusterConfigHelper = (PlatformClusterConfigHelper)ConfigHelperFactory.getImplFromImplFactory(string);
        }
        if (platformClusterConfigHelper == null) {
            platformClusterConfigHelper = (PlatformClusterConfigHelper)ConfigHelperFactory.getDefaultHelper("PlatformClusterConfigHelperImpl");
        }
        return platformClusterConfigHelper;
    }

    public static PlatformClusterMemberConfigHelper getPlatformClusterMemberConfigHelper(Node node) {
        PlatformClusterMemberConfigHelper platformClusterMemberConfigHelper = null;
        String string = null;
        String string2 = ConfigHelperFactory.normalizePlatform(node);
        string = string2 != null && string2.length() > 0 ? "com.ibm.ws.management.util." + string2 + ".PlatformClusterMemberHelperImpl" : "com.ibm.ws.management.util.PlatformClusterMemberHelperImpl";
        platformClusterMemberConfigHelper = (PlatformClusterMemberConfigHelper)ConfigHelperFactory.getImplFromClass(string);
        if (platformClusterMemberConfigHelper == null) {
            platformClusterMemberConfigHelper = (PlatformClusterMemberConfigHelper)ConfigHelperFactory.getImplFromImplFactory(string);
        }
        if (platformClusterMemberConfigHelper == null) {
            platformClusterMemberConfigHelper = (PlatformClusterMemberConfigHelper)ConfigHelperFactory.getDefaultHelper("PlatformClusterMemberHelperImpl");
        }
        return platformClusterMemberConfigHelper;
    }

    private static String normalizePlatform(Node node) {
        String string;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            return "zos";
        }
        if (node != null && (string = null) != null && string.length() > 0) {
            if (string.startsWith("win")) {
                return "win";
            }
            if (string.startsWith("sun")) {
                return "sun";
            }
            if (string.startsWith("os400")) {
                return "os400";
            }
            if (string.startsWith("hp")) {
                return "hp";
            }
        }
        return null;
    }

    private static Object getImplFromImplFactory(String string) {
        Object object = null;
        try {
            object = ImplFactory.loadImplFromKey((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private static Object getImplFromClass(String string) {
        Object var1_1 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var1_1 = clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return var1_1;
    }

    private static Object getDefaultHelper(String string) {
        Object object = null;
        object = ConfigHelperFactory.getImplFromClass("com.ibm.ws.management.util." + string);
        return object;
    }
}

