/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDragGestureRecognizer;
import javax.swing.plaf.basic.BasicDropTargetListener;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.text.Position;

public class BasicListUI
extends ListUI {
    protected JList list = null;
    protected CellRendererPane rendererPane;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    protected ListSelectionListener listSelectionListener;
    protected ListDataListener listDataListener;
    protected PropertyChangeListener propertyChangeListener;
    private KeyListener keyListener;
    protected int[] cellHeights = null;
    protected int cellHeight = -1;
    protected int cellWidth = -1;
    protected int updateLayoutStateNeeded = 1;
    private int listHeight;
    private int listWidth;
    private int layoutOrientation;
    private int columnCount;
    private int preferredHeight;
    private int rowsPerColumn;
    private boolean hasSelectCurrentAction = false;
    private IncrementLeadSelectionAction selectCurrentAction = new IncrementLeadSelectionAction("selectCurrent", 1, 0);
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    private static final int layoutOrientationChanged = 128;
    private static final int heightChanged = 256;
    private static final int widthChanged = 512;
    private static final int componentOrientationChanged = 1024;
    private static final int CHANGE_LEAD = 0;
    private static final int CHANGE_SELECTION = 1;
    private static final int EXTEND_SELECTION = 2;
    private static final ListDragGestureRecognizer defaultDragRecognizer = new ListDragGestureRecognizer();
    private static final TransferHandler defaultTransferHandler = new ListTransferHandler();

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object = listModel.getElementAt(n);
        boolean bl = this.list.hasFocus() && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl2, bl);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        this.rendererPane.paintComponent(graphics, component, this.list, n3, n4, n5, n6, true);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        int n2;
        int n3;
        switch (this.layoutOrientation) {
            case 1: {
                if (this.list.getHeight() == this.listHeight) break;
                this.updateLayoutStateNeeded |= 0x100;
                this.redrawList();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.listWidth) break;
                this.updateLayoutStateNeeded |= 0x200;
                this.redrawList();
                break;
            }
        }
        this.maybeUpdateLayoutState();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        ListModel listModel = this.list.getModel();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        if (listCellRenderer == null || (n3 = listModel.getSize()) == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            n2 = this.convertLocationToColumn(rectangle.x, rectangle.y);
            n = this.convertLocationToColumn(rectangle.x + rectangle.width, rectangle.y);
        } else {
            n2 = this.convertLocationToColumn(rectangle.x + rectangle.width, rectangle.y);
            n = this.convertLocationToColumn(rectangle.x, rectangle.y);
        }
        int n4 = rectangle.y + rectangle.height;
        int n5 = this.list.getLeadSelectionIndex();
        int n6 = this.layoutOrientation == 2 ? this.columnCount : 1;
        for (int i = n2; i <= n; ++i) {
            int n7;
            int n8 = this.getRowCount(i);
            int n9 = this.getModelIndex(i, n7);
            Rectangle rectangle2 = this.getCellBounds(this.list, n9, n9);
            if (rectangle2 == null) {
                return;
            }
            for (n7 = this.convertLocationToRowInColumn(rectangle.y, i); n7 < n8 && rectangle2.y < n4 && n9 < n3; n9 += n6, ++n7) {
                rectangle2.height = this.getHeight(i, n7);
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.paintCell(graphics, n9, rectangle2, listCellRenderer, listModel, listSelectionModel, n5);
                rectangle2.y += rectangle2.height;
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Rectangle rectangle;
        this.maybeUpdateLayoutState();
        int n = this.list.getModel().getSize() - 1;
        if (n < 0) {
            return new Dimension(0, 0);
        }
        Insets insets = this.list.getInsets();
        int n2 = this.cellWidth * this.columnCount + insets.left + insets.right;
        int n3 = this.layoutOrientation != 0 ? this.preferredHeight : ((rectangle = this.getCellBounds(this.list, n)) != null ? rectangle.y + rectangle.height + insets.bottom : 0);
        return new Dimension(n2, n3);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void selectPreviousIndex() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(--n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void selectNextIndex() {
        int n = this.list.getSelectedIndex();
        if (n + 1 < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(++n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.list, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null) {
            SwingUtilities.replaceUIActionMap(this.list, actionMap);
        }
    }

    InputMap getInputMap(int n) {
        if (n == 0) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("List.focusInputMap");
            if (this.list.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)UIManager.get("List.focusInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("List.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("List.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectPreviousColumn", new IncrementLeadByColumnAction("selectPreviousColumn", 1, -1));
        actionMapUIResource.put("selectPreviousColumnExtendSelection", new IncrementLeadByColumnAction("selectPreviousColumnExtendSelection", 2, -1));
        actionMapUIResource.put("selectNextColumn", new IncrementLeadByColumnAction("selectNextColumn", 1, 1));
        actionMapUIResource.put("selectNextColumnExtendSelection", new IncrementLeadByColumnAction("selectNextColumnExtendSelection", 2, 1));
        actionMapUIResource.put("selectPreviousRow", new IncrementLeadSelectionAction("selectPreviousRow", 1, -1));
        actionMapUIResource.put("selectPreviousRowExtendSelection", new IncrementLeadSelectionAction("selectPreviousRowExtendSelection", 2, -1));
        actionMapUIResource.put("selectNextRow", new IncrementLeadSelectionAction("selectNextRow", 1, 1));
        actionMapUIResource.put("selectNextRowExtendSelection", new IncrementLeadSelectionAction("selectNextRowExtendSelection", 2, 1));
        actionMapUIResource.put("selectFirstRow", new HomeAction("selectFirstRow", 1));
        actionMapUIResource.put("selectFirstRowExtendSelection", new HomeAction("selectFirstRowExtendSelection", 2));
        actionMapUIResource.put("selectLastRow", new EndAction("selctLastRow", 1));
        actionMapUIResource.put("selectLastRowExtendSelection", new EndAction("selectLastRowExtendSelection", 2));
        actionMapUIResource.put("scrollUp", new PageUpAction("scrollUp", 1));
        actionMapUIResource.put("scrollUpExtendSelection", new PageUpAction("scrollUpExtendSelection", 2));
        actionMapUIResource.put("scrollDown", new PageDownAction("scrollDown", 1));
        actionMapUIResource.put("scrollDownExtendSelection", new PageDownAction("scrollDownExtendSelection", 2));
        actionMapUIResource.put("selectAll", new SelectAllAction("selectAll"));
        actionMapUIResource.put("clearSelection", new ClearSelectionAction("clearSelection"));
        actionMapUIResource.put("selectCurrent", this.selectCurrentAction);
        this.hasSelectCurrentAction = true;
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.list, null);
        SwingUtilities.replaceUIInputMap(this.list, 0, null);
    }

    protected void installListeners() {
        ListSelectionModel listSelectionModel;
        this.focusListener = this.createFocusListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.listSelectionListener = this.createListSelectionListener();
        this.listDataListener = this.createListDataListener();
        this.keyListener = this.createKeyListener();
        this.list.addFocusListener(this.focusListener);
        this.list.addMouseListener(defaultDragRecognizer);
        this.list.addMouseMotionListener(defaultDragRecognizer);
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        this.list.addKeyListener(this.keyListener);
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.addListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.addListSelectionListener(this.listSelectionListener);
        }
    }

    protected void uninstallListeners() {
        ListSelectionModel listSelectionModel;
        this.list.removeFocusListener(this.focusListener);
        this.list.removeMouseListener(defaultDragRecognizer);
        this.list.removeMouseMotionListener(defaultDragRecognizer);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        this.list.removeKeyListener(this.keyListener);
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.removeListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.removeListSelectionListener(this.listSelectionListener);
        }
        this.focusListener = null;
        this.mouseInputListener = null;
        this.listSelectionListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
        this.keyListener = null;
    }

    protected void installDefaults() {
        DropTarget dropTarget;
        TransferHandler transferHandler;
        Color color;
        Color color2;
        this.columnCount = 1;
        this.list.setLayout(null);
        LookAndFeel.installBorder(this.list, "List.border");
        LookAndFeel.installColorsAndFont(this.list, "List.background", "List.foreground", "List.font");
        if (this.list.getCellRenderer() == null) {
            this.list.setCellRenderer((ListCellRenderer)UIManager.get("List.cellRenderer"));
        }
        if ((color2 = this.list.getSelectionBackground()) == null || color2 instanceof UIResource) {
            this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        }
        if ((color = this.list.getSelectionForeground()) == null || color instanceof UIResource) {
            this.list.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        }
        if ((transferHandler = this.list.getTransferHandler()) == null || transferHandler instanceof UIResource) {
            this.list.setTransferHandler(defaultTransferHandler);
        }
        if ((dropTarget = this.list.getDropTarget()) instanceof UIResource) {
            try {
                dropTarget.addDropTargetListener(new ListDropTargetListener());
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.list);
        if (this.list.getFont() instanceof UIResource) {
            this.list.setFont(null);
        }
        if (this.list.getForeground() instanceof UIResource) {
            this.list.setForeground(null);
        }
        if (this.list.getBackground() instanceof UIResource) {
            this.list.setBackground(null);
        }
        if (this.list.getSelectionBackground() instanceof UIResource) {
            this.list.setSelectionBackground(null);
        }
        if (this.list.getSelectionForeground() instanceof UIResource) {
            this.list.setSelectionForeground(null);
        }
        if (this.list.getCellRenderer() instanceof UIResource) {
            this.list.setCellRenderer(null);
        }
        if (this.list.getTransferHandler() instanceof UIResource) {
            this.list.setTransferHandler(null);
        }
    }

    public void installUI(JComponent jComponent) {
        this.list = (JList)jComponent;
        this.layoutOrientation = this.list.getLayoutOrientation();
        this.rendererPane = new CellRendererPane();
        this.list.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.cellHeight = -1;
        this.cellWidth = -1;
        this.cellHeights = null;
        this.listHeight = -1;
        this.listWidth = -1;
        this.list.remove(this.rendererPane);
        this.rendererPane = null;
        this.list = null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertLocationToModel(point.x, point.y);
    }

    public Point indexToLocation(JList jList, int n) {
        this.maybeUpdateLayoutState();
        Rectangle rectangle = this.getCellBounds(jList, n, n);
        if (rectangle != null) {
            return new Point(rectangle.x, rectangle.y);
        }
        return null;
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (n3 >= jList.getModel().getSize()) {
            return null;
        }
        Rectangle rectangle = this.getCellBounds(jList, n3);
        if (rectangle == null) {
            return null;
        }
        if (n3 == n4) {
            return rectangle;
        }
        Rectangle rectangle2 = this.getCellBounds(jList, n4);
        if (rectangle2 != null) {
            if (this.layoutOrientation == 2) {
                int n5;
                int n6 = this.convertModelToRow(n3);
                if (n6 != (n5 = this.convertModelToRow(n4))) {
                    rectangle.x = 0;
                    rectangle.width = jList.getWidth();
                }
            } else if (rectangle.x != rectangle2.x) {
                rectangle.y = 0;
                rectangle.height = jList.getHeight();
            }
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    private Rectangle getCellBounds(JList jList, int n) {
        int n2;
        int n3;
        this.maybeUpdateLayoutState();
        int n4 = this.convertModelToRow(n);
        int n5 = this.convertModelToColumn(n);
        if (n4 == -1 || n5 == -1) {
            return null;
        }
        Insets insets = jList.getInsets();
        int n6 = this.cellWidth;
        int n7 = insets.top;
        switch (this.layoutOrientation) {
            case 1: 
            case 2: {
                n3 = jList.getComponentOrientation().isLeftToRight() ? insets.left + n5 * this.cellWidth : jList.getWidth() - insets.right - (n5 + 1) * this.cellWidth;
                n7 += this.cellHeight * n4;
                n2 = this.cellHeight;
                break;
            }
            default: {
                n3 = insets.left;
                if (this.cellHeights == null) {
                    n7 += this.cellHeight * n4;
                } else if (n4 >= this.cellHeights.length) {
                    n7 = 0;
                } else {
                    for (int i = 0; i < n4; ++i) {
                        n7 += this.cellHeights[i];
                    }
                }
                n6 = jList.getWidth() - (insets.left + insets.right);
                n2 = this.getRowHeight(n);
            }
        }
        return new Rectangle(n3, n7, n6, n2);
    }

    protected int getRowHeight(int n) {
        return this.getHeight(0, n);
    }

    protected int convertYToRow(int n) {
        return this.convertLocationToRow(0, n, false);
    }

    protected int convertRowToY(int n) {
        if (this.getRowCount(0) >= n || n < 0) {
            return -1;
        }
        Rectangle rectangle = this.getCellBounds(this.list, n, n);
        return rectangle.y;
    }

    private int getHeight(int n, int n2) {
        if (n < 0 || n > this.columnCount || n2 < 0) {
            return -1;
        }
        if (this.layoutOrientation != 0) {
            return this.cellHeight;
        }
        if (n2 >= this.list.getModel().getSize()) {
            return -1;
        }
        return this.cellHeights == null ? this.cellHeight : (n2 < this.cellHeights.length ? this.cellHeights[n2] : -1);
    }

    private int convertLocationToRow(int n, int n2, boolean bl) {
        int n3;
        int n4 = this.list.getModel().getSize();
        if (n4 <= 0) {
            return -1;
        }
        Insets insets = this.list.getInsets();
        if (this.cellHeights == null) {
            int n5;
            int n6 = n5 = this.cellHeight == 0 ? 0 : (n2 - insets.top) / this.cellHeight;
            if (bl) {
                if (n5 < 0) {
                    n5 = 0;
                } else if (n5 >= n4) {
                    n5 = n4 - 1;
                }
            }
            return n5;
        }
        if (n4 > this.cellHeights.length) {
            return -1;
        }
        int n7 = insets.top;
        int n8 = 0;
        if (bl && n2 < n7) {
            return 0;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (n2 >= n7 && n2 < n7 + this.cellHeights[n3]) {
                return n8;
            }
            n7 += this.cellHeights[n3];
            ++n8;
        }
        return n3 - 1;
    }

    private int convertLocationToRowInColumn(int n, int n2) {
        int n3 = 0;
        if (this.layoutOrientation != 0) {
            n3 = this.list.getComponentOrientation().isLeftToRight() ? n2 * this.cellWidth : this.list.getWidth() - (n2 + 1) * this.cellWidth - this.list.getInsets().right;
        }
        return this.convertLocationToRow(n3, n, true);
    }

    private int convertLocationToModel(int n, int n2) {
        int n3 = this.convertLocationToRow(n, n2, true);
        int n4 = this.convertLocationToColumn(n, n2);
        if (n3 >= 0 && n4 >= 0) {
            return this.getModelIndex(n4, n3);
        }
        return -1;
    }

    private int getRowCount(int n) {
        if (n < 0 || n >= this.columnCount) {
            return -1;
        }
        if (this.layoutOrientation == 0 || n == 0 && this.columnCount == 1) {
            return this.list.getModel().getSize();
        }
        if (n >= this.columnCount) {
            return -1;
        }
        if (this.layoutOrientation == 1) {
            if (n < this.columnCount - 1) {
                return this.rowsPerColumn;
            }
            return this.list.getModel().getSize() - (this.columnCount - 1) * this.rowsPerColumn;
        }
        int n2 = this.columnCount - (this.columnCount * this.rowsPerColumn - this.list.getModel().getSize());
        if (n >= n2) {
            return Math.max(0, this.rowsPerColumn - 1);
        }
        return this.rowsPerColumn;
    }

    private int getModelIndex(int n, int n2) {
        switch (this.layoutOrientation) {
            case 1: {
                return Math.min(this.list.getModel().getSize() - 1, this.rowsPerColumn * n + Math.min(n2, this.rowsPerColumn - 1));
            }
            case 2: {
                return Math.min(this.list.getModel().getSize() - 1, n2 * this.columnCount + n);
            }
        }
        return n2;
    }

    private int convertLocationToColumn(int n, int n2) {
        if (this.cellWidth > 0) {
            if (this.layoutOrientation == 0) {
                return 0;
            }
            Insets insets = this.list.getInsets();
            int n3 = this.list.getComponentOrientation().isLeftToRight() ? (n - insets.left) / this.cellWidth : (this.list.getWidth() - n - insets.right) / this.cellWidth;
            if (n3 < 0) {
                return 0;
            }
            if (n3 >= this.columnCount) {
                return this.columnCount - 1;
            }
            return n3;
        }
        return 0;
    }

    private int convertModelToRow(int n) {
        int n2 = this.list.getModel().getSize();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.layoutOrientation != 0 && this.columnCount > 1 && this.rowsPerColumn > 0) {
            if (this.layoutOrientation == 1) {
                return n % this.rowsPerColumn;
            }
            return n / this.columnCount;
        }
        return n;
    }

    private int convertModelToColumn(int n) {
        int n2 = this.list.getModel().getSize();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.layoutOrientation != 0 && this.rowsPerColumn > 0 && this.columnCount > 1) {
            if (this.layoutOrientation == 1) {
                return n / this.rowsPerColumn;
            }
            return n % this.columnCount;
        }
        return 0;
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void updateLayoutState() {
        int n = this.list.getFixedCellHeight();
        int n2 = this.list.getFixedCellWidth();
        int n3 = this.cellWidth = n2 != -1 ? n2 : -1;
        if (n != -1) {
            this.cellHeight = n;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            this.cellHeights = new int[this.list.getModel().getSize()];
        }
        if (n2 == -1 || n == -1) {
            ListModel listModel = this.list.getModel();
            int n4 = listModel.getSize();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            if (listCellRenderer != null) {
                for (int i = 0; i < n4; ++i) {
                    Object object = listModel.getElementAt(i);
                    Component component = listCellRenderer.getListCellRendererComponent(this.list, object, i, false, false);
                    this.rendererPane.add(component);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n != -1 || this.cellHeights == null) continue;
                    this.cellHeights[i] = dimension.height;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                if (this.cellHeights == null) {
                    this.cellHeights = new int[n4];
                }
                for (int i = 0; i < n4; ++i) {
                    this.cellHeights[i] = 0;
                }
            }
        }
        this.columnCount = 1;
        if (this.layoutOrientation != 0) {
            this.updateHorizontalLayoutState(n2, n);
        }
    }

    private void updateHorizontalLayoutState(int n, int n2) {
        int n3;
        int n4 = this.list.getVisibleRowCount();
        int n5 = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        this.listHeight = this.list.getHeight();
        this.listWidth = this.list.getWidth();
        if (n5 == 0) {
            this.columnCount = 0;
            this.rowsPerColumn = 0;
            this.preferredHeight = insets.top + insets.bottom;
            return;
        }
        if (n2 != -1) {
            n3 = n2;
        } else {
            int n6 = 0;
            if (this.cellHeights != null && this.cellHeights.length > 0) {
                n6 = this.cellHeights[this.cellHeights.length - 1];
                for (int i = this.cellHeights.length - 2; i >= 0; --i) {
                    n6 = Math.max(n6, this.cellHeights[i]);
                }
            }
            n3 = this.cellHeight = n6;
            this.cellHeights = null;
        }
        this.rowsPerColumn = n5;
        if (n4 > 0) {
            this.rowsPerColumn = n4;
            this.columnCount = Math.max(1, n5 / this.rowsPerColumn);
            if (n5 > 0 && n5 > this.rowsPerColumn && n5 % this.rowsPerColumn != 0) {
                ++this.columnCount;
            }
            if (this.layoutOrientation == 2) {
                this.rowsPerColumn = n5 / this.columnCount;
                if (n5 % this.columnCount > 0) {
                    ++this.rowsPerColumn;
                }
            }
        } else if (this.layoutOrientation == 1 && n3 != 0) {
            this.rowsPerColumn = Math.max(1, (this.listHeight - insets.top - insets.bottom) / n3);
            this.columnCount = Math.max(1, n5 / this.rowsPerColumn);
            if (n5 > 0 && n5 > this.rowsPerColumn && n5 % this.rowsPerColumn != 0) {
                ++this.columnCount;
            }
        } else if (this.layoutOrientation == 2 && this.cellWidth > 0 && this.listWidth > 0) {
            this.columnCount = Math.max(1, (this.listWidth - insets.left - insets.right) / this.cellWidth);
            this.rowsPerColumn = n5 / this.columnCount;
            if (n5 % this.columnCount > 0) {
                ++this.rowsPerColumn;
            }
        }
        this.preferredHeight = this.rowsPerColumn * this.cellHeight + insets.top + insets.bottom;
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private void checkSelectCurrentAction() {
        if (this.list.isSelectionEmpty() != this.hasSelectCurrentAction) {
            ActionMap actionMap = SwingUtilities.getUIActionMap(this.list);
            if (this.list.isSelectionEmpty()) {
                actionMap.put("selectCurrent", this.selectCurrentAction);
            } else {
                actionMap.remove("selectCurrent");
            }
            this.hasSelectCurrentAction = !this.hasSelectCurrentAction;
        }
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private KeyListener createKeyListener() {
        return new KeyHandler();
    }

    static class ListTransferHandler
    extends TransferHandler
    implements UIResource {
        ListTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JList) {
                JList jList = (JList)jComponent;
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray == null || objectArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<ul>\n");
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    String string = object == null ? "" : object.toString();
                    stringBuffer.append(string + "\n");
                    stringBuffer2.append("  <li>" + string + "\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</ul>\n</body>\n</html>");
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    class ListDropTargetListener
    extends BasicDropTargetListener {
        private int[] selectedIndices;

        ListDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            JList jList = (JList)jComponent;
            this.selectedIndices = jList.getSelectedIndices();
        }

        protected void restoreComponentState(JComponent jComponent) {
            JList jList = (JList)jComponent;
            jList.setSelectedIndices(this.selectedIndices);
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JList jList = (JList)jComponent;
            int n = BasicListUI.this.convertLocationToModel(point.x, point.y);
            if (n != -1) {
                jList.setSelectionInterval(n, n);
            }
        }
    }

    static class ListDragGestureRecognizer
    extends BasicDragGestureRecognizer {
        ListDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            ListUI listUI;
            int n;
            JList jList;
            return super.isDragPossible(mouseEvent) && (jList = (JList)this.getComponent(mouseEvent)).getDragEnabled() && (n = (listUI = jList.getUI()).locationToIndex(jList, new Point(mouseEvent.getX(), mouseEvent.getY()))) != -1 && jList.isSelectedIndex(n);
        }
    }

    private static class ClearSelectionAction
    extends AbstractAction {
        private ClearSelectionAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            jList.clearSelection();
        }
    }

    private static class SelectAllAction
    extends AbstractAction {
        private SelectAllAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            int n = jList.getModel().getSize();
            if (n > 0) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (listSelectionModel.getSelectionMode() == 0) {
                    if (jList.getMinSelectionIndex() == -1) {
                        jList.setSelectionInterval(0, 0);
                    }
                } else {
                    jList.setSelectionInterval(0, n - 1);
                    jList.ensureIndexIsVisible(jList.getLeadSelectionIndex());
                }
            }
        }
    }

    private static class PageDownAction
    extends IncrementLeadSelectionAction {
        protected PageDownAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            int n = jList.getLastVisibleIndex();
            ListSelectionModel listSelectionModel = jList.getSelectionModel();
            if (n == -1) {
                n = jList.getModel().getSize() - 1;
            }
            if (listSelectionModel.getLeadSelectionIndex() == n) {
                Rectangle rectangle = jList.getVisibleRect();
                rectangle.y += rectangle.height + rectangle.height - 1;
                n = jList.locationToIndex(rectangle.getLocation());
                if (n == -1) {
                    n = jList.getModel().getSize() - 1;
                }
            }
            return n;
        }

        protected void ensureIndexIsVisible(JList jList, int n) {
            Rectangle rectangle = jList.getVisibleRect();
            Rectangle rectangle2 = jList.getCellBounds(n, n);
            rectangle2.y = Math.max(0, rectangle2.y + rectangle2.height - rectangle.height);
            rectangle2.height = rectangle.height;
            jList.scrollRectToVisible(rectangle2);
        }
    }

    private static class PageUpAction
    extends IncrementLeadSelectionAction {
        protected PageUpAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            int n = jList.getFirstVisibleIndex();
            ListSelectionModel listSelectionModel = jList.getSelectionModel();
            if (listSelectionModel.getLeadSelectionIndex() == n) {
                Rectangle rectangle = jList.getVisibleRect();
                rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                n = jList.locationToIndex(rectangle.getLocation());
            }
            return n;
        }

        protected void ensureIndexIsVisible(JList jList, int n) {
            Rectangle rectangle = jList.getVisibleRect();
            Rectangle rectangle2 = jList.getCellBounds(n, n);
            rectangle2.height = rectangle.height;
            jList.scrollRectToVisible(rectangle2);
        }
    }

    private static class EndAction
    extends IncrementLeadSelectionAction {
        protected EndAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            return jList.getModel().getSize() - 1;
        }
    }

    private static class HomeAction
    extends IncrementLeadSelectionAction {
        protected HomeAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            return 0;
        }
    }

    private static class IncrementLeadByColumnAction
    extends IncrementLeadSelectionAction {
        IncrementLeadByColumnAction(String string, int n, int n2) {
            super(string, n, n2);
        }

        protected int getNextIndex(JList jList) {
            BasicListUI basicListUI;
            ListUI listUI;
            if (jList.getLayoutOrientation() != 0 && (listUI = jList.getUI()) instanceof BasicListUI && (basicListUI = (BasicListUI)listUI).columnCount > 1) {
                int n = jList.getLeadSelectionIndex();
                if (n == -1) {
                    return 0;
                }
                int n2 = jList.getModel().getSize();
                int n3 = basicListUI.convertModelToColumn(n);
                int n4 = basicListUI.convertModelToRow(n);
                if ((n3 += this.amount) >= basicListUI.columnCount || n3 < 0) {
                    return -1;
                }
                int n5 = basicListUI.getRowCount(n3);
                if (n4 >= n5) {
                    n4 = n5 - 1;
                }
                return basicListUI.getModelIndex(n3, n4);
            }
            return -1;
        }
    }

    private static class IncrementLeadSelectionAction
    extends AbstractAction {
        protected int amount;
        protected int selectionType;

        protected IncrementLeadSelectionAction(String string, int n) {
            this(string, n, -1);
        }

        protected IncrementLeadSelectionAction(String string, int n, int n2) {
            super(string);
            this.amount = n2;
            this.selectionType = n;
        }

        protected int getNextIndex(JList jList) {
            int n = jList.getLeadSelectionIndex();
            int n2 = jList.getModel().getSize();
            if (n == -1 || n >= n2) {
                if (n2 > 0) {
                    n = this.amount >= 0 ? 0 : n2 - 1;
                }
            } else {
                n += this.getAmount(jList);
            }
            return n;
        }

        protected int getAmount(JList jList) {
            ListUI listUI;
            if (jList.getLayoutOrientation() == 2 && (listUI = jList.getUI()) instanceof BasicListUI) {
                return ((BasicListUI)listUI).columnCount * this.amount;
            }
            return this.amount;
        }

        protected void ensureIndexIsVisible(JList jList, int n) {
            jList.ensureIndexIsVisible(n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            int n = this.getNextIndex(jList);
            if (jList.getModel().getSize() == 1) {
                n = 0;
            }
            if (n >= 0 && n < jList.getModel().getSize()) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (this.selectionType == 2) {
                    listSelectionModel.setLeadSelectionIndex(n);
                } else if (this.selectionType == 1) {
                    jList.setSelectedIndex(n);
                } else {
                    listSelectionModel.setLeadSelectionIndex(n);
                }
                this.ensureIndexIsVisible(jList, n);
            }
        }
    }

    private static class KeyHandler
    implements KeyListener {
        private String prefix = "";
        private transient String typedString = "";
        private long lastTime = 0L;

        private KeyHandler() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n;
            JList jList = (JList)keyEvent.getSource();
            ListModel listModel = jList.getModel();
            if (listModel.getSize() == 0 || keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                return;
            }
            boolean bl = true;
            char c = keyEvent.getKeyChar();
            long l = keyEvent.getWhen();
            int n2 = jList.getSelectedIndex();
            if (l - this.lastTime < 1000L) {
                this.typedString = this.typedString + c;
                if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                    ++n2;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++n2;
                this.prefix = this.typedString = "" + c;
            }
            this.lastTime = l;
            if (n2 < 0 || n2 >= listModel.getSize()) {
                bl = false;
                n2 = 0;
            }
            if ((n = jList.getNextMatch(this.prefix, n2, Position.Bias.Forward)) >= 0) {
                jList.setSelectedIndex(n);
                jList.ensureIndexIsVisible(n);
            } else if (bl && (n = jList.getNextMatch(this.prefix, 0, Position.Bias.Forward)) >= 0) {
                jList.setSelectedIndex(n);
                jList.ensureIndexIsVisible(n);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DropTarget dropTarget;
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                if (listModel != null) {
                    listModel.removeListDataListener(BasicListUI.this.listDataListener);
                }
                if (listModel2 != null) {
                    listModel2.addListDataListener(BasicListUI.this.listDataListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (string.equals("selectionModel")) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                if (listSelectionModel != null) {
                    listSelectionModel.removeListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                if (listSelectionModel2 != null) {
                    listSelectionModel2.addListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (string.equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                BasicListUI.this.redrawList();
            } else if (string.equals("font")) {
                BasicListUI.this.updateLayoutStateNeeded |= 4;
                BasicListUI.this.redrawList();
            } else if (string.equals("prototypeCellValue")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x20;
                BasicListUI.this.redrawList();
            } else if (string.equals("fixedCellHeight")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x10;
                BasicListUI.this.redrawList();
            } else if (string.equals("fixedCellWidth")) {
                BasicListUI.this.updateLayoutStateNeeded |= 8;
                BasicListUI.this.redrawList();
            } else if (string.equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                BasicListUI.this.redrawList();
            } else if (string.equals("selectionForeground")) {
                BasicListUI.this.list.repaint();
            } else if (string.equals("selectionBackground")) {
                BasicListUI.this.list.repaint();
            } else if ("layoutOrientation".equals(string)) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x80;
                BasicListUI.this.layoutOrientation = BasicListUI.this.list.getLayoutOrientation();
                BasicListUI.this.redrawList();
            } else if ("visibleRowCount".equals(string)) {
                if (BasicListUI.this.layoutOrientation != 0) {
                    BasicListUI.this.updateLayoutStateNeeded |= 0x80;
                    BasicListUI.this.redrawList();
                }
            } else if ("componentOrientation".equals(string)) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x400;
                BasicListUI.this.redrawList();
                InputMap inputMap = BasicListUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(BasicListUI.this.list, 0, inputMap);
            } else if ("transferHandler".equals(string) && (dropTarget = BasicListUI.this.list.getDropTarget()) instanceof UIResource) {
                try {
                    dropTarget.addDropTargetListener(new ListDropTargetListener());
                }
                catch (TooManyListenersException tooManyListenersException) {
                    // empty catch block
                }
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(n, n2 - n + 1, true);
            }
            BasicListUI.this.redrawList();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
                listSelectionModel.setAnchorSelectionIndex(-1);
            }
            BasicListUI.this.redrawList();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            BasicListUI.this.redrawList();
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BasicListUI.this.maybeUpdateLayoutState();
            Rectangle rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex());
            if (rectangle != null) {
                BasicListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (BasicListUI.this.list.isFocusOwner()) {
                BasicListUI.this.checkSelectCurrentAction();
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        protected void repaintCellFocus() {
            Rectangle rectangle;
            int n = BasicListUI.this.list.getLeadSelectionIndex();
            if (n != -1 && (rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n)) != null) {
                BasicListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (BasicListUI.this.list.getModel().getSize() > 0 && (listSelectionModel.getLeadSelectionIndex() < 0 || listSelectionModel.getLeadSelectionIndex() >= BasicListUI.this.list.getModel().getSize())) {
                listSelectionModel.setAnchorSelectionIndex(0);
                listSelectionModel.setLeadSelectionIndex(0);
                listSelectionModel.clearSelection();
            }
            this.repaintCellFocus();
            BasicListUI.this.checkSelectCurrentAction();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private boolean selectedOnPress;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(mouseEvent);
        }

        void adjustFocusAndSelection(MouseEvent mouseEvent) {
            int n;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicListUI.this.list.isEnabled()) {
                return;
            }
            if (!BasicListUI.this.list.hasFocus() && BasicListUI.this.list.isRequestFocusEnabled()) {
                BasicListUI.this.list.requestFocus();
            }
            if ((n = BasicListUI.this.convertLocationToModel(mouseEvent.getX(), mouseEvent.getY())) != -1) {
                boolean bl = mouseEvent.getID() == 501;
                BasicListUI.this.list.setValueIsAdjusting(bl);
                int n2 = BasicListUI.this.list.getAnchorSelectionIndex();
                if (mouseEvent.isControlDown()) {
                    if (BasicListUI.this.list.isSelectedIndex(n)) {
                        BasicListUI.this.list.removeSelectionInterval(n, n);
                    } else {
                        BasicListUI.this.list.addSelectionInterval(n, n);
                    }
                } else if (mouseEvent.isShiftDown() && n2 != -1) {
                    BasicListUI.this.list.setSelectionInterval(n2, n);
                } else {
                    BasicListUI.this.list.setSelectionInterval(n, n);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicListUI.this.list.isEnabled()) {
                return;
            }
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                return;
            }
            int n = BasicListUI.this.convertLocationToModel(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1 && (rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n)) != null) {
                BasicListUI.this.list.scrollRectToVisible(rectangle);
                BasicListUI.this.list.setSelectionInterval(n, n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selectedOnPress) {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                BasicListUI.this.list.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(mouseEvent);
            }
        }
    }
}

