/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.PlatformFont;
import sun.awt.image.ByteComponentRaster;
import sun.awt.windows.WImage;
import sun.awt.windows.WPrinterJob;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;
import sun.print.RasterPrinterJob;

class WPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;
    private static final float MIN_DEVICE_LINEWIDTH = 1.2f;
    private static final float MAX_THINLINE_INCHES = 0.014f;
    private Font lastFont;
    private Font lastDeviceSizeFont;
    private int lastAngle;
    private float lastScaledFontSize;
    private float lastAverageWidthScale;

    WPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n, boolean bl) {
        super(graphics2D, printerJob, printable, pageFormat, n, bl);
    }

    public Graphics create() {
        return new WPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    public void draw(Shape shape) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = null;
            BasicStroke basicStroke2 = (BasicStroke)stroke;
            float f = basicStroke2.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f, f);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f2 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            if (f2 < 1.2f) {
                Point2D.Float float_2 = new Point2D.Float(1.2f, 1.2f);
                try {
                    AffineTransform affineTransform2 = affineTransform.createInverse();
                    affineTransform2.deltaTransform(float_2, float_2);
                    float f3 = Math.max(Math.abs(float_2.x), Math.abs(float_2.y));
                    basicStroke = new BasicStroke(f3, basicStroke2.getEndCap(), basicStroke2.getLineJoin(), basicStroke2.getMiterLimit(), basicStroke2.getDashArray(), basicStroke2.getDashPhase());
                    this.setStroke(basicStroke);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            super.draw(shape);
            if (basicStroke != null) {
                this.setStroke(basicStroke2);
            }
        } else {
            super.draw(shape);
        }
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        boolean bl = false;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(this.getFont().getTransform());
        int n = affineTransform2.getType();
        boolean bl2 = n != 32 && (n & 0x40) == 0;
        boolean bl3 = this.stringNeedsShaping(string);
        if (!WPrinterJob.shapeTextProp && bl2 && !bl3) {
            Font font;
            double d;
            Point2D.Float float_ = new Point2D.Float(f, f2);
            affineTransform.transform(float_, float_);
            Font font2 = this.getFont();
            float f3 = font2.getSize2D();
            Point2D.Double double_ = new Point2D.Double(0.0, 1.0);
            affineTransform2.deltaTransform(double_, double_);
            double d2 = Math.sqrt(double_.x * double_.x + double_.y * double_.y);
            float f4 = (float)((double)f3 * d2);
            Point2D.Double double_2 = new Point2D.Double(1.0, 0.0);
            affineTransform2.deltaTransform(double_2, double_2);
            double d3 = Math.sqrt(double_2.x * double_2.x + double_2.y * double_2.y);
            float f5 = (float)((double)f3 * d3);
            float f6 = (float)(d3 / d2);
            if (f6 > 0.999f && f6 < 1.001f) {
                f6 = 1.0f;
            }
            if ((d = Math.toDegrees(Math.atan2(double_2.y, double_2.x))) < 0.0) {
                d += 360.0;
            }
            if (d != 0.0) {
                d = 360.0 - d;
            }
            int n2 = (int)Math.round(d * 10.0);
            if (font2 != null && this.lastFont != null && this.lastDeviceSizeFont != null && f4 == this.lastScaledFontSize && f6 == this.lastAverageWidthScale && font2.equals(this.lastFont) && n2 == this.lastAngle) {
                font = this.lastDeviceSizeFont;
            } else {
                font = font2.deriveFont(f4);
                this.lastAngle = n2;
                this.lastScaledFontSize = f4;
                this.lastAverageWidthScale = f6;
                this.lastDeviceSizeFont = font;
                this.lastFont = font2;
            }
            WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
            boolean bl4 = false;
            boolean bl5 = wPrinterJob.setFont(font, n2, f6);
            if (!bl5 && SunGraphicsEnvironment.isLogicalFont(font) && (bl4 = wPrinterJob.setLogicalFont(font, n2, f6))) {
                try {
                    if (((PlatformFont)font.getPeer()).makeMultiCharsetString(string, false) == null) {
                        bl4 = false;
                    }
                }
                catch (Exception exception) {
                    bl4 = false;
                }
            }
            if (bl5 || bl4) {
                try {
                    wPrinterJob.setTextColor((Color)this.getPaint());
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("Expected a Color instance");
                }
                if (this.getClip() != null) {
                    this.deviceClip(this.getClip().getPathIterator(affineTransform));
                }
                wPrinterJob.textOut(string, float_.x, float_.y, bl4 ? font : null);
                bl = true;
            }
        }
        if (!bl) {
            super.drawString(string, f, f2);
        }
    }

    private boolean stringNeedsShaping(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if ((c & 0xFE00) == 0) continue;
            if (c >= '\u0590' && c <= '\u05ff') {
                bl = true;
                break;
            }
            if (c >= '\u0600' && c <= '\u06ff') {
                bl = true;
                break;
            }
            if (c >= '\u202a' && c <= '\u202e') {
                bl = true;
                break;
            }
            if (c < '\u206a' || c > '\u206f') continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        boolean bl = n3 < 0 || n4 < 0 ? false : this.drawImage(image, n, n2, n3, n4, color, imageObserver);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        boolean bl = n5 < 0 || n6 < 0 ? false : this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, n5, n6, imageObserver);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        float f = (float)(n3 - n) / (float)n9;
        float f2 = (float)(n4 - n2) / (float)n10;
        AffineTransform affineTransform = new AffineTransform(f, 0.0f, 0.0f, f2, (float)n - (float)n5 * f, (float)n2 - (float)n6 * f2);
        return this.drawImageToGDI(image, affineTransform, null, color, n5, n6, n9, n10, false);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        boolean bl = n < 0 || n2 < 0 ? false : this.drawImageToGDI(image, affineTransform, null, null, 0, 0, n, n2, false);
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        if (n3 < 0 || n4 < 0) {
            boolean bl = false;
        } else {
            AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2);
            boolean bl = this.drawImageToGDI(bufferedImage, affineTransform, null, null, 0, 0, n3, n4, false);
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage bufferedImage = null;
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
        this.drawImageToGDI(bufferedImage, affineTransform, null, null, 0, 0, n, n2, false);
    }

    private boolean drawBitmaskImage(Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, Color color, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        Image image2;
        ColorModel colorModel;
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof WImage) {
            image2 = (WImage)image;
            bufferedImage = image2.getBufferedImage();
            if (bufferedImage == null) {
                return true;
            }
            colorModel = image2.getColorModel();
        } else if (image instanceof VolatileImage) {
            bufferedImage = ((VolatileImage)image).getSnapshot();
            colorModel = bufferedImage.getColorModel();
        } else {
            return false;
        }
        if (!(colorModel instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        if (colorModel.getTransparency() != 2) {
            return false;
        }
        if (bufferedImageOp != null) {
            return false;
        }
        if (color != null && color.getAlpha() < 128) {
            return false;
        }
        if ((affineTransform.getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        if ((this.getTransform().getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        image2 = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n9 = indexColorModel.getTransparentPixel();
        byte[] byArray = new byte[indexColorModel.getMapSize()];
        indexColorModel.getAlphas(byArray);
        if (n9 >= 0) {
            byArray[n9] = 0;
        }
        int n10 = writableRaster.getWidth();
        int n11 = writableRaster.getHeight();
        if (n > n10 || n2 > n11) {
            return false;
        }
        if (n + n3 > n10) {
            n8 = n10;
            n7 = n8 - n;
        } else {
            n8 = n + n3;
            n7 = n3;
        }
        if (n2 + n4 > n11) {
            n6 = n11;
            n5 = n6 - n2;
        } else {
            n6 = n2 + n4;
            n5 = n4;
        }
        int[] nArray = new int[n7];
        for (int i = n2; i < n6; ++i) {
            int n12 = -1;
            writableRaster.getPixels(n, i, n7, 1, nArray);
            for (int j = n; j < n8; ++j) {
                if (byArray[nArray[j - n]] == 0) {
                    if (n12 < 0) continue;
                    image2 = bufferedImage.getSubimage(n12, i, j - n12, 1);
                    affineTransform.translate(n12, i);
                    this.drawImageToGDI(image2, affineTransform, bufferedImageOp, color, 0, 0, j - n12, 1, true);
                    affineTransform.translate(-n12, -i);
                    n12 = -1;
                    continue;
                }
                if (n12 >= 0) continue;
                n12 = j;
            }
            if (n12 < 0) continue;
            image2 = bufferedImage.getSubimage(n12, i, n8 - n12, 1);
            affineTransform.translate(n12, i);
            this.drawImageToGDI(image2, affineTransform, bufferedImageOp, color, 0, 0, n8 - n12, 1, true);
            affineTransform.translate(-n12, -i);
        }
        return true;
    }

    private boolean drawImageToGDI(Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Object object;
        if (image instanceof WImage && ((sun.awt.image.Image)(object = (WImage)image)).getBufferedImage() == null) {
            return false;
        }
        object = (WPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d = float_.distance(float_3);
        double d2 = float_2.distance(float_3);
        if (d != 0.0 && d2 != 0.0) {
            AffineTransform affineTransform3 = new AffineTransform(dArray[0] / d, dArray[1] / d2, dArray[2] / d, dArray[3] / d2, dArray[4] / d, dArray[5] / d2);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n, n2, n3, n4);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 0.001, rectangle2D.getHeight() + 0.001);
            int n5 = (int)rectangle2D.getWidth();
            int n6 = (int)rectangle2D.getHeight();
            if (n5 > 0 && n6 > 0) {
                boolean bl2 = true;
                if (!bl && this.hasTransparentPixels(image)) {
                    bl2 = false;
                    if (this.isBitmaskTransparency(image)) {
                        if (color == null) {
                            if (this.drawBitmaskImage(image, affineTransform, bufferedImageOp, color, n, n2, n3, n4)) {
                                return true;
                            }
                        } else if (color.getTransparency() == 1) {
                            bl2 = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        bl2 = true;
                    }
                } else {
                    color = null;
                }
                if ((n + n3 > image.getWidth(null) || n2 + n4 > image.getHeight(null)) && this.canDoRedraws()) {
                    bl2 = false;
                }
                if (!bl2) {
                    ((RasterPrinterJob)object).saveState(this.getTransform(), this.getClip(), rectangle2D, d, d2, float_4, affineTransform);
                    return true;
                }
                BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.transform(affineTransform3);
                if (color == null) {
                    color = Color.white;
                }
                graphics2D.drawImage(image, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4, color, null);
                Shape shape2 = this.getClip();
                this.clip(affineTransform.createTransformedShape(float_4));
                this.deviceClip(this.getClip().getPathIterator(this.getTransform()));
                Rectangle2D.Float float_5 = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                ((WPrinterJob)object).drawImage3ByteBGR(byteComponentRaster.getDataStorage(), float_5.x, float_5.y, (float)Math.rint((double)float_5.width + 0.5), (float)Math.rint((double)float_5.height + 0.5), 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.dispose();
                this.setClip(shape2);
            }
        }
        return true;
    }

    private boolean hasTransparentPixels(Image image) {
        Object object;
        ColorModel colorModel;
        boolean bl = true;
        BufferedImage bufferedImage = null;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof WImage) {
            object = (WImage)image;
            bufferedImage = ((sun.awt.image.Image)object).getBufferedImage();
            if (bufferedImage == null) {
                return false;
            }
            colorModel = ((sun.awt.image.Image)object).getColorModel();
        } else {
            if (image instanceof VolatileImage) {
                return false;
            }
            colorModel = null;
        }
        boolean bl2 = colorModel == null ? true : (bl = colorModel.getTransparency() != 1);
        if (bl && bufferedImage != null && bufferedImage.getType() == 2) {
            object = bufferedImage.getRaster().getDataBuffer();
            SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
            if (object instanceof DataBufferInt && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray = ((DataBufferInt)object).getData();
                int n = bufferedImage.getMinX();
                int n2 = bufferedImage.getMinY();
                int n3 = bufferedImage.getWidth();
                int n4 = bufferedImage.getHeight();
                int n5 = singlePixelPackedSampleModel.getScanlineStride();
                boolean bl3 = false;
                for (int i = n2; i < n2 + n4; ++i) {
                    int n6 = n2 * n5;
                    for (int j = n; j < n + n3; ++j) {
                        if ((nArray[n6 + j] & 0xFF000000) == -16777216) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) break;
                }
                if (!bl3) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean isBitmaskTransparency(Image image) {
        ColorModel colorModel = null;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof WImage) {
            WImage wImage = (WImage)image;
            colorModel = wImage.getColorModel();
        } else if (image instanceof VolatileImage) {
            return false;
        }
        return colorModel != null && colorModel.getTransparency() == 2;
    }

    public void redrawRegion(Rectangle2D rectangle2D, double d, double d2, Rectangle2D rectangle2D2, AffineTransform affineTransform) throws PrinterException {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, wPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f = (float)(wPrinterJob.getXRes() / d);
        float f2 = (float)(wPrinterJob.getYRes() / d2);
        proxyGraphics2D.scale(f / 72.0f, f2 / 72.0f);
        proxyGraphics2D.translate(-wPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / wPrinterJob.getXRes() * 72.0, -wPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / wPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n);
        graphics2D.dispose();
        this.clip(affineTransform.createTransformedShape(rectangle2D2));
        this.deviceClip(this.getClip().getPathIterator(this.getTransform()));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
        ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
        wPrinterJob.drawImage3ByteBGR(byteComponentRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectSolidBrush(color);
        wPrinterJob.fillPath();
    }

    protected void deviceClip(PathIterator pathIterator) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectClipPath();
    }

    protected void deviceFrameRect(int n, int n2, int n3, int n4, Color color) {
        boolean bl;
        AffineTransform affineTransform = this.getTransform();
        int n5 = affineTransform.getType();
        boolean bl2 = bl = (n5 & 0x30) != 0;
        if (bl) {
            this.draw(new Rectangle2D.Float(n, n2, n3, n4));
            return;
        }
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            int n6 = basicStroke.getEndCap();
            int n7 = basicStroke.getLineJoin();
            if (n6 == 2 && n7 == 0 && basicStroke.getMiterLimit() == 10.0f) {
                float f = basicStroke.getLineWidth();
                Point2D.Float float_ = new Point2D.Float(f, f);
                affineTransform.deltaTransform(float_, float_);
                float f2 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
                Point2D.Float float_2 = new Point2D.Float(n, n2);
                affineTransform.transform(float_2, float_2);
                Point2D.Float float_3 = new Point2D.Float(n + n3, n2 + n4);
                affineTransform.transform(float_3, float_3);
                float f3 = (float)(float_3.getX() - float_2.getX());
                float f4 = (float)(float_3.getY() - float_2.getY());
                WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
                if (wPrinterJob.selectStylePen(n6, n7, f2, color)) {
                    wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f3, f4);
                } else {
                    double d = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                    if ((double)f2 / d < (double)0.014f) {
                        wPrinterJob.selectPen(f2, color);
                        wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f3, f4);
                    } else {
                        this.draw(new Rectangle2D.Float(n, n2, n3, n4));
                    }
                }
            } else {
                this.draw(new Rectangle2D.Float(n, n2, n3, n4));
            }
        }
    }

    protected void deviceFillRect(int n, int n2, int n3, int n4, Color color) {
        boolean bl;
        AffineTransform affineTransform = this.getTransform();
        int n5 = affineTransform.getType();
        boolean bl2 = bl = (n5 & 0x30) != 0;
        if (bl) {
            this.fill(new Rectangle2D.Float(n, n2, n3, n4));
            return;
        }
        Point2D.Float float_ = new Point2D.Float(n, n2);
        affineTransform.transform(float_, float_);
        Point2D.Float float_2 = new Point2D.Float(n + n3, n2 + n4);
        affineTransform.transform(float_2, float_2);
        float f = (float)(float_2.getX() - float_.getX());
        float f2 = (float)(float_2.getY() - float_.getY());
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        wPrinterJob.fillRect((float)float_.getX(), (float)float_.getY(), f, f2, color);
    }

    protected void deviceDrawLine(int n, int n2, int n3, int n4, Color color) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            WPrinterJob wPrinterJob;
            BasicStroke basicStroke = (BasicStroke)stroke;
            if (basicStroke.getDashArray() != null) {
                this.draw(new Line2D.Float(n, n2, n3, n4));
                return;
            }
            float f = basicStroke.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f, f);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f2 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            Point2D.Float float_2 = new Point2D.Float(n, n2);
            affineTransform.transform(float_2, float_2);
            Point2D.Float float_3 = new Point2D.Float(n3, n4);
            affineTransform.transform(float_3, float_3);
            int n5 = basicStroke.getEndCap();
            int n6 = basicStroke.getLineJoin();
            if (float_3.getX() == float_2.getX() && float_3.getY() == float_2.getY()) {
                n5 = 1;
            }
            if ((wPrinterJob = (WPrinterJob)this.getPrinterJob()).selectStylePen(n5, n6, f2, color)) {
                wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
            } else {
                double d = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                if (n5 == 1 || (n == n3 || n2 == n4) && (double)f2 / d < (double)0.014f) {
                    wPrinterJob.selectPen(f2, color);
                    wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                    wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
                } else {
                    this.draw(new Line2D.Float(n, n2, n3, n4));
                }
            }
        }
    }

    private void convertToWPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
        wPrinterJob.setPolyFillMode(n);
        wPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    wPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    wPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    int n3 = wPrinterJob.getPenX();
                    int n4 = wPrinterJob.getPenY();
                    float f = (float)n3 + (fArray[0] - (float)n3) * 2.0f / 3.0f;
                    float f2 = (float)n4 + (fArray[1] - (float)n4) * 2.0f / 3.0f;
                    float f3 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f4 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    wPrinterJob.polyBezierTo(f, f2, f3, f4, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    wPrinterJob.polyBezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    wPrinterJob.closeFigure();
                }
            }
            pathIterator.next();
        }
        wPrinterJob.endPath();
    }
}

