/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dimension;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.peer.ScrollbarPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;

class WScrollbarPeer
extends WComponentPeer
implements ScrollbarPeer {
    private boolean dragInProgress = false;

    public Dimension getMinimumSize() {
        if (((Scrollbar)this.target).getOrientation() == 1) {
            return new Dimension(15, 50);
        }
        return new Dimension(50, 15);
    }

    public native void setValues(int var1, int var2, int var3, int var4);

    public native void setLineIncrement(int var1);

    public native void setPageIncrement(int var1);

    WScrollbarPeer(Scrollbar scrollbar) {
        super(scrollbar);
    }

    native void create(WComponentPeer var1);

    void initialize() {
        Scrollbar scrollbar = (Scrollbar)this.target;
        this.setValues(scrollbar.getValue(), scrollbar.getVisibleAmount(), scrollbar.getMinimum(), scrollbar.getMaximum());
        super.initialize();
    }

    private void postAdjustmentEvent(final int n, final int n2, final boolean bl) {
        final Scrollbar scrollbar = (Scrollbar)this.target;
        WToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(){

            public void run() {
                scrollbar.setValueIsAdjusting(bl);
                scrollbar.setValue(n2);
                WScrollbarPeer.this.postEvent(new AdjustmentEvent(scrollbar, 601, n, n2, bl));
            }
        });
    }

    void lineUp(int n) {
        this.postAdjustmentEvent(2, n, false);
    }

    void lineDown(int n) {
        this.postAdjustmentEvent(1, n, false);
    }

    void pageUp(int n) {
        this.postAdjustmentEvent(3, n, false);
    }

    void pageDown(int n) {
        this.postAdjustmentEvent(4, n, false);
    }

    void warp(int n) {
        this.postAdjustmentEvent(5, n, false);
    }

    void drag(int n) {
        if (!this.dragInProgress) {
            this.dragInProgress = true;
        }
        this.postAdjustmentEvent(5, n, true);
    }

    void dragEnd(final int n) {
        final Scrollbar scrollbar = (Scrollbar)this.target;
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        WToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(){

            public void run() {
                scrollbar.setValueIsAdjusting(false);
                WScrollbarPeer.this.postEvent(new AdjustmentEvent(scrollbar, 601, 5, n, false));
            }
        });
    }

    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }
}

