/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.HostnameNormalizer;
import com.ibm.websphere.naming.WsnBatchModeContext;
import com.ibm.websphere.naming.WsnBatchResult;
import com.ibm.websphere.naming.WsnOptimizedJndiContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.jbatch.BatchModeNotSupported;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.NameFormatHelper;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public class JndiHelper {
    private static final int BIND = 1;
    private static final int REBIND = 2;
    private static final int CREATE_SUBCONTEXT = 3;
    private static final String _sourceInfo = "@(#) 1.20 ws/code/naming/src/com/ibm/websphere/naming/JndiHelper.java, WAS.naming, ASV 9/18/02 14:31:18 [10/15/02 11:04:58]";
    private static final TraceComponent _tc = Tr.register(class$com$ibm$websphere$naming$JndiHelper == null ? (class$com$ibm$websphere$naming$JndiHelper = JndiHelper.class$("com.ibm.websphere.naming.JndiHelper")) : class$com$ibm$websphere$naming$JndiHelper, "Naming");
    private static HostnameNormalizer _hostnameNormalizer = null;
    static /* synthetic */ Class class$com$ibm$websphere$naming$JndiHelper;

    private JndiHelper() {
    }

    public static Context recursiveCreateSubcontext(Context context, String string) throws NamingException {
        NameParser nameParser = context.getNameParser("");
        Name name = nameParser.parse(string);
        return JndiHelper.recursiveCreateSubcontext(context, name);
    }

    public static Context recursiveCreateSubcontext(Context context, Name name) throws NamingException {
        Object object;
        Object object2;
        Tr.entry(_tc, "recursiveCreateSubcontext ", _sourceInfo);
        Context context2 = null;
        boolean bl = false;
        WsnBatchModeContext wsnBatchModeContext = null;
        context = (Context)CommonHelpers.extractCtxImplFromInitCtx(context);
        try {
            object2 = CommonHelpers.getContextIfUrlName(name, context.getEnvironment());
            if (object2 != null) {
                context = object2;
                object = object2.getNameParser("");
                String string = NameFormatHelper.getUrlScheme(name);
                String string2 = name.toString();
                string2 = string2.substring(string.length() + 1);
                name = object.parse(string2);
                if (_tc.isDebugEnabled()) {
                    Tr.exit(_tc, "recursiveCreateSubcontext: URL name.", new Object[]{"newStartingContext=" + context.getNameInNamespace() + ", name=" + string2});
                }
            }
        }
        catch (NamingException namingException) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "recursiveCreateSubcontext: Could not process URL.  Rethrowing NamingException: " + namingException);
            }
            throw namingException;
        }
        if (context instanceof WsnBatchModeContext) {
            wsnBatchModeContext = (WsnBatchModeContext)context;
            context = wsnBatchModeContext.getNonBatchModeContext();
        }
        if (context instanceof WsnOptimizedJndiContext && !((WsnOptimizedJndiContext)((Object)context)).isLocal()) {
            bl = true;
            if (wsnBatchModeContext == null) {
                try {
                    wsnBatchModeContext = ((WsnOptimizedJndiContext)((Object)context)).getBatchModeContext();
                }
                catch (BatchModeNotSupported batchModeNotSupported) {
                    Tr.debug(_tc, "Batch mode not supported ", batchModeNotSupported);
                    wsnBatchModeContext = null;
                    bl = false;
                }
            }
        }
        if (bl) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "recursiveCreateSubcontext", " using batch");
            }
            JndiHelper.batchCreateSubcontextsDriver(wsnBatchModeContext, name);
            object2 = wsnBatchModeContext.executeBatchedOperations();
            object = object2.getResultEnumeration();
            context2 = JndiHelper.getSubcontextFromBatchResults(context, (Enumeration)object, name.size());
        } else {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "recursiveCreateSubcontext", " not using batch");
            }
            context2 = JndiHelper.createSubcontextsDriver(context, name);
        }
        Tr.exit(_tc, "recursiveCreateSubcontext");
        return context2;
    }

    private static void batchCreateSubcontextsDriver(WsnBatchModeContext wsnBatchModeContext, Name name) throws NamingException {
        Tr.entry(_tc, "batchCreateSubcontextsDriver ", _sourceInfo);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "batchCreateSubcontextsDriver", name.toString());
        }
        Name name2 = null;
        wsnBatchModeContext.lookup(name);
        for (int i = 1; i <= name.size(); ++i) {
            name2 = name.getPrefix(i);
            wsnBatchModeContext.createSubcontext(name2);
        }
        Tr.exit(_tc, "batchCreateSubcontextsDriver");
    }

    private static Context createSubcontextsDriver(Context context, Name name) throws NamingException {
        Tr.entry(_tc, "createSubcontextsDriver ", _sourceInfo);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSubcontextsDriver", name.toString());
        }
        Context context2 = null;
        context2 = JndiHelper.createSubcontexts(context, name);
        Tr.exit(_tc, "createSubcontextsDriver");
        return context2;
    }

    private static Context createSubcontexts(Context context, Name name) throws NamingException {
        Context context2;
        block7: {
            Tr.entry(_tc, "createSubcontexts ", _sourceInfo);
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "createSubcontexts", name.toString());
            }
            context2 = null;
            try {
                context2 = context.createSubcontext(name);
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                Object object;
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "createSubcontexts", " caught NameAlreadyBoundException " + nameAlreadyBoundException);
                }
                if (!((object = context.lookup(name)) instanceof Context)) {
                    throw new NotContextException("Name \"" + name.toString() + "\", relative to context \"" + context.getNameInNamespace() + "\" is already bound to an object which is not a context.");
                }
                context2 = (Context)object;
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "createSubcontexts", " caught NameNotFoundException" + nameNotFoundException);
                }
                if (name.size() <= 1) break block7;
                Name name2 = name.getPrefix(name.size() - 1);
                context2 = JndiHelper.createSubcontexts(context, name2);
                context2 = context.createSubcontext(name);
            }
        }
        Tr.exit(_tc, "createSubcontexts");
        return context2;
    }

    public static void recursiveRebind(Context context, String string, Object object) throws NamingException {
        NameParser nameParser = context.getNameParser("");
        Name name = nameParser.parse(string);
        JndiHelper.recursiveBind(context, name, object, 2);
    }

    public static void recursiveRebind(Context context, Name name, Object object) throws NamingException {
        JndiHelper.recursiveBind(context, name, object, 2);
    }

    public static void recursiveBind(Context context, String string, Object object) throws NamingException {
        NameParser nameParser = context.getNameParser("");
        Name name = nameParser.parse(string);
        JndiHelper.recursiveBind(context, name, object, 1);
    }

    public static void recursiveBind(Context context, Name name, Object object) throws NamingException {
        JndiHelper.recursiveBind(context, name, object, 1);
    }

    private static void recursiveBind(Context context, Name name, Object object, int n) throws NamingException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Tr.entry(_tc, "recursiveBind ", _sourceInfo);
        boolean bl = false;
        WsnBatchModeContext wsnBatchModeContext = null;
        context = (Context)CommonHelpers.extractCtxImplFromInitCtx(context);
        try {
            object5 = CommonHelpers.getContextIfUrlName(name, context.getEnvironment());
            if (object5 != null) {
                context = object5;
                object4 = object5.getNameParser("");
                object3 = NameFormatHelper.getUrlScheme(name);
                object2 = name.toString();
                object2 = ((String)object2).substring(((String)object3).length() + 1);
                name = object4.parse((String)object2);
                if (_tc.isDebugEnabled()) {
                    Tr.exit(_tc, "recursiveBind: URL name.", new Object[]{"newStartingContext=" + context.getNameInNamespace() + ", name=" + (String)object2});
                }
            }
        }
        catch (NamingException namingException) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "recursiveBind: Could not process URL.  Rethrowing NamingException: " + namingException);
            }
            throw namingException;
        }
        if (context instanceof WsnBatchModeContext) {
            wsnBatchModeContext = (WsnBatchModeContext)context;
            context = wsnBatchModeContext.getNonBatchModeContext();
        }
        if (context instanceof WsnOptimizedJndiContext && !((WsnOptimizedJndiContext)((Object)context)).isLocal()) {
            bl = true;
            if (wsnBatchModeContext == null) {
                try {
                    wsnBatchModeContext = ((WsnOptimizedJndiContext)((Object)context)).getBatchModeContext();
                }
                catch (BatchModeNotSupported batchModeNotSupported) {
                    Tr.debug(_tc, "Batch mode not supported ", batchModeNotSupported);
                    wsnBatchModeContext = null;
                    bl = false;
                }
            }
        }
        object5 = name.getPrefix(name.size() - 1);
        object4 = null;
        if (bl) {
            WsnBatchResult wsnBatchResult;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "recursiveBind", " using batch ");
            }
            if (object5.size() > 0) {
                JndiHelper.batchCreateSubcontextsDriver(wsnBatchModeContext, (Name)object5);
            }
            if (n == 1) {
                wsnBatchModeContext.bind(name, object);
            } else {
                wsnBatchModeContext.rebind(name, object);
            }
            object3 = wsnBatchModeContext.executeBatchedOperations();
            object2 = object3.getResultEnumeration();
            if (object5.size() > 0) {
                object4 = JndiHelper.getSubcontextFromBatchResults(context, (Enumeration)object2, object5.size());
            }
            if (!(wsnBatchResult = (WsnBatchResult)object2.nextElement()).getResult()) {
                throw wsnBatchResult.getException();
            }
        } else {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "recursiveBind", " not using batch ");
            }
            if (object5.size() > 0) {
                object4 = JndiHelper.createSubcontextsDriver(context, (Name)object5);
            }
            if (n == 1) {
                context.bind(name, object);
            } else {
                context.rebind(name, object);
            }
        }
        Tr.exit(_tc, "recursiveBind");
    }

    private static Context getSubcontextFromBatchResults(Context context, Enumeration enumeration, int n) throws NamingException {
        Context context2 = null;
        WsnBatchResult wsnBatchResult = (WsnBatchResult)enumeration.nextElement();
        if (wsnBatchResult.getResult()) {
            Object object = wsnBatchResult.getOutputObject();
            if (!(object instanceof Context)) {
                throw new NotContextException("Name \"" + wsnBatchResult.getName().toString() + "\", relative to context \"" + context.getNameInNamespace() + "\" is already bound to an object which is not a context.");
            }
            context2 = (Context)object;
            for (int i = 0; i < n; ++i) {
                wsnBatchResult = (WsnBatchResult)enumeration.nextElement();
            }
            return context2;
        }
        for (int i = 0; enumeration.hasMoreElements() && i < n; ++i) {
            wsnBatchResult = (WsnBatchResult)enumeration.nextElement();
            if (wsnBatchResult.getResult()) continue;
            NamingException namingException = wsnBatchResult.getException();
            if (namingException instanceof NameAlreadyBoundException) continue;
            throw namingException;
        }
        return context2;
    }

    public static String normalizeHostname(Hashtable hashtable) throws NamingException {
        Tr.entry(_tc, "normalizeHostname");
        if (hashtable == null) {
            hashtable = CommonHelpers.getWsnJndiProperties();
        }
        JndiHelper.initializeHostnameNormalizer(hashtable);
        boolean bl = JndiHelper.needToEscapeDots(hashtable);
        String string = _hostnameNormalizer.normalizeHostname(bl);
        Tr.exit(_tc, "normalizeHostname");
        return string;
    }

    public static String normalizeHostname(Hashtable hashtable, String string) throws NamingException {
        Tr.entry(_tc, "normalizeHostname");
        if (string == null) {
            JndiHelper.nullParam("hostname");
        }
        if (hashtable == null) {
            hashtable = CommonHelpers.getWsnJndiProperties();
        }
        JndiHelper.initializeHostnameNormalizer(hashtable);
        boolean bl = JndiHelper.needToEscapeDots(hashtable);
        String string2 = _hostnameNormalizer.normalizeHostname(bl, string);
        Tr.exit(_tc, "normalizeHostname");
        return string2;
    }

    public static String normalizeHostname(Hashtable hashtable, InetAddress inetAddress) throws NamingException {
        Tr.entry(_tc, "normalizeHostname");
        if (inetAddress == null) {
            JndiHelper.nullParam("ipAddress");
        }
        if (hashtable == null) {
            hashtable = CommonHelpers.getWsnJndiProperties();
        }
        JndiHelper.initializeHostnameNormalizer(hashtable);
        boolean bl = JndiHelper.needToEscapeDots(hashtable);
        String string = _hostnameNormalizer.normalizeHostname(bl, inetAddress);
        Tr.exit(_tc, "normalizeHostname");
        return string;
    }

    private static Hashtable nullParam(String string) throws NamingException {
        String string2 = "Parameter \"" + string + "\" is null.  Null is not a valid value for this call.";
        NamingException namingException = null;
        namingException = new NamingException(string2);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, string2, namingException);
        }
        throw namingException;
    }

    private static boolean needToEscapeDots(Hashtable hashtable) throws NamingException {
        Tr.entry(_tc, "needToEscapeDots");
        String string = (String)hashtable.get("com.ibm.websphere.naming.name.syntax");
        if (string == null) {
            String string2 = "Failed to get com.ibm.websphere.naming.name.syntax from environment.  Please ensure that the environment parameter  has been obtained by a getEnvironment() call on a valid Context. ";
            if (_tc.isDebugEnabled()) {
                Tr.warning(_tc, "environment not valid", "com.ibm.websphere.naming.name.syntax");
            }
            NamingException namingException = new NamingException(string2);
            Tr.debug(_tc, string2, namingException);
            Tr.exit(_tc, "needToExcapeDots");
            throw namingException;
        }
        boolean bl = string.equals("ins");
        Tr.exit(_tc, "needToEscapeDots");
        return bl;
    }

    private static void initializeHostnameNormalizer(Hashtable hashtable) throws NamingException {
        Tr.entry(_tc, "initializeHostnameNormalizer");
        if (_hostnameNormalizer == null) {
            String string = (String)hashtable.get("com.ibm.websphere.naming.hostname.normalizer");
            if (string == null) {
                String string2 = "Failed to get com.ibm.websphere.naming.hostname.normalizer from environment.  Please ensure that the environment parameter  has been obtained by a getEnvironment() call on a valid Context. ";
                if (_tc.isDebugEnabled()) {
                    Tr.warning(_tc, "environment not valid", "com.ibm.websphere.naming.hostname.normalizer");
                }
                NamingException namingException = new NamingException(string2);
                Tr.debug(_tc, string2, namingException);
                Tr.exit(_tc, "initializeHostnameNormalizer");
                throw namingException;
            }
            Class<?> clazz = null;
            try {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Implementation Class=" + string);
                }
                clazz = Class.forName(string);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.websphere.naming.JndiHelper.initializeHostnameNormalizer", "775");
                String string3 = "Failed to create Class object for the class " + string + ". ";
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, string3, exception);
                }
                Tr.warning(_tc, "cannotGetClassObj", string);
                NamingException namingException = new NamingException(string3 + "Please get the root cause Throwable contained in this NamingException for more information.");
                namingException.setRootCause(exception);
                Tr.exit(_tc, "initializeHostnameNormalizer");
                throw namingException;
            }
            try {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Getting the Constructor for Class=" + string);
                }
                Constructor<?> constructor = clazz.getConstructor(null);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Creating an instance for Class=" + string);
                }
                Object obj = constructor.newInstance(null);
                _hostnameNormalizer = (HostnameNormalizer)obj;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.websphere.naming.JndiHelper.initializeHostnameNormalizer", "803");
                String string4 = "Could not create an instance of the class " + string + ". ";
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, string4, exception);
                }
                Tr.warning(_tc, "cannotCreateObj", string);
                NamingException namingException = new NamingException(string4 + "Please get the root cause Throwable contained in this NamingException for more information.");
                namingException.setRootCause(exception);
                Tr.exit(_tc, "initializeHostnameNormalizer");
                throw namingException;
            }
        }
        Tr.exit(_tc, "initializeHostnameNormalizer");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

