/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import tcl.lang.Channel;
import tcl.lang.ConsoleEvent;
import tcl.lang.Interp;
import tcl.lang.StdChannel;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

class ConsoleThread
extends Thread {
    Interp interp;
    Vector historyObjs;
    StringBuffer sbuf;
    private Channel in;
    private Channel out;
    private Channel err;
    private static final boolean debug = false;
    private static boolean sysInAvailableWorks = false;

    ConsoleThread(Interp interp) {
        this.setName("ConsoleThread");
        this.interp = interp;
        this.sbuf = new StringBuffer(100);
        this.historyObjs = new Vector();
        this.out = new StdChannel("stdout");
        this.err = new StdChannel("stderr");
    }

    public synchronized void run() {
        this.put(this.out, "% ");
        while (true) {
            TclObject tclObject;
            this.getLine();
            if (Interp.commandComplete(this.sbuf.toString())) {
                int n;
                Object object;
                ConsoleEvent consoleEvent = new ConsoleEvent(this.interp, this.sbuf.toString());
                this.interp.getNotifier().queueEvent(consoleEvent, 0);
                consoleEvent.sync();
                if (consoleEvent.evalResult != null) {
                    TclObject tclObject2;
                    object = consoleEvent.evalResult.toString();
                    if (((String)object).length() > 0) {
                        this.putLine(this.out, (String)object);
                    }
                    n = 0;
                    try {
                        tclObject2 = this.interp.getVar("historyLimit", 1);
                        if (tclObject2 != null) {
                            n = TclInteger.get((Interp)this.interp, (TclObject)tclObject2);
                        }
                    }
                    catch (TclException tclException) {
                        // empty catch block
                    }
                    if (n > 0) {
                        this.historyObjs.addElement(consoleEvent.evalResult);
                    } else {
                        consoleEvent.evalResult.release();
                    }
                    if (this.historyObjs.size() > n && this.historyObjs.size() > 0) {
                        tclObject2 = (TclObject)this.historyObjs.elementAt(0);
                        this.historyObjs.removeElementAt(0);
                        tclObject2.release();
                    }
                } else {
                    object = consoleEvent.evalException;
                    n = object.getCompletionCode();
                    if (n != 2 || (n = this.interp.updateReturnInfo()) != 0) {
                        switch (n) {
                            case 1: {
                                this.putLine(this.err, this.interp.getResult().toString());
                                break;
                            }
                            case 3: {
                                this.putLine(this.err, "invoked \"break\" outside of a loop");
                                break;
                            }
                            case 4: {
                                this.putLine(this.err, "invoked \"continue\" outside of a loop");
                                break;
                            }
                            default: {
                                this.putLine(this.err, "command returned bad code: " + n);
                            }
                        }
                    }
                }
                this.sbuf.setLength(0);
                try {
                    tclObject = this.interp.getVar("tcl_prompt1", 1);
                }
                catch (TclException tclException) {
                    tclObject = null;
                }
                if (tclObject != null) {
                    try {
                        this.interp.eval(tclObject.toString(), 1);
                    }
                    catch (TclException tclException) {
                        this.put(this.out, "% ");
                    }
                    continue;
                }
                this.put(this.out, "% ");
                continue;
            }
            try {
                tclObject = this.interp.getVar("tcl_prompt2", 1);
            }
            catch (TclException tclException) {
                tclObject = null;
            }
            if (tclObject != null) {
                try {
                    this.interp.eval(tclObject.toString(), 1);
                }
                catch (TclException tclException) {
                    this.put(this.out, "> ");
                }
                continue;
            }
            this.put(this.out, "> ");
        }
    }

    private void getLine() {
        int n = -1;
        if (sysInAvailableWorks) {
            try {
                n = 0;
                while (n == 0) {
                    n = System.in.available();
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                System.exit(0);
            }
            catch (EOFException eOFException) {
                System.exit(0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
        }
        char c = ' ';
        char c2 = ' ';
        while (n != 0) {
            try {
                int n2 = System.in.read();
                if (n2 == -1) {
                    if (this.sbuf.length() == 0) {
                        System.exit(0);
                    } else {
                        return;
                    }
                }
                c2 = (char)n2;
                --n;
                if (c2 == '\r') {
                    n2 = System.in.read();
                    if (n2 == -1) {
                        if (this.sbuf.length() == 0) {
                            System.exit(0);
                        } else {
                            return;
                        }
                    }
                    if ((c = (char)((char)n2)) == '\n') {
                        c2 = c;
                    } else {
                        this.sbuf.append(c2);
                        c2 = c;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
            this.sbuf.append(c2);
            if (c2 != 10) continue;
            return;
        }
    }

    private void putLine(Channel channel, String string) {
        this.put(channel, string);
        this.put(channel, "\n");
    }

    private void put(Channel channel, String string) {
        try {
            this.out.write(this.interp, string);
            this.out.flush(this.interp);
        }
        catch (Exception exception) {
            throw new TclRuntimeError("unexpected Exception " + exception);
        }
    }

    static {
        try {
            System.in.available();
            sysInAvailableWorks = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Util.isWindows()) {
            sysInAvailableWorks = false;
        }
    }
}

