/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

class InfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"args", "body", "cmdcount", "commands", "complete", "default", "exists", "globals", "hostname", "level", "library", "loaded", "locals", "nameofexecutable", "patchlevel", "procs", "script", "sharedlibextension", "tclversion", "vars"};
    static final int OPT_ARGS = 0;
    static final int OPT_BODY = 1;
    static final int OPT_CMDCOUNT = 2;
    static final int OPT_COMMANDS = 3;
    static final int OPT_COMPLETE = 4;
    static final int OPT_DEFAULT = 5;
    static final int OPT_EXISTS = 6;
    static final int OPT_GLOBALS = 7;
    static final int OPT_HOSTNAME = 8;
    static final int OPT_LEVEL = 9;
    static final int OPT_LIBRARY = 10;
    static final int OPT_LOADED = 11;
    static final int OPT_LOCALS = 12;
    static final int OPT_NAMEOFEXECUTABLE = 13;
    static final int OPT_PATCHLEVEL = 14;
    static final int OPT_PROCS = 15;
    static final int OPT_SCRIPT = 16;
    static final int OPT_SHAREDLIBEXTENSION = 17;
    static final int OPT_TCLVERSION = 18;
    static final int OPT_VARS = 19;

    InfoCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg arg ...?");
        }
        int n = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[1], (String[])validCmds, (String)"option", (int)0);
        switch (n) {
            case 0: {
                InfoCmd.InfoArgsCmd(interp, tclObjectArray);
                break;
            }
            case 1: {
                InfoCmd.InfoBodyCmd(interp, tclObjectArray);
                break;
            }
            case 2: {
                InfoCmd.InfoCmdCountCmd(interp, tclObjectArray);
                break;
            }
            case 3: {
                InfoCmd.InfoCommandsCmd(interp, tclObjectArray);
                break;
            }
            case 4: {
                InfoCmd.InfoCompleteCmd(interp, tclObjectArray);
                break;
            }
            case 5: {
                InfoCmd.InfoDefaultCmd(interp, tclObjectArray);
                break;
            }
            case 6: {
                InfoCmd.InfoExistsCmd(interp, tclObjectArray);
                break;
            }
            case 7: {
                InfoCmd.InfoGlobalsCmd(interp, tclObjectArray);
                break;
            }
            case 8: {
                InfoCmd.InfoHostnameCmd(interp, tclObjectArray);
                break;
            }
            case 9: {
                InfoCmd.InfoLevelCmd(interp, tclObjectArray);
                break;
            }
            case 10: {
                InfoCmd.InfoLibraryCmd(interp, tclObjectArray);
                break;
            }
            case 11: {
                InfoCmd.InfoLoadedCmd(interp, tclObjectArray);
                break;
            }
            case 12: {
                InfoCmd.InfoLocalsCmd(interp, tclObjectArray);
                break;
            }
            case 13: {
                InfoCmd.InfoNameOfExecutableCmd(interp, tclObjectArray);
                break;
            }
            case 14: {
                InfoCmd.InfoPatchLevelCmd(interp, tclObjectArray);
                break;
            }
            case 15: {
                InfoCmd.InfoProcsCmd(interp, tclObjectArray);
                break;
            }
            case 16: {
                InfoCmd.InfoScriptCmd(interp, tclObjectArray);
                break;
            }
            case 17: {
                InfoCmd.InfoSharedlibCmd(interp, tclObjectArray);
                break;
            }
            case 18: {
                InfoCmd.InfoTclVersionCmd(interp, tclObjectArray);
                break;
            }
            case 19: {
                InfoCmd.InfoVarsCmd(interp, tclObjectArray);
            }
        }
    }

    private static void InfoArgsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "procname");
        }
        String string = tclObjectArray[2].toString();
        Procedure procedure = Procedure.findProc(interp, string);
        if (procedure == null) {
            throw new TclException(interp, "\"" + string + "\" isn't a procedure");
        }
        TclObject tclObject = TclList.newInstance();
        int n = 0;
        while (n < procedure.argList.length) {
            TclObject tclObject2 = TclString.newInstance((Object)procedure.argList[n][0]);
            TclList.append(interp, tclObject, tclObject2);
            ++n;
        }
        interp.setResult(tclObject);
    }

    private static void InfoBodyCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "procname");
        }
        String string = tclObjectArray[2].toString();
        Procedure procedure = Procedure.findProc(interp, string);
        if (procedure == null) {
            throw new TclException(interp, "\"" + string + "\" isn't a procedure");
        }
        interp.setResult(procedure.body.toString());
    }

    private static void InfoCmdCountCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        interp.setResult(interp.cmdCount);
    }

    private static void InfoCommandsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        NamespaceCmd.Namespace namespace;
        String string;
        NamespaceCmd.Namespace namespace2 = NamespaceCmd.getGlobalNamespace(interp);
        NamespaceCmd.Namespace namespace3 = NamespaceCmd.getCurrentNamespace(interp);
        boolean bl = false;
        if (tclObjectArray.length == 2) {
            string = null;
            namespace = namespace3;
            bl = false;
        } else if (tclObjectArray.length == 3) {
            String string2 = tclObjectArray[2].toString();
            NamespaceCmd.Namespace[] namespaceArray = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] namespaceArray2 = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] namespaceArray3 = new NamespaceCmd.Namespace[1];
            String[] stringArray = new String[1];
            NamespaceCmd.getNamespaceForQualName(interp, string2, null, 0, namespaceArray, namespaceArray2, namespaceArray3, stringArray);
            namespace = namespaceArray[0];
            string = stringArray[0];
            if (namespace != null) {
                bl = string.compareTo(string2) != 0;
            }
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        TclObject tclObject = TclList.newInstance();
        if (namespace != null) {
            String string3;
            Enumeration enumeration = namespace.cmdTable.keys();
            while (enumeration.hasMoreElements()) {
                TclObject tclObject2;
                string3 = (String)enumeration.nextElement();
                if (string != null && !Util.stringMatch(string3, string)) continue;
                if (bl) {
                    WrappedCommand wrappedCommand = (WrappedCommand)namespace.cmdTable.get(string3);
                    tclObject2 = TclString.newInstance((String)interp.getCommandFullName(wrappedCommand));
                } else {
                    tclObject2 = TclString.newInstance((String)string3);
                }
                TclList.append(interp, tclObject, tclObject2);
            }
            if (namespace != namespace2 && !bl) {
                enumeration = namespace2.cmdTable.keys();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    if (string != null && !Util.stringMatch(string3, string) || namespace.cmdTable.get(string3) != null) continue;
                    TclList.append(interp, tclObject, TclString.newInstance((String)string3));
                }
            }
        }
        interp.setResult(tclObject);
    }

    private static void InfoCompleteCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "command");
        }
        interp.setResult(Interp.commandComplete(tclObjectArray[2].toString()));
    }

    private static void InfoDefaultCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 5) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "procname arg varname");
        }
        String string = tclObjectArray[2].toString();
        String string2 = tclObjectArray[3].toString();
        Procedure procedure = Procedure.findProc(interp, string);
        if (procedure == null) {
            throw new TclException(interp, "\"" + string + "\" isn't a procedure");
        }
        int n = 0;
        while (n < procedure.argList.length) {
            if (string2.equals(procedure.argList[n][0].toString())) {
                String string3 = tclObjectArray[4].toString();
                try {
                    if (procedure.argList[n][1] != null) {
                        interp.setVar(string3, procedure.argList[n][1], 0);
                        interp.setResult(1);
                    } else {
                        interp.setVar(string3, "", 0);
                        interp.setResult(0);
                    }
                }
                catch (TclException tclException) {
                    throw new TclException(interp, "couldn't store default value in variable \"" + string3 + "\"");
                }
                return;
            }
            ++n;
        }
        throw new TclException(interp, "procedure \"" + string + "\" doesn't have an argument \"" + string2 + "\"");
    }

    private static void InfoExistsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Var var = null;
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "varName");
        }
        String string = tclObjectArray[2].toString();
        Var[] varArray = Var.lookupVar(interp, string, null, 0, "access", false, false);
        if (varArray != null) {
            var = varArray[0];
        }
        if (var != null && !var.isVarUndefined()) {
            interp.setResult(true);
        } else {
            interp.setResult(false);
        }
    }

    private static void InfoGlobalsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        NamespaceCmd.Namespace namespace = NamespaceCmd.getGlobalNamespace(interp);
        if (tclObjectArray.length == 2) {
            string = null;
        } else if (tclObjectArray.length == 3) {
            string = tclObjectArray[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        TclObject tclObject = TclList.newInstance();
        Enumeration enumeration = namespace.varTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Var var = (Var)namespace.varTable.get(string2);
            if (var.isVarUndefined() || string != null && !Util.stringMatch(string2, string)) continue;
            TclList.append(interp, tclObject, TclString.newInstance((String)string2));
        }
        interp.setResult(tclObject);
    }

    private static void InfoHostnameCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        String string = null;
        if (string != null) {
            interp.setResult(string);
            return;
        }
        interp.setResult("unable to determine name of host");
    }

    private static void InfoLevelCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length == 2) {
            if (interp.varFrame == null) {
                interp.setResult(0);
            } else {
                interp.setResult(interp.varFrame.level);
            }
            return;
        }
        if (tclObjectArray.length == 3) {
            int n = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[2]);
            if (n <= 0) {
                if (interp.varFrame == null) {
                    throw new TclException(interp, "bad level \"" + tclObjectArray[2].toString() + "\"");
                }
                n += interp.varFrame.level;
            }
            CallFrame callFrame = interp.varFrame;
            while (callFrame != null) {
                if (callFrame.level == n) break;
                callFrame = callFrame.callerVar;
            }
            if (callFrame == null || callFrame.objv == null) {
                throw new TclException(interp, "bad level \"" + tclObjectArray[2].toString() + "\"");
            }
            TclObject tclObject = TclList.newInstance();
            int n2 = 0;
            while (n2 < callFrame.objv.length) {
                TclList.append(interp, tclObject, TclString.newInstance((Object)callFrame.objv[n2]));
                ++n2;
            }
            interp.setResult(tclObject);
            return;
        }
        throw new TclNumArgsException(interp, 2, tclObjectArray, "?number?");
    }

    private static void InfoLibraryCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        try {
            interp.setResult(interp.getVar("tcl_library", 1));
            return;
        }
        catch (TclException tclException) {
            throw new TclException(interp, "no library has been specified for Tcl");
        }
    }

    private static void InfoLoadedCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?interp?");
        }
        throw new TclException(interp, "info loaded not implemented");
    }

    private static void InfoLocalsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        if (tclObjectArray.length == 2) {
            string = null;
        } else if (tclObjectArray.length == 3) {
            string = tclObjectArray[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        if (interp.varFrame == null || !interp.varFrame.isProcCallFrame) {
            return;
        }
        TclObject tclObject = TclList.newInstance();
        InfoCmd.AppendLocals(interp, tclObject, string, false);
        interp.setResult(tclObject);
    }

    private static void AppendLocals(Interp interp, TclObject tclObject, String string, boolean bl) throws TclException {
        Hashtable hashtable = interp.varFrame.varTable;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Var var = (Var)hashtable.get(string2);
                if (var.isVarUndefined() || !bl && var.isVarLink() || string != null && !Util.stringMatch(string2, string)) continue;
                TclList.append(interp, tclObject, TclString.newInstance((String)string2));
            }
        }
    }

    private static void InfoNameOfExecutableCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        String string = null;
        if (string != null) {
            interp.setResult(string);
        }
    }

    private static void InfoPatchLevelCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        interp.setResult(interp.getVar("tcl_patchLevel", 1));
    }

    private static void InfoProcsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        NamespaceCmd.Namespace namespace = NamespaceCmd.getCurrentNamespace(interp);
        if (tclObjectArray.length == 2) {
            string = null;
        } else if (tclObjectArray.length == 3) {
            string = tclObjectArray[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        TclObject tclObject = TclList.newInstance();
        Enumeration enumeration = namespace.cmdTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            WrappedCommand wrappedCommand = (WrappedCommand)namespace.cmdTable.get(string2);
            WrappedCommand wrappedCommand2 = NamespaceCmd.getOriginalCommand(wrappedCommand);
            if (!Procedure.isProc(wrappedCommand) && (wrappedCommand2 == null || !Procedure.isProc(wrappedCommand2)) || string != null && !Util.stringMatch(string2, string)) continue;
            TclList.append(interp, tclObject, TclString.newInstance((String)string2));
        }
        interp.setResult(tclObject);
    }

    private static void InfoScriptCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        interp.setResult(interp.scriptFile);
    }

    private static void InfoSharedlibCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        interp.setResult(".jar");
    }

    private static void InfoTclVersionCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        interp.setResult(interp.getVar("tcl_version", 1));
    }

    private static void InfoVarsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        NamespaceCmd.Namespace namespace;
        String string;
        NamespaceCmd.Namespace namespace2 = NamespaceCmd.getGlobalNamespace(interp);
        NamespaceCmd.Namespace namespace3 = NamespaceCmd.getCurrentNamespace(interp);
        boolean bl = false;
        if (tclObjectArray.length == 2) {
            string = null;
            namespace = namespace3;
            bl = false;
        } else if (tclObjectArray.length == 3) {
            String string2 = tclObjectArray[2].toString();
            NamespaceCmd.Namespace[] namespaceArray = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] namespaceArray2 = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] namespaceArray3 = new NamespaceCmd.Namespace[1];
            String[] stringArray = new String[1];
            NamespaceCmd.getNamespaceForQualName(interp, string2, null, 0, namespaceArray, namespaceArray2, namespaceArray3, stringArray);
            namespace = namespaceArray[0];
            string = stringArray[0];
            if (namespace != null) {
                bl = string.compareTo(string2) != 0;
            }
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        if (namespace == null) {
            return;
        }
        TclObject tclObject = TclList.newInstance();
        if (interp.varFrame == null || !interp.varFrame.isProcCallFrame || bl) {
            Var var;
            String string3;
            Enumeration enumeration = namespace.varTable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                var = (Var)namespace.varTable.get(string3);
                if (var.isVarUndefined() && (var.flags & 0x80) == 0 || string != null && !Util.stringMatch(string3, string)) continue;
                TclObject tclObject2 = bl ? TclString.newInstance((String)Var.getVariableFullName(interp, var)) : TclString.newInstance((String)string3);
                TclList.append(interp, tclObject, tclObject2);
            }
            if (namespace != namespace2 && !bl) {
                enumeration = namespace2.varTable.keys();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    var = (Var)namespace2.varTable.get(string3);
                    if (var.isVarUndefined() && (var.flags & 0x80) == 0 || string != null && !Util.stringMatch(string3, string) || namespace.varTable.get(string3) != null) continue;
                    TclList.append(interp, tclObject, TclString.newInstance((String)string3));
                }
            }
        } else {
            InfoCmd.AppendLocals(interp, tclObject, string, true);
        }
        interp.setResult(tclObject);
    }
}

