/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.AssocData;
import tcl.lang.BackSlashResult;
import tcl.lang.BgErrorMgr;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.DebugInfo;
import tcl.lang.Env;
import tcl.lang.Expression;
import tcl.lang.Extension;
import tcl.lang.FileUtil;
import tcl.lang.ImportRef;
import tcl.lang.ImportedCmdData;
import tcl.lang.NamespaceCmd;
import tcl.lang.Notifier;
import tcl.lang.PackageCmd;
import tcl.lang.Parser;
import tcl.lang.Procedure;
import tcl.lang.RegexpCmd;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.VarTrace;
import tcl.lang.WrappedCommand;

public class Interp {
    Hashtable reflectIDTable = new Hashtable();
    Hashtable reflectObjTable = new Hashtable();
    long reflectObjCount = 0L;
    private Thread primaryThread;
    private static final int MAX_ERR_LENGTH = 200;
    static final String TCL_VERSION = "8.0";
    static final String TCL_PATCH_LEVEL = "8.0";
    protected int cmdCount;
    Hashtable interpChanTable;
    private Notifier notifier;
    Hashtable assocData;
    private File workingDir;
    CallFrame frame;
    CallFrame varFrame;
    NamespaceCmd.Namespace globalNs;
    String scriptFile;
    int nestLevel;
    int maxNestingDepth;
    int evalFlags;
    int flags;
    int termOffset;
    Expression expr;
    int noEval;
    boolean randSeedInit;
    long randSeed;
    String errorInfo;
    String errorCode;
    protected int returnCode;
    protected boolean deleted;
    protected boolean errInProgress;
    protected boolean errAlreadyLogged;
    protected boolean errCodeSet;
    int errorLine = 0;
    private TclObject m_result;
    private TclObject m_nullResult;
    Hashtable packageTable;
    String packageUnknown;
    TclObject[][][] parserObjv;
    int[] parserObjvUsed;
    TclToken[] parserTokens;
    int parserTokensUsed;
    Hashtable[] importTable = new Hashtable[]{new Hashtable(), new Hashtable()};
    protected DebugInfo dbg;
    static /* synthetic */ Class class$tcl$lang$Interp;

    public Interp() {
        this.m_nullResult = TclString.newInstance((String)"");
        this.m_nullResult.preserve();
        this.m_result = this.m_nullResult;
        this.expr = new Expression();
        this.nestLevel = 0;
        this.maxNestingDepth = 1000;
        this.frame = null;
        this.varFrame = null;
        this.returnCode = 0;
        this.errorInfo = null;
        this.errorCode = null;
        this.packageTable = new Hashtable();
        this.packageUnknown = null;
        this.cmdCount = 0;
        this.termOffset = 0;
        this.evalFlags = 0;
        this.scriptFile = null;
        this.flags = 0;
        this.assocData = null;
        this.globalNs = null;
        this.globalNs = NamespaceCmd.createNamespace(this, null, null);
        if (this.globalNs == null) {
            throw new TclRuntimeError("Interp(): can't create global namespace");
        }
        this.workingDir = new File(Util.tryGetSystemProperty("user.dir", "."));
        this.noEval = 0;
        this.primaryThread = Thread.currentThread();
        this.notifier = Notifier.getNotifierForThread(this.primaryThread);
        this.notifier.preserve();
        this.randSeedInit = false;
        this.deleted = false;
        this.errInProgress = false;
        this.errAlreadyLogged = false;
        this.errCodeSet = false;
        this.dbg = this.initDebugInfo();
        Parser.init(this);
        TclParse.init(this);
        this.interpChanTable = TclIO.getInterpChanTable(this);
        Util.setupPrecisionTrace(this);
        this.createCommands();
        try {
            this.setVar("tcl_platform", "platform", "java", 1);
            this.setVar("tcl_platform", "byteOrder", "bigEndian", 1);
            this.setVar("tcl_platform", "os", Util.tryGetSystemProperty("os.name", "?"), 1);
            this.setVar("tcl_platform", "osVersion", Util.tryGetSystemProperty("os.version", "?"), 1);
            this.setVar("tcl_platform", "machine", Util.tryGetSystemProperty("os.arch", "?"), 1);
            this.setVar("tcl_version", "8.0", 1);
            this.setVar("tcl_patchLevel", "8.0", 1);
            this.setVar("tcl_library", "resource:/tcl/lang/library", 1);
            if (Util.isWindows()) {
                this.setVar("tcl_platform", "host_platform", "windows", 1);
            } else if (Util.isMac()) {
                this.setVar("tcl_platform", "host_platform", "macintosh", 1);
            } else {
                this.setVar("tcl_platform", "host_platform", "unix", 1);
            }
            Env.initialize(this);
            this.pkgProvide("Tcl", "8.0");
            this.evalResource("/tcl/lang/library/init.tcl");
        }
        catch (TclException tclException) {
            System.out.println(this.getResult());
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)tclException));
        }
    }

    public void dispose() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        if (this.nestLevel > 0) {
            throw new TclRuntimeError("dispose() called with active evals");
        }
        if (this.notifier != null) {
            this.notifier.release();
            this.notifier = null;
        }
        NamespaceCmd.teardownNamespace(this.globalNs);
        TclObject tclObject = null;
        TclObject tclObject2 = null;
        try {
            tclObject = this.getVar("errorInfo", null, 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        if (tclObject != null) {
            tclObject.preserve();
        }
        try {
            tclObject2 = this.getVar("errorCode", null, 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        if (tclObject2 != null) {
            tclObject2.preserve();
        }
        this.frame = null;
        this.varFrame = null;
        try {
            if (tclObject != null) {
                this.setVar("errorInfo", null, tclObject, 1);
                tclObject.release();
            }
            if (tclObject2 != null) {
                this.setVar("errorCode", null, tclObject2, 1);
                tclObject2.release();
            }
        }
        catch (TclException tclException) {
            // empty catch block
        }
        this.expr = null;
        while (this.assocData != null) {
            Hashtable hashtable = this.assocData;
            this.assocData = null;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                AssocData assocData = (AssocData)hashtable.get(k);
                assocData.disposeAssocData(this);
                hashtable.remove(k);
            }
        }
        NamespaceCmd.deleteNamespace(this.globalNs);
        this.globalNs = null;
        this.frame = null;
        this.varFrame = null;
        this.resetResult();
    }

    protected void finalize() {
        this.dispose();
    }

    protected void createCommands() {
        Extension.loadOnDemand((Interp)this, (String)"after", (String)"tcl.lang.AfterCmd");
        Extension.loadOnDemand((Interp)this, (String)"append", (String)"tcl.lang.AppendCmd");
        Extension.loadOnDemand((Interp)this, (String)"array", (String)"tcl.lang.ArrayCmd");
        Extension.loadOnDemand((Interp)this, (String)"break", (String)"tcl.lang.BreakCmd");
        Extension.loadOnDemand((Interp)this, (String)"case", (String)"tcl.lang.CaseCmd");
        Extension.loadOnDemand((Interp)this, (String)"catch", (String)"tcl.lang.CatchCmd");
        Extension.loadOnDemand((Interp)this, (String)"cd", (String)"tcl.lang.CdCmd");
        Extension.loadOnDemand((Interp)this, (String)"clock", (String)"tcl.lang.ClockCmd");
        Extension.loadOnDemand((Interp)this, (String)"close", (String)"tcl.lang.CloseCmd");
        Extension.loadOnDemand((Interp)this, (String)"continue", (String)"tcl.lang.ContinueCmd");
        Extension.loadOnDemand((Interp)this, (String)"concat", (String)"tcl.lang.ConcatCmd");
        Extension.loadOnDemand((Interp)this, (String)"eof", (String)"tcl.lang.EofCmd");
        Extension.loadOnDemand((Interp)this, (String)"eval", (String)"tcl.lang.EvalCmd");
        Extension.loadOnDemand((Interp)this, (String)"error", (String)"tcl.lang.ErrorCmd");
        if (!Util.isMac()) {
            Extension.loadOnDemand((Interp)this, (String)"exec", (String)"tcl.lang.ExecCmd");
        }
        Extension.loadOnDemand((Interp)this, (String)"exit", (String)"tcl.lang.ExitCmd");
        Extension.loadOnDemand((Interp)this, (String)"expr", (String)"tcl.lang.ExprCmd");
        Extension.loadOnDemand((Interp)this, (String)"fblocked", (String)"tcl.lang.FblockedCmd");
        Extension.loadOnDemand((Interp)this, (String)"fconfigure", (String)"tcl.lang.FconfigureCmd");
        Extension.loadOnDemand((Interp)this, (String)"file", (String)"tcl.lang.FileCmd");
        Extension.loadOnDemand((Interp)this, (String)"flush", (String)"tcl.lang.FlushCmd");
        Extension.loadOnDemand((Interp)this, (String)"for", (String)"tcl.lang.ForCmd");
        Extension.loadOnDemand((Interp)this, (String)"foreach", (String)"tcl.lang.ForeachCmd");
        Extension.loadOnDemand((Interp)this, (String)"format", (String)"tcl.lang.FormatCmd");
        Extension.loadOnDemand((Interp)this, (String)"gets", (String)"tcl.lang.GetsCmd");
        Extension.loadOnDemand((Interp)this, (String)"global", (String)"tcl.lang.GlobalCmd");
        Extension.loadOnDemand((Interp)this, (String)"glob", (String)"tcl.lang.GlobCmd");
        Extension.loadOnDemand((Interp)this, (String)"if", (String)"tcl.lang.IfCmd");
        Extension.loadOnDemand((Interp)this, (String)"incr", (String)"tcl.lang.IncrCmd");
        Extension.loadOnDemand((Interp)this, (String)"info", (String)"tcl.lang.InfoCmd");
        Extension.loadOnDemand((Interp)this, (String)"list", (String)"tcl.lang.ListCmd");
        Extension.loadOnDemand((Interp)this, (String)"join", (String)"tcl.lang.JoinCmd");
        Extension.loadOnDemand((Interp)this, (String)"lappend", (String)"tcl.lang.LappendCmd");
        Extension.loadOnDemand((Interp)this, (String)"lindex", (String)"tcl.lang.LindexCmd");
        Extension.loadOnDemand((Interp)this, (String)"linsert", (String)"tcl.lang.LinsertCmd");
        Extension.loadOnDemand((Interp)this, (String)"llength", (String)"tcl.lang.LlengthCmd");
        Extension.loadOnDemand((Interp)this, (String)"lrange", (String)"tcl.lang.LrangeCmd");
        Extension.loadOnDemand((Interp)this, (String)"lreplace", (String)"tcl.lang.LreplaceCmd");
        Extension.loadOnDemand((Interp)this, (String)"lsearch", (String)"tcl.lang.LsearchCmd");
        Extension.loadOnDemand((Interp)this, (String)"lsort", (String)"tcl.lang.LsortCmd");
        Extension.loadOnDemand((Interp)this, (String)"namespace", (String)"tcl.lang.NamespaceCmd");
        Extension.loadOnDemand((Interp)this, (String)"open", (String)"tcl.lang.OpenCmd");
        Extension.loadOnDemand((Interp)this, (String)"package", (String)"tcl.lang.PackageCmd");
        Extension.loadOnDemand((Interp)this, (String)"proc", (String)"tcl.lang.ProcCmd");
        Extension.loadOnDemand((Interp)this, (String)"puts", (String)"tcl.lang.PutsCmd");
        Extension.loadOnDemand((Interp)this, (String)"pwd", (String)"tcl.lang.PwdCmd");
        Extension.loadOnDemand((Interp)this, (String)"read", (String)"tcl.lang.ReadCmd");
        Extension.loadOnDemand((Interp)this, (String)"regsub", (String)"tcl.lang.RegsubCmd");
        Extension.loadOnDemand((Interp)this, (String)"rename", (String)"tcl.lang.RenameCmd");
        Extension.loadOnDemand((Interp)this, (String)"return", (String)"tcl.lang.ReturnCmd");
        Extension.loadOnDemand((Interp)this, (String)"scan", (String)"tcl.lang.ScanCmd");
        Extension.loadOnDemand((Interp)this, (String)"seek", (String)"tcl.lang.SeekCmd");
        Extension.loadOnDemand((Interp)this, (String)"set", (String)"tcl.lang.SetCmd");
        Extension.loadOnDemand((Interp)this, (String)"socket", (String)"tcl.lang.SocketCmd");
        Extension.loadOnDemand((Interp)this, (String)"source", (String)"tcl.lang.SourceCmd");
        Extension.loadOnDemand((Interp)this, (String)"split", (String)"tcl.lang.SplitCmd");
        Extension.loadOnDemand((Interp)this, (String)"string", (String)"tcl.lang.StringCmd");
        Extension.loadOnDemand((Interp)this, (String)"subst", (String)"tcl.lang.SubstCmd");
        Extension.loadOnDemand((Interp)this, (String)"switch", (String)"tcl.lang.SwitchCmd");
        Extension.loadOnDemand((Interp)this, (String)"tell", (String)"tcl.lang.TellCmd");
        Extension.loadOnDemand((Interp)this, (String)"time", (String)"tcl.lang.TimeCmd");
        Extension.loadOnDemand((Interp)this, (String)"trace", (String)"tcl.lang.TraceCmd");
        Extension.loadOnDemand((Interp)this, (String)"unset", (String)"tcl.lang.UnsetCmd");
        Extension.loadOnDemand((Interp)this, (String)"update", (String)"tcl.lang.UpdateCmd");
        Extension.loadOnDemand((Interp)this, (String)"uplevel", (String)"tcl.lang.UplevelCmd");
        Extension.loadOnDemand((Interp)this, (String)"upvar", (String)"tcl.lang.UpvarCmd");
        Extension.loadOnDemand((Interp)this, (String)"variable", (String)"tcl.lang.VariableCmd");
        Extension.loadOnDemand((Interp)this, (String)"vwait", (String)"tcl.lang.VwaitCmd");
        Extension.loadOnDemand((Interp)this, (String)"while", (String)"tcl.lang.WhileCmd");
        RegexpCmd.init(this);
        Extension.loadOnDemand((Interp)this, (String)"jaclloadjava", (String)"tcl.lang.JaclLoadJavaCmd");
        try {
            this.eval("package ifneeded java 1.2.6 jaclloadjava");
        }
        catch (TclException tclException) {
            System.out.println(this.getResult());
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)tclException));
        }
    }

    public void setAssocData(String string, AssocData assocData) {
        if (this.assocData == null) {
            this.assocData = new Hashtable();
        }
        this.assocData.put(string, assocData);
    }

    public void deleteAssocData(String string) {
        if (this.assocData == null) {
            return;
        }
        this.assocData.remove(string);
    }

    public AssocData getAssocData(String string) {
        if (this.assocData == null) {
            return null;
        }
        return (AssocData)this.assocData.get(string);
    }

    public void backgroundError() {
        BgErrorMgr bgErrorMgr = (BgErrorMgr)this.getAssocData("tclBgError");
        if (bgErrorMgr == null) {
            bgErrorMgr = new BgErrorMgr(this);
            this.setAssocData("tclBgError", bgErrorMgr);
        }
        bgErrorMgr.addBgError();
    }

    final TclObject setVar(TclObject tclObject, TclObject tclObject2, int n) throws TclException {
        return Var.setVar(this, tclObject, tclObject2, n | 0x200);
    }

    public final TclObject setVar(String string, TclObject tclObject, int n) throws TclException {
        return Var.setVar(this, string, tclObject, n | 0x200);
    }

    public final TclObject setVar(String string, String string2, TclObject tclObject, int n) throws TclException {
        return Var.setVar(this, string, string2, tclObject, n | 0x200);
    }

    final void setVar(String string, String string2, int n) throws TclException {
        Var.setVar(this, string, TclString.newInstance((String)string2), n | 0x200);
    }

    final void setVar(String string, String string2, String string3, int n) throws TclException {
        Var.setVar(this, string, string2, TclString.newInstance((String)string3), n | 0x200);
    }

    final TclObject getVar(TclObject tclObject, int n) throws TclException {
        return Var.getVar(this, tclObject, n | 0x200);
    }

    public final TclObject getVar(String string, int n) throws TclException {
        return Var.getVar(this, string, n | 0x200);
    }

    public final TclObject getVar(String string, String string2, int n) throws TclException {
        return Var.getVar(this, string, string2, n | 0x200);
    }

    final void unsetVar(TclObject tclObject, int n) throws TclException {
        Var.unsetVar(this, tclObject, n | 0x200);
    }

    public final void unsetVar(String string, int n) throws TclException {
        Var.unsetVar(this, string, n | 0x200);
    }

    public final void unsetVar(String string, String string2, int n) throws TclException {
        Var.unsetVar(this, string, string2, n | 0x200);
    }

    void traceVar(TclObject tclObject, VarTrace varTrace, int n) throws TclException {
        Var.traceVar(this, tclObject, n, varTrace);
    }

    public void traceVar(String string, VarTrace varTrace, int n) throws TclException {
        Var.traceVar(this, string, n, varTrace);
    }

    public void traceVar(String string, String string2, VarTrace varTrace, int n) throws TclException {
        Var.traceVar(this, string, string2, n, varTrace);
    }

    void untraceVar(TclObject tclObject, VarTrace varTrace, int n) {
        Var.untraceVar(this, tclObject, n, varTrace);
    }

    public void untraceVar(String string, VarTrace varTrace, int n) {
        Var.untraceVar(this, string, n, varTrace);
    }

    public void untraceVar(String string, String string2, VarTrace varTrace, int n) {
        Var.untraceVar(this, string, string2, n, varTrace);
    }

    public void createCommand(String string, Command command) {
        WrappedCommand wrappedCommand;
        String string2;
        NamespaceCmd.Namespace namespace;
        ImportRef importRef = null;
        if (this.deleted) {
            return;
        }
        if (string.indexOf("::") != -1) {
            NamespaceCmd.Namespace[] namespaceArray = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] namespaceArray2 = new NamespaceCmd.Namespace[1];
            String[] stringArray = new String[1];
            NamespaceCmd.getNamespaceForQualName(this, string, null, 2048, namespaceArray, namespaceArray2, namespaceArray2, stringArray);
            namespace = namespaceArray[0];
            string2 = stringArray[0];
            if (namespace == null || string2 == null) {
                return;
            }
        } else {
            namespace = this.globalNs;
            string2 = string;
        }
        if ((wrappedCommand = (WrappedCommand)namespace.cmdTable.get(string2)) != null) {
            importRef = wrappedCommand.importRef;
            wrappedCommand.importRef = null;
            this.deleteCommandFromToken(wrappedCommand);
            wrappedCommand = (WrappedCommand)namespace.cmdTable.get(string2);
            if (wrappedCommand != null) {
                wrappedCommand.table.remove(wrappedCommand.hashKey);
            }
        }
        wrappedCommand = new WrappedCommand();
        namespace.cmdTable.put(string2, wrappedCommand);
        wrappedCommand.table = namespace.cmdTable;
        wrappedCommand.hashKey = string2;
        wrappedCommand.ns = namespace;
        wrappedCommand.cmd = command;
        wrappedCommand.deleted = false;
        if (importRef != null) {
            wrappedCommand.importRef = importRef;
            while (importRef != null) {
                WrappedCommand wrappedCommand2 = importRef.importedCmd;
                ImportedCmdData importedCmdData = (ImportedCmdData)wrappedCommand2.cmd;
                importedCmdData.realCmd = wrappedCommand;
                importRef = importRef.next;
            }
        }
    }

    String getCommandFullName(WrappedCommand wrappedCommand) {
        Interp interp = this;
        StringBuffer stringBuffer = new StringBuffer();
        if (wrappedCommand != null) {
            if (wrappedCommand.ns != null) {
                stringBuffer.append(wrappedCommand.ns.fullName);
                if (wrappedCommand.ns != interp.globalNs) {
                    stringBuffer.append("::");
                }
            }
            if (wrappedCommand.table != null) {
                stringBuffer.append(wrappedCommand.hashKey);
            }
        }
        return stringBuffer.toString();
    }

    public int deleteCommand(String string) {
        WrappedCommand wrappedCommand;
        try {
            wrappedCommand = NamespaceCmd.findCommand(this, string, null, 0);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)tclException));
        }
        if (wrappedCommand == null) {
            return -1;
        }
        return this.deleteCommandFromToken(wrappedCommand);
    }

    protected int deleteCommandFromToken(WrappedCommand wrappedCommand) {
        if (wrappedCommand == null) {
            return -1;
        }
        if (wrappedCommand.deleted) {
            wrappedCommand.table.remove(wrappedCommand.hashKey);
            wrappedCommand.table = null;
            wrappedCommand.hashKey = null;
            return 0;
        }
        wrappedCommand.deleted = true;
        if (wrappedCommand.cmd instanceof CommandWithDispose) {
            ((CommandWithDispose)wrappedCommand.cmd).disposeCmd();
        }
        ImportRef importRef = wrappedCommand.importRef;
        while (importRef != null) {
            ImportRef importRef2 = importRef.next;
            WrappedCommand wrappedCommand2 = importRef.importedCmd;
            this.deleteCommandFromToken(wrappedCommand2);
            importRef = importRef2;
        }
        if (wrappedCommand.table != null) {
            wrappedCommand.table.remove(wrappedCommand.hashKey);
            wrappedCommand.table = null;
            wrappedCommand.hashKey = null;
        }
        wrappedCommand.cmd = null;
        return 0;
    }

    protected void renameCommand(String string, String string2) throws TclException {
        Interp interp = this;
        WrappedCommand wrappedCommand = NamespaceCmd.findCommand(interp, string, null, 0);
        if (wrappedCommand == null) {
            throw new TclException(interp, "can't " + (string2 == null || string2.length() == 0 ? "delete" : "rename") + " \"" + string + "\": command doesn't exist");
        }
        NamespaceCmd.Namespace namespace = wrappedCommand.ns;
        if (string2 == null || string2.length() == 0) {
            this.deleteCommandFromToken(wrappedCommand);
            return;
        }
        NamespaceCmd.Namespace[] namespaceArray = new NamespaceCmd.Namespace[1];
        NamespaceCmd.Namespace[] namespaceArray2 = new NamespaceCmd.Namespace[1];
        String[] stringArray = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, string2, null, 2048, namespaceArray, namespaceArray2, namespaceArray2, stringArray);
        NamespaceCmd.Namespace namespace2 = namespaceArray[0];
        String string3 = stringArray[0];
        if (namespace2 == null || string3 == null) {
            throw new TclException(interp, "can't rename to \"" + string2 + "\": bad command name");
        }
        if (namespace2.cmdTable.get(string3) != null) {
            throw new TclException(interp, "can't rename to \"" + string2 + "\": command already exists");
        }
        Hashtable hashtable = wrappedCommand.table;
        String string4 = wrappedCommand.hashKey;
        namespace2.cmdTable.put(string3, wrappedCommand);
        wrappedCommand.table = namespace2.cmdTable;
        wrappedCommand.hashKey = string3;
        wrappedCommand.ns = namespace2;
        if (wrappedCommand.cmd instanceof Procedure) {
            Procedure procedure = (Procedure)wrappedCommand.cmd;
            procedure.ns = wrappedCommand.ns;
        }
        hashtable.remove(string4);
    }

    public Command getCommand(String string) {
        WrappedCommand wrappedCommand;
        try {
            wrappedCommand = NamespaceCmd.findCommand(this, string, null, 0);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)tclException));
        }
        return wrappedCommand == null ? null : wrappedCommand.cmd;
    }

    public static boolean commandComplete(String string) {
        return Parser.commandComplete(string, string.length());
    }

    public final TclObject getResult() {
        return this.m_result;
    }

    public final void setResult(TclObject tclObject) {
        if (tclObject == null) {
            throw new NullPointerException("Interp.setResult() called with null TclObject argument.");
        }
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
        }
        this.m_result = tclObject;
        this.m_result.preserve();
    }

    public final void setResult(String string) {
        if (string == null) {
            this.resetResult();
        } else {
            this.setResult(TclString.newInstance((String)string));
        }
    }

    public final void setResult(int n) {
        this.setResult(TclInteger.newInstance((int)n));
    }

    public final void setResult(double d) {
        this.setResult(TclDouble.newInstance((double)d));
    }

    public final void setResult(boolean bl) {
        this.setResult(TclBoolean.newInstance((boolean)bl));
    }

    public final void resetResult() {
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
            this.m_result = this.m_nullResult;
        }
        this.errAlreadyLogged = false;
        this.errInProgress = false;
        this.errCodeSet = false;
    }

    void appendElement(String string) throws TclException {
        TclObject tclObject = this.getResult();
        tclObject.preserve();
        tclObject = tclObject.takeExclusive();
        TclList.append(this, tclObject, TclString.newInstance((String)string));
        this.setResult(tclObject.toString());
        tclObject.release();
    }

    public void eval(String string, int n) throws TclException {
        CharPointer charPointer = new CharPointer(string);
        Parser.eval2(this, charPointer.array, charPointer.index, charPointer.length(), n);
    }

    public void eval(String string) throws TclException {
        this.eval(string, 0);
    }

    public void eval(TclObject tclObject, int n) throws TclException {
        this.eval(tclObject.toString(), n);
    }

    public void evalFile(String string) throws TclException {
        String string2 = this.readScriptFromFile(string);
        if (string2 == null) {
            throw new TclException(this, "couldn't read file \"" + string + "\"");
        }
        String string3 = this.scriptFile;
        this.scriptFile = string;
        try {
            try {
                this.pushDebugStack(string, 1);
                this.eval(string2, 0);
            }
            catch (TclException tclException) {
                if (tclException.getCompletionCode() == 1) {
                    this.addErrorInfo("\n    (file \"" + string + "\" line " + this.errorLine + ")");
                }
                throw tclException;
            }
            Object var6_4 = null;
            this.scriptFile = string3;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.scriptFile = string3;
            this.popDebugStack();
            throw throwable;
        }
        this.popDebugStack();
    }

    void evalURL(URL uRL, String string) throws TclException {
        String string2 = this.readScriptFromURL(uRL, string);
        if (string2 == null) {
            throw new TclException(this, "cannot read URL \"" + string + "\"");
        }
        String string3 = this.scriptFile;
        this.scriptFile = string;
        try {
            this.eval(string2, 0);
            Object var6_5 = null;
            this.scriptFile = string3;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.scriptFile = string3;
            throw throwable;
        }
    }

    private String readScriptFromFile(String string) {
        FileInputStream fileInputStream;
        try {
            File file = FileUtil.getNewFileObj(this, string);
            fileInputStream = new FileInputStream(file);
        }
        catch (TclException tclException) {
            this.resetResult();
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        try {
            try {
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                String string2 = new String(byArray);
                Object var8_11 = null;
                this.closeInputStream(fileInputStream);
                return string2;
            }
            catch (IOException iOException) {
                String string3 = null;
                Object var8_12 = null;
                this.closeInputStream(fileInputStream);
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.closeInputStream(fileInputStream);
            throw throwable;
        }
    }

    private String readScriptFromURL(URL uRL, String string) {
        Object object;
        Object object2;
        URL uRL2;
        Object object3 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        try {
            object3 = uRL2.getContent();
        }
        catch (UnknownServiceException unknownServiceException) {
            try {
                object2 = Class.forName("java.net.JarURLConnection");
            }
            catch (Exception exception) {
                return null;
            }
            try {
                object = uRL2.openConnection();
            }
            catch (IOException iOException) {
                return null;
            }
            if (object == null) {
                return null;
            }
            try {
                Method method = ((Class)object2).getMethod("openConnection", null);
                object3 = method.invoke(object, null);
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (object3 instanceof String) {
            return (String)object3;
        }
        if (object3 instanceof InputStream) {
            InputStream inputStream = (InputStream)object3;
            try {
                try {
                    object2 = new byte[inputStream.available()];
                    inputStream.read((byte[])object2);
                    object = new String((byte[])object2);
                    Object var10_17 = null;
                    this.closeInputStream(inputStream);
                    return object;
                }
                catch (IOException iOException) {
                    object = null;
                    Object var10_18 = null;
                    this.closeInputStream(inputStream);
                    return object;
                }
            }
            catch (Throwable throwable) {
                Object var10_19 = null;
                this.closeInputStream(inputStream);
                throw throwable;
            }
        }
        return null;
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void evalResource(String string) throws TclException {
        InputStream inputStream = null;
        try {
            inputStream = (class$tcl$lang$Interp == null ? (class$tcl$lang$Interp = Interp.class$("tcl.lang.Interp")) : class$tcl$lang$Interp).getResourceAsStream(string);
        }
        catch (SecurityException securityException) {
            System.err.println("evalResource: Ignoring SecurityException, it is likely we are running in an applet: cannot read resource \"" + string + "\"" + securityException);
            return;
        }
        if (inputStream == null) {
            throw new TclException(this, "cannot read resource \"" + string + "\"");
        }
        try {
            block10: {
                try {
                    if (System.getProperty("java.version").startsWith("1.2") && inputStream.getClass().getName().equals("java.util.zip.ZipFile$1")) {
                        int n;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                        byte[] byArray = new byte[1024];
                        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                            byteArrayOutputStream.write(byArray, 0, n);
                        }
                        this.eval(new String(byteArrayOutputStream.toByteArray()), 0);
                        break block10;
                    }
                    int n = inputStream.available();
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    while (n > 0) {
                        int n3 = inputStream.read(byArray, n2, n);
                        n2 += n3;
                        n -= n3;
                    }
                    this.eval(new String(byArray), 0);
                }
                catch (IOException iOException) {
                    Object var8_13 = null;
                    this.closeInputStream(inputStream);
                    return;
                }
            }
            Object var8_12 = null;
            this.closeInputStream(inputStream);
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            this.closeInputStream(inputStream);
            throw throwable;
        }
    }

    static BackSlashResult backslash(String string, int n, int n2) {
        CharPointer charPointer = new CharPointer(string.substring(0, n2));
        charPointer.index = n;
        return Parser.backslash(charPointer.array, charPointer.index);
    }

    public void setErrorCode(TclObject tclObject) {
        try {
            this.setVar("errorCode", null, tclObject, 1);
            this.errCodeSet = true;
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    public void addErrorInfo(String string) {
        if (!this.errInProgress) {
            this.errInProgress = true;
            try {
                this.setVar("errorInfo", null, this.getResult().toString(), 1);
            }
            catch (TclException tclException) {
                // empty catch block
            }
            if (!this.errCodeSet) {
                try {
                    this.setVar("errorCode", null, "NONE", 1);
                }
                catch (TclException tclException) {
                    // empty catch block
                }
            }
        }
        try {
            this.setVar("errorInfo", null, string, 5);
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    protected int updateReturnInfo() {
        int n = this.returnCode;
        this.returnCode = 0;
        if (n == 1) {
            try {
                this.setVar("errorCode", null, this.errorCode != null ? this.errorCode : "NONE", 1);
            }
            catch (TclException tclException) {
                // empty catch block
            }
            this.errCodeSet = true;
            if (this.errorInfo != null) {
                try {
                    this.setVar("errorInfo", null, this.errorInfo, 1);
                }
                catch (TclException tclException) {
                    // empty catch block
                }
                this.errInProgress = true;
            }
        }
        return n;
    }

    protected CallFrame newCallFrame(Procedure procedure, TclObject[] tclObjectArray) throws TclException {
        return new CallFrame(this, procedure, tclObjectArray);
    }

    protected CallFrame newCallFrame() {
        return new CallFrame(this);
    }

    File getWorkingDir() {
        if (this.workingDir == null) {
            try {
                String string = this.getVar("env", "HOME", 0).toString();
                this.workingDir = FileUtil.getNewFileObj(this, string);
            }
            catch (TclException tclException) {
                this.resetResult();
            }
            this.workingDir = new File(Util.tryGetSystemProperty("user.home", "."));
        }
        return this.workingDir;
    }

    void setWorkingDir(String string) throws TclException {
        File file = FileUtil.getNewFileObj(this, string);
        try {
            file = new File(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.isDirectory()) {
            throw new TclException(this, "couldn't change working directory to \"" + file.getName() + "\": no such file or directory");
        }
        this.workingDir = file;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public final void pkgProvide(String string, String string2) throws TclException {
        PackageCmd.pkgProvide(this, string, string2);
    }

    public final String pkgRequire(String string, String string2, boolean bl) throws TclException {
        return PackageCmd.pkgRequire(this, string, string2, bl);
    }

    protected DebugInfo initDebugInfo() {
        return new DebugInfo(null, 1);
    }

    void pushDebugStack(String string, int n) {
    }

    void popDebugStack() throws TclRuntimeError {
    }

    String getScriptFile() {
        return this.dbg.fileName;
    }

    int getArgLineNumber(int n) {
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

