/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.ImportRef;
import tcl.lang.ImportedCmdData;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class NamespaceCmd
extends InternalRep
implements Command {
    static final int FIND_ONLY_NS = 4096;
    private static long numNsCreated = 0L;
    private static Object nsMutex = new Object();
    static final int NS_DYING = 1;
    static final int NS_DEAD = 2;
    static final int CREATE_NS_IF_UNKNOWN = 2048;
    private ResolvedNsName otherValue = null;
    private static final String[] validCmds = new String[]{"children", "code", "current", "delete", "eval", "export", "forget", "import", "inscope", "origin", "parent", "qualifiers", "tail", "which"};
    private static final int OPT_CHILDREN = 0;
    private static final int OPT_CODE = 1;
    private static final int OPT_CURRENT = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_EVAL = 4;
    private static final int OPT_EXPORT = 5;
    private static final int OPT_FORGET = 6;
    private static final int OPT_IMPORT = 7;
    private static final int OPT_INSCOPE = 8;
    private static final int OPT_ORIGIN = 9;
    private static final int OPT_PARENT = 10;
    private static final int OPT_QUALIFIERS = 11;
    private static final int OPT_TAIL = 12;
    private static final int OPT_WHICH = 13;

    static void initNamespaceSubsystem() {
    }

    static Namespace getCurrentNamespace(Interp interp) {
        if (interp.varFrame != null) {
            return interp.varFrame.ns;
        }
        return interp.globalNs;
    }

    static Namespace getGlobalNamespace(Interp interp) {
        return interp.globalNs;
    }

    static void pushCallFrame(Interp interp, CallFrame callFrame, Namespace namespace, boolean bl) {
        Namespace namespace2;
        if (namespace == null) {
            namespace2 = NamespaceCmd.getCurrentNamespace(interp);
        } else {
            namespace2 = namespace;
            if ((namespace2.flags & 2) != 0) {
                throw new TclRuntimeError("Trying to push call frame for dead namespace");
            }
        }
        ++namespace2.activationCount;
        callFrame.ns = namespace2;
        callFrame.isProcCallFrame = bl;
        callFrame.objv = null;
        callFrame.caller = interp.frame;
        callFrame.callerVar = interp.varFrame;
        callFrame.level = interp.varFrame != null ? interp.varFrame.level + 1 : 1;
        callFrame.varTable = null;
        interp.frame = callFrame;
        interp.varFrame = callFrame;
    }

    static void popCallFrame(Interp interp) {
        CallFrame callFrame = interp.frame;
        interp.frame = callFrame.caller;
        interp.varFrame = callFrame.callerVar;
        int n = interp.flags & 2;
        if (callFrame.varTable != null) {
            Var.deleteVars(interp, callFrame.varTable);
            callFrame.varTable = null;
        }
        interp.flags |= n;
        Namespace namespace = callFrame.ns;
        --namespace.activationCount;
        if ((namespace.flags & 1) != 0 && namespace.activationCount == 0) {
            NamespaceCmd.deleteNamespace(namespace);
        }
        callFrame.ns = null;
    }

    static Namespace createNamespace(Interp interp, String string, DeleteProc deleteProc) {
        Object object;
        String string2;
        Namespace namespace;
        Namespace namespace2 = NamespaceCmd.getGlobalNamespace(interp);
        if (namespace2 == null && interp.varFrame == null) {
            namespace = null;
            string2 = "";
        } else {
            if (string.length() == 0) {
                interp.setResult("can't create namespace \"\": only global namespace can have empty name");
                return null;
            }
            object = new Namespace[1];
            Namespace[] namespaceArray = new Namespace[1];
            String[] stringArray = new String[1];
            NamespaceCmd.getNamespaceForQualName(interp, string, null, 2560, object, namespaceArray, namespaceArray, stringArray);
            namespace = object[0];
            string2 = stringArray[0];
            if (string2.length() == 0) {
                return namespace;
            }
            if (namespace.childTable.get(string2) != null) {
                interp.setResult("can't create namespace \"" + string + "\": already exists");
                return null;
            }
        }
        Namespace namespace3 = new Namespace();
        namespace3.name = string2;
        namespace3.fullName = null;
        namespace3.deleteProc = deleteProc;
        namespace3.parent = namespace;
        namespace3.childTable = new Hashtable();
        object = nsMutex;
        synchronized (object) {
            namespace3.nsId = ++numNsCreated;
        }
        namespace3.interp = interp;
        namespace3.flags = 0;
        namespace3.activationCount = 0;
        namespace3.refCount = 1;
        namespace3.cmdTable = new Hashtable();
        namespace3.varTable = new Hashtable();
        namespace3.exportArray = null;
        namespace3.numExportPatterns = 0;
        namespace3.maxExportPatterns = 0;
        if (namespace != null) {
            namespace.childTable.put(string2, namespace3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Namespace namespace4 = namespace3;
        while (namespace4 != null) {
            if (namespace4 != namespace2) {
                stringBuffer.append("::");
                stringBuffer.append(namespace4.name);
            }
            stringBuffer.append((Object)stringBuffer2);
            stringBuffer2.setLength(0);
            stringBuffer2.append((Object)stringBuffer);
            stringBuffer.setLength(0);
            namespace4 = namespace4.parent;
        }
        namespace3.fullName = string = stringBuffer2.toString();
        return namespace3;
    }

    static void deleteNamespace(Namespace namespace) {
        Namespace namespace2 = namespace;
        Interp interp = namespace2.interp;
        Namespace namespace3 = NamespaceCmd.getGlobalNamespace(interp);
        if (namespace2.activationCount > 0) {
            namespace2.flags |= 1;
            if (namespace2.parent != null) {
                namespace2.parent.childTable.remove(namespace2.name);
            }
            namespace2.parent = null;
        } else {
            NamespaceCmd.teardownNamespace(namespace2);
            if (namespace2 != namespace3 || (interp.flags & 1) != 0) {
                Var.deleteVars(namespace2.interp, namespace2.varTable);
                namespace2.childTable.clear();
                namespace2.cmdTable.clear();
                if (namespace2.refCount == 0) {
                    NamespaceCmd.free(namespace2);
                } else {
                    namespace2.flags |= 2;
                }
            }
        }
    }

    static void teardownNamespace(Namespace namespace) {
        Interp interp = namespace.interp;
        Namespace namespace2 = NamespaceCmd.getGlobalNamespace(interp);
        if (namespace == namespace2) {
            String string;
            String string2;
            try {
                string2 = interp.getVar("errorInfo", 1).toString();
            }
            catch (TclException tclException) {
                string2 = null;
            }
            try {
                string = interp.getVar("errorCode", 1).toString();
            }
            catch (TclException tclException) {
                string = null;
            }
            Var.deleteVars(interp, namespace.varTable);
            if (string2 != null) {
                try {
                    interp.setVar("errorInfo", string2, 1);
                }
                catch (TclException tclException) {
                    // empty catch block
                }
            }
            if (string != null) {
                try {
                    interp.setVar("errorCode", string, 1);
                }
                catch (TclException tclException) {}
            }
        } else {
            Var.deleteVars(interp, namespace.varTable);
        }
        if (namespace.parent != null) {
            namespace.parent.childTable.remove(namespace.name);
        }
        namespace.parent = null;
        Enumeration enumeration = namespace.childTable.elements();
        while (enumeration.hasMoreElements()) {
            Namespace namespace3 = (Namespace)enumeration.nextElement();
            NamespaceCmd.deleteNamespace(namespace3);
        }
        enumeration = namespace.cmdTable.elements();
        while (enumeration.hasMoreElements()) {
            WrappedCommand wrappedCommand = (WrappedCommand)enumeration.nextElement();
            interp.deleteCommandFromToken(wrappedCommand);
        }
        namespace.cmdTable.clear();
        if (namespace.exportArray != null) {
            namespace.exportArray = null;
            namespace.numExportPatterns = 0;
            namespace.maxExportPatterns = 0;
        }
        if (namespace.deleteProc != null) {
            namespace.deleteProc.delete();
        }
        namespace.deleteProc = null;
        namespace.nsId = 0L;
    }

    static void free(Namespace namespace) {
        namespace.name = null;
        namespace.fullName = null;
    }

    static void exportList(Interp interp, Namespace namespace, String string, boolean bl) throws TclException {
        Namespace namespace2 = NamespaceCmd.getCurrentNamespace(interp);
        Namespace namespace3 = namespace == null ? namespace2 : namespace;
        if (bl && namespace3.exportArray != null) {
            int n = 0;
            while (n < namespace3.numExportPatterns) {
                namespace3.exportArray[n] = null;
                ++n;
            }
            namespace3.exportArray = null;
            namespace3.numExportPatterns = 0;
            namespace3.maxExportPatterns = 0;
        }
        Namespace[] namespaceArray = new Namespace[1];
        Namespace[] namespaceArray2 = new Namespace[1];
        String[] stringArray = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, string, namespace3, 512, namespaceArray, namespaceArray2, namespaceArray2, stringArray);
        Namespace namespace4 = namespaceArray[0];
        String string2 = stringArray[0];
        if (namespace4 != namespace3 || string.compareTo(string2) != 0) {
            throw new TclException(interp, "invalid export pattern \"" + string + "\": pattern can't specify a namespace");
        }
        int n = namespace3.numExportPatterns + 1;
        if (namespace3.exportArray == null) {
            namespace3.exportArray = new String[5];
            namespace3.numExportPatterns = 0;
            namespace3.maxExportPatterns = 5;
        } else if (n > namespace3.maxExportPatterns) {
            int n2 = 2 * namespace3.maxExportPatterns;
            String[] stringArray2 = new String[n2];
            System.arraycopy(namespace3.exportArray, 0, stringArray2, 0, namespace3.numExportPatterns);
            namespace3.exportArray = stringArray2;
            namespace3.maxExportPatterns = n2;
        }
        namespace3.exportArray[namespace3.numExportPatterns] = string;
        ++namespace3.numExportPatterns;
    }

    static void appendExportList(Interp interp, Namespace namespace, TclObject tclObject) throws TclException {
        Namespace namespace2 = namespace == null ? NamespaceCmd.getCurrentNamespace(interp) : namespace;
        int n = 0;
        while (n < namespace2.numExportPatterns) {
            TclList.append(interp, tclObject, TclString.newInstance((String)namespace2.exportArray[n]));
            ++n;
        }
    }

    static void importList(Interp interp, Namespace namespace, String string, boolean bl) throws TclException {
        String[] stringArray;
        WrappedCommand wrappedCommand;
        Object[] objectArray;
        Namespace namespace2 = NamespaceCmd.getCurrentNamespace(interp);
        Namespace namespace3 = namespace == null ? namespace2 : namespace;
        WrappedCommand wrappedCommand2 = NamespaceCmd.findCommand(interp, "auto_import", null, 1);
        if (wrappedCommand2 != null) {
            objectArray = new TclObject[2];
            objectArray[0] = TclString.newInstance((String)"auto_import");
            objectArray[0].preserve();
            objectArray[1] = TclString.newInstance((String)string);
            objectArray[1].preserve();
            wrappedCommand = wrappedCommand2;
            try {
                wrappedCommand.cmd.cmdProc(interp, objectArray);
                stringArray = null;
            }
            catch (Throwable throwable) {
                Object var21_10 = null;
                objectArray[0].release();
                objectArray[1].release();
                throw throwable;
            }
            objectArray[0].release();
            objectArray[1].release();
            interp.resetResult();
        }
        if (string.length() == 0) {
            throw new TclException(interp, "empty import pattern");
        }
        objectArray = new Namespace[1];
        Namespace[] namespaceArray = new Namespace[1];
        stringArray = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, string, namespace3, 512, (Namespace[])objectArray, namespaceArray, namespaceArray, stringArray);
        TclObject tclObject = objectArray[0];
        String string2 = stringArray[0];
        if (tclObject == null) {
            throw new TclException(interp, "unknown namespace in import pattern \"" + string + "\"");
        }
        if (tclObject == namespace3) {
            if (string == string2) {
                throw new TclException(interp, "no namespace specified in import pattern \"" + string + "\"");
            }
            throw new TclException(interp, "import pattern \"" + string + "\" tries to import from namespace \"" + tclObject.name + "\" into itself");
        }
        Enumeration enumeration = tclObject.cmdTable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!Util.stringMatch(string3, string2)) continue;
            boolean bl2 = false;
            int n = 0;
            while (n < tclObject.numExportPatterns) {
                if (Util.stringMatch(string3, tclObject.exportArray[n])) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            if (!bl2) continue;
            if (namespace3.cmdTable.get(string3) == null || bl) {
                WrappedCommand wrappedCommand3;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(namespace3.fullName);
                if (namespace3 != interp.globalNs) {
                    stringBuffer.append("::");
                }
                stringBuffer.append(string3);
                wrappedCommand = (WrappedCommand)tclObject.cmdTable.get(string3);
                if (wrappedCommand.cmd instanceof ImportedCmdData && (wrappedCommand3 = NamespaceCmd.getOriginalCommand(wrappedCommand)) != null && wrappedCommand3.ns == namespace2 && namespace2.cmdTable.get(string3) != null) {
                    throw new TclException(interp, "import pattern \"" + string + "\" would create a loop containing command \"" + stringBuffer.toString() + "\"");
                }
                ImportedCmdData importedCmdData = new ImportedCmdData();
                interp.createCommand(stringBuffer.toString(), importedCmdData);
                WrappedCommand wrappedCommand4 = NamespaceCmd.findCommand(interp, stringBuffer.toString(), namespace3, 514);
                importedCmdData.realCmd = wrappedCommand;
                importedCmdData.self = wrappedCommand4;
                ImportRef importRef = new ImportRef();
                importRef.importedCmd = wrappedCommand4;
                importRef.next = wrappedCommand.importRef;
                wrappedCommand.importRef = importRef;
                continue;
            }
            throw new TclException(interp, "can't import command \"" + string3 + "\": already exists");
        }
    }

    static void forgetImport(Interp interp, Namespace namespace, String string) throws TclException {
        Namespace namespace2 = namespace == null ? NamespaceCmd.getCurrentNamespace(interp) : namespace;
        Namespace[] namespaceArray = new Namespace[1];
        Namespace[] namespaceArray2 = new Namespace[1];
        Namespace[] namespaceArray3 = new Namespace[1];
        String[] stringArray = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, string, namespace2, 512, namespaceArray, namespaceArray2, namespaceArray3, stringArray);
        Namespace namespace3 = namespaceArray[0];
        Namespace namespace4 = namespaceArray3[0];
        String string2 = stringArray[0];
        if (namespace3 == null) {
            throw new TclException(interp, "unknown namespace in namespace forget pattern \"" + string + "\"");
        }
        Enumeration enumeration = namespace3.cmdTable.keys();
        while (enumeration.hasMoreElements()) {
            WrappedCommand wrappedCommand;
            String string3 = (String)enumeration.nextElement();
            if (!Util.stringMatch(string3, string2) || (wrappedCommand = (WrappedCommand)namespace2.cmdTable.get(string3)) == null || !(wrappedCommand.cmd instanceof ImportedCmdData)) continue;
            interp.deleteCommandFromToken(wrappedCommand);
        }
    }

    /*
     * Unable to fully structure code
     */
    static WrappedCommand getOriginalCommand(WrappedCommand var0) {
        var1_1 = var0;
        if (var1_1.cmd instanceof ImportedCmdData) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = (ImportedCmdData)var1_1.cmd;
            var1_1 = var2_2.realCmd;
lbl6:
            // 2 sources

            ** while (var1_1.cmd instanceof ImportedCmdData)
        }
lbl7:
        // 1 sources

        return var1_1;
    }

    static void invokeImportedCmd(Interp interp, ImportedCmdData importedCmdData, TclObject[] tclObjectArray) throws TclException {
        WrappedCommand wrappedCommand = importedCmdData.realCmd;
        wrappedCommand.cmd.cmdProc(interp, tclObjectArray);
    }

    static void deleteImportedCmd(ImportedCmdData importedCmdData) {
        WrappedCommand wrappedCommand = importedCmdData.realCmd;
        WrappedCommand wrappedCommand2 = importedCmdData.self;
        ImportRef importRef = null;
        ImportRef importRef2 = wrappedCommand.importRef;
        while (importRef2 != null) {
            if (importRef2.importedCmd == wrappedCommand2) {
                if (importRef == null) {
                    wrappedCommand.importRef = importRef2.next;
                } else {
                    importRef.next = importRef2.next;
                }
                importRef2 = null;
                importedCmdData = null;
                return;
            }
            importRef = importRef2;
            importRef2 = importRef2.next;
        }
        throw new TclRuntimeError("DeleteImportedCmd: did not find cmd in real cmd's list of import references");
    }

    /*
     * Unable to fully structure code
     */
    static void getNamespaceForQualName(Interp var0, String var1_1, Namespace var2_2, int var3_3, Namespace[] var4_4, Namespace[] var5_5, Namespace[] var6_6, String[] var7_7) {
        if (var4_4 == null || var4_4.length != 1) {
            throw new RuntimeException("nsPtrPtr " + var4_4);
        }
        if (var5_5 == null || var5_5.length != 1) {
            throw new RuntimeException("altNsPtrPtr " + var5_5);
        }
        if (var6_6 == null || var6_6.length != 1) {
            throw new RuntimeException("actualCxtPtrPtr " + var6_6);
        }
        if (var7_7 == null || var7_7.length != 1) {
            throw new RuntimeException("simpleNamePtr " + var7_7);
        }
        var8_8 = var2_2;
        var10_9 = NamespaceCmd.getGlobalNamespace(var0);
        if ((var3_3 & 4098) != 0) {
            var8_8 = NamespaceCmd.getCurrentNamespace(var0);
        } else if ((var3_3 & 1) != 0) {
            var8_8 = var10_9;
        } else if (var8_8 == null) {
            var8_8 = var0.varFrame != null ? var0.varFrame.ns : var0.globalNs;
        }
        var16_10 = 0;
        var18_11 = var1_1.length();
        if (var18_11 >= 2 && var1_1.charAt(0) == ':' && var1_1.charAt(1) == ':') {
            var16_10 = 2;
            while (var16_10 < var18_11 && var1_1.charAt(var16_10) == ':') {
                ++var16_10;
            }
            var8_8 = var10_9;
            if (var16_10 >= var18_11) {
                var4_4[0] = var10_9;
                var5_5[0] = null;
                var6_6[0] = var10_9;
                var7_7[0] = "";
                return;
            }
        }
        var6_6[0] = var8_8;
        var9_12 = var10_9;
        if (var8_8 == var10_9 || (var3_3 & 4098) != 0) {
            var9_12 = null;
        }
        var17_13 = var16_10;
        while (var16_10 < var18_11) {
            var15_16 = 0;
            var17_13 = var16_10;
            while (var17_13 < var18_11) {
                if (var18_11 - var17_13 > 1 && var1_1.charAt(var17_13) == ':' && var1_1.charAt(var17_13 + 1) == ':') {
                    var17_13 += 2;
                    while (var17_13 < var18_11 && var1_1.charAt(var17_13) == ':') {
                        ++var17_13;
                    }
                    break;
                }
                ++var15_16;
                ++var17_13;
            }
            if (var17_13 != var18_11 || var17_13 - var16_10 >= 2 && var1_1.charAt(var17_13 - 1) == ':' && var1_1.charAt(var17_13 - 2) == ':') ** GOTO lbl59
            if ((var3_3 & 4096) != 0) {
                var14_15 = var1_1.substring(var16_10);
            } else {
                var4_4[0] = var8_8;
                var5_5[0] = var9_12;
                var7_7[0] = var1_1.substring(var16_10);
                return;
lbl59:
                // 1 sources

                var14_15 = var1_1.substring(var16_10, var16_10 + var15_16);
            }
            if (var8_8 != null) {
                var11_14 = (Namespace)var8_8.childTable.get(var14_15);
                if (var11_14 != null) {
                    var8_8 = var11_14;
                } else if ((var3_3 & 2048) != 0) {
                    var19_17 = var0.newCallFrame();
                    NamespaceCmd.pushCallFrame(var0, var19_17, var8_8, false);
                    var8_8 = NamespaceCmd.createNamespace(var0, var14_15, null);
                    NamespaceCmd.popCallFrame(var0);
                    if (var8_8 == null) {
                        throw new RuntimeException("Could not create namespace " + var14_15);
                    }
                } else {
                    var8_8 = null;
                }
            }
            if (var9_12 != null) {
                var9_12 = (Namespace)var9_12.childTable.get(var14_15);
            }
            if (var8_8 == null && var9_12 == null) {
                var4_4[0] = null;
                var5_5[0] = null;
                var7_7[0] = null;
                return;
            }
            var16_10 = var17_13;
        }
        var7_7[0] = (var3_3 & 4096) != 0 || var17_13 > var16_10 && var1_1.charAt(var17_13 - 1) != ':' ? null : var1_1.substring(var17_13);
        if ((var3_3 & 4096) != 0 && var18_11 == 0 && var8_8 != var10_9) {
            var8_8 = null;
        }
        var4_4[0] = var8_8;
        var5_5[0] = var9_12;
    }

    static Namespace findNamespace(Interp interp, String string, Namespace namespace, int n) throws TclException {
        Namespace[] namespaceArray = new Namespace[1];
        Namespace[] namespaceArray2 = new Namespace[1];
        String[] stringArray = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, string, namespace, n | 0x1000, namespaceArray, namespaceArray2, namespaceArray2, stringArray);
        Namespace namespace2 = namespaceArray[0];
        if (namespace2 != null) {
            return namespace2;
        }
        if ((n & 0x200) != 0) {
            interp.setResult("unknown namespace \"" + string + "\"");
        }
        return null;
    }

    static WrappedCommand findCommand(Interp interp, String string, Namespace namespace, int n) throws TclException {
        Namespace[] namespaceArray = new Namespace[2];
        Namespace namespace2 = (n & 1) != 0 ? NamespaceCmd.getGlobalNamespace(interp) : (namespace != null ? namespace : NamespaceCmd.getCurrentNamespace(interp));
        Namespace[] namespaceArray2 = new Namespace[1];
        Namespace[] namespaceArray3 = new Namespace[1];
        Namespace[] namespaceArray4 = new Namespace[1];
        String[] stringArray = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, string, namespace, n, namespaceArray2, namespaceArray3, namespaceArray4, stringArray);
        namespaceArray[0] = namespaceArray2[0];
        namespaceArray[1] = namespaceArray3[0];
        namespace2 = namespaceArray4[0];
        String string2 = stringArray[0];
        WrappedCommand wrappedCommand = null;
        int n2 = 0;
        while (n2 < 2 && wrappedCommand == null) {
            if (namespaceArray[n2] != null && string2 != null) {
                wrappedCommand = (WrappedCommand)namespaceArray[n2].cmdTable.get(string2);
            }
            ++n2;
        }
        if (wrappedCommand != null) {
            return wrappedCommand;
        }
        if ((n & 0x200) != 0) {
            throw new TclException(interp, "unknown command \"" + string + "\"");
        }
        return null;
    }

    static Var findNamespaceVar(Interp interp, String string, Namespace namespace, int n) throws TclException {
        Namespace[] namespaceArray = new Namespace[2];
        Namespace namespace2 = (n & 1) != 0 ? NamespaceCmd.getGlobalNamespace(interp) : (namespace != null ? namespace : NamespaceCmd.getCurrentNamespace(interp));
        Namespace[] namespaceArray2 = new Namespace[1];
        Namespace[] namespaceArray3 = new Namespace[1];
        Namespace[] namespaceArray4 = new Namespace[1];
        String[] stringArray = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, string, namespace, n, namespaceArray2, namespaceArray3, namespaceArray4, stringArray);
        namespaceArray[0] = namespaceArray2[0];
        namespaceArray[1] = namespaceArray3[0];
        namespace2 = namespaceArray4[0];
        String string2 = stringArray[0];
        Var var = null;
        int n2 = 0;
        while (n2 < 2 && var == null) {
            if (namespaceArray[n2] != null && string2 != null) {
                var = (Var)namespaceArray[n2].varTable.get(string2);
            }
            ++n2;
        }
        if (var != null) {
            return var;
        }
        if ((n & 0x200) != 0) {
            interp.setResult("unknown variable \"" + string + "\"");
        }
        return null;
    }

    static Namespace getNamespaceFromObj(Interp interp, TclObject tclObject) throws TclException {
        Namespace namespace = NamespaceCmd.getCurrentNamespace(interp);
        if (!(tclObject.getInternalRep() instanceof NamespaceCmd)) {
            NamespaceCmd.setNsNameFromAny(interp, tclObject);
        }
        ResolvedNsName resolvedNsName = ((NamespaceCmd)tclObject.getInternalRep()).otherValue;
        Namespace namespace2 = null;
        if (resolvedNsName != null && resolvedNsName.refNs == namespace && resolvedNsName.nsId == resolvedNsName.ns.nsId) {
            namespace2 = resolvedNsName.ns;
            if ((namespace2.flags & 2) != 0) {
                namespace2 = null;
            }
        }
        if (namespace2 == null) {
            NamespaceCmd.setNsNameFromAny(interp, tclObject);
            resolvedNsName = ((NamespaceCmd)tclObject.getInternalRep()).otherValue;
            if (resolvedNsName != null) {
                namespace2 = resolvedNsName.ns;
                if ((namespace2.flags & 2) != 0) {
                    namespace2 = null;
                }
            }
        }
        return namespace2;
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "subcommand ?arg ...?");
        }
        int n = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[1], (String[])validCmds, (String)"option", (int)0);
        switch (n) {
            case 0: {
                NamespaceCmd.childrenCmd(interp, tclObjectArray);
                return;
            }
            case 1: {
                NamespaceCmd.codeCmd(interp, tclObjectArray);
                return;
            }
            case 2: {
                NamespaceCmd.currentCmd(interp, tclObjectArray);
                return;
            }
            case 3: {
                NamespaceCmd.deleteCmd(interp, tclObjectArray);
                return;
            }
            case 4: {
                NamespaceCmd.evalCmd(interp, tclObjectArray);
                return;
            }
            case 5: {
                NamespaceCmd.exportCmd(interp, tclObjectArray);
                return;
            }
            case 6: {
                NamespaceCmd.forgetCmd(interp, tclObjectArray);
                return;
            }
            case 7: {
                NamespaceCmd.importCmd(interp, tclObjectArray);
                return;
            }
            case 8: {
                NamespaceCmd.inscopeCmd(interp, tclObjectArray);
                return;
            }
            case 9: {
                NamespaceCmd.originCmd(interp, tclObjectArray);
                return;
            }
            case 10: {
                NamespaceCmd.parentCmd(interp, tclObjectArray);
                return;
            }
            case 11: {
                NamespaceCmd.qualifiersCmd(interp, tclObjectArray);
                return;
            }
            case 12: {
                NamespaceCmd.tailCmd(interp, tclObjectArray);
                return;
            }
            case 13: {
                NamespaceCmd.whichCmd(interp, tclObjectArray);
                return;
            }
        }
    }

    private static void childrenCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Namespace namespace;
        Namespace namespace2 = NamespaceCmd.getGlobalNamespace(interp);
        String string = null;
        if (tclObjectArray.length == 2) {
            namespace = NamespaceCmd.getCurrentNamespace(interp);
        } else if (tclObjectArray.length == 3 || tclObjectArray.length == 4) {
            namespace = NamespaceCmd.getNamespaceFromObj(interp, tclObjectArray[2]);
            if (namespace == null) {
                throw new TclException(interp, "unknown namespace \"" + tclObjectArray[2].toString() + "\" in namespace children command");
            }
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?name? ?pattern?");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (tclObjectArray.length == 4) {
            String string2 = tclObjectArray[3].toString();
            if (string2.startsWith("::")) {
                string = string2;
            } else {
                stringBuffer.append(namespace.fullName);
                if (namespace != namespace2) {
                    stringBuffer.append("::");
                }
                stringBuffer.append(string2);
                string = stringBuffer.toString();
            }
        }
        TclObject tclObject = TclList.newInstance();
        Enumeration enumeration = namespace.childTable.elements();
        while (enumeration.hasMoreElements()) {
            Namespace namespace3 = (Namespace)enumeration.nextElement();
            if (string != null && !Util.stringMatch(namespace3.fullName, string)) continue;
            TclObject tclObject2 = TclString.newInstance((String)namespace3.fullName);
            TclList.append(interp, tclObject, tclObject2);
        }
        interp.setResult(tclObject);
    }

    private static void codeCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "arg");
        }
        String string = tclObjectArray[2].toString();
        int n = string.length();
        if (n > 17 && string.charAt(0) == 'n' && string.startsWith("namespace")) {
            int n2 = 9;
            while (n2 < n && string.charAt(n2) == ' ') {
                ++n2;
            }
            if (n - n2 >= 7 && string.charAt(n2) == 'i' && string.startsWith("inscope", n2)) {
                interp.setResult(tclObjectArray[2]);
                return;
            }
        }
        TclObject tclObject = TclList.newInstance();
        TclList.append(interp, tclObject, TclString.newInstance((String)"namespace"));
        TclList.append(interp, tclObject, TclString.newInstance((String)"inscope"));
        Namespace namespace = NamespaceCmd.getCurrentNamespace(interp);
        TclObject tclObject2 = namespace == NamespaceCmd.getGlobalNamespace(interp) ? TclString.newInstance((String)"::") : TclString.newInstance((String)namespace.fullName);
        TclList.append(interp, tclObject, tclObject2);
        TclList.append(interp, tclObject, tclObjectArray[2]);
        interp.setResult(tclObject);
    }

    private static void currentCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        Namespace namespace = NamespaceCmd.getCurrentNamespace(interp);
        if (namespace == NamespaceCmd.getGlobalNamespace(interp)) {
            interp.setResult("::");
        } else {
            interp.setResult(namespace.fullName);
        }
    }

    private static void deleteCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Namespace namespace;
        String string;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?name name...?");
        }
        int n = 2;
        while (n < tclObjectArray.length) {
            string = tclObjectArray[n].toString();
            namespace = NamespaceCmd.findNamespace(interp, string, null, 0);
            if (namespace == null) {
                throw new TclException(interp, "unknown namespace \"" + tclObjectArray[n].toString() + "\" in namespace delete command");
            }
            ++n;
        }
        n = 2;
        while (n < tclObjectArray.length) {
            string = tclObjectArray[n].toString();
            namespace = NamespaceCmd.findNamespace(interp, string, null, 0);
            if (namespace != null) {
                NamespaceCmd.deleteNamespace(namespace);
            }
            ++n;
        }
    }

    private static void evalCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        if (tclObjectArray.length < 4) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "name arg ?arg...?");
        }
        Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, tclObjectArray[2]);
        if (namespace == null && (namespace = NamespaceCmd.createNamespace(interp, string = tclObjectArray[2].toString(), null)) == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        CallFrame callFrame = interp.newCallFrame();
        NamespaceCmd.pushCallFrame(interp, callFrame, namespace, false);
        try {
            block8: {
                try {
                    if (tclObjectArray.length == 4) {
                        interp.eval(tclObjectArray[3], 0);
                        break block8;
                    }
                    String string2 = Util.concat(3, tclObjectArray.length, tclObjectArray);
                    interp.eval(string2);
                }
                catch (TclException tclException) {
                    if (tclException.getCompletionCode() == 1) {
                        interp.addErrorInfo("\n    (in namespace eval \"" + namespace.fullName + "\" script line " + interp.errorLine + ")");
                    }
                    throw tclException;
                }
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            NamespaceCmd.popCallFrame(interp);
            throw throwable;
        }
        NamespaceCmd.popCallFrame(interp);
    }

    private static void exportCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        String string;
        Namespace namespace = NamespaceCmd.getCurrentNamespace(interp);
        boolean bl = false;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?-clear? ?pattern pattern...?");
        }
        int n2 = 2;
        if (n2 < tclObjectArray.length && (string = tclObjectArray[n2].toString()).equals("-clear")) {
            bl = true;
            ++n2;
        }
        if ((n = tclObjectArray.length - n2) == 0) {
            if (n2 > 2) {
                return;
            }
            TclObject tclObject = TclList.newInstance();
            NamespaceCmd.appendExportList(interp, namespace, tclObject);
            interp.setResult(tclObject);
            return;
        }
        int n3 = n2;
        while (n3 < tclObjectArray.length) {
            String string2 = tclObjectArray[n3].toString();
            NamespaceCmd.exportList(interp, namespace, string2, n3 == n2 ? bl : false);
            ++n3;
        }
    }

    private static void forgetCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern pattern...?");
        }
        int n = 2;
        while (n < tclObjectArray.length) {
            String string = tclObjectArray[n].toString();
            NamespaceCmd.forgetImport(interp, null, string);
            ++n;
        }
    }

    private static void importCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        boolean bl = false;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?-force? ?pattern pattern...?");
        }
        int n = 2;
        if (n < tclObjectArray.length && (string = tclObjectArray[n].toString()).equals("-force")) {
            bl = true;
            ++n;
        }
        int n2 = n;
        while (n2 < tclObjectArray.length) {
            String string2 = tclObjectArray[n2].toString();
            NamespaceCmd.importList(interp, null, string2, bl);
            ++n2;
        }
    }

    private static void inscopeCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 4) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "name arg ?arg...?");
        }
        Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, tclObjectArray[2]);
        if (namespace == null) {
            throw new TclException(interp, "unknown namespace \"" + tclObjectArray[2].toString() + "\" in inscope namespace command");
        }
        CallFrame callFrame = interp.newCallFrame();
        NamespaceCmd.pushCallFrame(interp, callFrame, namespace, false);
        try {
            block11: {
                try {
                    if (tclObjectArray.length == 4) {
                        interp.eval(tclObjectArray[3], 0);
                        break block11;
                    }
                    TclObject[] tclObjectArray2 = new TclObject[2];
                    TclObject tclObject = TclList.newInstance();
                    int n = 4;
                    while (n < tclObjectArray.length) {
                        try {
                            TclList.append(interp, tclObject, tclObjectArray[n]);
                        }
                        catch (TclException tclException) {
                            tclObject.release();
                            throw tclException;
                        }
                        ++n;
                    }
                    tclObjectArray2[0] = tclObjectArray[3];
                    tclObjectArray2[1] = tclObject;
                    String string = Util.concat(0, 1, tclObjectArray2);
                    interp.eval(string);
                    tclObject.release();
                }
                catch (TclException tclException) {
                    if (tclException.getCompletionCode() == 1) {
                        interp.addErrorInfo("\n    (in namespace inscope \"" + namespace.fullName + "\" script line " + interp.errorLine + ")");
                    }
                    throw tclException;
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            NamespaceCmd.popCallFrame(interp);
            throw throwable;
        }
        NamespaceCmd.popCallFrame(interp);
    }

    private static void originCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
        }
        WrappedCommand wrappedCommand = NamespaceCmd.findCommand(interp, tclObjectArray[2].toString(), null, 0);
        if (wrappedCommand == null) {
            throw new TclException(interp, "invalid command name \"" + tclObjectArray[2].toString() + "\"");
        }
        WrappedCommand wrappedCommand2 = NamespaceCmd.getOriginalCommand(wrappedCommand);
        if (wrappedCommand2 == null) {
            interp.setResult(interp.getCommandFullName(wrappedCommand));
        } else {
            interp.setResult(interp.getCommandFullName(wrappedCommand2));
        }
    }

    private static void parentCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Namespace namespace;
        if (tclObjectArray.length == 2) {
            namespace = NamespaceCmd.getCurrentNamespace(interp);
        } else if (tclObjectArray.length == 3) {
            namespace = NamespaceCmd.getNamespaceFromObj(interp, tclObjectArray[2]);
            if (namespace == null) {
                throw new TclException(interp, "unknown namespace \"" + tclObjectArray[2].toString() + "\" in namespace parent command");
            }
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?name?");
        }
        if (namespace.parent != null) {
            interp.setResult(namespace.parent.fullName);
        }
    }

    private static void qualifiersCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "string");
        }
        String string = tclObjectArray[2].toString();
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) != ':' || n <= 0 || string.charAt(n - 1) != ':') continue;
            n -= 2;
            while (n >= 0 && string.charAt(n) == ':') {
                --n;
            }
            break block0;
        }
        if (n >= 0) {
            interp.setResult(string.substring(0, n + 1));
        }
    }

    private static void tailCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "string");
        }
        String string = tclObjectArray[2].toString();
        int n = string.length();
        while (--n > 0) {
            if (string.charAt(n) != ':' || string.charAt(n - 1) != ':') continue;
            ++n;
            break;
        }
        if (n >= 0) {
            interp.setResult(string.substring(n));
        }
    }

    private static void whichCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?-command? ?-variable? name");
        }
        int n = 2;
        int n2 = 0;
        String string = tclObjectArray[2].toString();
        if (string.length() > 1 && string.charAt(0) == '-') {
            if (string.equals("-command")) {
                n2 = 0;
            } else if (string.equals("-variable")) {
                n2 = 1;
            } else {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "?-command? ?-variable? name");
            }
            n = 3;
        }
        if (tclObjectArray.length != n + 1) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?-command? ?-variable? name");
        }
        switch (n2) {
            case 0: {
                string = tclObjectArray[n].toString();
                WrappedCommand wrappedCommand = NamespaceCmd.findCommand(interp, string, null, 0);
                if (wrappedCommand == null) {
                    return;
                }
                interp.setResult(interp.getCommandFullName(wrappedCommand));
                return;
            }
            case 1: {
                string = tclObjectArray[n].toString();
                Var var = NamespaceCmd.findNamespaceVar(interp, string, null, 0);
                if (var != null) {
                    interp.setResult(Var.getVariableFullName(interp, var));
                }
                return;
            }
        }
    }

    protected void dispose() {
        ResolvedNsName resolvedNsName = this.otherValue;
        if (resolvedNsName != null) {
            --resolvedNsName.refCount;
            if (resolvedNsName.refCount == 0) {
                Namespace namespace = resolvedNsName.ns;
                --namespace.refCount;
                if (namespace.refCount == 0 && (namespace.flags & 2) != 0) {
                    NamespaceCmd.free(namespace);
                }
                this.otherValue = null;
            }
        }
    }

    protected InternalRep duplicate() {
        ResolvedNsName resolvedNsName = this.otherValue;
        if (resolvedNsName != null) {
            ++resolvedNsName.refCount;
        }
        return this;
    }

    private static void setNsNameFromAny(Interp interp, TclObject tclObject) throws TclException {
        ResolvedNsName resolvedNsName;
        Object object;
        Namespace[] namespaceArray = new Namespace[1];
        Namespace[] namespaceArray2 = new Namespace[1];
        String[] stringArray = new String[1];
        String string = tclObject.toString();
        NamespaceCmd.getNamespaceForQualName(interp, string, null, 4096, namespaceArray, namespaceArray2, namespaceArray2, stringArray);
        Namespace namespace = namespaceArray[0];
        if (namespace != null) {
            object = NamespaceCmd.getCurrentNamespace(interp);
            ++namespace.refCount;
            resolvedNsName = new ResolvedNsName();
            resolvedNsName.ns = namespace;
            resolvedNsName.nsId = namespace.nsId;
            resolvedNsName.refNs = object;
            resolvedNsName.refCount = 1;
        } else {
            resolvedNsName = null;
        }
        object = new NamespaceCmd();
        ((NamespaceCmd)((Object)object)).otherValue = resolvedNsName;
        tclObject.setInternalRep((InternalRep)object);
    }

    public String toString() {
        ResolvedNsName resolvedNsName = this.otherValue;
        String string = "";
        if (resolvedNsName != null && resolvedNsName.nsId == resolvedNsName.ns.nsId) {
            Namespace namespace = resolvedNsName.ns;
            if ((namespace.flags & 2) != 0) {
                namespace = null;
            }
            if (namespace != null) {
                string = namespace.fullName;
            }
        }
        return string;
    }

    static class ResolvedNsName {
        Namespace ns;
        long nsId;
        Namespace refNs;
        int refCount;

        ResolvedNsName() {
        }
    }

    static class Namespace {
        String name;
        String fullName;
        DeleteProc deleteProc;
        Namespace parent;
        Hashtable childTable;
        long nsId;
        Interp interp;
        int flags;
        int activationCount;
        int refCount;
        Hashtable cmdTable;
        Hashtable varTable;
        String[] exportArray;
        int numExportPatterns;
        int maxExportPatterns;

        Namespace() {
        }

        public String toString() {
            return this.fullName;
        }
    }

    static interface DeleteProc {
        public void delete();
    }
}

