/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;

class Parser {
    static final char TYPE_NORMAL = '\u0000';
    static final char TYPE_SPACE = '\u0001';
    static final char TYPE_COMMAND_END = '\u0002';
    static final char TYPE_SUBS = '\u0004';
    static final char TYPE_QUOTE = '\b';
    static final char TYPE_CLOSE_PAREN = '\u0010';
    static final char TYPE_CLOSE_BRACK = ' ';
    static final char TYPE_BRACE = '@';
    static final char TYPE_MAX = '\u007f';
    static char[] typeTable = new char[]{'\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0002', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\b', '\u0000', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0010', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0004', '\u0004', ' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '@', '\u0000', '@', '\u0000', '\u0000'};
    static final int TCL_TOKEN_WORD = 1;
    static final int TCL_TOKEN_SIMPLE_WORD = 2;
    static final int TCL_TOKEN_TEXT = 4;
    static final int TCL_TOKEN_BS = 8;
    static final int TCL_TOKEN_COMMAND = 16;
    static final int TCL_TOKEN_VARIABLE = 32;
    static final int TCL_NO_EVAL = 65536;
    static final int TCL_EVAL_GLOBAL = 131072;
    static final int TCL_EVAL_DIRECT = 262144;
    static final int TCL_BRACKET_TERM = 1;
    static final int TCL_ALLOW_EXCEPTIONS = 4;
    static final int DELETED = 1;
    static final int ERR_IN_PROGRESS = 2;
    static final int ERR_ALREADY_LOGGED = 4;
    static final int ERROR_CODE_SET = 8;
    static final int EXPR_INITIALIZED = 16;
    static final int DONT_COMPILE_CMDS_INLINE = 32;
    static final int RAND_SEED_INITIALIZED = 64;
    static final int SAFE_INTERP = 128;
    static final int USE_EVAL_DIRECT = 256;
    private static final int OBJV_CACHE_MAX = 10;
    private static final int[] OBJV_CACHE_SIZES = new int[]{0, 4, 4, 10, 4, 4, 4, 4, 4, 4};

    Parser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TclParse parseCommand(Interp interp, char[] cArray, int n, int n2, String string, int n3, boolean bl) {
        TclParse tclParse;
        char c;
        block49: {
            char c2;
            BackSlashResult backSlashResult;
            char c3;
            int n4;
            int n5 = n;
            int n6 = cArray.length - 1;
            if (n2 < 0) {
                n2 = n6 - n;
            }
            if ((n4 = n + n2) > n6) {
                n4 = n6;
            }
            c = cArray[n4];
            cArray[n4] = '\u0000';
            tclParse = new TclParse(interp, cArray, n4, string, n3);
            int n7 = bl ? 34 : 2;
            try {
                block2: while (true) {
                    c3 = cArray[n];
                    while (true) {
                        if ((c3 > '\u007f' || typeTable[c3] != '\u0001') && c3 != '\n') {
                            if (c3 != '\\' || cArray[n + 1] != '\n') break;
                            if (n + 2 == tclParse.endIndex) {
                                tclParse.incomplete = true;
                            }
                            n += 2;
                            continue block2;
                        }
                        c3 = cArray[++n];
                    }
                    if (c3 != '#') {
                        tclParse.commandStart = n;
                        break;
                    }
                    if (tclParse.commentStart < 0) {
                        tclParse.commentStart = n;
                    }
                    while (true) {
                        c3 = cArray[n];
                        if (n == tclParse.endIndex) {
                            tclParse.incomplete = true;
                            tclParse.commentSize = n - tclParse.commentStart;
                            continue block2;
                        }
                        if (c3 == '\\') {
                            if (cArray[n + 1] == '\n' && n + 2 == tclParse.endIndex) {
                                tclParse.incomplete = true;
                            }
                            backSlashResult = Parser.backslash(cArray, n);
                            n = backSlashResult.nextIndex;
                            continue;
                        }
                        if (c3 == '\n') {
                            tclParse.commentSize = ++n - tclParse.commentStart;
                            continue block2;
                        }
                        ++n;
                    }
                    break;
                }
            }
            catch (TclException tclException) {
                cArray[n4] = c;
                if (tclParse.commandStart < 0) {
                    tclParse.commandStart = n5;
                }
                tclParse.commandSize = tclParse.termIndex - tclParse.commandStart;
                tclParse.result = 1;
                return tclParse;
            }
            while (true) {
                TclToken tclToken;
                int n8;
                block52: {
                    block54: {
                        block50: {
                            block53: {
                                block51: {
                                    n8 = tclParse.numTokens;
                                    tclToken = tclParse.getToken(n8);
                                    tclToken.type = 1;
                                    while (true) {
                                        char c4 = c2 = (c3 = cArray[n]) > '\u007f' ? (char)'\u0000' : typeTable[c3];
                                        if (c2 == '\u0001') {
                                            ++n;
                                            continue;
                                        }
                                        if (c3 != '\\' || cArray[n + 1] != '\n') break;
                                        if (n + 2 == tclParse.endIndex) {
                                            tclParse.incomplete = true;
                                        }
                                        backSlashResult = Parser.backslash(cArray, n);
                                        n = backSlashResult.nextIndex;
                                    }
                                    if ((c2 & n7) != 0) {
                                        ++n;
                                        break block49;
                                    }
                                    if (n == tclParse.endIndex) break block49;
                                    tclToken.script_array = cArray;
                                    tclToken.script_index = n;
                                    ++tclParse.numTokens;
                                    ++tclParse.numWords;
                                    c3 = cArray[n];
                                    if (c3 != '\"') break block51;
                                    tclParse = Parser.parseTokens(cArray, ++n, 8, tclParse);
                                    if (tclParse.result != 0) {
                                        throw new TclException(tclParse.result);
                                    }
                                    if (tclParse.string[tclParse.termIndex] != '\"') {
                                        tclParse.termIndex = n - 1;
                                        tclParse.incomplete = true;
                                        throw new TclException(tclParse.interp, "missing \"");
                                    }
                                    n = tclParse.termIndex + 1;
                                    break block52;
                                }
                                if (c3 == '{') break block53;
                                tclParse = Parser.parseTokens(cArray, n, 1 | n7, tclParse);
                                if (tclParse.result != 0) {
                                    throw new TclException(tclParse.result);
                                }
                                n = tclParse.termIndex;
                                break block52;
                            }
                            tclToken = tclParse.getToken(tclParse.numTokens);
                            tclToken.type = 4;
                            tclToken.script_array = cArray;
                            tclToken.script_index = ++n;
                            tclToken.numComponents = 0;
                            int n9 = 1;
                            while (true) {
                                c3 = cArray[n];
                                while ((c3 > '\u007f' ? (char)'\u0000' : typeTable[c3]) == '\u0000') {
                                    c3 = cArray[++n];
                                }
                                if (cArray[n] == '}') {
                                    if (--n9 == 0) {
                                        if (n == tclToken.script_index) {
                                            break;
                                        }
                                        break block50;
                                    } else {
                                        ++n;
                                        continue;
                                    }
                                }
                                if (cArray[n] == '{') {
                                    ++n9;
                                    ++n;
                                    continue;
                                }
                                if (cArray[n] == '\\') {
                                    backSlashResult = Parser.backslash(cArray, n);
                                    if (cArray[n + 1] == '\n') {
                                        if (n + 2 == tclParse.endIndex) {
                                            tclParse.incomplete = true;
                                        }
                                        tclToken.size = n - tclToken.script_index;
                                        if (tclToken.size != 0) {
                                            ++tclParse.numTokens;
                                        }
                                        tclToken = tclParse.getToken(tclParse.numTokens);
                                        tclToken.type = 8;
                                        tclToken.script_array = cArray;
                                        tclToken.script_index = n;
                                        tclToken.size = backSlashResult.nextIndex - n;
                                        tclToken.numComponents = 0;
                                        ++tclParse.numTokens;
                                        n = backSlashResult.nextIndex;
                                        tclToken = tclParse.getToken(tclParse.numTokens);
                                        tclToken.type = 4;
                                        tclToken.script_array = cArray;
                                        tclToken.script_index = n;
                                        tclToken.numComponents = 0;
                                        continue;
                                    }
                                    n = backSlashResult.nextIndex;
                                    continue;
                                }
                                if (n == tclParse.endIndex) {
                                    tclParse.termIndex = tclParse.getToken((int)n8).script_index;
                                    tclParse.incomplete = true;
                                    throw new TclException(interp, "missing close-brace");
                                }
                                ++n;
                            }
                            if (tclParse.numTokens != n8 + 1) break block54;
                        }
                        tclToken.size = n - tclToken.script_index;
                        ++tclParse.numTokens;
                    }
                    ++n;
                }
                tclToken = tclParse.getToken(n8);
                tclToken.size = n - tclToken.script_index;
                tclToken.numComponents = tclParse.numTokens - (n8 + 1);
                if (tclToken.numComponents == 1 && tclParse.getToken((int)(n8 + 1)).type == 4) {
                    tclToken.type = 2;
                }
                char c5 = c2 = (c3 = cArray[n]) > '\u007f' ? (char)'\u0000' : typeTable[c3];
                if (c2 == '\u0001') {
                    ++n;
                    continue;
                }
                if (c3 != '\\' || cArray[n + 1] != '\n') break;
                if (n + 2 == tclParse.endIndex) {
                    tclParse.incomplete = true;
                }
                backSlashResult = Parser.backslash(cArray, n);
                n = backSlashResult.nextIndex;
            }
            if ((c2 & n7) != 0) {
                ++n;
            } else if (n != tclParse.endIndex) {
                tclParse.termIndex = n;
                if (cArray[n - 1] == '\"') {
                    throw new TclException(interp, "extra characters after close-quote");
                }
                throw new TclException(interp, "extra characters after close-brace");
            }
        }
        cArray[n4] = c;
        tclParse.commandSize = n - tclParse.commandStart;
        tclParse.result = 0;
        return tclParse;
    }

    static TclParse parseTokens(char[] cArray, int n, int n2, TclParse tclParse) {
        int n3;
        block16: {
            n3 = tclParse.numTokens;
            while (true) {
                char c;
                TclToken tclToken = tclParse.getToken(tclParse.numTokens);
                tclToken.script_array = cArray;
                tclToken.script_index = ++n;
                tclToken.numComponents = 0;
                char c2 = cArray[n];
                char c3 = c = c2 > '\u007f' ? (char)'\u0000' : typeTable[c2];
                if ((c & n2) != 0) break block16;
                if ((c & 4) == 0) {
                    while (((c = (c2 = cArray[++n]) > '\u007f' ? (char)'\u0000' : typeTable[c2]) & (n2 | 4)) == 0) {
                    }
                    tclToken.type = 4;
                    tclToken.size = n - tclToken.script_index;
                    ++tclParse.numTokens;
                    continue;
                }
                if (c2 == '$') {
                    int n4 = tclParse.numTokens;
                    tclParse = Parser.parseVarName(tclParse.interp, cArray, n, tclParse.endIndex - n, tclParse, true);
                    if (tclParse.result != 0) {
                        return tclParse;
                    }
                    n += tclParse.getToken((int)n4).size;
                    continue;
                }
                if (c2 == '[') {
                    block17: {
                        ++n;
                        do {
                            TclParse tclParse2 = Parser.parseCommand(tclParse.interp, cArray, n, tclParse.endIndex - n, tclParse.fileName, tclParse.lineNum, true);
                            if (tclParse2.result != 0) {
                                tclParse.termIndex = tclParse2.termIndex;
                                tclParse.incomplete = tclParse2.incomplete;
                                tclParse.result = tclParse2.result;
                                return tclParse;
                            }
                            n = tclParse2.commandStart + tclParse2.commandSize;
                            if (cArray[n - 1] == ']' && !tclParse2.incomplete) break block17;
                        } while (n != tclParse.endIndex);
                        if (tclParse.interp != null) {
                            tclParse.interp.setResult("missing close-bracket");
                        }
                        tclParse.termIndex = tclToken.script_index;
                        tclParse.incomplete = true;
                        tclParse.result = 1;
                        return tclParse;
                    }
                    tclToken.type = 16;
                    tclToken.size = n - tclToken.script_index;
                    ++tclParse.numTokens;
                    continue;
                }
                if (c2 == '\\') {
                    if (cArray[n + 1] == '\n') {
                        if (n + 2 == tclParse.endIndex) {
                            tclParse.incomplete = true;
                        }
                        if ((n2 & 1) != 0) break block16;
                    }
                    tclToken.type = 8;
                    BackSlashResult backSlashResult = Parser.backslash(cArray, n);
                    tclToken.size = backSlashResult.nextIndex - n;
                    ++tclParse.numTokens;
                    n += tclToken.size;
                    continue;
                }
                if (c2 != '\u0000') break;
                if (n != tclParse.endIndex) {
                    tclToken.type = 4;
                    tclToken.size = 1;
                    ++tclParse.numTokens;
                    continue;
                }
                break block16;
                break;
            }
            throw new TclRuntimeError("parseTokens encountered unknown character");
        }
        if (tclParse.numTokens == n3) {
            tclToken.type = 4;
            tclToken.size = 0;
            ++tclParse.numTokens;
        }
        tclParse.termIndex = n;
        tclParse.result = 0;
        return tclParse;
    }

    static void evalObjv(Interp interp, TclObject[] tclObjectArray, int n, int n2) throws TclException {
        interp.resetResult();
        if (tclObjectArray.length == 0) {
            return;
        }
        if (interp.deleted) {
            TclString.append((TclObject)interp.getResult(), (String)"attempt to call eval in deleted interpreter");
            interp.setErrorCode(TclString.newInstance((String)"CORE IDELETE {attempt to call eval in deleted interpreter}"));
            throw new TclException(1);
        }
        if (interp.nestLevel >= interp.maxNestingDepth) {
            throw new TclException(interp, "too many nested calls to eval (infinite loop?)");
        }
        ++interp.nestLevel;
        try {
            Command command = interp.getCommand(tclObjectArray[0].toString());
            if (command == null) {
                TclObject[] tclObjectArray2 = new TclObject[tclObjectArray.length + 1];
                int n3 = tclObjectArray.length - 1;
                while (n3 >= 0) {
                    tclObjectArray2[n3 + 1] = tclObjectArray[n3];
                    --n3;
                }
                tclObjectArray2[0] = TclString.newInstance((String)"unknown");
                tclObjectArray2[0].preserve();
                command = interp.getCommand("unknown");
                if (command == null) {
                    throw new TclException(interp, "invalid command name \"" + tclObjectArray[0].toString() + "\"");
                }
                Parser.evalObjv(interp, tclObjectArray2, n, 0);
                tclObjectArray2[0].release();
                Object var9_7 = null;
                --interp.nestLevel;
                return;
            }
            ++interp.cmdCount;
            CallFrame callFrame = interp.varFrame;
            if ((n2 & 0x20000) != 0) {
                interp.varFrame = null;
            }
            command.cmdProc(interp, tclObjectArray);
            interp.varFrame = callFrame;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            --interp.nestLevel;
            throw throwable;
        }
        Object var9_8 = null;
        --interp.nestLevel;
        {
        }
    }

    static void logCommandInfo(Interp interp, char[] cArray, int n, int n2, int n3, TclException tclException) {
        String string;
        int n4;
        if (interp.errAlreadyLogged) {
            return;
        }
        interp.errorLine = 1;
        int n5 = 0;
        while (n5 < n2) {
            if (cArray[n5] == '\n') {
                ++interp.errorLine;
            }
            ++n5;
        }
        if (n3 < 0) {
            int n6 = cArray.length - 1;
            n3 = n6 - n2;
        }
        if (n3 > 150) {
            n4 = 150;
            string = "...";
        } else {
            n4 = n3;
            string = "";
        }
        String string2 = new String(cArray, n2, n4);
        if (!interp.errInProgress) {
            interp.addErrorInfo("\n    while executing\n\"" + string2 + string + "\"");
        } else {
            interp.addErrorInfo("\n    invoked from within\n\"" + string2 + string + "\"");
        }
        interp.errAlreadyLogged = false;
        tclException.errIndex = n2 + n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TclObject evalTokens(Interp interp, TclToken[] tclTokenArray, int n, int n2) throws TclException {
        String string = null;
        TclObject tclObject = null;
        while (n2 > 0) {
            TclToken tclToken = tclTokenArray[n];
            TclObject tclObject2 = null;
            switch (tclToken.type) {
                case 4: {
                    string = tclToken.getTokenString();
                    break;
                }
                case 8: {
                    BackSlashResult backSlashResult = Parser.backslash(tclToken.script_array, tclToken.script_index);
                    if (backSlashResult.isWordSep) {
                        string = "\\" + backSlashResult.c;
                        break;
                    }
                    Character c = new Character(backSlashResult.c);
                    string = c.toString();
                    break;
                }
                case 16: {
                    interp.evalFlags |= 1;
                    ++tclToken.script_index;
                    Parser.eval2(interp, tclToken.script_array, tclToken.script_index, tclToken.size - 2, 0);
                    --tclToken.script_index;
                    tclObject2 = interp.getResult();
                    break;
                }
                case 32: {
                    TclObject tclObject3;
                    if (tclToken.numComponents == 1) {
                        tclObject3 = null;
                    } else {
                        tclObject3 = Parser.evalTokens(interp, tclTokenArray, n + 2, tclToken.numComponents - 1);
                        if (tclObject3 == null) {
                            return null;
                        }
                    }
                    String string2 = tclTokenArray[n + 1].getTokenString();
                    if (interp.noEval == 0) {
                        if (tclObject3 != null) {
                            Object var13_12;
                            try {
                                tclObject2 = interp.getVar(string2, tclObject3.toString(), 0);
                                var13_12 = null;
                                tclObject3.release();
                            }
                            catch (Throwable throwable) {
                                var13_12 = null;
                                tclObject3.release();
                                throw throwable;
                            }
                        } else {
                            tclObject2 = interp.getVar(string2, null, 0);
                        }
                    } else {
                        tclObject2 = TclString.newInstance((String)"");
                        tclObject2.preserve();
                    }
                    n2 -= tclToken.numComponents;
                    n += tclToken.numComponents;
                    break;
                }
                default: {
                    throw new TclRuntimeError("unexpected token type in evalTokens");
                }
            }
            if (tclObject == null) {
                tclObject = tclObject2 != null ? tclObject2 : TclString.newInstance((String)string);
                tclObject.preserve();
            } else {
                tclObject = tclObject.takeExclusive();
                if (tclObject2 != null) {
                    string = tclObject2.toString();
                }
                TclString.append((TclObject)tclObject, (String)string);
            }
            ++n;
            --n2;
        }
        return tclObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void eval2(Interp interp, char[] cArray, int n, int n2, int n3) throws TclException {
        int n4 = 0;
        TclParse tclParse = null;
        int n5 = cArray.length - 1;
        char[] cArray2 = cArray;
        int n6 = n;
        if (n2 < 0) {
            n2 = n5 - n;
        }
        interp.resetResult();
        CallFrame callFrame = interp.varFrame;
        if ((n3 & 0x20000) != 0) {
            interp.varFrame = null;
        }
        int n7 = n2;
        TclObject[] tclObjectArray = Parser.grabObjv(interp, 3);
        boolean bl = (interp.evalFlags & 1) != 0;
        interp.evalFlags &= 0xFFFFFFFE;
        try {
            do {
                block26: {
                    tclParse = Parser.parseCommand(interp, cArray2, n6, n7, null, 0, bl);
                    if (tclParse.result != 0) {
                        throw new TclException(tclParse.result);
                    }
                    if (tclParse.numWords > 0 && interp.noEval == 0) {
                        int n8;
                        Object var23_19;
                        try {
                            try {
                                int n9 = 0;
                                TclToken tclToken = tclParse.getToken(n9);
                                if (tclObjectArray.length != tclParse.numWords) {
                                    Parser.releaseObjv(interp, tclObjectArray);
                                    tclObjectArray = Parser.grabObjv(interp, tclParse.numWords);
                                }
                                n4 = 0;
                                while (true) {
                                    if (n4 >= tclParse.numWords) {
                                        try {
                                            Parser.evalObjv(interp, tclObjectArray, n7, 0);
                                            break;
                                        }
                                        catch (StackOverflowError stackOverflowError) {
                                            interp.setResult("too many nested calls to eval (infinite loop?)");
                                            throw new TclException(1);
                                        }
                                    }
                                    TclObject tclObject = Parser.evalTokens(interp, tclParse.tokenList, n9 + 1, tclToken.numComponents);
                                    if (tclObject == null) {
                                        throw new TclException(1);
                                    }
                                    tclObjectArray[n4] = tclObject;
                                    tclToken = tclParse.getToken(n9 += tclToken.numComponents + 1);
                                    ++n4;
                                }
                                var23_19 = null;
                                n8 = 0;
                            }
                            catch (TclException tclException) {
                                if (tclException.getCompletionCode() == 1 && !interp.errAlreadyLogged) {
                                    int n10 = tclParse.commandSize;
                                    if (tclParse.commandStart + n10 != n + n2) {
                                        --n10;
                                    }
                                    interp.varFrame = callFrame;
                                    Parser.logCommandInfo(interp, cArray, n, tclParse.commandStart, n10, tclException);
                                }
                                throw tclException;
                            }
                            while (true) {
                                if (n8 >= n4) {
                                    n4 = 0;
                                    tclParse.release();
                                    break block26;
                                }
                                tclObjectArray[n8].release();
                                ++n8;
                            }
                        }
                        catch (Throwable throwable) {
                            var23_19 = null;
                            n8 = 0;
                        }
                        while (true) {
                            if (n8 >= n4) {
                                n4 = 0;
                                tclParse.release();
                                throw throwable;
                            }
                            tclObjectArray[n8].release();
                            ++n8;
                        }
                    }
                }
                int n11 = tclParse.commandStart + tclParse.commandSize;
                n7 -= n11 - n6;
                n6 = n11;
                if (!bl || n6 <= 1 || cArray2[n6 - 1] != ']') continue;
                interp.termOffset = n6 - 1 - n;
                interp.varFrame = callFrame;
                Object var25_24 = null;
                if (tclParse != null) {
                    tclParse.release();
                }
                Parser.releaseObjv(interp, tclObjectArray);
                return;
            } while (n7 > 0);
            Object var25_25 = null;
            if (tclParse != null) {
                tclParse.release();
            }
            Parser.releaseObjv(interp, tclObjectArray);
        }
        catch (Throwable throwable) {
            Object var25_26 = null;
            if (tclParse != null) {
                tclParse.release();
            }
            Parser.releaseObjv(interp, tclObjectArray);
            throw throwable;
        }
        interp.termOffset = n6 - n;
        interp.varFrame = callFrame;
    }

    static TclParse parseVarName(Interp interp, char[] cArray, int n, int n2, TclParse tclParse, boolean bl) {
        int n3 = n2 >= 0 ? n + n2 : cArray.length - 1;
        if (!bl) {
            tclParse = new TclParse(interp, cArray, n3, null, -1);
        }
        TclToken tclToken = tclParse.getToken(tclParse.numTokens);
        tclToken.type = 32;
        tclToken.script_array = cArray;
        tclToken.script_index = n++;
        int n4 = tclParse.numTokens++;
        if (n >= n3) {
            tclToken.type = 4;
            tclToken.size = 1;
            tclToken.numComponents = 0;
            tclParse.result = 0;
            return tclParse;
        }
        TclToken tclToken2 = tclToken;
        tclToken = tclParse.getToken(tclParse.numTokens);
        if (cArray[n] == '{') {
            tclToken.type = 4;
            tclToken.script_array = cArray;
            tclToken.script_index = ++n;
            tclToken.numComponents = 0;
            while (true) {
                if (n == n3) {
                    if (interp != null) {
                        interp.setResult("missing close-brace for variable name");
                    }
                    tclParse.termIndex = tclToken.script_index - 1;
                    tclParse.incomplete = true;
                    tclParse.result = 1;
                    return tclParse;
                }
                if (cArray[n] == '}') break;
                ++n;
            }
            tclToken.size = n - tclToken.script_index;
            tclToken2.size = n - tclToken2.script_index;
            ++tclParse.numTokens;
            ++n;
        } else {
            tclToken.type = 4;
            tclToken.script_array = cArray;
            tclToken.script_index = n;
            tclToken.numComponents = 0;
            while (n != n3) {
                char c = cArray[n];
                if (Character.isLetterOrDigit(c) || c == '_') {
                    ++n;
                    continue;
                }
                if (c != ':' || n + 1 == n3 || cArray[n + 1] != ':') break;
                n += 2;
                while (n != n3 && cArray[n] == ':') {
                    ++n;
                }
            }
            tclToken.size = n - tclToken.script_index;
            if (tclToken.size == 0) {
                tclToken2.type = 4;
                tclToken2.size = 1;
                tclToken2.numComponents = 0;
                tclParse.result = 0;
                return tclParse;
            }
            ++tclParse.numTokens;
            if (n != n3 && cArray[n] == '(') {
                tclParse = Parser.parseTokens(cArray, ++n, 16, tclParse);
                if (tclParse.result != 0) {
                    return tclParse;
                }
                if (tclParse.termIndex == n3 || tclParse.string[tclParse.termIndex] != ')') {
                    if (interp != null) {
                        interp.setResult("missing )");
                    }
                    tclParse.termIndex = n - 1;
                    tclParse.incomplete = true;
                    tclParse.result = 1;
                    return tclParse;
                }
                n = tclParse.termIndex + 1;
            }
        }
        tclToken2.size = n - tclToken2.script_index;
        tclToken2.numComponents = tclParse.numTokens - (n4 + 1);
        tclParse.result = 0;
        return tclParse;
    }

    static ParseResult parseVar(Interp interp, String string) throws TclException {
        ParseResult parseResult;
        CharPointer charPointer = new CharPointer(string);
        TclParse tclParse = Parser.parseVarName(interp, charPointer.array, charPointer.index, -1, null, false);
        try {
            if (tclParse.numTokens == 1) {
                ParseResult parseResult2 = new ParseResult("$", 1);
                Object var8_6 = null;
                tclParse.release();
                return parseResult2;
            }
            TclObject tclObject = Parser.evalTokens(interp, tclParse.tokenList, 0, tclParse.numTokens);
            if (!tclObject.isShared()) {
                throw new TclRuntimeError("parseVar got temporary object from evalTokens");
            }
            tclObject.release();
            parseResult = new ParseResult(tclObject, tclParse.tokenList[0].size);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            tclParse.release();
            throw throwable;
        }
        Object var8_7 = null;
        tclParse.release();
        return parseResult;
    }

    static boolean commandComplete(String string, int n) {
        TclParse tclParse;
        CharPointer charPointer = new CharPointer(string);
        do {
            tclParse = Parser.parseCommand(null, charPointer.array, charPointer.index, n, null, 0, false);
            charPointer.index = tclParse.commandStart + tclParse.commandSize;
            tclParse.release();
            if (charPointer.index >= n) break;
            ++charPointer.index;
        } while (tclParse.result == 0);
        return !tclParse.incomplete;
    }

    static boolean objCommandComplete(TclObject tclObject) {
        String string = tclObject.toString();
        return Parser.commandComplete(string, string.length());
    }

    static BackSlashResult backslash(char[] cArray, int n) {
        int n2 = cArray.length - 1;
        if (++n == n2) {
            return new BackSlashResult('\\', n);
        }
        char c = cArray[n];
        switch (c) {
            case 'a': {
                return new BackSlashResult('\u0007', n + 1);
            }
            case 'b': {
                return new BackSlashResult('\b', n + 1);
            }
            case 'f': {
                return new BackSlashResult('\f', n + 1);
            }
            case 'n': {
                return new BackSlashResult('\n', n + 1);
            }
            case 'r': {
                return new BackSlashResult('\r', n + 1);
            }
            case 't': {
                return new BackSlashResult('\t', n + 1);
            }
            case 'v': {
                return new BackSlashResult('\u000b', n + 1);
            }
            case 'x': {
                if (++n < n2 && ((c = cArray[n]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                    String string = new String(cArray, n, n2 - n);
                    StrtoulResult strtoulResult = Util.strtoul(string, 0, 16);
                    if (strtoulResult.errno == 0) {
                        byte by = (byte)(strtoulResult.value & 0xFFL);
                        return new BackSlashResult((char)by, n + strtoulResult.index);
                    }
                }
                return new BackSlashResult('x', n);
            }
            case 'u': {
                int n3 = 0;
                int n4 = 0;
                while (n4 < 4) {
                    if (!((c = cArray[++n]) >= '0' && c <= '9' || c >= 'a' && c <= 'f') && (c < 'A' || c > 'F')) break;
                    int n5 = c - 48;
                    if (n5 > 9) {
                        n5 = n5 + 48 + 10 - 65;
                    }
                    if (n5 > 16) {
                        n5 = n5 + 65 - 97;
                    }
                    n3 = (n3 << 4) + n5;
                    ++n4;
                }
                if (n4 == 0) {
                    n3 = 117;
                }
                return new BackSlashResult((char)n3, n + 1);
            }
            case '\n': 
            case '\r': {
                if (c == '\r' && n + 1 < n2 && cArray[n + 1] == '\n') {
                    ++n;
                }
                do {
                    c = cArray[++n];
                } while (n < n2 && (c == ' ' || c == '\t'));
                return new BackSlashResult(' ', n);
            }
            case '\u0000': {
                return new BackSlashResult('\\', n + 1);
            }
        }
        if (c >= '0' && c <= '9') {
            int n6 = c - 48;
            if (++n != n2 && (c = cArray[n]) >= '0' && c <= '9') {
                n6 = n6 * 8 + (c - 48);
                if (++n != n2 && (c = cArray[n]) >= '0' && c <= '9') {
                    n6 = n6 * 8 + (c - 48);
                    ++n;
                }
            }
            return new BackSlashResult((char)(n6 & 0xFF), n);
        }
        return new BackSlashResult(c, n + 1);
    }

    static char charType(char c) {
        return c > '\u007f' ? (char)'\u0000' : typeTable[c];
    }

    static void init(Interp interp) {
        TclObject[][][] tclObjectArrayArray = new TclObject[10][][];
        int[] nArray = new int[10];
        int n = 0;
        while (n < 10) {
            int n2 = OBJV_CACHE_SIZES[n];
            tclObjectArrayArray[n] = new TclObject[n2][];
            nArray[n] = 0;
            int n3 = 0;
            while (n3 < n2) {
                tclObjectArrayArray[n][n3] = new TclObject[n];
                ++n3;
            }
            ++n;
        }
        interp.parserObjv = tclObjectArrayArray;
        interp.parserObjvUsed = nArray;
    }

    private static TclObject[] grabObjv(Interp interp, int n) {
        if (n >= 10) {
            return new TclObject[n];
        }
        int n2 = interp.parserObjvUsed[n];
        if (n2 < OBJV_CACHE_SIZES[n]) {
            int n3 = n;
            interp.parserObjvUsed[n3] = interp.parserObjvUsed[n3] + 1;
            return interp.parserObjv[n][n2];
        }
        return new TclObject[n];
    }

    private static void releaseObjv(Interp interp, TclObject[] tclObjectArray) {
        int n = tclObjectArray.length;
        if (n >= 10) {
            return;
        }
        int n2 = interp.parserObjvUsed[n];
        if (n2 > 0) {
            interp.parserObjvUsed[n] = --n2;
            interp.parserObjv[n][n2] = tclObjectArray;
        }
    }
}

