/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclObject;

class SocketCmd
implements Command {
    private static final String[] validCmds = new String[]{"-async", "-myaddr", "-myport", "-server"};
    static final int OPT_ASYNC = 0;
    static final int OPT_MYADDR = 1;
    static final int OPT_MYPORT = 2;
    static final int OPT_SERVER = 3;

    SocketCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl3 = false;
        int n = 1;
        while (n < tclObjectArray.length) {
            if (tclObjectArray[n].toString().length() <= 0 || tclObjectArray[n].toString().charAt(0) != '-') break;
            int n2 = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[n], (String[])validCmds, (String)"option", (int)0);
            switch (n2) {
                case 0: {
                    if (bl) {
                        throw new TclException(interp, "cannot set -async option for server sockets");
                    }
                    bl2 = true;
                    break;
                }
                case 1: {
                    if (++n >= tclObjectArray.length) {
                        throw new TclException(interp, "no argument given for -myaddr option");
                    }
                    string2 = tclObjectArray[n].toString();
                    break;
                }
                case 2: {
                    if (++n < tclObjectArray.length) break;
                    throw new TclException(interp, "no argument given for -myport option");
                }
                case 3: {
                    if (bl2) {
                        throw new TclException(interp, "cannot set -async option for server sockets");
                    }
                    bl = true;
                    if (++n >= tclObjectArray.length) {
                        throw new TclException(interp, "no argument given for -server option");
                    }
                    string3 = tclObjectArray[n].toString();
                    break;
                }
                default: {
                    throw new TclException(interp, "bad option \"" + tclObjectArray[n] + "\", must be -async, -myaddr, -myport," + " or -server");
                }
            }
            ++n;
        }
        if (bl) {
            string4 = string2;
            if (bl3) {
                throw new TclException(interp, "Option -myport is not valid for servers");
            }
        } else if (n < tclObjectArray.length) {
            string4 = tclObjectArray[n].toString();
            ++n;
        } else {
            SocketCmd.errorWrongNumArgs(interp, tclObjectArray[0].toString());
        }
        if (n != tclObjectArray.length - 1) {
            SocketCmd.errorWrongNumArgs(interp, tclObjectArray[0].toString());
        }
        if (bl) {
            // empty if block
        }
        throw new TclException(interp, "socket command not implemented yet");
    }

    private static void errorWrongNumArgs(Interp interp, String string) throws TclException {
        throw new TclException(interp, "wrong # args: should be either:\n" + string + " ?-myaddr addr? ?-myport myport? ?-async? host port\n" + string + " -server command ?-myaddr addr? port");
    }
}

