/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class SubstCmd
implements Command {
    private static final String[] validCmds = new String[]{"-nobackslashes", "-nocommands", "-novariables"};
    static final int OPT_NOBACKSLASHES = 0;
    static final int OPT_NOCOMMANDS = 1;
    static final int OPT_NOVARS = 2;

    SubstCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n = tclObjectArray.length - 1;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        String string = "";
        int n2 = 1;
        while (n2 < n) {
            if (!tclObjectArray[n2].toString().startsWith("-")) break;
            int n3 = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[n2], (String[])validCmds, (String)"switch", (int)0);
            switch (n3) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl2 = false;
                    break;
                }
                case 2: {
                    bl3 = false;
                    break;
                }
                default: {
                    throw new TclException(interp, "SubstCmd.cmdProc: bad option " + n3 + " index to cmds");
                }
            }
            ++n2;
        }
        if (n2 != n) {
            throw new TclNumArgsException(interp, n2, tclObjectArray, "?-nobackslashes? ?-nocommands? ?-novariables? string");
        }
        String string2 = tclObjectArray[n2].toString();
        int n4 = string2.length();
        int n5 = 0;
        while (n5 < n4) {
            char c = string2.charAt(n5);
            if (c == '[' && bl2) {
                ParseResult parseResult;
                try {
                    interp.evalFlags = 1;
                    interp.eval(string2.substring(n5 + 1, n4));
                    parseResult = new ParseResult(interp.getResult(), n5 + interp.termOffset);
                }
                catch (TclException tclException) {
                    n5 = tclException.errIndex + 1;
                    throw tclException;
                }
                n5 = parseResult.nextIndex + 2;
                string = string + parseResult.value.toString();
            } else if (c == '\r') {
                ++n5;
            } else if (c == '$' && bl3) {
                ParseResult parseResult = Parser.parseVar(interp, string2.substring(n5, n4));
                n5 += parseResult.nextIndex;
                string = string + parseResult.value.toString();
            } else if (c == '\\' && bl) {
                BackSlashResult backSlashResult = Interp.backslash(string2, n5, n4);
                n5 = backSlashResult.nextIndex;
                if (backSlashResult.isWordSep) break;
                string = string + backSlashResult.c;
            } else {
                string = string + c;
                ++n5;
            }
            if (n5 >= n4) break;
        }
        interp.setResult(string);
    }
}

