/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.UnaryMathFunction;

class TanhFunction
extends UnaryMathFunction {
    TanhFunction() {
    }

    ExprValue apply(Interp interp, TclObject[] tclObjectArray) throws TclException {
        double d = TclDouble.get((Interp)interp, (TclObject)tclObjectArray[0]);
        if (d == 0.0) {
            return new ExprValue(0.0);
        }
        double d2 = Math.pow(Math.E, d);
        double d3 = Math.pow(Math.E, -d);
        Expression.checkDoubleRange(interp, d2);
        Expression.checkDoubleRange(interp, d3);
        return new ExprValue((d2 - d3) / (d2 + d3));
    }
}

