/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.JTASynchronization;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.CORBAResourceWrapper;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.CoordinatorResource;
import com.ibm.ws.Transaction.JTS.CoordinatorResourceImpl;
import com.ibm.ws.Transaction.JTS.GlobalTID;
import com.ibm.ws.Transaction.JTS.RecoveryCoordinatorImpl;
import com.ibm.ws.Transaction.JTS.ResourceCallback;
import com.ibm.ws.Transaction.JTS.TransactionWrapper;
import com.ibm.ws.Transaction.JTS.TxInterceptorHelper;
import com.ibm.ws.Transaction.JTS.TxStatusHelper;
import com.ibm.ws.Transaction.JTS.WSCoordinatorImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.transaction.RollbackException;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions._CoordinatorImplBase;
import org.omg.CosTransactions.otid_t;

public final class CoordinatorImpl
extends _CoordinatorImplBase
implements ResourceCallback {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$Transaction$JTS$CoordinatorImpl == null ? (class$com$ibm$ws$Transaction$JTS$CoordinatorImpl = CoordinatorImpl.class$("com.ibm.ws.Transaction.JTS.CoordinatorImpl")) : class$com$ibm$ws$Transaction$JTS$CoordinatorImpl), (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private TransactionImpl _transaction;
    private static Hashtable _coordinatorTable;
    private PropagationContext _propagationContext = null;
    private Coordinator _superiorCoord;
    private RecoveryCoordinator _recoveryCoordinator = null;
    private ByteArray _gtrid = null;
    private ArrayList _corbaResources = null;
    private ORB _orb = null;
    static /* synthetic */ Class class$com$ibm$ws$Transaction$JTS$CoordinatorImpl;

    public CoordinatorImpl(TransactionImpl transactionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"CoordinatorImpl", (java.lang.Object)transactionImpl);
        }
        this._transaction = transactionImpl;
        this._orb = Configuration.getORB();
        this._propagationContext = this.get_txcontext();
        GlobalTID globalTID = new GlobalTID(this._propagationContext.current.otid);
        this._gtrid = new ByteArray(globalTID.getGlobalTransactionId());
        CoordinatorImpl.getCoordinatorTable().put(this._gtrid, this);
        this._transaction.addDestroyCallback((ResourceCallback)this);
        this._orb.connect((Object)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"CoordinatorImpl");
        }
    }

    public CoordinatorImpl(TransactionImpl transactionImpl, PropagationContext propagationContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"CoordinatorImpl", (java.lang.Object)new java.lang.Object[]{transactionImpl, propagationContext});
        }
        this._transaction = transactionImpl;
        this._propagationContext = propagationContext;
        this._superiorCoord = this._propagationContext.current.coord;
        GlobalTID globalTID = new GlobalTID(this._propagationContext.current.otid);
        this._gtrid = new ByteArray(globalTID.getGlobalTransactionId());
        CoordinatorImpl.getCoordinatorTable().put(this._gtrid, this);
        this._transaction.addDestroyCallback((ResourceCallback)this);
        this._orb = Configuration.getORB();
        this._orb.connect((Object)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"CoordinatorImpl");
        }
    }

    public static CoordinatorImpl get(PropagationContext propagationContext, boolean bl) {
        TransactionImpl transactionImpl;
        TransactionWrapper transactionWrapper;
        java.lang.Object object;
        java.lang.Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get", (java.lang.Object)new java.lang.Object[]{propagationContext, new Boolean(bl)});
        }
        if (propagationContext.current == null || propagationContext.current.otid.formatID == -1) {
            Tr.warning((TraceComponent)tc, (String)"WTRN0007_CANT_IMPORT_NULL_CONTEXT");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"get context has null transaction identifier");
            }
            throw new TRANSACTION_REQUIRED();
        }
        if (propagationContext.parents.length > 0) {
            Tr.warning((TraceComponent)tc, (String)"WTRN0008_CANT_IMPORT_NESTED_TRAN", (java.lang.Object)new GlobalTID(propagationContext.current.otid));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"get throwing INAVLID TRANSACTION");
            }
            throw new INVALID_TRANSACTION();
        }
        CoordinatorImpl coordinatorImpl = null;
        if (!bl) {
            object2 = propagationContext.current.otid;
            if (object2.tid.length - object2.bqual_length <= 0) {
                Tr.warning((TraceComponent)tc, (String)"WTRN0007_CANT_IMPORT_NULL_CONTEXT");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"get context has null/invalid gtid");
                }
                throw new TRANSACTION_REQUIRED();
            }
            object = new GlobalTID((otid_t)object2).getGlobalTransactionId();
            coordinatorImpl = (CoordinatorImpl)CoordinatorImpl.getCoordinatorTable().get(new ByteArray(object));
            if (coordinatorImpl == null && (transactionWrapper = ((WSCoordinatorImpl)TxInterceptorHelper.getWSCoordinator()).lookupTransactionWrapper((byte[])object)) != null) {
                transactionImpl = transactionWrapper.getTransaction();
                coordinatorImpl = new CoordinatorImpl(transactionImpl, propagationContext);
            }
        }
        if (coordinatorImpl == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"No coordinator cached for given context");
            }
            if (!TranManagerSet.instance().isActive()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"throwing TRANSACTION_ROLLEDBACK as not active");
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Coordinator in context", (java.lang.Object)propagationContext.current.coord);
                }
                if (((ObjectImpl)propagationContext.current.coord)._is_local()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"get throwing TRANSACTION_ROLLEDBACK");
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                object2 = new GlobalTID(propagationContext.current.otid);
                transactionImpl = new TransactionImpl(propagationContext.timeout, (GlobalTID)object2);
                coordinatorImpl = new CoordinatorImpl(transactionImpl, propagationContext);
                try {
                    object = new CoordinatorResourceImpl((GlobalTID)object2, transactionImpl).object();
                    transactionWrapper = propagationContext.current.coord.register_resource((Resource)object);
                    transactionImpl.setRecoveryCoordinator((RecoveryCoordinator)transactionWrapper);
                    transactionImpl.setCoordinatorResource((CoordinatorResource)object);
                }
                catch (Throwable throwable) {
                    block28: {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.Transaction.JTS.CoordinatorImpl.get", (String)"170");
                        if (throwable instanceof Inactive || throwable instanceof OBJECT_NOT_EXIST) {
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Exception caught registering coordinator with superior", (java.lang.Object)throwable);
                            }
                        } else {
                            Tr.error((TraceComponent)tc, (String)"WTRN0010_EXC_AT_COORD_REG", (java.lang.Object)throwable);
                        }
                        try {
                            transactionImpl.rollback();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTS.CoordinatorImpl.get", (String)"180");
                            if (!tc.isEventEnabled()) break block28;
                            Tr.event((TraceComponent)tc, (String)"Exception rolling back imported tx", (java.lang.Object)exception);
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"get", (java.lang.Object)"TRANSACTION_ROLLEDBACK");
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
            }
            transactionImpl = new TransactionImpl(propagationContext.timeout, propagationContext.current.otid.formatID);
            coordinatorImpl = new CoordinatorImpl(transactionImpl);
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Cached coordinator found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get", coordinatorImpl);
        }
        return coordinatorImpl;
    }

    public TransactionImpl getJTATransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJTATransaction");
            Tr.exit((TraceComponent)tc, (String)"getJTATransaction", (java.lang.Object)this._transaction);
        }
        return this._transaction;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        java.lang.Object v = CoordinatorImpl.getCoordinatorTable().remove(this._gtrid);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Coordinator removed from table ", v);
        }
        this._orb.disconnect((Object)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    private static Hashtable getCoordinatorTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCoordinatorTable");
        }
        if (_coordinatorTable == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Null coordinator table. Initializing.");
            }
            _coordinatorTable = new Hashtable();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCoordinatorTable", (java.lang.Object)_coordinatorTable);
        }
        return _coordinatorTable;
    }

    public Status get_status() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get_status");
        }
        Status status = TxStatusHelper.getCORBAStatus(this._transaction.getStatus());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get_status", (java.lang.Object)TxStatusHelper.getCORBAStatusAsString(status));
        }
        return status;
    }

    public Status get_parent_status() {
        return this.get_status();
    }

    public Status get_top_level_status() {
        return this.get_status();
    }

    public boolean is_same_transaction(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"is_same_transaction", (java.lang.Object)new java.lang.Object[]{this, coordinator});
        }
        boolean bl = false;
        TransactionImpl transactionImpl = null;
        if (coordinator instanceof CoordinatorImpl) {
            transactionImpl = ((CoordinatorImpl)coordinator).getJTATransaction();
        }
        if (transactionImpl != null) {
            bl = this._transaction.equals((java.lang.Object)transactionImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("is_same_transaction " + bl));
        }
        return bl;
    }

    public boolean is_related_transaction(Coordinator coordinator) {
        return this.is_same_transaction(coordinator);
    }

    public boolean is_ancestor_transaction(Coordinator coordinator) {
        return this.is_same_transaction(coordinator);
    }

    public boolean is_descendant_transaction(Coordinator coordinator) {
        return this.is_same_transaction(coordinator);
    }

    public boolean is_top_level_transaction() {
        return true;
    }

    public int hash_transaction() {
        return this._transaction.hashCode();
    }

    public int hash_top_level_tran() {
        return this.hash_transaction();
    }

    public synchronized RecoveryCoordinator register_resource(Resource resource) throws Inactive {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"register_resource", (java.lang.Object)resource);
        }
        if (this._corbaResources == null) {
            this._corbaResources = new ArrayList();
        } else {
            for (int i = 0; i < this._corbaResources.size(); ++i) {
                block9: {
                    if (!resource._is_equivalent((Object)this._corbaResources.get(i))) continue;
                    try {
                        this._transaction.setRollbackOnly();
                    }
                    catch (IllegalStateException illegalStateException) {
                        FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.Transaction.JTS.CoordinatorImpl.register_resource", (String)"483", (java.lang.Object)this);
                        if (!tc.isEventEnabled()) break block9;
                        Tr.event((TraceComponent)tc, (String)"IllegalStateException setting tx rollback only", (java.lang.Object)illegalStateException);
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"register_resource", (java.lang.Object)"TRANSACTION_ROLLEDBACK");
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
        }
        this._corbaResources.add(resource);
        this._transaction.enlistResource((JTAResource)new CORBAResourceWrapper(resource));
        if (this._recoveryCoordinator == null) {
            this._recoveryCoordinator = new RecoveryCoordinatorImpl(this._transaction).object();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"register_resource", (java.lang.Object)this._recoveryCoordinator);
        }
        return this._recoveryCoordinator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void register_synchronization(Synchronization synchronization) throws Inactive {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"register_synchronization", (java.lang.Object)synchronization);
        }
        try {
            try {
                this._transaction.registerSynchronization((javax.transaction.Synchronization)new JTASynchronization(synchronization));
            }
            catch (RollbackException rollbackException) {
                throw new TRANSACTION_ROLLEDBACK();
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.Transaction.JTS.Coordinator.register_synchronization", (String)"614", (java.lang.Object)this);
                if (!tc.isEventEnabled()) throw new Inactive();
                Tr.event((TraceComponent)tc, (String)"IllegalStateException registering sync. Throwing Inactive");
                throw new Inactive();
            }
            java.lang.Object var4_2 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"register_synchronization");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"register_synchronization");
    }

    public void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws NotSubtransaction {
        throw new NotSubtransaction();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback_only() throws Inactive {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback_only");
        }
        try {
            try {
                this._transaction.setRollbackOnly();
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.Transaction.JTS.Coordinator.rollback_only", (String)"637", (java.lang.Object)this);
                if (!tc.isEventEnabled()) throw new Inactive();
                Tr.event((TraceComponent)tc, (String)"IllegalStateException setting tx rollback only. Throwing Inactive");
                throw new Inactive();
            }
            java.lang.Object var3_1 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var3_2 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"rollback_only");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"rollback_only");
    }

    public String get_transaction_name() {
        return this._transaction.getGlobalTID().toString();
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable {
        throw new SubtransactionsUnavailable();
    }

    public PropagationContext get_txcontext() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get_txcontext");
        }
        if (this._propagationContext == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Creating propagation context");
            }
            long l = this._transaction.getExpirationTime();
            int n = 0;
            if (l != 0L && (n = (int)((l - System.currentTimeMillis() + 999L) / 1000L) + 10) <= 0) {
                block9: {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Timeout for subordinate <= 0. Marking rollback only");
                    }
                    try {
                        this._transaction.setRollbackOnly();
                    }
                    catch (IllegalStateException illegalStateException) {
                        FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.Transaction.JTS.CoordinatorImpl.get_txcontext", (String)"686", (java.lang.Object)this);
                        if (!tc.isEventEnabled()) break block9;
                        Tr.event((TraceComponent)tc, (String)"IllegalStateException setting tx rollback only");
                    }
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
            this._propagationContext = new PropagationContext(n, new TransIdentity((Coordinator)this, null, this._transaction.getGlobalTID().getRealTID()), new TransIdentity[0], this._orb.create_any());
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"PC context.timeout", (java.lang.Object)new Integer(n));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get_txcontext");
        }
        return this._propagationContext;
    }

    public String toString() {
        return Util.identity((java.lang.Object)this);
    }

    public Coordinator getParentCoordinator() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getParentCoordinator");
            Tr.exit((TraceComponent)tc, (String)"getParentCoordinator", (java.lang.Object)this._superiorCoord);
        }
        return this._superiorCoord;
    }

    public static TransactionImpl lookupTransaction(GlobalTID globalTID) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupTransaction", (java.lang.Object)globalTID);
        }
        ByteArray byteArray = new ByteArray(globalTID.getGlobalTransactionId());
        CoordinatorImpl coordinatorImpl = (CoordinatorImpl)CoordinatorImpl.getCoordinatorTable().get(byteArray);
        TransactionImpl transactionImpl = null;
        if (coordinatorImpl != null) {
            transactionImpl = coordinatorImpl.getJTATransaction();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupTransaction", (java.lang.Object)transactionImpl);
        }
        return transactionImpl;
    }

    public static CoordinatorImpl lookupCoordinator(GlobalTID globalTID) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupCoordinator", (java.lang.Object)globalTID);
        }
        ByteArray byteArray = new ByteArray(globalTID.getGlobalTransactionId());
        CoordinatorImpl coordinatorImpl = (CoordinatorImpl)CoordinatorImpl.getCoordinatorTable().get(byteArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupCoordinator", (java.lang.Object)coordinatorImpl);
        }
        return coordinatorImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

