/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.helper;

import com.ibm.ejs.models.base.extensions.helper.J2EEMigrationMultiStatus;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.mofj2ee.nls.J2EESpecificationMigrationConstants;
import java.text.MessageFormat;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;

public class J2EEMigrationStatus
implements J2EESpecificationMigrationConstants {
    public static final int COMPLETED_OK = 0;
    public static final int NOT_NEEDED = 1;
    public static final int NOT_POSSIBLE = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    private static final J2EEMigrationStatus[] EmptyStatusArray = new J2EEMigrationStatus[0];
    private int severity;
    private String message;
    private XMLResource resource;
    private EObject targetObject;

    J2EEMigrationStatus() {
    }

    public J2EEMigrationStatus(int n, String string) {
        this(n, (EObject)null, string);
    }

    public J2EEMigrationStatus(int n, XMLResource xMLResource) {
        this(n, xMLResource, null);
    }

    public J2EEMigrationStatus(int n, EObject eObject) {
        this(n, eObject, null);
    }

    public J2EEMigrationStatus(int n, XMLResource xMLResource, String string) {
        this.severity = n;
        this.resource = xMLResource;
        this.message = string;
    }

    public J2EEMigrationStatus(int n, EObject eObject, String string) {
        this.severity = n;
        this.targetObject = eObject;
        this.message = string;
    }

    protected String format(String string, String string2) {
        return MessageFormat.format(string, string2);
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = this.createDefaultMessage();
        }
        return this.message;
    }

    public String getMessageForDisplay() {
        return this.getSeverityText() + " " + this.getMessage();
    }

    protected String getSeverityText() {
        switch (this.severity) {
            case 4: {
                return J2EESpecificationMigrationConstants.ERROR_TEXT;
            }
            case 3: {
                return J2EESpecificationMigrationConstants.WARNING_TEXT;
            }
            case 1: 
            case 2: {
                return J2EESpecificationMigrationConstants.INFO_TEXT;
            }
        }
        return "";
    }

    private String createDefaultMessage() {
        String string;
        if (this.getResource() != null) {
            string = this.getResource().getURI().toString();
        } else if (this.getTargetObject() != null && this.getTargetObject() instanceof ENamedElement) {
            string = ((ENamedElement)this.getTargetObject()).getName();
        } else {
            return null;
        }
        switch (this.getSeverity()) {
            case 0: {
                return this.format(J2EESpecificationMigrationConstants.DEFAULT_COMPLETED_STATUS_MSG, string);
            }
            case 1: {
                return this.format(J2EESpecificationMigrationConstants.DEFAULT_NOT_NEEDED_STATUS_MSG, string);
            }
            case 2: {
                return this.format(J2EESpecificationMigrationConstants.DEFAULT_NOT_POSSIBLE_STATUS_MSG, string);
            }
            case 4: {
                return this.format(J2EESpecificationMigrationConstants.DEFAULT_ERROR_STATUS_MSG, string);
            }
        }
        return null;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public boolean isOK() {
        return this.severity == 0 || this.severity == 1;
    }

    public boolean isError() {
        return this.severity == 4;
    }

    public boolean isWarning() {
        return this.severity == 3;
    }

    public boolean isNotNeeded() {
        return this.severity == 1;
    }

    public boolean isNotPossible() {
        return this.severity == 2;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }

    public J2EEMigrationStatus[] getChildren() {
        return EmptyStatusArray;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public XMLResource getResource() {
        return this.resource;
    }

    public EObject getTargetObject() {
        return this.targetObject;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MigrationStatus ");
        if (this.severity == 0) {
            stringBuffer.append("Completed OK");
        } else if (this.severity == 4) {
            stringBuffer.append("ERROR");
        } else if (this.severity == 3) {
            stringBuffer.append("WARNING");
        } else if (this.severity == 1) {
            stringBuffer.append("Not Needed");
        } else if (this.severity == 2) {
            stringBuffer.append("Not Possible");
        } else {
            stringBuffer.append("severity=");
            stringBuffer.append(this.severity);
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.message);
        return stringBuffer.toString();
    }

    public J2EEMigrationStatus append(J2EEMigrationStatus j2EEMigrationStatus) {
        if (j2EEMigrationStatus == null) {
            return this;
        }
        J2EEMigrationMultiStatus j2EEMigrationMultiStatus = new J2EEMigrationMultiStatus();
        j2EEMigrationMultiStatus.merge(this);
        j2EEMigrationMultiStatus.merge(j2EEMigrationStatus);
        return j2EEMigrationMultiStatus;
    }
}

