/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.helper;

import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPResAuthType;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBBindingsHelper;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndPackage;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransaction;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransactionBoundaryKind;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransactionResolverKind;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransactionUnresolvedActionKind;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocaltranPackage;
import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.EjbqlFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FullSelectFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.LocalTran;
import com.ibm.ejs.models.base.extensions.ejbext.WhereClauseFinderDescriptor;
import com.ibm.ejs.models.base.extensions.helper.J2EEMigrationMultiStatus;
import com.ibm.ejs.models.base.extensions.helper.J2EEMigrationStatus;
import com.ibm.etools.application.ApplicationResource;
import com.ibm.etools.client.ApplicationClientResource;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EJBResource;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.ejb.Query;
import com.ibm.etools.ejb.QueryMethod;
import com.ibm.etools.j2ee.J2EEConstants;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.mofj2ee.nls.J2EESpecificationMigrationConstants;
import com.ibm.etools.webapplication.WebAppResource;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class J2EESpecificationMigrator
implements J2EEConstants,
J2EESpecificationMigrationConstants {
    protected XMLResource xmlResource;
    protected String version;
    protected boolean isComplex;

    public J2EESpecificationMigrator(XMLResource xMLResource, String string, boolean bl) {
        this.xmlResource = xMLResource;
        this.version = string;
        this.isComplex = bl;
    }

    public J2EESpecificationMigrator(String string, boolean bl) {
        this.version = string;
        this.isComplex = bl;
    }

    protected String format(String string, String string2) {
        return MessageFormat.format(string, string2);
    }

    protected String format(String string, String string2, String string3) {
        return MessageFormat.format(string, string2, string3);
    }

    public J2EEMigrationStatus migrate() {
        if (this.xmlResource != null && this.version != null) {
            switch (this.xmlResource.getType()) {
                case 1: {
                    return this.migrate((ApplicationClientResource)this.xmlResource);
                }
                case 2: {
                    return this.migrate((ApplicationResource)this.xmlResource);
                }
                case 3: {
                    return this.migrate((EJBResource)this.xmlResource);
                }
                case 4: {
                    return this.migrate((WebAppResource)this.xmlResource);
                }
            }
        }
        return new J2EEMigrationStatus(1, this.xmlResource);
    }

    private boolean basicNeedsToMigrate() {
        boolean bl = this.xmlResource.isJ2EE1_3();
        boolean bl2 = this.isVersion1_3();
        return bl && !bl2 || !bl && bl2;
    }

    private boolean isVersion1_3() {
        return this.version == "J2EE_1.3";
    }

    private boolean isVersion1_2() {
        return this.version == "J2EE_1.2";
    }

    protected J2EEMigrationStatus migrate(ApplicationClientResource applicationClientResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEMigrationStatus(1, (XMLResource)applicationClientResource);
        }
        boolean bl = this.isVersion1_3();
        String string = bl ? "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN" : "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
        String string2 = bl ? "http://java.sun.com/dtd/application-client_1_3.dtd" : "http://java.sun.com/j2ee/dtds/application-client_1_2.dtd";
        applicationClientResource.setPublicId(string);
        applicationClientResource.setSystemId(string2);
        return new J2EEMigrationStatus(0, (XMLResource)applicationClientResource);
    }

    protected J2EEMigrationStatus migrate(WebAppResource webAppResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEMigrationStatus(1, (XMLResource)webAppResource);
        }
        boolean bl = this.isVersion1_3();
        String string = bl ? "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN" : "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
        String string2 = bl ? "http://java.sun.com/dtd/web-app_2_3.dtd" : "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
        webAppResource.setPublicId(string);
        webAppResource.setSystemId(string2);
        return new J2EEMigrationStatus(0, (XMLResource)webAppResource);
    }

    protected J2EEMigrationStatus migrate(ApplicationResource applicationResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEMigrationStatus(1, (XMLResource)applicationResource);
        }
        boolean bl = this.isVersion1_3();
        String string = bl ? "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN" : "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
        String string2 = bl ? "http://java.sun.com/dtd/application_1_3.dtd" : "http://java.sun.com/j2ee/dtds/application_1_2.dtd";
        applicationResource.setPublicId(string);
        applicationResource.setSystemId(string2);
        return new J2EEMigrationStatus(0, (XMLResource)applicationResource);
    }

    protected J2EEMigrationStatus migrate(EJBResource eJBResource) {
        J2EEMigrationStatus j2EEMigrationStatus = null;
        boolean bl = this.basicNeedsToMigrate();
        boolean bl2 = this.isVersion1_3();
        EJBJar eJBJar = eJBResource.getEJBJar();
        if (bl) {
            if (!bl2 && (j2EEMigrationStatus = this.getMigrateToLowerLevelStatus(eJBJar)) != null) {
                return j2EEMigrationStatus;
            }
            this.ensureBeanVersionsSet(eJBJar);
            String string = bl2 ? "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN" : "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
            String string2 = bl2 ? "http://java.sun.com/dtd/ejb-jar_2_0.dtd" : "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
            eJBResource.setPublicId(string);
            eJBResource.setSystemId(string2);
        } else {
            j2EEMigrationStatus = new J2EEMigrationStatus(1, (XMLResource)eJBResource);
        }
        boolean bl3 = j2EEMigrationStatus != null;
        j2EEMigrationStatus = this.mergeStatuses(j2EEMigrationStatus, this.migrateEJBJar(eJBJar));
        j2EEMigrationStatus = this.mergeStatuses(j2EEMigrationStatus, this.migrateBeans(eJBJar));
        if (!bl3) {
            j2EEMigrationStatus = this.mergeStatuses(j2EEMigrationStatus, new J2EEMigrationStatus(0, (XMLResource)eJBResource));
        }
        return j2EEMigrationStatus;
    }

    private J2EEMigrationStatus mergeStatuses(J2EEMigrationStatus j2EEMigrationStatus, J2EEMigrationStatus j2EEMigrationStatus2) {
        if (j2EEMigrationStatus != null) {
            return j2EEMigrationStatus.append(j2EEMigrationStatus2);
        }
        return j2EEMigrationStatus2;
    }

    private J2EEMigrationStatus migrateEJBJar(EJBJar eJBJar) {
        if (eJBJar == null) {
            return null;
        }
        EJBJarBinding eJBJarBinding = EJBBindingsHelper.getEJBJarBinding(eJBJar);
        ResourceRefBinding resourceRefBinding = eJBJarBinding.getDefaultDatasource();
        if (resourceRefBinding != null) {
            Object object;
            if (eJBJarBinding.getDefaultCMPConnectionFactory() == null) {
                object = this.createCMPConnectionFactoryBinding(resourceRefBinding);
                eJBJarBinding.setDefaultCMPConnectionFactory((CMPConnectionFactoryBinding)object);
            }
            eJBJarBinding.setDefaultDatasource(null);
            object = eJBJar.getDisplayName() != null ? this.format(J2EESpecificationMigrationConstants.MIGRATED_DEFAULT_DATASOURCE_JAR_MSG, eJBJar.getDisplayName()) : J2EESpecificationMigrationConstants.MIGRATED_DEFAULT_DATASOURCE_MSG;
            return new J2EEMigrationStatus(0, (EObject)eJBJar, (String)object);
        }
        return null;
    }

    private CMPConnectionFactoryBinding createCMPConnectionFactoryBinding(ResourceRefBinding resourceRefBinding) {
        CMPConnectionFactoryBinding cMPConnectionFactoryBinding = ((EjbbndPackage)EPackage.Registry.INSTANCE.getEPackage("ejbbnd.xmi")).getEjbbndFactory().createCMPConnectionFactoryBinding();
        cMPConnectionFactoryBinding.setJndiName(resourceRefBinding.getJndiName());
        cMPConnectionFactoryBinding.setResAuth(CMPResAuthType.PER_CONNECTION_FACTORY_LITERAL);
        return cMPConnectionFactoryBinding;
    }

    private void ensureBeanVersionsSet(EJBJar eJBJar) {
        if (eJBJar != null) {
            EList eList = eJBJar.getEnterpriseBeans();
            int n = eList.size();
            int n2 = 0;
            while (n2 < n) {
                EnterpriseBean enterpriseBean = (EnterpriseBean)eList.get(n2);
                if (enterpriseBean.isContainerManagedEntity() && enterpriseBean.isVersion1_X()) {
                    ((ContainerManagedEntity)enterpriseBean).setVersion("1.x");
                }
                ++n2;
            }
        }
    }

    private J2EEMigrationStatus getMigrateToLowerLevelStatus(EJBJar eJBJar) {
        J2EEMigrationStatus j2EEMigrationStatus = null;
        if (eJBJar != null) {
            EList eList = eJBJar.getEnterpriseBeans();
            int n = eList.size();
            int n2 = 0;
            while (n2 < n) {
                EnterpriseBean enterpriseBean = (EnterpriseBean)eList.get(n2);
                J2EEMigrationStatus j2EEMigrationStatus2 = this.getMigrateToLowerLevelStatus(enterpriseBean);
                j2EEMigrationStatus = j2EEMigrationStatus == null ? j2EEMigrationStatus2 : j2EEMigrationStatus.append(j2EEMigrationStatus2);
                ++n2;
            }
        }
        return j2EEMigrationStatus;
    }

    private J2EEMigrationStatus getMigrateToLowerLevelStatus(EnterpriseBean enterpriseBean) {
        if (enterpriseBean.isMessageDriven() && this.isVersion1_2()) {
            return new J2EEMigrationStatus(2, (EObject)enterpriseBean);
        }
        if (enterpriseBean.isContainerManagedEntity() && enterpriseBean.isVersion2_X() && this.isVersion1_2()) {
            return new J2EEMigrationStatus(2, (EObject)enterpriseBean);
        }
        return null;
    }

    private J2EEMigrationMultiStatus migrateBeans(EJBJar eJBJar) {
        J2EEMigrationMultiStatus j2EEMigrationMultiStatus = new J2EEMigrationMultiStatus();
        if (eJBJar != null) {
            EList eList = eJBJar.getEnterpriseBeans();
            int n = eList.size();
            int n2 = 0;
            while (n2 < n) {
                EnterpriseBean enterpriseBean = (EnterpriseBean)eList.get(n2);
                j2EEMigrationMultiStatus.merge(this.migrate(enterpriseBean));
                ++n2;
            }
        }
        return j2EEMigrationMultiStatus;
    }

    public J2EEMigrationStatus migrate(EnterpriseBean enterpriseBean) {
        if (enterpriseBean != null && this.version != null) {
            if (enterpriseBean.isContainerManagedEntity()) {
                return this.migrate((ContainerManagedEntity)enterpriseBean);
            }
            return this.migrateBeanInterfaces(enterpriseBean);
        }
        return new J2EEMigrationStatus(1, (EObject)enterpriseBean);
    }

    protected J2EEMigrationStatus migrate(ContainerManagedEntity containerManagedEntity) {
        if (this.isVersion1_2() && containerManagedEntity.isVersion2_X()) {
            return new J2EEMigrationStatus(2, (EObject)containerManagedEntity);
        }
        if (this.isVersion1_3() && containerManagedEntity.isVersion1_X()) {
            return this.migrate1_xCMPFor2_0Target(containerManagedEntity);
        }
        return new J2EEMigrationStatus(1, (EObject)containerManagedEntity);
    }

    private J2EEMigrationStatus migrate1_xCMPFor2_0Target(ContainerManagedEntity containerManagedEntity) {
        containerManagedEntity.setVersion("2.x");
        if (!this.isComplex) {
            containerManagedEntity.setVersion("1.x");
        } else {
            containerManagedEntity.setAbstractSchemaName(containerManagedEntity.getName());
        }
        J2EEMigrationStatus j2EEMigrationStatus = this.migrateDataSourceIfNecessary(containerManagedEntity);
        j2EEMigrationStatus = this.mergeStatuses(j2EEMigrationStatus, this.migrateExtensionsIfNecessary(containerManagedEntity));
        return this.mergeStatuses(j2EEMigrationStatus, new J2EEMigrationStatus(0, (EObject)containerManagedEntity));
    }

    private J2EEMigrationStatus migrateDataSourceIfNecessary(ContainerManagedEntity containerManagedEntity) {
        EnterpriseBeanBinding enterpriseBeanBinding = EJBBindingsHelper.getExistingEjbBinding((EnterpriseBean)containerManagedEntity);
        if (enterpriseBeanBinding != null && enterpriseBeanBinding.getDatasource() != null) {
            return this.migrateDatasource(enterpriseBeanBinding);
        }
        return null;
    }

    private J2EEMigrationStatus migrateDatasource(EnterpriseBeanBinding enterpriseBeanBinding) {
        if (enterpriseBeanBinding.getCmpConnectionFactory() == null) {
            ResourceRefBinding resourceRefBinding = enterpriseBeanBinding.getDatasource();
            CMPConnectionFactoryBinding cMPConnectionFactoryBinding = this.createCMPConnectionFactoryBinding(resourceRefBinding);
            enterpriseBeanBinding.setCmpConnectionFactory(cMPConnectionFactoryBinding);
        }
        enterpriseBeanBinding.setDatasource(null);
        return new J2EEMigrationStatus(0, enterpriseBeanBinding, this.format("Migrated Datasource binding to a CMP Connection Factory binding for \"{0}\" bean.", enterpriseBeanBinding.getEnterpriseBean().getName()));
    }

    private J2EEMigrationStatus migrateExtensionsIfNecessary(ContainerManagedEntity containerManagedEntity) {
        if (!this.isComplex) {
            return null;
        }
        ContainerManagedEntityExtension containerManagedEntityExtension = (ContainerManagedEntityExtension)EjbExtensionsHelper.getExistingEjbExtension((EnterpriseBean)containerManagedEntity);
        if (containerManagedEntityExtension == null) {
            return null;
        }
        String string = containerManagedEntity.getName();
        if (string == null) {
            string = J2EESpecificationMigrationConstants.UNNAMED_EJB;
        }
        J2EEMigrationStatus j2EEMigrationStatus = this.removeIsolationLevels(containerManagedEntityExtension, string);
        j2EEMigrationStatus = this.mergeStatuses(j2EEMigrationStatus, this.removeAccessIntents(containerManagedEntityExtension, string));
        j2EEMigrationStatus = this.mergeStatuses(j2EEMigrationStatus, this.migrateLocalTran(containerManagedEntityExtension, string));
        return this.mergeStatuses(j2EEMigrationStatus, this.migrateFinders(containerManagedEntityExtension, string));
    }

    private J2EEMigrationStatus removeAccessIntents(ContainerManagedEntityExtension containerManagedEntityExtension, String string) {
        int n = containerManagedEntityExtension.getAccessIntents().size();
        if (n > 0) {
            containerManagedEntityExtension.getAccessIntents().clear();
            return new J2EEMigrationStatus(0, this.format(J2EESpecificationMigrationConstants.REMOVED_ACCESS_INTENTS_MSG, Integer.toString(n), string));
        }
        return null;
    }

    private J2EEMigrationStatus removeIsolationLevels(ContainerManagedEntityExtension containerManagedEntityExtension, String string) {
        int n = containerManagedEntityExtension.getIsolationLevelAttributes().size();
        if (n > 0) {
            containerManagedEntityExtension.getIsolationLevelAttributes().clear();
            return new J2EEMigrationStatus(0, this.format(J2EESpecificationMigrationConstants.REMOVED_ISOLATION_LEVELS_MSG, Integer.toString(n), string));
        }
        return null;
    }

    private J2EEMigrationStatus migrateLocalTran(ContainerManagedEntityExtension containerManagedEntityExtension, String string) {
        LocalTran localTran = containerManagedEntityExtension.getLocalTran();
        if (localTran == null) {
            return null;
        }
        LocalTransaction localTransaction = ((LocaltranPackage)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/ejs/models/base/extensions/commonext/localtran.ecore")).getLocaltranFactory().createLocalTransaction();
        localTransaction.setBoundary(this.transformBoundary(localTran.getBoundary().getValue()));
        localTransaction.setResolver(this.transformResolver(localTran.getResolver().getValue()));
        localTransaction.setUnresolvedAction(this.transformUnresolvedAction(localTran.getUnresolvedAction().getValue()));
        containerManagedEntityExtension.setLocalTran(null);
        containerManagedEntityExtension.setLocalTransaction(localTransaction);
        return null;
    }

    private LocalTransactionUnresolvedActionKind transformUnresolvedAction(int n) {
        switch (n) {
            case 1: {
                return LocalTransactionUnresolvedActionKind.COMMIT_LITERAL;
            }
            case 0: {
                return LocalTransactionUnresolvedActionKind.ROLLBACK_LITERAL;
            }
        }
        return null;
    }

    private LocalTransactionResolverKind transformResolver(int n) {
        switch (n) {
            case 0: {
                return LocalTransactionResolverKind.APPLICATION_LITERAL;
            }
            case 1: {
                return LocalTransactionResolverKind.CONTAINER_AT_BOUNDARY_LITERAL;
            }
        }
        return null;
    }

    private LocalTransactionBoundaryKind transformBoundary(int n) {
        switch (n) {
            case 0: {
                return LocalTransactionBoundaryKind.ACTIVITY_SESSION_LITERAL;
            }
            case 1: {
                return LocalTransactionBoundaryKind.BEAN_METHOD_LITERAL;
            }
        }
        return null;
    }

    private J2EEMigrationStatus migrateFinders(ContainerManagedEntityExtension containerManagedEntityExtension, String string) {
        if (containerManagedEntityExtension.getFinderDescriptors().size() == 0 || containerManagedEntityExtension.getEnterpriseBean() == null) {
            return null;
        }
        ContainerManagedEntity containerManagedEntity = containerManagedEntityExtension.getContainerManagedEntity();
        Iterator iterator = containerManagedEntityExtension.getFinderDescriptors().iterator();
        J2EEMigrationStatus j2EEMigrationStatus = null;
        while (iterator.hasNext()) {
            FinderDescriptor finderDescriptor = (FinderDescriptor)iterator.next();
            Query query = this.convertFinderToQuery(finderDescriptor);
            iterator.remove();
            if (query != null) {
                containerManagedEntity.getQueries().add((Object)query);
            }
            j2EEMigrationStatus = this.mergeStatuses(j2EEMigrationStatus, this.newMigratedFinderStatus(finderDescriptor, string));
        }
        return j2EEMigrationStatus;
    }

    private MethodElement getMethodElement(FinderDescriptor finderDescriptor) {
        if (finderDescriptor.getFinderMethodElements().isEmpty()) {
            return null;
        }
        return (MethodElement)finderDescriptor.getFinderMethodElements().get(0);
    }

    private Query convertFinderToQuery(FinderDescriptor finderDescriptor) {
        Query query = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createQuery();
        query.setDescription(J2EESpecificationMigrationConstants.CONVERTED_QUERY_DESCRIPTION);
        query.setQueryMethod(this.convertMethodElementToQueryMethod(this.getMethodElement(finderDescriptor)));
        query.setEjbQL(this.getEjbQLString(finderDescriptor));
        return query;
    }

    private String getEjbQLString(FinderDescriptor finderDescriptor) {
        if (finderDescriptor.isWhereClauseFinder()) {
            return ((WhereClauseFinderDescriptor)finderDescriptor).getWhereClause();
        }
        if (finderDescriptor.isFullSelectFinder()) {
            return ((FullSelectFinderDescriptor)finderDescriptor).getSelectStatement();
        }
        if (finderDescriptor.isEjbqlFinder()) {
            return ((EjbqlFinderDescriptor)finderDescriptor).getEjbqlQueryString();
        }
        return "";
    }

    private QueryMethod convertMethodElementToQueryMethod(MethodElement methodElement) {
        QueryMethod queryMethod = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createQueryMethod();
        queryMethod.setParms(methodElement.getParms());
        queryMethod.setName(methodElement.getName());
        return queryMethod;
    }

    private J2EEMigrationStatus newMigratedFinderStatus(FinderDescriptor finderDescriptor, String string) {
        MethodElement methodElement = this.getMethodElement(finderDescriptor);
        if (methodElement == null) {
            return null;
        }
        return new J2EEMigrationStatus(0, this.format(J2EESpecificationMigrationConstants.CONVERTED_FINDER_MSG, methodElement.getSignature(), string));
    }

    protected J2EEMigrationStatus migrateBeanInterfaces(EnterpriseBean enterpriseBean) {
        if (this.isVersion1_2() && enterpriseBean.isVersion2_X() && enterpriseBean.hasLocalClient()) {
            enterpriseBean.setLocalInterface(null);
            enterpriseBean.setLocalHomeInterface(null);
            return new J2EEMigrationStatus(3, (EObject)enterpriseBean, this.format(J2EESpecificationMigrationConstants.REMOVED_LOCAL_CLIENT_MSG, enterpriseBean.getName()));
        }
        return new J2EEMigrationStatus(1, (EObject)enterpriseBean);
    }
}

