/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.PortableSQLException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.security.GenericCredential;
import javax.transaction.xa.XAException;

public class GenericDataStoreHelper
implements DataStoreHelper,
Serializable {
    protected static final String resBundle = "IBMDataStoreAdapterNLS";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$rsadapter$GenericDataStoreHelper == null ? (class$com$ibm$websphere$rsadapter$GenericDataStoreHelper = GenericDataStoreHelper.class$("com.ibm.websphere.rsadapter.GenericDataStoreHelper")) : class$com$ibm$websphere$rsadapter$GenericDataStoreHelper), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    protected static final String EOLN = System.getProperty("line.separator");
    final DataStoreHelperMetaData dshMd = new DataStoreHelperMetaData();
    static final long serialVersionUID = -3806603123795564229L;
    protected HashMap genErrorMap = new HashMap(17);
    private static final int HASHSIZE = 17;
    private HashMap userNewMap = null;
    static /* synthetic */ Class class$com$ibm$websphere$rsadapter$GenericDataStoreHelper;
    static /* synthetic */ Class class$com$ibm$websphere$ce$cm$StaleConnectionException;
    static /* synthetic */ Class class$com$ibm$websphere$ce$cm$DuplicateKeyException;
    static /* synthetic */ Class class$com$ibm$websphere$ce$cm$StaleStatementException;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$sql$SQLException;

    public GenericDataStoreHelper(Properties properties) {
        this.addInitialMaps();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init", (Object)this);
        }
    }

    public DataStoreHelperMetaData getMetaData() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"returning: ", (Object)this.dshMd);
        }
        return this.dshMd;
    }

    private void addInitialMaps() {
        this.genErrorMap.put("55032", class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.genErrorMap.put("08001", class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.genErrorMap.put("08003", class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.genErrorMap.put("40003", class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.genErrorMap.put("S1000", class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.genErrorMap.put("08006", class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.genErrorMap.put("08S01", class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.genErrorMap.put(new Integer(23505), class$com$ibm$websphere$ce$cm$DuplicateKeyException == null ? (class$com$ibm$websphere$ce$cm$DuplicateKeyException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.DuplicateKeyException")) : class$com$ibm$websphere$ce$cm$DuplicateKeyException);
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getIsolationLevel, default(read committed) is returned, intent is:", (Object)accessIntent);
        }
        return 2;
    }

    public int getResultSetType(AccessIntent accessIntent) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getResultSetType, return: ResultSet.TYPE_FORWARD_ONLY");
        }
        return 1003;
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getResultSetConcurrency, default (CONCUR_READ_ONLY) is returned. intent is:", (Object)accessIntent);
        }
        return 1007;
    }

    public void processGenericCredentials(GenericCredential genericCredential) throws ResourceException {
    }

    public boolean isConnectionError(SQLException sQLException) {
        Class clazz;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isConnectionError: ", (Object)sQLException);
        }
        if (sQLException != null && (clazz = this.findMappingClass(sQLException)) != null) {
            boolean bl2 = clazz.equals(class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException) || clazz.equals(class$com$ibm$websphere$ce$cm$StaleStatementException == null ? (class$com$ibm$websphere$ce$cm$StaleStatementException = GenericDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleStatementException")) : class$com$ibm$websphere$ce$cm$StaleStatementException) ? true : (bl = false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isConnectionError: ", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String hasLostUpdateOrDeadLockOccurred(int n, boolean bl) {
        switch (n) {
            case 1: 
            case 2: {
                return "MSG_CONM_7008W";
            }
        }
        if (!bl) {
            return "MSG_CONM_7010W";
        }
        return null;
    }

    public Class findMappingClass(SQLException sQLException) {
        Object var2_2 = null;
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findMappingClass for exception", (Object)sQLException);
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"the DataStoreHelper is: ", (Object)this);
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                var2_2 = this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (var2_2 != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
                string = sQLException.getSQLState();
                if (string != null && (var2_2 = this.userNewMap.get(string)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
            }
            if ((var2_2 = this.genErrorMap.get(new Integer(sQLException.getErrorCode()))) == null && (string = sQLException.getSQLState()) != null) {
                var2_2 = this.genErrorMap.get(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findMappingClass, returning", var2_2);
        }
        return var2_2;
    }

    private SQLException mapExceptionHelper(SQLException sQLException) {
        Class clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapExceptionHelper");
        }
        if ((clazz = this.findMappingClass(sQLException)) != null && !clazz.equals(class$java$lang$Void == null ? (class$java$lang$Void = GenericDataStoreHelper.class$("java.lang.Void")) : class$java$lang$Void)) {
            try {
                Class[] classArray = new Class[]{class$java$sql$SQLException == null ? (class$java$sql$SQLException = GenericDataStoreHelper.class$("java.sql.SQLException")) : class$java$sql$SQLException};
                Constructor constructor = clazz.getDeclaredConstructor(classArray);
                PortableSQLException portableSQLException = (PortableSQLException)constructor.newInstance(sQLException);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"mapExceptionHelper: Mapping was done returning:", (Object)sQLException);
                }
                return portableSQLException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.rsadapter.GenericDataStoreHelper.mapExceptionHelper", (String)"313", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"NO_EXCPT_MAP", (Object)exception);
                return sQLException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapExceptionHelper: No Mapping was done returning:");
        }
        return sQLException;
    }

    public SQLException mapException(SQLException sQLException) {
        if (sQLException instanceof PortableSQLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception does not need to be mapped, returning the same exception", (Object)sQLException);
            }
            return sQLException;
        }
        return this.mapExceptionHelper(sQLException);
    }

    public final DataStoreAdapterException mapException(DataStoreAdapterException dataStoreAdapterException) {
        SQLException sQLException = null;
        SQLException sQLException2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"exception to be mapped is: ", (Object)dataStoreAdapterException);
        }
        if (!dataStoreAdapterException.beenMapped()) {
            if (dataStoreAdapterException.containsSqlException() && (sQLException = this.mapExceptionHelper(sQLException2 = (SQLException)dataStoreAdapterException.getLinkedException())) instanceof PortableSQLException) {
                if (sQLException2 instanceof BatchUpdateException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception is a batchUpdate ex, no exception mapping is done, just setting connection error flag because cause id a staleConnectionException");
                    }
                } else {
                    dataStoreAdapterException.setLinkedException((Exception)sQLException);
                }
                if (sQLException instanceof StaleConnectionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"mapException: linkedException causes a  Stale Connection");
                    }
                    dataStoreAdapterException.setConnectionError(true);
                }
            }
            dataStoreAdapterException.setBeenMapped();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"exception returned is: ", (Object)dataStoreAdapterException);
        }
        return dataStoreAdapterException;
    }

    public void doConnectionSetup(Connection connection) throws SQLException {
    }

    public boolean doConnectionCleanup(Connection connection) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doConnectionCleanup(): no cleanup is done return false");
        }
        return false;
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setCursorName(null);
        preparedStatement.setEscapeProcessing(true);
        preparedStatement.setFetchDirection(1000);
        preparedStatement.setMaxFieldSize(0);
        preparedStatement.setMaxRows(0);
        preparedStatement.setQueryTimeout(0);
    }

    public String showLockInfo(Properties properties) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo() is not supported for GenericDataStoreHelper");
        }
        return AdapterUtil.getNLSMessage((String)"GENERIC_HELPER_NO_LOCK_INFO");
    }

    public void setUserDefinedMap(Map map) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setUserDefinedMap: ", (Object)map);
        }
        this.userNewMap = new HashMap(map);
    }

    public int getLockType(AccessIntent accessIntent) {
        int n;
        block5: {
            block6: {
                n = 1;
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"getLockType called with accessintent of :", (Object)accessIntent);
                }
                if (accessIntent == null) break block5;
                if (accessIntent.getAccessType() != 1) break block5;
                if (accessIntent.getConcurrencyControl() != 1) break block5;
                int n2 = accessIntent.getPessimisticUpdateLockHint();
                if (n2 == 3) break block6;
                if (n2 != 4) break block5;
            }
            n = 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"the locktype returned is: ", (Object)AdapterUtil.getLockTypeAsString((int)n));
        }
        return n;
    }

    public short calcPartitionNumber(String string, Properties properties) throws ResourceException {
        return -1;
    }

    public PrintWriter getPrintWriter() {
        return null;
    }

    public String getXAExceptionContents(XAException xAException) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("The cause is               : ").append(xAException.getCause());
        return stringBuffer.toString();
    }

    public int modifyXAFlag(int n) {
        return n;
    }

    public boolean isBatchUpdateSupportedWithAccessIntent(AccessIntent accessIntent) {
        return true;
    }

    public String processSQL(String string, int n) {
        return null;
    }

    public String processSQL(String string, int n, boolean bl, boolean bl2) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

