/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterInternalException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.xa.OracleXAException;
import oracle.sql.BLOB;

public class OracleDataStoreHelper
extends GenericDataStoreHelper
implements Serializable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$rsadapter$OracleDataStoreHelper == null ? (class$com$ibm$websphere$rsadapter$OracleDataStoreHelper = OracleDataStoreHelper.class$("com.ibm.websphere.rsadapter.OracleDataStoreHelper")) : class$com$ibm$websphere$rsadapter$OracleDataStoreHelper), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private HashMap userNewMap = null;
    private HashMap oraErrorMap = null;
    private static final int HASHSIZE = 41;
    static final long serialVersionUID = -2977953273352295083L;
    private boolean isXADataSource = false;
    private static final String oracleXADataSourceClassName = "OracleXADataSource";
    static /* synthetic */ Class class$com$ibm$websphere$rsadapter$OracleDataStoreHelper;
    static /* synthetic */ Class class$com$ibm$websphere$ce$cm$StaleConnectionException;
    static /* synthetic */ Class class$com$ibm$websphere$ce$cm$DuplicateKeyException;

    public OracleDataStoreHelper(Properties properties) {
        super(null);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init> OracleHelper:", (Object)properties);
        }
        this.oraErrorMap = new HashMap(41);
        this.addInitialMaps();
        this.dshMd.setHelperType(13);
        this.dshMd.setReadOnlySupport(false);
        String string = (String)properties.remove("dataSourceClass");
        if (string != null && string.endsWith(oracleXADataSourceClassName)) {
            this.isXADataSource = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"the metadata for the oracle helper is", (Object)this.dshMd);
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object)("The Oracle DataSource class name is " + string));
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object)("isXADataSource = " + this.isXADataSource));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init> OracleHelper:", (Object)this);
        }
    }

    private void addInitialMaps() {
        this.oraErrorMap.put(new Integer(28), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(1012), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(1014), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(1033), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(1034), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(1035), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(1089), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(1090), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(1092), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(3113), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(3114), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(12541), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(12560), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(12571), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(17002), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(17008), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(17009), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(17410), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(17401), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.oraErrorMap.put(new Integer(1), class$com$ibm$websphere$ce$cm$DuplicateKeyException == null ? (class$com$ibm$websphere$ce$cm$DuplicateKeyException = OracleDataStoreHelper.class$("com.ibm.websphere.ce.cm.DuplicateKeyException")) : class$com$ibm$websphere$ce$cm$DuplicateKeyException);
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setEscapeProcessing(true);
        if (preparedStatement.getFetchDirection() != 1000) {
            preparedStatement.setFetchDirection(1000);
        }
        preparedStatement.setMaxFieldSize(0);
        preparedStatement.setMaxRows(0);
        preparedStatement.setQueryTimeout(0);
    }

    public final Class findMappingClass(SQLException sQLException) {
        Object var2_2 = null;
        String string = null;
        Object var4_4 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findMappingClass for :", (Object)sQLException);
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                var2_2 = this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (var2_2 != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
                string = sQLException.getSQLState();
                if (string != null && (var2_2 = this.userNewMap.get(string)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
            }
            if ((var2_2 = this.oraErrorMap.get(new Integer(sQLException.getErrorCode()))) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findMappingClass return ", var2_2);
                }
                return var2_2;
            }
            string = sQLException.getSQLState();
            if (string != null) {
                var2_2 = this.oraErrorMap.get(string);
            }
            if (var2_2 == null) {
                return super.findMappingClass(sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
        }
        return var2_2;
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        int n = 2;
        int n2 = -1;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIsolationLevel, intent: ", (Object)accessIntent);
        }
        if (accessIntent != null) {
            n2 = accessIntent.getPessimisticUpdateLockHint();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The hint_value is: ", (Object)new Integer(n2));
            }
            if (n2 == 4) {
                n = 8;
                Tr.warning((TraceComponent)tc, (String)"ORACLE_MAYBE_BAD_ISOLATION");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIsolationLevel, return:", (Object)AdapterUtil.getIsolationLevelString((int)n));
        }
        return n;
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        int n = 1007;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResultSetConcurrency, intent: ", (Object)accessIntent);
        }
        if (accessIntent == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResultSetConcurrency,intent is null, return: ResultSet.CONCUR_READ_ONLY");
            }
            return n;
        }
        if (accessIntent.getAccessType() == 1) {
            n = 1008;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResultSetConcurrency, return:", (Object)AdapterUtil.getConcurrencyModeString((int)n));
        }
        return n;
    }

    public String hasLostUpdateOrDeadLockOccurred(int n, boolean bl) {
        if (!bl && n == 2) {
            return "MSG_CONM_7009W";
        }
        return null;
    }

    public final String showLockInfo(Properties properties) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo: ", (Object)properties);
        }
        if (properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"showLockInfo: connection property is not specified ");
            }
            return null;
        }
        ConnectionPoolDataSource connectionPoolDataSource = null;
        String string = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
        Object object = null;
        try {
            object = DSConfigurationHelper.createDataSource((Object)string);
            DSConfigurationHelper.setDataSourceProperties((Object)object, (Properties)properties);
            connectionPoolDataSource = (ConnectionPoolDataSource)object;
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.websphere.rsadapter.OracleDataStoreHelper.showLockInfo", (String)"254", (Object)this);
            Exception exception = resourceException.getLinkedException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed during establishing a connection -- datasource creation exception is:", (Object)exception);
            }
            throw exception;
        }
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo: connection established ", (Object)connection);
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select distinct LO.Os_user_name, LO.Oracle_userName , LO.Process,  LO.session_ID, S.serial#, L.LMode, L.request, L.Block, L.type, O.sql_text, k.name from v$lock L, v$locked_object LO, v$open_cursor O, v$session S, sys.obj$ k where L.sid=LO.session_ID and L.sid=O.sid and S.sid=L.sid and LO.object_id=k.obj#");
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(256);
        while (resultSet.next()) {
            stringBuffer.append("                   ===========" + ++n + "===========" + EOLN);
            stringBuffer.append("The OSID issued the lock       : " + resultSet.getString(1) + EOLN);
            stringBuffer.append("The OracleID issued the lock   : " + resultSet.getString(2) + EOLN);
            stringBuffer.append("The java process               : " + resultSet.getString(3) + EOLN);
            stringBuffer.append("The session ID                 : " + resultSet.getString(4) + EOLN);
            stringBuffer.append("The session serial#            : " + resultSet.getString(5) + EOLN);
            if (resultSet.getInt(6) != 0) {
                stringBuffer.append("The LOCK mode held             : " + resultSet.getString(6) + EOLN);
            }
            if (resultSet.getInt(7) != 0) {
                stringBuffer.append("The REQUEST mode               : " + resultSet.getString(7) + EOLN);
                bl = true;
            } else {
                bl = false;
            }
            if (resultSet.getInt(8) == 1) {
                stringBuffer.append("Status                         : Blocking" + EOLN);
            } else if (bl) {
                stringBuffer.append("Status                         : Waiting" + EOLN);
            }
            stringBuffer.append("The lock type                  : " + resultSet.getString(9) + EOLN);
            stringBuffer.append("The sqlText                    : " + resultSet.getString(10) + EOLN);
            stringBuffer.append("The locked table               : " + resultSet.getString(11) + EOLN);
        }
        stringBuffer.append(EOLN + "===>" + n + "Oracle locks found" + EOLN + EOLN + EOLN);
        stringBuffer.append("*****************************" + EOLN);
        stringBuffer.append("Symbols table: " + EOLN);
        stringBuffer.append("Lmode:  Lock mode in which the session holds the lock:" + EOLN + " 0, None " + EOLN + " 1, Null (NULL) " + EOLN + " 2, Row-S (SS) " + EOLN + " 3, Row-X (SX) " + EOLN + " 4, Share (S) " + EOLN + " 5, S/Row-X (SSX) " + EOLN + " 6, Exclusive (X)" + EOLN);
        stringBuffer.append("*****************************" + EOLN);
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public final void addNewMap(Map map) {
        this.userNewMap = new HashMap(map);
    }

    public int getLockType(AccessIntent accessIntent) {
        int n = 1;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLockType called with accessIntent : ", (Object)accessIntent);
        }
        if (accessIntent == null) {
            return 2;
        }
        if (accessIntent.getAccessType() == 1) {
            if (accessIntent.getConcurrencyControl() == 1) {
                int n2 = accessIntent.getPessimisticUpdateLockHint();
                if (n2 != 1) {
                    n = 2;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"the locktype returned is: ", (Object)AdapterUtil.getLockTypeAsString((int)n));
        }
        return n;
    }

    public void doSpecialBLobWork(ResultSet resultSet, InputStream[] inputStreamArray, String[] stringArray) throws DataStoreAdapterException {
        BLOB bLOB = null;
        int n = stringArray.length;
        OutputStream outputStream = null;
        try {
            if (resultSet.next()) {
                for (int i = 0; i < n; ++i) {
                    int n2;
                    bLOB = (BLOB)resultSet.getBlob(i + 1);
                    outputStream = bLOB.getBinaryOutputStream();
                    int n3 = bLOB.getChunkSize();
                    byte[] byArray = new byte[n3];
                    while ((n2 = inputStreamArray[i].read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n2);
                    }
                    inputStreamArray[i].close();
                    outputStream.close();
                }
            } else {
                throw new DataStoreAdapterInternalException("Using Oracle Special Blob update: row containing blob wasn't found, can't update the blob");
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new DataStoreAdapterException("DSA_ERROR", (Throwable)exception, this.getClass());
        }
    }

    public String assembleSqlString(String[] stringArray, StringBuffer stringBuffer, String[] stringArray2, String string) {
        StringBuffer stringBuffer2 = null;
        String string2 = null;
        int n = stringArray.length;
        if (n > 0) {
            int n2;
            int n3;
            stringBuffer2 = new StringBuffer(512);
            stringBuffer2.append("select ");
            stringBuffer2.append(stringArray[0]);
            for (n3 = 1; n3 < n; ++n3) {
                stringBuffer2.append(", ");
                stringBuffer2.append(stringArray[n3]);
            }
            stringBuffer2.append(" from ");
            stringBuffer2.append(string);
            stringBuffer2.append(" where ");
            n3 = 0;
            while ((n2 = stringBuffer.toString().indexOf("?")) != -1) {
                stringBuffer.deleteCharAt(n2);
                stringBuffer.insert(n2, stringArray2[0]);
            }
            stringBuffer2.append(stringBuffer);
            stringBuffer2.append(" for update");
            string2 = stringBuffer2.toString();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"the assembled sql string is: ", string2);
        }
        return string2;
    }

    public String getXAExceptionContents(XAException xAException) {
        StringBuffer stringBuffer = new StringBuffer(350);
        if (xAException instanceof OracleXAException) {
            OracleXAException oracleXAException = (OracleXAException)xAException;
            int n = oracleXAException.getXAError();
            int n2 = oracleXAException.getOracleError();
            stringBuffer.append(EOLN).append("The XA Error is            : ").append(n).append(EOLN);
            stringBuffer.append("The XA Error message is    : ").append(OracleXAException.getXAErrorMessage((int)n)).append(EOLN);
            stringBuffer.append("The Oracle Error code is   : ").append(n2).append(EOLN);
            stringBuffer.append("The Oracle Error message is: ").append(OracleXAException.getXAErrorMessage((int)n2)).append(EOLN);
        }
        stringBuffer.append("The cause is               : ").append(xAException.getCause());
        return new String(stringBuffer);
    }

    public int modifyXAFlag(int n) {
        int n2 = n | 0x10000;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"returning (xaflag | OracleXAResource.ORATRANSLOOSE): ", (Object)new Integer(n2));
        }
        return n2;
    }

    public boolean isBatchUpdateSupportedWithAccessIntent(AccessIntent accessIntent) {
        if (accessIntent != null && accessIntent.getConcurrencyControl() == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isBatchUpdateSupportedWithAccessIntent(): returning false because occ is used.  AccessIntent is: ", (Object)accessIntent);
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isBatchUpdateSupportedWithAccessIntent(): returning true.  Accessintent is:", (Object)accessIntent);
        }
        return true;
    }

    public boolean doConnectionCleanup(Connection connection) throws SQLException {
        if (this.isXADataSource) {
            connection.setAutoCommit(false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"doConnectionCleanup", (Object)"Set autocommit to false");
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

