/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class SybaseDataStoreHelper
extends GenericDataStoreHelper
implements Serializable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$rsadapter$SybaseDataStoreHelper == null ? (class$com$ibm$websphere$rsadapter$SybaseDataStoreHelper = SybaseDataStoreHelper.class$("com.ibm.websphere.rsadapter.SybaseDataStoreHelper")) : class$com$ibm$websphere$rsadapter$SybaseDataStoreHelper), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final TraceComponent sybaseTc = Tr.register((String)"com.ibm.ws.sybase.logwriter", (String)"WAS.database", null);
    private HashMap userNewMap = null;
    private HashMap sybaseErrorMap = new HashMap(5);
    private static final int HASHSIZE = 5;
    static final long serialVersionUID = -6564766431174081694L;
    static /* synthetic */ Class class$com$ibm$websphere$rsadapter$SybaseDataStoreHelper;
    static /* synthetic */ Class class$com$ibm$websphere$ce$cm$StaleConnectionException;
    static /* synthetic */ Class class$com$ibm$websphere$ce$cm$DuplicateKeyException;

    public SybaseDataStoreHelper(Properties properties) {
        super(null);
        this.addInitialMaps();
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setHelperType(11);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"the metadata for the Sybase helper is", (Object)this.dshMd);
            Tr.debug((TraceComponent)tc, (String)"done constructing Sybase helper:", (Object)this);
        }
    }

    private void addInitialMaps() {
        this.sybaseErrorMap.put("JZ0C0", class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = SybaseDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.sybaseErrorMap.put("JZ0C1", class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = SybaseDataStoreHelper.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.sybaseErrorMap.put(new Integer(2601), class$com$ibm$websphere$ce$cm$DuplicateKeyException == null ? (class$com$ibm$websphere$ce$cm$DuplicateKeyException = SybaseDataStoreHelper.class$("com.ibm.websphere.ce.cm.DuplicateKeyException")) : class$com$ibm$websphere$ce$cm$DuplicateKeyException);
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setEscapeProcessing(true);
        preparedStatement.setFetchDirection(1000);
        if (preparedStatement.getMaxFieldSize() != 0) {
            preparedStatement.setMaxFieldSize(0);
        }
        if (preparedStatement.getMaxRows() != 0) {
            preparedStatement.setMaxRows(0);
        }
        preparedStatement.setQueryTimeout(0);
    }

    public final Class findMappingClass(SQLException sQLException) {
        Object var2_2 = null;
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findMappingClass for: " + sQLException));
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                var2_2 = this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (var2_2 != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
                string = sQLException.getSQLState();
                if (string != null && (var2_2 = this.userNewMap.get(string)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
            }
            if ((var2_2 = this.sybaseErrorMap.get(new Integer(sQLException.getErrorCode()))) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findMappingClass: return ", var2_2);
                }
                return var2_2;
            }
            string = sQLException.getSQLState();
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The sqlState is: ", (Object)string);
                }
                if (string.equals("JZ006")) {
                    SQLException sQLException2 = sQLException.getNextException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Sybase JZ006 found, recursively calling findMappingClass");
                    }
                    return this.findMappingClass(sQLException2);
                }
                var2_2 = this.sybaseErrorMap.get(string);
            }
            if (var2_2 == null) {
                return super.findMappingClass(sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findMappingClass: return ", var2_2);
        }
        return var2_2;
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        int n = 4;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIsolationLevel, intent: ", (Object)accessIntent);
        }
        if (accessIntent != null) {
            if (accessIntent.getConcurrencyControl() == 2) {
                n = 2;
            } else if (accessIntent.getAccessType() == 2) {
                n = 4;
            } else {
                int n2 = accessIntent.getPessimisticUpdateLockHint();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The hint_value is: ", (Object)new Integer(n2));
                }
                switch (n2) {
                    case 2: 
                    case 3: {
                        n = 4;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 8;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIsolationLevel, return:", (Object)AdapterUtil.getIsolationLevelString((int)n));
        }
        return n;
    }

    public final String showLockInfo(Properties properties) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo: ", (Object)properties);
        }
        if (properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"showLockInfo: must specify connection properties ", (Object)properties);
            }
            return null;
        }
        String string = properties.getProperty("databaseName");
        ConnectionPoolDataSource connectionPoolDataSource = null;
        String string2 = "com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource";
        Object object = null;
        try {
            object = DSConfigurationHelper.createDataSource((Object)string2);
            DSConfigurationHelper.setDataSourceProperties((Object)object, (Properties)properties);
            connectionPoolDataSource = (ConnectionPoolDataSource)object;
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.websphere.rsadapter.SybaseDataStoreHelper.showLockInfo", (String)"232", (Object)this);
            Exception exception = resourceException.getLinkedException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed during establishing a connection -- datasource creation exception is:", (Object)exception);
            }
            throw exception;
        }
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo: connection established ", (Object)connection);
        }
        String string3 = "select spid, id, type from master.dbo.syslocks, master.dbo.sysdatabases where master.dbo.sysdatabases.name = '" + string + "' and master.dbo.sysdatabases.dbid = master.dbo.syslocks.dbid";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string3);
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        while (resultSet.next()) {
            stringBuffer.append(EOLN + "\t===========" + ++n + "===========" + EOLN);
            stringBuffer.append("\tDatabase:\t" + string);
            int n2 = resultSet.getInt("spid");
            stringBuffer.append("\tProcess ID:\t" + n2);
            Statement statement2 = connection.createStatement();
            ResultSet resultSet2 = statement2.executeQuery("Select name from master.dbo.syslogins, master.dbo.sysprocesses where  master.dbo.syslogins.suid =  master.dbo.sysprocesses.suid and  master.dbo.sysprocesses.spid = " + n2);
            resultSet2.next();
            stringBuffer.append(EOLN + "\tLock Owner:\t" + resultSet2.getString("name"));
            Statement statement3 = connection.createStatement();
            ResultSet resultSet3 = statement3.executeQuery("Select name from sysobjects where id = " + resultSet.getInt("id"));
            resultSet3.next();
            stringBuffer.append(EOLN + "\tTable:\t\t" + resultSet3.getString("name"));
            resultSet2.close();
            try {
                resultSet3.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement3.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                resultSet2.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement2.close();
            }
            catch (SQLException sQLException) {}
        }
        stringBuffer.append("\t" + EOLN + "===> " + n + " Sybase locks found" + EOLN);
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public final void setUserDefinedMap(Map map) {
        this.userNewMap = new HashMap(map);
    }

    public PrintWriter getPrintWriter() {
        if (sybaseTc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Sybase logging is enabled");
            return new PrintWriter((Writer)new TraceWriter(sybaseTc));
        }
        return null;
    }

    public void doConnectionSetup(Connection connection) throws SQLException {
        SQLWarning sQLWarning = connection.getWarnings();
        if (sQLWarning != null) {
            SQLException sQLException = null;
            String string = sQLWarning.getSQLState();
            if (string.equals("010UF")) {
                SQLException sQLException2 = sQLException = new SQLException(sQLWarning.getMessage(), string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string + sQLWarning.getMessage()));
                }
                for (sQLWarning = sQLWarning.getNextWarning(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                    sQLException2 = new SQLException(sQLWarning.getMessage(), sQLWarning.getSQLState());
                    sQLException.setNextException(sQLException2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(sQLWarning.getSQLState() + sQLWarning.getMessage()));
                }
                throw sQLException;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

