/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util.locking;

public abstract class Lockable {
    private int locked = 0;
    private Thread owner = null;

    public synchronized void lock() throws InterruptedException {
        if (Thread.currentThread() != this.owner) {
            while (this.locked != 0) {
                this.wait();
            }
            this.owner = Thread.currentThread();
        }
        ++this.locked;
    }

    public synchronized boolean tryLock() {
        if (Thread.currentThread() != this.owner) {
            if (this.locked > 0) {
                return false;
            }
            this.owner = Thread.currentThread();
        }
        ++this.locked;
        return true;
    }

    public synchronized void unlock() {
        if (--this.locked == 0) {
            this.owner = null;
            this.notify();
        }
    }
}

