/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.deploy;

import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.runtime.deploy.DeployedObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class DeployedObjectCollaborator
extends RuntimeCollaborator
implements PropertyChangeListener {
    static final String SERVER = "WebSphere:type=Server,*";
    protected String archivePath;
    protected String ddFilename;
    protected ModuleItem pmiModule;
    private long ntfySeqNum = 0L;
    private DeployedObject deployedObj;

    public DeployedObjectCollaborator(DeployedObject deployedObject) {
        this.deployedObj = deployedObject;
        Resource resource = deployedObject.getDeploymentDescriptor().eResource();
        ModuleFile moduleFile = deployedObject.getModuleFile();
        try {
            this.archivePath = moduleFile.getResourcesPath();
            this.ddFilename = resource.getURI().toFileString();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        deployedObject.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    public void destroy() {
        this.deployedObj.removePropertyChangeListener("state", (PropertyChangeListener)this);
        this.deployedObj = null;
    }

    public abstract String getType();

    public String getName() {
        return this.getObjectName().getKeyProperty("name");
    }

    public String getJavaVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vm.vendor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeploymentDescriptor() throws IOException {
        StringBuffer stringBuffer;
        ZipFile zipFile;
        block8: {
            Reader reader = null;
            zipFile = null;
            try {
                long l;
                Object object;
                File file = new File(this.archivePath);
                if (file.isDirectory()) {
                    object = new File(file, this.ddFilename);
                    l = ((File)object).length();
                    reader = new FileReader((File)object);
                } else {
                    zipFile = new JarFile(file);
                    object = ((JarFile)zipFile).getEntry(this.ddFilename);
                    l = ((ZipEntry)object).getSize();
                    reader = new InputStreamReader(((JarFile)zipFile).getInputStream((ZipEntry)object));
                }
                stringBuffer = new StringBuffer((int)l);
                object = new char[2048];
                int n = 0;
                while (l > 0L) {
                    n = reader.read((char[])object);
                    stringBuffer.append((char[])object, 0, n);
                    l -= (long)n;
                }
                Object var10_8 = null;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (reader != null) {
                    reader.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
                throw throwable;
            }
            reader.close();
        }
        if (zipFile != null) {
            zipFile.close();
        }
        return stringBuffer.toString();
    }

    public Stats getStats() {
        if (this.pmiModule == null) {
            this.pmiModule = PmiRegistry.findModuleItem((ObjectName)this.getObjectName());
        }
        if (this.pmiModule != null) {
            return this.pmiModule.getStats(false);
        }
        return null;
    }

    public String getServer() {
        return this.getObjectName(SERVER);
    }

    protected Set lookupMBeans(String string, QueryExp queryExp) {
        try {
            ObjectName objectName = new ObjectName(string);
            return AdminServiceFactory.getMBeanFactory().getMBeanServer().queryNames(objectName, queryExp);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    protected String[] getObjectNames(String string) {
        return this.getObjectNames(string, null);
    }

    protected String[] getObjectNames(String string, QueryExp queryExp) {
        Set set = this.lookupMBeans(string, queryExp);
        String[] stringArray = new String[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next().toString();
        }
        return stringArray;
    }

    protected String getObjectName(String string) {
        Set set = this.lookupMBeans(string, null);
        if (set.size() == 0) {
            return null;
        }
        return set.iterator().next().toString();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        String string2 = null;
        if (string.equals("STARTING")) {
            string2 = "j2ee.state.starting";
        } else if (string.equals("STARTED")) {
            string2 = "j2ee.state.running";
        } else if (string.equals("STOPPING")) {
            string2 = "j2ee.state.stopping";
        } else if (string.equals("STOPPED")) {
            string2 = "j2ee.state.stopped";
        }
        if (string2 != null) {
            try {
                this.sendNotification(new Notification(string2, this.getObjectName(), this.ntfySeqNum++));
            }
            catch (MBeanException mBeanException) {
                // empty catch block
            }
        }
    }
}

