/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.analyzer;

import com.ibm.ejs.util.deployment.utilities.UtilsReflection;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class EJBMethodPartInfo
implements Cloneable {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Method meth;
    private Class returnType;
    private String methodNameString = null;
    private String returnTypeString = null;
    private String methodCallString = null;
    private String methodHeadString = null;
    private String methodInterfaceString = null;
    private String serverClassNameString = null;
    private String argumentString = new String();
    private String parameterString = new String();
    private String modifierString = null;
    private String signature = null;
    private boolean hasUserExceptions;
    private String exceptionString = new String();
    private int methIndex = 0;
    private Class[] parameters;
    private Class[] excepList;
    private Vector sortedExceps = null;
    static /* synthetic */ Class class$java$lang$Throwable;

    public EJBMethodPartInfo(Method method) {
        this.meth = method;
        this.initException(method);
        this.initParms(method);
    }

    public String getArgumentListString() {
        return this.parameterString;
    }

    public String getArgumentNewInstanceString(int n) {
        Class clazz = this.getParameterType(n);
        if (clazz.isPrimitive()) {
            return "";
        }
        return this.getArgumentString(n) + " = new " + this.getParameterType(n) + "();";
    }

    public String getArgumentString() {
        return this.argumentString;
    }

    public String getArgumentString(int n) {
        return "arg" + n;
    }

    public String getExceptionString() {
        return this.exceptionString;
    }

    public Class[] getExceptionTypes() {
        return this.excepList;
    }

    public String getMethodCall() {
        return this.methodCallString;
    }

    public String getMethodHead() {
        return this.methodHeadString;
    }

    public int getMethodIndex() {
        return this.methIndex;
    }

    public String getMethodInterface() {
        return this.methodInterfaceString;
    }

    public String getMethodName() {
        return this.methodNameString;
    }

    public Method getMethodObject() {
        return this.meth;
    }

    public String getModifier() {
        return this.modifierString;
    }

    public String getNullInitializerString(int n) {
        String string = this.getParameterString(n);
        Class clazz = this.getParameterType(n);
        String string2 = "";
        if (!clazz.isPrimitive()) {
            string2 = string2 + " = null";
        }
        return string + string2 + ";";
    }

    public Class[] getParameters() {
        return this.parameters;
    }

    public String getParameterString(int n) {
        return UtilsReflection.getClassDisplayName(this.parameters[n]) + " " + this.getArgumentString(n);
    }

    public Class getParameterType(int n) {
        return this.parameters[n];
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String getReturnTypeString() {
        return this.returnTypeString;
    }

    public String getServerClassName() {
        return this.serverClassNameString;
    }

    public String getSignature() {
        return this.signature;
    }

    public Vector getSortedExceptions() {
        return this.sortedExceps;
    }

    public Vector getSortedExceptions(Class[] classArray) {
        Vector<Class> vector = new Vector<Class>();
        block0: for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            if (clazz.equals(class$java$lang$Throwable == null ? EJBMethodPartInfo.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
                vector.addElement(clazz);
                continue;
            }
            for (Class clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                if (clazz2.equals(class$java$lang$Throwable == null ? EJBMethodPartInfo.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
                    vector.addElement(clazz);
                    continue block0;
                }
                boolean bl = false;
                for (int j = 0; j < vector.size(); ++j) {
                    if (!((Class)vector.elementAt(j)).getName().equals(clazz2.getName())) continue;
                    vector.insertElementAt(clazz, j);
                    bl = true;
                    break;
                }
                if (bl) continue block0;
            }
        }
        return vector;
    }

    public boolean hasUserExceptions() {
        return this.hasUserExceptions;
    }

    private void initException(Method method) {
        this.excepList = method.getExceptionTypes();
        this.sortedExceps = this.getSortedExceptions(this.excepList);
        int n = this.sortedExceps.size();
        for (int i = 0; i < n - 1; ++i) {
            String string = ((Class)this.sortedExceps.elementAt(i)).getName();
            this.exceptionString = this.exceptionString + string + ", ";
        }
        if (n > 0) {
            String string = ((Class)this.sortedExceps.elementAt(n - 1)).getName();
            this.exceptionString = this.exceptionString + string;
            this.hasUserExceptions = true;
        }
    }

    private void initParms(Method method) {
        int n = method.getModifiers();
        this.modifierString = Modifier.isSynchronized(n) ? "synchronized " : "";
        this.methodNameString = method.getName();
        this.returnType = method.getReturnType();
        this.returnTypeString = UtilsReflection.getClassDisplayName(this.returnType);
        this.parameters = method.getParameterTypes();
        int n2 = this.parameters.length;
        for (int i = 0; i < n2; ++i) {
            String string = this.getArgumentString(i);
            this.parameterString = this.parameterString + UtilsReflection.getClassDisplayName(this.parameters[i]) + " " + string;
            this.argumentString = this.argumentString + string;
            if (i >= n2 - 1) continue;
            this.parameterString = this.parameterString + ", ";
            this.argumentString = this.argumentString + ", ";
        }
        this.methodHeadString = this.returnTypeString + " " + this.methodNameString + "(" + this.parameterString + ")";
        if (this.hasUserExceptions()) {
            this.methodHeadString = this.methodHeadString + " throws " + this.exceptionString;
        }
        this.methodCallString = this.methodNameString + "(" + this.argumentString + ")";
    }

    public void setMethodCall(String string) {
        this.methodCallString = string;
    }

    public void setMethodHead(String string) {
        this.methodHeadString = string;
    }

    public void setMethodIndex(int n) {
        this.methIndex = n;
    }

    public void setMethodInterface(String string) {
        this.methodInterfaceString = string;
    }

    public void setMethodName(String string) {
        this.methodNameString = string;
    }

    public void setModifier(String string) {
        this.modifierString = string;
    }

    public void setReturnType(String string) {
        this.returnTypeString = string;
    }

    public void setServerClassName(String string) {
        this.serverClassNameString = string;
    }

    public void setSignature(String string) {
        this.signature = string;
    }

    public void setUserExceptions(boolean bl) {
        this.hasUserExceptions = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

