/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.analyzer;

import com.ibm.ejs.util.deployment.analyzer.EJBAnalyzerResourceHandler;
import com.ibm.ejs.util.deployment.analyzer.EJBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Locale;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;

public abstract class EJBVerify {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final int DB2_MAX_COLUMNNAME_LENGTH = 18;
    protected static final int DB2_MAX_TABLENAME_LENGTH = 18;
    protected EJBean ejb = null;
    protected Class ejbClass = null;
    protected DeploymentDescriptor ejbDD = null;
    protected Class homeInterfaceClass = null;
    protected Class remoteInterfaceClass = null;
    protected Method[] ejbMethods = null;
    protected Method[] homeInterfaceMethods = null;
    protected Method[] remoteInterfaceMethods = null;
    protected String ejbName = null;
    protected String homeInterfaceName = null;
    protected String remoteInterfaceName = null;
    protected static final Hashtable excludeExceptions = new Hashtable();
    protected static EJBAnalyzerResourceHandler resH;
    private static boolean traceOn;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$ejb$CreateException;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$javax$ejb$FinderException;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$io$Serializable;

    public EJBVerify(EJBean eJBean) {
        this.ejb = eJBean;
        this.ejbClass = eJBean.getEJBClass();
        this.ejbDD = eJBean.getDeploymentDescriptor();
        this.homeInterfaceClass = eJBean.getHomeInterfaceClass();
        this.remoteInterfaceClass = eJBean.getRemoteInterfaceClass();
        this.homeInterfaceMethods = eJBean.getHomeInterfaceMethods();
        this.remoteInterfaceMethods = eJBean.getRemoteInterfaceMethods();
        this.ejbMethods = eJBean.getEJBMethods();
        this.ejbName = this.ejbDD.getEnterpriseBeanClassName();
        this.homeInterfaceName = this.ejbDD.getHomeInterfaceClassName();
        this.remoteInterfaceName = this.ejbDD.getRemoteInterfaceClassName();
    }

    protected static final boolean compareClasses(Class clazz, Class clazz2) {
        if (!clazz.equals(clazz2)) {
            return false;
        }
        if (!clazz.isArray()) {
            return true;
        }
        return EJBVerify.compareClasses(clazz.getComponentType(), clazz2.getComponentType());
    }

    protected static final Class getClassType(Class clazz) {
        if (!clazz.isArray()) {
            return clazz;
        }
        return EJBVerify.getClassType(clazz.getComponentType());
    }

    protected static final void trace(String string) {
        if (traceOn) {
            System.err.println(string);
        }
    }

    protected static final void trace(String string, Exception exception) {
        if (traceOn) {
            System.err.println(string);
            System.err.println(">>>>> Exception Message: " + exception.getMessage());
            System.err.println(">>>>> Stack trace:");
            exception.printStackTrace();
        }
    }

    public static final void traceOn(boolean bl) {
        traceOn = bl;
    }

    public boolean verify() {
        return true;
    }

    protected boolean verifyControlDescriptors() {
        int n;
        boolean bl = true;
        boolean bl2 = false;
        ControlDescriptor[] controlDescriptorArray = this.ejbDD.getControlDescriptors();
        if (controlDescriptorArray == null) {
            return true;
        }
        for (n = 0; n < controlDescriptorArray.length; ++n) {
            if (controlDescriptorArray[n].getTransactionAttribute() != 1) continue;
            bl2 = true;
        }
        if (bl2) {
            for (n = 0; n < controlDescriptorArray.length; ++n) {
                Method method = controlDescriptorArray[n].getMethod();
                if (method == null || controlDescriptorArray[n].getTransactionAttribute() == 1) continue;
                bl = false;
                this.ejb.addMessage(resH.getMessage("EJB_NOT_TX_BEAN_MANAGED", method.toString(), this.ejbName));
            }
        }
        return bl;
    }

    protected boolean verifyEJBMethod(Method method) {
        if (method == null) {
            return true;
        }
        boolean bl = this.verifyLegalRMIMethodWithoutExceptions(method);
        if (!Modifier.isPublic(method.getModifiers())) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_METHOD_NOT_PUBLIC", method.toString(), this.ejbName));
        }
        return bl;
    }

    protected static final boolean verifyImplemented(Class clazz, Class clazz2) {
        if (!clazz2.isInterface()) {
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    protected static final boolean verifyImplementedBySuper(Class clazz, Class clazz2) {
        if (clazz == null || clazz.equals(class$java$lang$Object == null ? (class$java$lang$Object = EJBVerify.class$("java.lang.Object")) : class$java$lang$Object) || !clazz2.isInterface()) {
            return false;
        }
        if (EJBVerify.verifyImplemented(clazz, clazz2)) {
            return true;
        }
        return EJBVerify.verifyImplementedBySuper(clazz.getSuperclass(), clazz2);
    }

    protected boolean verifyInterfaceMethod(Method method, String string) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        String string2 = method.getName();
        Class<?> clazz = method.getReturnType();
        Class[] classArray = method.getExceptionTypes();
        if (method.getDeclaringClass().isAssignableFrom(this.homeInterfaceClass)) {
            if (string2.equals("create")) {
                bl2 = true;
                string2 = "ejbCreate";
                if (!clazz.equals(this.remoteInterfaceClass)) {
                    bl = false;
                    this.ejb.addMessage(resH.getMessage("EJB_CREATE_NOT_RETURN_RI", method.toString(), string, this.ejbName, this.remoteInterfaceName));
                }
                if (!EJBVerify.verifyTypeInList(classArray, class$javax$ejb$CreateException == null ? (class$javax$ejb$CreateException = EJBVerify.class$("javax.ejb.CreateException")) : class$javax$ejb$CreateException)) {
                    bl = false;
                    this.ejb.addMessage(resH.getMessage("EJB_METHOD_NO_EXCEPTION", method.toString(), method.getDeclaringClass().getName(), "javax.ejb.CreateException"));
                }
            }
            if (string2.startsWith("find") && this.ejb.isEntityBean()) {
                bl3 = true;
                if (!clazz.isAssignableFrom(this.remoteInterfaceClass) && !clazz.equals(class$java$util$Enumeration == null ? (class$java$util$Enumeration = EJBVerify.class$("java.util.Enumeration")) : class$java$util$Enumeration)) {
                    bl = false;
                    this.ejb.addMessage(resH.getMessage("EJB_FINDER_NOT_RETURN_RI", method.toString(), string, this.ejbName, this.remoteInterfaceName));
                }
                if (!EJBVerify.verifyTypeInList(classArray, class$javax$ejb$FinderException == null ? (class$javax$ejb$FinderException = EJBVerify.class$("javax.ejb.FinderException")) : class$javax$ejb$FinderException)) {
                    bl = false;
                    this.ejb.addMessage(resH.getMessage("EJB_METHOD_NO_EXCEPTION", method.toString(), method.getDeclaringClass().getName(), "javax.ejb.FinderException"));
                }
                if (this.ejb.hasBMPFields()) {
                    string2 = "ejbF" + string2.substring(1);
                } else {
                    bl4 = false;
                }
            }
        }
        if (bl4) {
            boolean bl5 = this.verifyMatchingEJBMethod(method, string2, string, !bl2 && !bl3);
            bl = bl && bl5;
        }
        return bl;
    }

    protected boolean verifyLegalRMIMethod(Method method) {
        boolean bl = this.verifyLegalRMIMethodWithoutExceptions(method);
        if (!EJBVerify.verifyTypeInList(method.getExceptionTypes(), class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = EJBVerify.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_METHOD_NO_EXCEPTION", method.toString(), method.getDeclaringClass().getName(), "java.rmi.RemoteException"));
        }
        return bl;
    }

    protected boolean verifyLegalRMIMethodWithoutExceptions(Method method) {
        boolean bl = true;
        String string = method.getDeclaringClass().getName();
        Class<?> clazz = method.getReturnType();
        Class clazz2 = EJBVerify.getClassType(clazz);
        if (!EJBVerify.verifySerializableType(clazz2)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_METHOD_RETTYPE_NOTRMI", method.toString(), string, clazz.getName()));
        }
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (EJBVerify.verifySerializableType(EJBVerify.getClassType(classArray[i]))) continue;
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_METHOD_ARGTYPE_NOTRMI", method.toString(), string, classArray[i].getName()));
        }
        return bl;
    }

    protected boolean verifyMatchingEJBMethod(Method method, String string, String string2, boolean bl) {
        boolean bl2 = true;
        boolean bl3 = false;
        Method method2 = null;
        Method method3 = null;
        try {
            int n;
            Class<?>[] classArray;
            Class<?>[] classArray2;
            method2 = this.ejbClass.getMethod(string, method.getParameterTypes());
            if (string.equals("ejbCreate") && method.getDeclaringClass().equals(this.homeInterfaceClass) && this.ejb.isEntityBean()) {
                try {
                    method3 = this.ejbClass.getMethod("ejbPostCreate", method.getParameterTypes());
                    bl3 = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl4 = this.verifyEJBMethod(method2);
            boolean bl5 = this.verifyEJBMethod(method3);
            boolean bl6 = bl2 = bl2 && bl4 && bl5;
            if (bl) {
                classArray2 = method.getReturnType();
                classArray = method2.getReturnType();
                if (bl && !EJBVerify.compareClasses(classArray2, classArray)) {
                    bl2 = false;
                    this.ejb.addMessage(resH.getMessage("EJB_METHOD_TYPE_MISMATCH", method.toString(), string2, classArray.getName(), this.ejbName));
                }
            }
            classArray2 = method.getExceptionTypes();
            classArray = method2.getExceptionTypes();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            for (n = 0; n < classArray2.length; ++n) {
                hashtable.put(classArray2[n].getName(), "");
            }
            for (n = 0; n < classArray.length; ++n) {
                hashtable2.put(classArray[n].getName(), "");
                if (hashtable.containsKey(classArray[n].getName())) continue;
                bl2 = false;
                this.ejb.addMessage(resH.getMessage("EJB_METHOD_EXCEP_MISMATCH", classArray[n].getName(), method2.toString(), this.ejbName, method.getName(), string2));
            }
            if (bl3) {
                Class<?>[] classArray3 = method3.getExceptionTypes();
                for (int i = 0; i < classArray3.length; ++i) {
                    hashtable2.put(classArray3[i].getName(), "");
                    if (hashtable.containsKey(classArray3[i].getName())) continue;
                    bl2 = false;
                    this.ejb.addMessage(resH.getMessage("EJB_METHOD_EXCEP_MISMATCH", classArray3[i].getName(), method3.toString(), this.ejbName, method.getName(), string2));
                }
            }
            for (int i = 0; i < classArray2.length; ++i) {
                if (excludeExceptions.containsKey(classArray2[i].getName()) || hashtable2.containsKey(classArray2[i].getName())) continue;
                bl2 = false;
                String string3 = "EJB_METHOD_EXCEP_MISMATCH2";
                if (bl3) {
                    string3 = "EJB_METHOD_EXCEP_MISMATCH3";
                }
                this.ejb.addMessage(resH.getMessage(string3, classArray2[i].getName(), method.toString(), string2, method2.getName(), this.ejbName));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl2 = false;
            this.ejb.addMessage(resH.getMessage("EJB_NO_METHOD", method.toString(), string2, string, this.ejbName));
        }
        return bl2;
    }

    protected static final boolean verifySerializableType(Class clazz) {
        Class clazz2 = EJBVerify.getClassType(clazz);
        if (clazz2.isPrimitive() || clazz2.equals(class$java$lang$Object == null ? (class$java$lang$Object = EJBVerify.class$("java.lang.Object")) : class$java$lang$Object) || clazz2.equals(class$java$util$Enumeration == null ? (class$java$util$Enumeration = EJBVerify.class$("java.util.Enumeration")) : class$java$util$Enumeration) || clazz2.isInterface()) {
            return true;
        }
        return EJBVerify.verifyImplementedBySuper(clazz2, class$java$io$Serializable == null ? (class$java$io$Serializable = EJBVerify.class$("java.io.Serializable")) : class$java$io$Serializable);
    }

    public static final boolean verifyTypeInList(Class[] classArray, Class clazz) {
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].equals(clazz)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        excludeExceptions.put("java.rmi.RemoteException", "");
        excludeExceptions.put("javax.ejb.CreateException", "");
        excludeExceptions.put("javax.ejb.FinderException", "");
        resH = new EJBAnalyzerResourceHandler(Locale.getDefault());
        traceOn = false;
    }
}

