/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.analyzer;

import com.ibm.ejs.util.deployment.analyzer.EJBVerifySession;
import com.ibm.ejs.util.deployment.analyzer.EJBean;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenerator;
import com.ibm.ejs.util.deployment.utilities.UtilsReflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.ejb.deployment.EntityDescriptor;

public class EJBVerifyEntity
extends EJBVerifySession {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    Class keyClass = null;
    String keyClassName = null;
    static /* synthetic */ Class class$javax$ejb$EntityBean;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$ejb$EJBHome;

    public EJBVerifyEntity(EJBean eJBean) {
        super(eJBean);
        this.keyClass = eJBean.getKeyClass();
        this.keyClassName = this.keyClass.getName();
    }

    public boolean verify() {
        boolean bl = this.verifyEJBClass(class$javax$ejb$EntityBean == null ? (class$javax$ejb$EntityBean = EJBVerifyEntity.class$("javax.ejb.EntityBean")) : class$javax$ejb$EntityBean);
        boolean bl2 = this.verifyCMPFields();
        boolean bl3 = this.verifyEJBMethods();
        boolean bl4 = this.verifyHomeInterfaceClass();
        boolean bl5 = this.verifyHomeInterfaceMethods();
        boolean bl6 = this.verifyRemoteInterfaceClass();
        boolean bl7 = this.verifyRemoteInterfaceMethods();
        boolean bl8 = this.verifyControlDescriptors();
        return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8;
    }

    protected boolean verifyCMPFields() {
        int n;
        boolean bl = true;
        if (!this.ejb.hasCMPFields()) {
            return bl;
        }
        Field[] fieldArray = ((EntityDescriptor)this.ejbDD).getContainerManagedFields();
        Hashtable<String, Field> hashtable = new Hashtable<String, Field>();
        boolean bl2 = this.ejb.getUseMaps();
        for (n = 0; n < fieldArray.length; ++n) {
            if (fieldArray[n] == null) {
                bl = false;
                this.ejb.addMessage(resH.getMessage("EJB_INVALID_CMP_FIELD", n + 1 + "", this.ejbName));
                continue;
            }
            int n2 = fieldArray[n].getModifiers();
            String string = fieldArray[n].getName();
            String string2 = fieldArray[n].getType().getName();
            hashtable.put(string, fieldArray[n]);
            if (string.length() > 18 && !bl2) {
                this.ejb.addMessage(resH.getMessage("EJB_CMP_FIELD_NAME_LONG", string, this.ejbName, Integer.toString(18)));
            }
            if (!Modifier.isPublic(fieldArray[n].getModifiers())) {
                bl = false;
                this.ejb.addMessage(resH.getMessage("EJB_CMP_FIELD_NOT_PUBLIC", string, this.ejbName));
            }
            if (!EJBVerifyEntity.verifySerializableType(fieldArray[n].getType())) {
                bl = false;
                this.ejb.addMessage(resH.getMessage("EJB_CMP_FIELD_NOT_SER", string, string2, this.ejbName));
            }
            if (!Modifier.isStatic(n2)) continue;
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_CMP_FIELD_STATIC", string, this.ejbName));
        }
        if (fieldArray.length == 0) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_NO_CMP_FIELDS", this.ejbName));
        }
        n = this.verifyKeyClass(hashtable) ? 1 : 0;
        bl = bl && n != 0;
        return bl;
    }

    protected boolean verifyCreateMethod(Method method) {
        boolean bl = true;
        Class<?> clazz = method.getReturnType();
        if (this.ejb.hasBMPFields()) {
            if (!clazz.equals(this.keyClass) && !clazz.equals(class$java$util$Enumeration == null ? (class$java$util$Enumeration = EJBVerifyEntity.class$("java.util.Enumeration")) : class$java$util$Enumeration)) {
                bl = false;
                this.ejb.addMessage(resH.getMessage("EJB_CREATE_METH_NOT_PK", method.toString(), this.ejbName, this.keyClassName));
            }
        } else {
            bl = super.verifyCreateMethod(method);
        }
        return bl;
    }

    protected boolean verifyEJBClass(Class clazz) {
        boolean bl = super.verifyEJBClass(clazz);
        if (this.ejb.hasCMPFields()) {
            String string = EJBGenerator.getTableName(this.ejbName);
            if (string.indexOf(46) != -1) {
                string = string.substring(string.indexOf(46) + 1);
            }
            if (string.length() > 18 && !this.ejb.getUseMaps()) {
                this.ejb.addMessage(resH.getMessage("EJB_TABLE_NAME_NAME_LONG", this.ejbName, string, Integer.toString(18)));
            }
        }
        return bl;
    }

    protected boolean verifyEJBMethods() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        for (int i = 0; i < this.ejbMethods.length; ++i) {
            int n = this.ejbMethods[i].getModifiers();
            String string = this.ejbMethods[i].getName();
            if (string.equals("ejbCreate")) {
                bl2 = this.verifyCreateMethod(this.ejbMethods[i]);
                boolean bl4 = bl = bl && bl2;
            }
            if (!string.startsWith("ejbFind")) continue;
            if (string.equals("ejbFindByPrimaryKey")) {
                bl3 = true;
            }
            if (this.ejb.hasBMPFields()) {
                bl2 = this.verifyFinderMethod(this.ejbMethods[i]);
                bl = bl && bl2;
                continue;
            }
            this.ejb.addMessage(resH.getMessage("EJB_CMP_IMPL_FINDER_METHOD", this.ejbName, this.ejbMethods[i].toString()));
        }
        if (!bl3 && this.ejb.hasBMPFields()) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_HAS_NO_PK_METHOD", this.ejbName));
        }
        return bl;
    }

    private boolean verifyFindByPrimaryKeyMethod(Method method) {
        boolean bl = true;
        Class<?>[] classArray = method.getParameterTypes();
        Field[] fieldArray = UtilsReflection.stripField(this.keyClass.getFields());
        if (classArray.length == 0) {
            bl = false;
        } else if (!classArray[0].equals(this.keyClass) && !classArray[0].equals(class$java$lang$Object == null ? (class$java$lang$Object = EJBVerifyEntity.class$("java.lang.Object")) : class$java$lang$Object) || classArray.length != 1) {
            if (classArray.length == fieldArray.length) {
                for (int i = 0; i < classArray.length; ++i) {
                    if (classArray[i].equals(fieldArray[i].getType())) continue;
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (!bl) {
            this.ejb.addMessage(resH.getMessage("EJB_INVALID_FBPK_ARGS", method.toString(), this.homeInterfaceName, this.ejbName, this.keyClassName));
        }
        return bl;
    }

    protected boolean verifyFinderMethod(Method method) {
        boolean bl = true;
        Class<?> clazz = method.getReturnType();
        if (!clazz.equals(this.keyClass) && !clazz.equals(class$java$util$Enumeration == null ? (class$java$util$Enumeration = EJBVerifyEntity.class$("java.util.Enumeration")) : class$java$util$Enumeration)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_FINDER_METH_NOT_PK", method.toString(), this.ejbName, this.keyClassName));
        }
        return bl;
    }

    protected boolean verifyHomeInterfaceMethods() {
        boolean bl;
        String string;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        for (int i = 0; i < this.homeInterfaceMethods.length; ++i) {
            string = this.homeInterfaceMethods[i].getName();
            if (this.homeInterfaceMethods[i].getDeclaringClass().equals(class$javax$ejb$EJBHome == null ? EJBVerifyEntity.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome)) continue;
            if (string.equals("findByPrimaryKey")) {
                if (bl3) {
                    bl4 = true;
                }
                bl3 = true;
                bl = this.verifyFindByPrimaryKeyMethod(this.homeInterfaceMethods[i]);
                boolean bl5 = bl2 = bl2 && bl;
            }
            if (string.equals("create") || string.startsWith("find")) {
                bl = this.verifyLegalRMIMethod(this.homeInterfaceMethods[i]);
                boolean bl6 = this.verifyInterfaceMethod(this.homeInterfaceMethods[i], "home interface " + this.homeInterfaceName);
                bl2 = bl2 && bl && bl6;
            } else {
                this.ejb.addMessage(resH.getMessage("EJB_ENTITY_HOME_OTHER_METH", this.homeInterfaceMethods[i].toString(), this.ejbName, this.homeInterfaceName));
            }
            if (!this.ejb.hasCMPFields() || !string.startsWith("find") || string.equals("findByPrimaryKey") || string.equals("findAll")) continue;
            if (hashtable.containsKey(string)) {
                hashtable.put(string, new Boolean(false));
                continue;
            }
            hashtable.put(string, new Boolean(true));
        }
        if (!bl3) {
            bl2 = false;
            this.ejb.addMessage(resH.getMessage("EJB_HI_HAS_NO_PK_METHOD", this.homeInterfaceName, this.ejbName));
        }
        if (bl4) {
            this.ejb.addMessage(resH.getMessage("EJB_HAS_MULTIPLE_PK_METHODS", this.homeInterfaceName, this.ejbName));
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            bl = (Boolean)hashtable.get(string);
            if (bl) continue;
            bl2 = false;
            this.ejb.addMessage(resH.getMessage("EJB_FINDER_MULTISIG", string, this.homeInterfaceName, this.ejbName));
        }
        return bl2;
    }

    private boolean verifyKeyClass(Hashtable hashtable) {
        boolean bl = true;
        Field[] fieldArray = UtilsReflection.stripField(this.keyClass.getFields());
        Constructor<?>[] constructorArray = this.keyClass.getConstructors();
        if (!Modifier.isPublic(this.keyClass.getModifiers())) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_KEY_NOT_PUBLIC", this.keyClassName, this.ejbName));
        }
        if (constructorArray.length == 0) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_KEY_CONSTR_NOT_PUBLIC", this.keyClassName, this.ejbName));
        }
        if (fieldArray.length == 0) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_KEYCLASS_NO_FIELDS", this.keyClassName, this.ejbName));
        } else {
            for (int i = 0; i < fieldArray.length; ++i) {
                if (hashtable.containsKey(fieldArray[i].getName())) continue;
                bl = false;
                this.ejb.addMessage(resH.getMessage("EJB_KEYFIELD_NOT_CMP_FIELD", fieldArray[i].getName(), this.keyClassName, this.ejbName));
            }
        }
        String string = "hashCode";
        try {
            Method method = this.keyClass.getDeclaredMethod(string, new Class[0]);
            string = "equals";
            Class[] classArray = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = EJBVerifyEntity.class$("java.lang.Object")) : class$java$lang$Object};
            method = this.keyClass.getDeclaredMethod(string, classArray);
        }
        catch (Exception exception) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_KEY_NO_OVERRIDE_METHOD", this.keyClassName, this.ejbName, string));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

