/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.analyzer;

import com.ibm.ejs.util.deployment.analyzer.EJBVerify;
import com.ibm.ejs.util.deployment.analyzer.EJBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class EJBVerifySession
extends EJBVerify {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    static /* synthetic */ Class class$javax$ejb$SessionBean;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    public EJBVerifySession(EJBean eJBean) {
        super(eJBean);
    }

    public boolean verify() {
        boolean bl = this.verifyEJBClass(class$javax$ejb$SessionBean == null ? (class$javax$ejb$SessionBean = EJBVerifySession.class$("javax.ejb.SessionBean")) : class$javax$ejb$SessionBean);
        boolean bl2 = this.verifyEJBMethods();
        boolean bl3 = this.verifyHomeInterfaceClass();
        boolean bl4 = this.verifyHomeInterfaceMethods();
        boolean bl5 = this.verifyRemoteInterfaceClass();
        boolean bl6 = this.verifyRemoteInterfaceMethods();
        boolean bl7 = this.verifyControlDescriptors();
        return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7;
    }

    protected boolean verifyCreateMethod(Method method) {
        Class<?> clazz = method.getReturnType();
        if (!clazz.getName().equals("void")) {
            this.ejb.addMessage(resH.getMessage("EJB_CREATE_METH_NOT_VOID", method.toString(), this.ejbName));
        }
        return true;
    }

    protected boolean verifyEJBClass(Class clazz) {
        boolean bl = true;
        int n = this.ejbClass.getModifiers();
        Field[] fieldArray = this.ejbClass.getFields();
        if (!EJBVerifySession.verifyImplemented(this.ejbClass, clazz)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_INTF_NOT_IMPLEMENTED", this.ejbName, clazz.getName()));
        }
        if (!Modifier.isPublic(n)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_NOT_PUBLIC", this.ejbName));
        }
        if (Modifier.isAbstract(n)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_IS_ABSTRACT", this.ejbName));
        }
        for (int i = 0; i < fieldArray.length; ++i) {
            n = fieldArray[i].getModifiers();
            if (!Modifier.isStatic(n) || Modifier.isFinal(n)) continue;
            this.ejb.addMessage(resH.getMessage("EJB_FIELD_STATIC_NOT_FINAL", fieldArray[i].getName(), this.ejbName));
        }
        return bl;
    }

    protected boolean verifyEJBMethods() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        for (int i = 0; i < this.ejbMethods.length; ++i) {
            int n = this.ejbMethods[i].getModifiers();
            String string = this.ejbMethods[i].getName();
            if (!string.equals("ejbCreate")) continue;
            bl3 = true;
            bl2 = this.verifyCreateMethod(this.ejbMethods[i]);
            bl = bl && bl2;
        }
        if (!bl3) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_HAS_NO_CREATE_METHODS", this.ejbName));
        }
        return bl;
    }

    protected boolean verifyHomeInterfaceClass() {
        boolean bl = true;
        int n = this.homeInterfaceClass.getModifiers();
        if (!Modifier.isInterface(n)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_INVALID_INTF_CLASS", this.homeInterfaceName, this.ejbName));
        }
        if (!EJBVerifySession.verifyImplemented(this.homeInterfaceClass, class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = EJBVerifySession.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_INTF_NOT_EXTENDED", this.ejbName, this.homeInterfaceName, "javax.ejb.EJBHome"));
        }
        return bl;
    }

    protected boolean verifyHomeInterfaceMethods() {
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < this.homeInterfaceMethods.length; ++i) {
            if (this.homeInterfaceMethods[i].getDeclaringClass().equals(class$javax$ejb$EJBHome == null ? EJBVerifySession.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome)) continue;
            String string = this.homeInterfaceMethods[i].getName();
            if (string.equals("create")) {
                bl2 = true;
                boolean bl3 = this.verifyLegalRMIMethod(this.homeInterfaceMethods[i]);
                boolean bl4 = this.verifyInterfaceMethod(this.homeInterfaceMethods[i], "home interface " + this.homeInterfaceName);
                bl = bl && bl3 && bl4;
                continue;
            }
            this.ejb.addMessage(resH.getMessage("EJB_SESS_HOME_OTHER_METH", this.homeInterfaceMethods[i].toString(), this.ejbName, this.homeInterfaceName));
        }
        if (!bl2) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_HI_HAS_NO_CREATE_METHODS", this.homeInterfaceName, this.ejbName));
        }
        return bl;
    }

    protected boolean verifyRemoteInterfaceClass() {
        boolean bl = true;
        int n = this.homeInterfaceClass.getModifiers();
        if (!Modifier.isInterface(n)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_INVALID_INTF_CLASS", this.remoteInterfaceName, this.ejbName));
        }
        if (!EJBVerifySession.verifyImplemented(this.remoteInterfaceClass, class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = EJBVerifySession.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject)) {
            bl = false;
            this.ejb.addMessage(resH.getMessage("EJB_INTF_NOT_EXTENDED", this.ejbName, this.remoteInterfaceName, "javax.ejb.EJBObject"));
        }
        return bl;
    }

    protected boolean verifyRemoteInterfaceMethods() {
        boolean bl = true;
        for (int i = 0; i < this.remoteInterfaceMethods.length; ++i) {
            if (this.remoteInterfaceMethods[i].getDeclaringClass().equals(class$javax$ejb$EJBObject == null ? EJBVerifySession.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject)) continue;
            String string = this.remoteInterfaceMethods[i].getName();
            boolean bl2 = this.verifyLegalRMIMethod(this.remoteInterfaceMethods[i]);
            boolean bl3 = this.verifyInterfaceMethod(this.remoteInterfaceMethods[i], "remote interface " + this.remoteInterfaceName);
            bl = bl && bl2 && bl3;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

