/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.analyzer;

import com.ibm.ejs.deployment.DeploymentUtil;
import com.ibm.ejs.util.deployment.analyzer.EJBAnalyzerResourceHandler;
import com.ibm.ejs.util.deployment.analyzer.EJBMethodPartInfo;
import com.ibm.ejs.util.deployment.analyzer.EJBVerifyEntity;
import com.ibm.ejs.util.deployment.analyzer.EJBVerifySession;
import com.ibm.ejs.util.deployment.deployment.EJBJar;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Vector;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.EntityDescriptor;
import javax.ejb.deployment.SessionDescriptor;

public class EJBean {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private DeploymentDescriptor ddObject = null;
    private Class ejbClass = null;
    private Class homeInterfaceClass = null;
    private Class remoteInterfaceClass = null;
    private Class keyClass = null;
    private Method[] ejbMethods = null;
    private Method[] homeInterfaceMethods = null;
    private Method[] remoteInterfaceMethods = null;
    private Vector messages = new Vector();
    private boolean hasErrors = false;
    private static EJBAnalyzerResourceHandler resH = new EJBAnalyzerResourceHandler(Locale.getDefault());
    private static boolean traceOn = false;
    private boolean useMaps = false;

    public EJBean(DeploymentDescriptor deploymentDescriptor) {
        this.ddObject = deploymentDescriptor;
        this.getEJBClass();
        this.getHomeInterfaceClass();
        this.getRemoteInterfaceClass();
        this.getKeyClass();
        this.ejbMethods = this.getEJBMethods();
        this.homeInterfaceMethods = this.getHomeInterfaceMethods();
        this.remoteInterfaceMethods = this.getRemoteInterfaceMethods();
    }

    public void addMessage(String string) {
        this.messages.addElement(string);
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.ddObject;
    }

    public Class getEJBClass() {
        if (this.ejbClass != null) {
            return this.ejbClass;
        }
        String string = this.ddObject.getEnterpriseBeanClassName();
        try {
            this.ejbClass = EJBJar.bcl != null ? EJBJar.bcl.loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.hasErrors = true;
            EJBean.trace("EJBean: ClassNotFoundException occurred while introspecting EJB " + string, classNotFoundException);
            this.addMessage(resH.getMessage("EJB_CLASS_NOT_FOUND", string));
        }
        return this.ejbClass;
    }

    public Method[] getEJBMethods() {
        if (this.ejbMethods != null) {
            return this.ejbMethods;
        }
        this.ejbMethods = DeploymentUtil.getMethods(this.ejbClass);
        return this.ejbMethods;
    }

    public Class getHomeInterfaceClass() {
        if (this.homeInterfaceClass != null) {
            return this.homeInterfaceClass;
        }
        String string = this.ddObject.getHomeInterfaceClassName();
        try {
            this.homeInterfaceClass = EJBJar.bcl != null ? EJBJar.bcl.loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.hasErrors = true;
            EJBean.trace("EJBean: ClassNotFoundException occurred while introspecting home interface " + string, classNotFoundException);
            this.addMessage(resH.getMessage("EJB_INTF_CLASS_NOT_FOUND", string));
        }
        return this.homeInterfaceClass;
    }

    public Method[] getHomeInterfaceMethods() {
        if (this.homeInterfaceMethods != null) {
            return this.homeInterfaceMethods;
        }
        this.homeInterfaceMethods = DeploymentUtil.getMethods(this.homeInterfaceClass);
        return this.homeInterfaceMethods;
    }

    public Vector getHomeMethodInfoV() {
        Vector<EJBMethodPartInfo> vector = new Vector<EJBMethodPartInfo>();
        for (int i = 0; i < this.homeInterfaceMethods.length; ++i) {
            Method method = this.homeInterfaceMethods[i];
            EJBMethodPartInfo eJBMethodPartInfo = new EJBMethodPartInfo(method);
            eJBMethodPartInfo.setMethodIndex(i);
            vector.addElement(eJBMethodPartInfo);
        }
        return vector;
    }

    public Class getKeyClass() {
        if (this.isEntityBean() && this.keyClass == null) {
            String string = ((EntityDescriptor)this.ddObject).getPrimaryKeyClassName();
            try {
                if (EJBJar.bcl != null) {
                    return EJBJar.bcl.loadClass(string);
                }
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.hasErrors = true;
                EJBean.trace("EJBean: ClassNotFoundException occurred while introspecting Key class " + string, classNotFoundException);
                this.addMessage(resH.getMessage("EJB_KEY_CLASS_NOT_FOUND", string));
            }
        }
        return this.keyClass;
    }

    public String[] getMessages() {
        Object[] objectArray = new String[this.messages.size()];
        this.messages.copyInto(objectArray);
        return objectArray;
    }

    public Class getRemoteInterfaceClass() {
        if (this.remoteInterfaceClass != null) {
            return this.remoteInterfaceClass;
        }
        String string = this.ddObject.getRemoteInterfaceClassName();
        try {
            this.remoteInterfaceClass = EJBJar.bcl != null ? EJBJar.bcl.loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.hasErrors = true;
            EJBean.trace("EJBean: ClassNotFoundException occurred while introspecting home interface " + string, classNotFoundException);
            this.addMessage(resH.getMessage("EJB_INTF_CLASS_NOT_FOUND", string));
        }
        return this.remoteInterfaceClass;
    }

    public Method[] getRemoteInterfaceMethods() {
        if (this.remoteInterfaceMethods != null) {
            return this.remoteInterfaceMethods;
        }
        this.remoteInterfaceMethods = DeploymentUtil.getMethods(this.remoteInterfaceClass);
        return this.remoteInterfaceMethods;
    }

    public Vector getRemoteMethodInfoV() {
        Vector<EJBMethodPartInfo> vector = new Vector<EJBMethodPartInfo>();
        for (int i = 0; i < this.remoteInterfaceMethods.length; ++i) {
            Method method = this.remoteInterfaceMethods[i];
            EJBMethodPartInfo eJBMethodPartInfo = new EJBMethodPartInfo(method);
            eJBMethodPartInfo.setMethodIndex(i);
            vector.addElement(eJBMethodPartInfo);
        }
        return vector;
    }

    public boolean getUseMaps() {
        return this.useMaps;
    }

    public boolean hasBMPFields() {
        boolean bl = false;
        if (this.isEntityBean() && ((EntityDescriptor)this.ddObject).getContainerManagedFields() == null) {
            bl = true;
        }
        return bl;
    }

    public boolean hasCMPFields() {
        boolean bl = false;
        if (this.isEntityBean() && ((EntityDescriptor)this.ddObject).getContainerManagedFields() != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isEntityBean() {
        return this.ddObject instanceof EntityDescriptor;
    }

    public boolean isSessionBean() {
        return this.ddObject instanceof SessionDescriptor;
    }

    public void setUseMaps(boolean bl) {
        this.useMaps = bl;
    }

    public static final void trace(String string) {
        if (traceOn) {
            System.err.println(string);
        }
    }

    public static final void trace(String string, Exception exception) {
        if (traceOn) {
            System.err.println(string);
            System.err.println(">>>>> Exception Message: " + exception.getMessage());
            System.err.println(">>>>> Stack trace:");
            exception.printStackTrace();
        }
    }

    public static final void traceOn(boolean bl) {
        traceOn = bl;
    }

    public boolean verify() {
        if (this.hasErrors) {
            return false;
        }
        if (this.isSessionBean()) {
            EJBVerifySession eJBVerifySession = new EJBVerifySession(this);
            this.hasErrors = !eJBVerifySession.verify();
        } else if (this.isEntityBean()) {
            EJBVerifyEntity eJBVerifyEntity = new EJBVerifyEntity(this);
            this.hasErrors = !eJBVerifyEntity.verify();
        }
        return !this.hasErrors;
    }
}

