/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.codeGenerator;

import com.ibm.ejs.util.deployment.analyzer.EJBMethodPartInfo;
import com.ibm.ejs.util.deployment.analyzer.EJBean;
import com.ibm.ejs.util.deployment.codeGenerator.EJBCodegenException;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenerator;
import com.ibm.ejs.util.deployment.utilities.UtilsReflection;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.deployment.EntityDescriptor;

public class EJBGenPersister
extends EJBGenerator {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Field[] fields;
    private Field[] primaryKeyFields;
    private Hashtable primaryKeyMap = new Hashtable();
    private boolean allCMPFieldsAreKeyFields = true;
    public static final Hashtable typeMap = new Hashtable();

    public EJBGenPersister(EJBean eJBean, String string) {
        super(eJBean, string);
        Class clazz = null;
        this.fields = ((EntityDescriptor)this.myDD).getContainerManagedFields();
        this.interfaceMethodsInfo = eJBean.getHomeMethodInfoV();
        clazz = eJBean.getKeyClass();
        if (clazz != null) {
            int n;
            this.primaryKeyFields = UtilsReflection.stripField(clazz.getFields());
            for (n = 0; n < this.primaryKeyFields.length; ++n) {
                int n2 = 0;
                this.primaryKeyMap.put(this.primaryKeyFields[n].getName(), new Boolean(true));
                while (!this.primaryKeyFields[n].getName().equals(this.fields[n2].getName())) {
                    if (++n2 != this.fields.length) continue;
                    EJBGenPersister.trace("EJBGenPersister: Primary key field not container managed fields");
                }
                n2 = 0;
            }
            for (n = 0; n < this.fields.length; ++n) {
                if (this.primaryKeyMap.containsKey(this.fields[n].getName())) continue;
                this.allCMPFieldsAreKeyFields = false;
            }
        }
    }

    protected String classHeaderCodeSnip() {
        int n;
        String string = "{0}\n{1}\n\nimport com.ibm.ejs.persistence.*;\nimport javax.ejb.EntityBean;\nimport java.sql.*;\nimport java.text.*;\nimport com.ibm.vap.converters.streams.*;\nimport java.text.*;\n\npublic class {2} extends EJSJDBCPersister implements {3} @\n\n{4} \n";
        String string2 = "    final static String _createString = \"INSERT INTO {5}({6}) VALUES({7})\";\n    final static String _loadString = \"SELECT * FROM {5} WHERE {8}\";\n    final static String _loadForUpdateString = _loadString + \" FOR UPDATE\";\n    final static String _removeString = \"DELETE FROM {5} WHERE {8}\";\n    final static String _storeString = \"UPDATE {5} SET {9} WHERE {8}\";\n\n    byte serObj[] = null;\n    String createString;\n    String loadString;\n    String loadForUpdateString;\n    String removeString;\n    String storeString;\n" + this.getFinderStrs("    ") + "\n";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        int n2 = 0;
        for (n = 0; n < this.primaryKeyFields.length; ++n) {
            string3 = string3 + this.primaryKeyFields[n].getName() + " = ?";
            if (n + 1 >= this.primaryKeyFields.length) continue;
            string3 = string3 + " AND ";
        }
        for (n = 0; n < this.fields.length; ++n) {
            String string8 = this.fields[n].getName();
            string4 = string4 + "    final static int " + string8 + "Index = " + (n + 1) + ";\n";
            string5 = string5 + string8;
            string6 = string6 + " ?";
            if (!this.isPrimaryKeyField(string8)) {
                string7 = string7 + string8 + " = ?";
                if (++n2 < this.fields.length - this.primaryKeyFields.length) {
                    string7 = string7 + ", ";
                }
            }
            if (n + 1 >= this.fields.length) continue;
            string5 = string5 + ", ";
            string6 = string6 + ", ";
        }
        Object[] objectArray = new Object[]{this.getClassComment(), this.getPackageStatement(), this.getEJSClassName(), this.getFinderIntfClassName(), string4, EJBGenPersister.getTableName(this.ejbName), string5, string6, string3, string7};
        return this.getCodeSnip(objectArray, string) + this.getCodeSnip(objectArray, string2);
    }

    protected String constructorCodeSnip() {
        String string = "{0}\n    public {1}() @\n        super();\n    }\n\n";
        Object[] objectArray = new Object[]{this.getMethodComment(), this.getEJSClassName()};
        return this.getCodeSnip(objectArray, string);
    }

    protected String generateBody() throws EJBCodegenException {
        this.writer.println(this.getPostInitCodeSnip());
        this.writer.println(this.getCreateMethodCodeSnip());
        this.checkError(3);
        this.writer.println(this.getHydrateMethodCodeSnip());
        this.checkError(4);
        this.writer.println(this.getLoadWithObjectMethodCodeSnip());
        this.checkError(5);
        this.writer.println(this.getPrimaryKeyMethodCodeSnip());
        this.checkError(6);
        this.writer.println(this.getRefreshMethodCodeSnip());
        this.checkError(7);
        this.writer.println(this.getRemoveMethodCodeSnip());
        this.checkError(8);
        if (this.allCMPFieldsAreKeyFields) {
            this.writer.println(this.getStoreNoOpMethodCodeSnip());
        } else {
            this.writer.println(this.getStoreMethodCodeSnip());
        }
        this.checkError(9);
        this.writer.println(this.getCreateTableSQLStringMethodCodeSnip());
        this.checkError(10);
        super.generateBody();
        return null;
    }

    private String getArgsSetters(EJBMethodPartInfo eJBMethodPartInfo, String string, String string2) {
        String string3 = "";
        Class[] classArray = eJBMethodPartInfo.getParameters();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                string3 = string3 + string2 + EJBGenerator.getTypeSetter(classArray[i].getName(), string, "" + (i + 1), "arg" + i, string2) + ";\n";
            }
        }
        return string3;
    }

    private String getPostInitCodeSnip() {
        String string = "{0}\n    protected void postInit() @\n\n        Object msgArgs[] = new Object[]@schemaName};\n\n        createString = MessageFormat.format(_createString, msgArgs);\n        loadString = MessageFormat.format(_loadString, msgArgs);\n        loadForUpdateString = MessageFormat.format(_loadForUpdateString, msgArgs);\n        removeString = MessageFormat.format(_removeString, msgArgs);\n        storeString = MessageFormat.format(_storeString, msgArgs);\n" + this.getFinderFormatStrs("        ") + "    " + "}\n\n";
        Object[] objectArray = new Object[]{this.getMethodComment()};
        return this.getCodeSnip(objectArray, string);
    }

    private String getFinderStrs(String string) {
        String string2 = "";
        Vector vector = this.myBean.getHomeMethodInfoV();
        for (int i = 0; i < vector.size(); ++i) {
            EJBMethodPartInfo eJBMethodPartInfo = (EJBMethodPartInfo)vector.elementAt(i);
            if (!eJBMethodPartInfo.getMethodName().startsWith("find") || eJBMethodPartInfo.getMethodName().equals("findByPrimaryKey")) continue;
            string2 = string2 + string + "String _" + eJBMethodPartInfo.getMethodName() + "QueryString;\n";
        }
        return string2;
    }

    private String getFinderFormatStrs(String string) {
        String string2 = "";
        Vector vector = this.myBean.getHomeMethodInfoV();
        for (int i = 0; i < vector.size(); ++i) {
            EJBMethodPartInfo eJBMethodPartInfo = (EJBMethodPartInfo)vector.elementAt(i);
            if (!eJBMethodPartInfo.getMethodName().startsWith("find") || eJBMethodPartInfo.getMethodName().equals("findByPrimaryKey")) continue;
            string2 = string2 + string + "_" + eJBMethodPartInfo.getMethodName() + "QueryString = " + "MessageFormat.format(" + EJBGenPersister.getShortJavaName(this.ejbName) + "FinderHelper." + eJBMethodPartInfo.getMethodName() + "QueryString" + ", msgArgs);\n";
        }
        return string2;
    }

    private String getCreateMethodCodeSnip() {
        String string = "{0}\n    public void _create (EntityBean eb) throws Exception @\n\n        {1} b = ({1}) eb;\n\n        PreparedStatement pstmt = getPreparedStatement(createString);\n        try @\n{2}            pstmt.executeUpdate();\n        } finally @\n            returnPreparedStatement(pstmt);\n        }\n    }\n\n";
        String string2 = "";
        for (int i = 0; i < this.fields.length; ++i) {
            String string3 = this.fields[i].getName();
            String string4 = this.fields[i].getType().getName();
            string2 = string2 + "            " + EJBGenPersister.getTypeSetter(string4, "pstmt", "" + (i + 1), "b." + string3, "            ") + ";\n";
        }
        Object[] objectArray = new Object[]{this.getMethodComment(), this.ejbName, string2};
        return this.getCodeSnip(objectArray, string);
    }

    protected String getCreateTableSQLStringMethodCodeSnip() {
        String string = "{0}\n    public static String getCreateTableSQLString() @\n\n        return \"CREATE TABLE {1} ( \" + \n{2} + \")\";\n    }\n\n";
        Object[] objectArray = new Object[]{this.getMethodComment(), EJBGenPersister.getTableName(this.ejbName), this.getTableFields("            ")};
        return this.getCodeSnip(objectArray, string);
    }

    public String getCreateTableString() {
        return "CREATE TABLE " + EJBGenPersister.getTableName(this.ejbName) + "(" + this.getTableFields("    ") + ")";
    }

    public String getEJSClassName() {
        return "EJSJDBCPersister" + EJBGenPersister.getShortJavaName(this.ejbName);
    }

    public static final String getEJSClassName(String string) {
        return "EJSJDBCPersister" + EJBGenPersister.getShortJavaName(string);
    }

    protected String getFinderCodeSnip(EJBMethodPartInfo eJBMethodPartInfo) {
        Object[] objectArray;
        Class clazz = eJBMethodPartInfo.getReturnType();
        Class clazz2 = this.myBean.getRemoteInterfaceClass();
        String string = null;
        String string2 = null;
        String string3 = "{0} @\n\n        ResultSet resultSet = null;\n        PreparedStatement pstmt = null;\n        {1} result = null;\n\n        EJSJDBCFinder tmpFinder = null;\n        try @\n            try @\n                pstmt = getPreparedStatement({2});\n{3}                resultSet = pstmt.executeQuery();\n            } catch (java.sql.SQLException ex) @\n                returnPreparedStatement(pstmt);\n                throw new EJSPersistenceException(\"find failed:\", ex);\n            }\n            {4}        } finally @\n            if (tmpFinder != null) @\n                tmpFinder.close();\n            }\n            if (result != null) @\n                returnPreparedStatement(pstmt);\n            }\n        }\n    }\n\n";
        if (clazz.equals(clazz2)) {
            objectArray = "tmpFinder = new EJSJDBCFinder(resultSet, this, pstmt);\n\n            if (tmpFinder.hasMoreElements()) @\n                result = ({0})tmpFinder.nextElement();\n                return result;\n            } else @\n                throw new javax.ejb.ObjectNotFoundException();\n            }\n";
            Object[] objectArray2 = new Object[]{this.remoteInterfaceName};
            string = this.remoteInterfaceName;
            string2 = this.getCodeSnip(objectArray2, (String)objectArray);
        } else {
            string = "EJSFinder";
            string2 = "result = new EJSJDBCFinder(resultSet, this, pstmt);\n            return result;\n";
        }
        objectArray = new Object[]{this.getMethodComment() + "\n" + "    " + "public " + string + " " + eJBMethodPartInfo.getMethodName() + "(" + eJBMethodPartInfo.getArgumentListString() + ")\n" + "        " + "throws javax.ejb.FinderException, " + "java.rmi.RemoteException", string, "_" + eJBMethodPartInfo.getMethodName() + "QueryString", this.getArgsSetters(eJBMethodPartInfo, "pstmt", "                "), string2};
        return this.getCodeSnip(objectArray, string3);
    }

    private String getHydrateMethodCodeSnip() {
        String string = "{0}\n    public void hydrate (EntityBean eb, Object data, Object pKey) throws Exception @\n\n        {1} b = ({1}) eb;\n        {2} _primaryKey = ({2}) pKey;\n\n        java.sql.ResultSet resultSet = (java.sql.ResultSet) data;\n\n{3}    }\n\n";
        String string2 = "";
        string2 = string2 + this.getKeyFields("_primaryKey", "b", "        ");
        for (int i = this.primaryKeyFields.length; i < this.fields.length; ++i) {
            String string3 = this.fields[i].getName();
            string2 = string2 + "        b." + string3 + " = " + EJBGenPersister.getTypeGetter(this.fields[i].getType(), "resultSet", string3 + "Index") + ";\n";
        }
        Object[] objectArray = new Object[]{this.getMethodComment(), this.ejbName, ((EntityDescriptor)this.myDD).getPrimaryKeyClassName(), string2};
        return this.getCodeSnip(objectArray, string);
    }

    private String getKeyFields(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.primaryKeyFields.length; ++i) {
            stringBuffer.append(string3 + string2 + "." + this.primaryKeyFields[i].getName() + " = " + string + "." + this.primaryKeyFields[i].getName() + ";\n");
        }
        return stringBuffer.toString();
    }

    private String getKeyFieldsGetter(String string) {
        String string2 = "";
        for (int i = 0; i < this.primaryKeyFields.length; ++i) {
            String string3 = this.primaryKeyFields[i].getName();
            string2 = string2 + string + "key." + string3 + " = " + EJBGenPersister.getTypeGetter(this.primaryKeyFields[i].getType(), "resultSet", string3 + "Index") + ";\n";
        }
        return string2;
    }

    private String getKeyFieldsSetter(String string) {
        String string2 = "";
        for (int i = 0; i < this.primaryKeyFields.length; ++i) {
            String string3 = this.primaryKeyFields[i].getName();
            String string4 = this.primaryKeyFields[i].getType().getName();
            string2 = string2 + string + EJBGenPersister.getTypeSetter(string4, "pstmt", "" + (i + 1), "_primaryKey." + string3, string) + ";\n";
        }
        return string2;
    }

    private String getLoadWithObjectMethodCodeSnip() {
        String string = "{0}\n    public void load (EntityBean eb, Object pKey, boolean forUpdate) throws Exception @\n\n        {1} b = ({1}) eb;\n        {2} _primaryKey = ({2}) pKey;\n\n        PreparedStatement pstmt;\n        ResultSet resultSet = null;\n        'if (forUpdate) {\n            pstmt = getPreparedStatement(loadForUpdateString);\n        } else {\n            pstmt = getPreparedStatement(loadString);\n        }'\n        try @\n{3}            resultSet = pstmt.executeQuery();\n            if (!(resultSet.next()))\n                throw new javax.ejb.ObjectNotFoundException();\n            hydrate(b, resultSet, pKey);\n        } finally @\n            returnPreparedStatement(pstmt);\n            if (resultSet != null) @\n                resultSet.close();\n            }\n        }\n    }\n\n";
        Object[] objectArray = new Object[]{this.getMethodComment(), this.ejbName, ((EntityDescriptor)this.myBean.getDeploymentDescriptor()).getPrimaryKeyClassName(), this.getKeyFieldsSetter("            ")};
        return this.getCodeSnip(objectArray, string);
    }

    private String getPrimaryKeyMethodCodeSnip() {
        String string = "{0}\n    public Object getPrimaryKey( Object data ) throws Exception @\n\n        {1} key = new {1}();\n        java.sql.ResultSet resultSet = (java.sql.ResultSet) data;\n\n        if (resultSet != null) @\n{2}            return key;\n        }\n\n        return null;\n    }\n\n";
        Object[] objectArray = new Object[]{this.getMethodComment(), ((EntityDescriptor)this.myBean.getDeploymentDescriptor()).getPrimaryKeyClassName(), this.getKeyFieldsGetter("            ")};
        return this.getCodeSnip(objectArray, string);
    }

    private String getRefreshMethodCodeSnip() {
        String string = "{0}\n    public void refresh (EntityBean eb, boolean forUpdate) throws Exception @\n\n        {1} b = ({1}) eb;\n        {2} _primaryKey = new {2}();\n{3}        load(b, _primaryKey, forUpdate);\n    }\n\n";
        Object[] objectArray = new Object[]{this.getMethodComment(), this.ejbName, ((EntityDescriptor)this.myBean.getDeploymentDescriptor()).getPrimaryKeyClassName(), this.getKeyFields("b", "_primaryKey", "        ")};
        return this.getCodeSnip(objectArray, string);
    }

    private String getRemoveMethodCodeSnip() {
        String string = "{0}\n    public void remove (EntityBean eb) throws Exception @\n\n        {1} b = ({1}) eb;\n        {2} _primaryKey = new {2}();\n{3} \n        PreparedStatement pstmt = getPreparedStatement(removeString);\n        try @\n{4}            pstmt.executeUpdate();\n        } finally @\n            returnPreparedStatement(pstmt);\n        }\n    }\n\n";
        Object[] objectArray = new Object[]{this.getMethodComment(), this.ejbName, ((EntityDescriptor)this.myBean.getDeploymentDescriptor()).getPrimaryKeyClassName(), this.getKeyFields("b", "_primaryKey", "        "), this.getKeyFieldsSetter("            ")};
        return this.getCodeSnip(objectArray, string);
    }

    private String getStoreMethodCodeSnip() {
        String string;
        String string2;
        int n;
        String string3 = "{0}\n    public void store (EntityBean eb) throws Exception @\n\n        {1} b = ({1}) eb;\n        {2} _primaryKey = new {2}();\n{3}\n        PreparedStatement pstmt = getPreparedStatement(storeString);\n        try @\n{4}            pstmt.executeUpdate();\n        } finally @\n            returnPreparedStatement(pstmt);\n        }\n    }\n\n";
        String string4 = "";
        int n2 = 0;
        for (n = 0; n < this.fields.length; ++n) {
            string2 = this.fields[n].getName();
            string = this.fields[n].getType().getName();
            if (this.isPrimaryKeyField(string2)) continue;
            string4 = string4 + "            " + EJBGenPersister.getTypeSetter(string, "pstmt", "" + ++n2, "b." + string2, "            ") + ";\n";
        }
        for (n = 0; n < this.primaryKeyFields.length; ++n) {
            string2 = this.primaryKeyFields[n].getName();
            string = this.primaryKeyFields[n].getType().getName();
            string4 = string4 + "            " + EJBGenPersister.getTypeSetter(string, "pstmt", "" + (n2 + n + 1), "_primaryKey." + string2, "            ") + ";\n";
        }
        Object[] objectArray = new Object[]{this.getMethodComment(), this.ejbName, ((EntityDescriptor)this.myBean.getDeploymentDescriptor()).getPrimaryKeyClassName(), this.getKeyFields("b", "_primaryKey", "        "), string4};
        return this.getCodeSnip(objectArray, string3);
    }

    private String getStoreNoOpMethodCodeSnip() {
        String string = "{0}\n    public void store (EntityBean eb) @\n        return;\n    }\n\n";
        Object[] objectArray = new Object[]{this.getMethodComment()};
        return this.getCodeSnip(objectArray, string);
    }

    protected String getTableFields(String string) {
        String string2 = new String();
        for (int i = 0; i < this.fields.length; ++i) {
            String string3 = this.fields[i].getType().getName();
            String string4 = this.getTypeString(string3, this.isPrimaryKeyField(this.fields[i].getName()));
            string2 = string2 + string + "\"" + this.fields[i].getName() + " \" + \"" + string4 + "\"";
            if (i == this.fields.length - 1) {
                string2 = string2 + " + \",\" + \n" + string + "\"PRIMARY KEY (\" + ";
                for (int j = 0; j < this.primaryKeyFields.length; ++j) {
                    string2 = string2 + " \"" + this.primaryKeyFields[j].getName() + "\"";
                    string2 = j == this.primaryKeyFields.length - 1 ? string2 + " + \")\"" : string2 + " + \", \" + ";
                }
                continue;
            }
            string2 = string2 + " + \",\" +\n";
        }
        return string2;
    }

    protected String getTypeString(String string, boolean bl) {
        String string2 = (String)typeMap.get(string);
        if (string2 == null) {
            string2 = (String)typeMap.get("NON_PRIMITIVE_TYPE");
        }
        if (bl) {
            string2 = string2 + " NOT NULL";
        }
        return string2;
    }

    private boolean isPrimaryKeyField(String string) {
        Object v = this.primaryKeyMap.get(string);
        return v != null;
    }

    protected String methodCodeSnip(EJBMethodPartInfo eJBMethodPartInfo) {
        if (!eJBMethodPartInfo.getMethodName().equals("findByPrimaryKey") && eJBMethodPartInfo.getMethodName().startsWith("find")) {
            return this.getFinderCodeSnip(eJBMethodPartInfo);
        }
        return "";
    }

    static {
        typeMap.put("java.lang.String", "VARCHAR(251)");
        typeMap.put("boolean", "SMALLINT");
        typeMap.put("short", "SMALLINT");
        typeMap.put("int", "INTEGER");
        typeMap.put("long", "VARCHAR(22)");
        typeMap.put("float", "FLOAT");
        typeMap.put("double", "DOUBLE");
        typeMap.put("byte", "SMALLINT");
        typeMap.put("char", "CHAR(1)");
        typeMap.put("java.lang.Boolean", "SMALLINT");
        typeMap.put("java.lang.Short", "SMALLINT");
        typeMap.put("java.lang.Integer", "INTEGER");
        typeMap.put("java.lang.Long", "VARCHAR(22)");
        typeMap.put("java.lang.Float", "FLOAT");
        typeMap.put("java.lang.Double", "DOUBLE");
        typeMap.put("java.lang.Character", "CHAR(1)");
        typeMap.put("java.lang.Byte", "SMALLINT");
        typeMap.put("java.math.BigDecimal", "NUMERIC");
        typeMap.put("java.sql.Date", "DATE");
        typeMap.put("java.sql.Time", "TIME");
        typeMap.put("java.sql.Timestamp", "TIMESTAMP");
        typeMap.put("NON_PRIMITIVE_TYPE", "BLOB(1M)");
    }
}

