/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.codeGenerator;

import com.ibm.ejs.util.deployment.analyzer.EJBMethodPartInfo;
import com.ibm.ejs.util.deployment.analyzer.EJBVerify;
import com.ibm.ejs.util.deployment.analyzer.EJBean;
import com.ibm.ejs.util.deployment.codeGenerator.EJBCodegenException;
import com.ibm.ejs.util.deployment.codeGenerator.EJBCodegenResourceHandler;
import com.ibm.ejs.util.deployment.utilities.UtilsReflection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.EntityDescriptor;

public abstract class EJBGenerator {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected EJBean myBean;
    protected Class myBeanClass;
    protected DeploymentDescriptor myDD;
    protected Vector interfaceMethodsInfo;
    private String workingDir;
    protected PrintWriter writer;
    private static boolean traceOn = false;
    private boolean genPackageStatement = true;
    protected String genPackage = null;
    protected String ejbName = null;
    protected String homeInterfaceName = null;
    protected String homeBeanName = null;
    protected String remoteInterfaceName = null;
    protected String classComment = null;
    protected String methodComment = null;
    public static String EJSSessionHomeClass = "EJSSessionHomeClass";
    public static String EJSSessionRemoteClass = "EJSSessionRemoteClass";
    public static String EJSEntityHomeClass = "EJSEntityHomeClass";
    public static String EJSEntityRemoteClass = "EJSEntityRemoteClass";
    public static String EJSEntityPersister = "EJSEntityPersister";
    public static String fileSeparator = System.getProperty("file.separator");
    public static final String dent1 = "    ";
    public static final String dent2 = "        ";
    public static final String dent3 = "            ";
    public static final String dent4 = "                ";
    public static final String dent5 = "                    ";
    protected static final Hashtable typeSetterMap = new Hashtable();
    protected static final Hashtable typeGetterMap;
    protected static final Hashtable uncheckedExceptions;
    protected static EJBCodegenResourceHandler resH;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public EJBGenerator(EJBean eJBean, String string) {
        this.myBean = eJBean;
        this.myDD = eJBean.getDeploymentDescriptor();
        this.workingDir = string;
        this.myBeanClass = this.myBean.getEJBClass();
        this.ejbName = this.myDD.getEnterpriseBeanClassName();
        this.homeInterfaceName = this.myDD.getHomeInterfaceClassName();
        this.homeBeanName = EJBGenerator.getPackageNameWithDot(this.homeInterfaceName) + "EJS" + EJBGenerator.getShortJavaName(this.homeInterfaceName) + "Bean";
        this.remoteInterfaceName = this.myDD.getRemoteInterfaceClassName();
        this.genPackage = EJBGenerator.getPackageName(this.ejbName);
        this.classComment = resH.getMessage("GP_CLASS_COMMENT");
        this.methodComment = resH.getMessage("GP_METHOD_COMMENT");
    }

    protected String begin() throws EJBCodegenException {
        String string = this.workingDir + fileSeparator + this.getEJSClassName() + ".java";
        try {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            this.writer = new PrintWriter(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            throw new EJBCodegenException("GP_IO_EXCEPTION", string);
        }
        return null;
    }

    protected void checkError(int n) throws EJBCodegenException {
        if (this.writer.checkError()) {
            EJBGenerator.trace("EJBGenerator  at stage " + this.getEJSClassName() + n + " has encountered output stream error");
            this.writer.close();
            throw new EJBCodegenException("GP_PRINT_ERROR");
        }
    }

    protected abstract String classHeaderCodeSnip();

    protected abstract String constructorCodeSnip();

    protected String end() {
        this.writer.println("}");
        this.writer.flush();
        this.writer.close();
        return null;
    }

    public String generate() throws EJBCodegenException {
        this.begin();
        this.writer.println(this.classHeaderCodeSnip());
        this.checkError(1);
        this.writer.println(this.constructorCodeSnip());
        this.checkError(2);
        this.generateBody();
        this.end();
        return null;
    }

    protected String generateBody() throws EJBCodegenException {
        for (int i = 0; i < this.interfaceMethodsInfo.size(); ++i) {
            EJBMethodPartInfo eJBMethodPartInfo = (EJBMethodPartInfo)this.interfaceMethodsInfo.elementAt(i);
            this.writer.println(this.methodCodeSnip(eJBMethodPartInfo));
            this.checkError(i + 3);
        }
        return null;
    }

    protected String getClassComment() {
        return this.classComment;
    }

    protected String getCodeSnip(Object[] objectArray, String string) {
        MessageFormat messageFormat = new MessageFormat(string);
        String string2 = null;
        try {
            string2 = messageFormat.format(objectArray).replace('@', '{');
        }
        catch (Exception exception) {
            EJBGenerator.trace("EJBGenerator: format failed for pattern: " + string, exception);
        }
        return string2;
    }

    public String getEJSClassName() {
        return "EJS";
    }

    protected String getExceptionCodeSnip(EJBMethodPartInfo eJBMethodPartInfo, String string, String string2) {
        String string3 = new String();
        Vector vector = null;
        boolean bl = false;
        if (eJBMethodPartInfo.getMethodObject().getDeclaringClass().isAssignableFrom(this.myBean.getRemoteInterfaceClass())) {
            try {
                Class[] classArray;
                Method method = this.myBeanClass.getMethod(eJBMethodPartInfo.getMethodName(), eJBMethodPartInfo.getParameters());
                Class[] classArray2 = classArray = method.getExceptionTypes();
                if (!EJBVerify.verifyTypeInList(classArray, class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = EJBGenerator.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException)) {
                    classArray2 = new Class[classArray.length];
                    if (classArray.length != 0) {
                        System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
                    }
                }
                vector = eJBMethodPartInfo.getSortedExceptions(classArray2);
            }
            catch (Exception exception) {
                EJBGenerator.trace("EJBGenerator: getExceptionCodeSnip(): Exception occurred", exception);
            }
        } else {
            vector = eJBMethodPartInfo.getSortedExceptions();
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                string3 = string3 + "catch (" + ((Class)vector.elementAt(i)).getName() + " ex) @\n";
                if (uncheckedExceptions.containsKey(((Class)vector.elementAt(i)).getName())) {
                    string3 = string3 + string + "s.setUncheckedException(ex);\n";
                } else {
                    string3 = string3 + string + "s.setCheckedException(ex);\n";
                    string3 = string3 + string + "throw ex;\n";
                }
                string3 = string3 + string2 + "} ";
            }
        }
        if (!bl) {
            string3 = string3 + "catch (Throwable ex) @\n" + string + "s.setUncheckedException(ex);\n" + string + "throw new RemoteException(\"bean method raised unchecked exception\", ex);\n" + string2 + "} ";
        }
        return string3;
    }

    protected String getFinderImplClassName() {
        return "EJSJDBCFinder" + EJBGenerator.getShortJavaName(this.ejbName);
    }

    protected String getFinderIntfClassName() {
        return "EJSFinder" + EJBGenerator.getShortJavaName(this.ejbName);
    }

    protected String getKeyFromBeanMethodCodeSnip() {
        String string = "{0}\n    public Object keyFromBean ( javax.ejb.EntityBean generalEJB ) @\n        {1} keyClass = new {1}();\n        {2} tmpEJB = ({2}) generalEJB;\n{3}        return keyClass;\n    }\n\n";
        String string2 = "";
        Field[] fieldArray = UtilsReflection.stripField(this.myBean.getKeyClass().getFields());
        for (int i = 0; i < fieldArray.length; ++i) {
            string2 = string2 + "        keyClass." + fieldArray[i].getName() + " = " + "tmpEJB." + fieldArray[i].getName() + ";\n";
        }
        Object[] objectArray = new Object[]{this.getMethodComment(), ((EntityDescriptor)this.myDD).getPrimaryKeyClassName(), this.ejbName, string2};
        return this.getCodeSnip(objectArray, string);
    }

    protected String getKeyFromFieldsMethodCodeSnip() {
        String string = "{0}\n    private {1} keyFromFields ( {2} ) @\n        {1} keyClass = new {1}();\n{3}        return keyClass;\n    }\n\n";
        String string2 = "";
        String string3 = "";
        Field[] fieldArray = UtilsReflection.stripField(this.myBean.getKeyClass().getFields());
        for (int i = 0; i < fieldArray.length; ++i) {
            string2 = string2 + fieldArray[i].getType().getName() + " f" + i;
            if (i < fieldArray.length - 1) {
                string2 = string2 + ", ";
            }
            string3 = string3 + "        keyClass." + fieldArray[i].getName() + " = " + "f" + i + ";\n";
        }
        Object[] objectArray = new Object[]{this.getMethodComment(), ((EntityDescriptor)this.myDD).getPrimaryKeyClassName(), string2, string3};
        return this.getCodeSnip(objectArray, string);
    }

    protected String getMethodComment() {
        return this.methodComment;
    }

    public static final String getPackageName(String string) {
        int n = string.lastIndexOf(46, string.length());
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    public static final String getPackageNameWithDot(String string) {
        int n = string.lastIndexOf(46, string.length());
        if (n != -1) {
            return string.substring(0, n) + ".";
        }
        return "";
    }

    protected String getPackageStatement() {
        if (this.genPackageStatement) {
            if (!this.genPackage.equals("")) {
                return "package " + this.genPackage + ";";
            }
            return "";
        }
        return " ";
    }

    protected String getPersisterClassName() {
        return "EJSJDBCPersister" + EJBGenerator.getShortJavaName(this.ejbName);
    }

    protected String getResult(EJBMethodPartInfo eJBMethodPartInfo) {
        String string = eJBMethodPartInfo.getReturnTypeString();
        if (!string.equals("void")) {
            return "result;";
        }
        return ";";
    }

    protected String getResultEqual(EJBMethodPartInfo eJBMethodPartInfo) {
        String string = eJBMethodPartInfo.getReturnTypeString();
        if (!string.equals("void")) {
            return "result = ";
        }
        return "";
    }

    protected String getResultStatement(EJBMethodPartInfo eJBMethodPartInfo) {
        String string = eJBMethodPartInfo.getReturnTypeString();
        if (!string.equals("void")) {
            Class clazz = eJBMethodPartInfo.getReturnType();
            if (clazz.isPrimitive()) {
                if (clazz.equals(Boolean.TYPE)) {
                    return string + " result = false;";
                }
                return string + " result = 0;";
            }
            return string + " result = null;";
        }
        return "";
    }

    public static final String getShortJavaName(String string) {
        int n = string.lastIndexOf(46, string.length());
        if (n <= 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        return string.substring(n + 1);
    }

    public static final String getTableName(String string) {
        return "{0}" + EJBGenerator.getShortJavaName(string) + "Tbl";
    }

    protected static final String getTypeGetter(Class clazz, String string, String string2) {
        String string3 = UtilsReflection.getClassDisplayName(clazz);
        String string4 = "";
        if (!typeGetterMap.containsKey(string3)) {
            string4 = "((" + string3 + ") " + "VapBinaryStreamToSerializableObjectConverter.singleton().objectFrom(" + string + ".getBinaryStream(" + string2 + ")))";
        } else {
            String string5 = string + "." + (String)typeGetterMap.get(string3) + "(" + string2 + ")";
            string4 = string3.equals("byte") ? string4 + "(byte) " + string5 : (string3.equals("java.lang.Byte") ? string4 + "new Byte((byte) " + string5 + ")" : (string3.equals("long") ? string4 + "java.lang.Long.parseLong(" + string5 + ")" : (string3.equals("java.lang.Long") ? string4 + "new Long(" + string5 + ")" : (string3.equals("char") ? string4 + "((" + string5 + ").toCharArray())[0]" : (string3.equals("java.lang.Character") ? string4 + "new Character(((" + string5 + ").toCharArray())[0])" : (string3.equals("boolean") ? string4 + "(" + string5 + " == 1)" : (string3.equals("java.lang.Boolean") ? string4 + "new Boolean(" + string5 + " == 1)" : (string3.startsWith("java.lang.") && !string3.equals("java.lang.String") ? string4 + "(" + string3 + ") " + string5 : string5))))))));
        }
        return string4;
    }

    protected static final String getTypeSetter(String string, String string2, String string3, String string4, String string5) {
        String string6;
        if (!typeSetterMap.containsKey(string)) {
            string6 = "serObj = (byte[]) VapBinaryStreamToSerializableObjectConverter.singleton().dataFrom(" + string4 + ");\n" + string5 + "if (serObj == null) {\n" + string5 + string2 + ".setNull(" + string3 + ",java.sql.Types.VARBINARY);\n" + string5 + "} else {\n" + string5 + string2 + ".setBinaryStream(" + string3 + ", new java.io.ByteArrayInputStream(serObj), " + "serObj.getLength());\n" + string5 + "}\n";
        } else {
            string6 = string2 + "." + (String)typeSetterMap.get(string) + "(" + string3 + ", ";
            string6 = string.equals("byte") ? string6 + "(short) " + string4 + ")" : (string.equals("java.lang.Byte") ? string6 + "(short) " + string4 + ".byteValue())" : (string.equals("long") ? string6 + "java.lang.Long.toString(" + string4 + "))" : (string.equals("java.lang.Long") ? string6 + string4 + ".toString())" : (string.equals("char") ? string6 + "java.lang.String.valueOf(" + string4 + "))" : (string.equals("java.lang.Character") ? string6 + string4 + ".toString())" : (string.equals("boolean") ? string6 + "(short) (" + string4 + " ? 1 : 0))" : (string.equals("java.lang.Boolean") ? string6 + "(short) (" + string4 + ".booleanValue() ? 1 : 0))" : (string.equals("java.lang.String") ? "if (" + string4 + " == null) {\n" + string5 + dent1 + string2 + ".setNull(" + string3 + ", java.sql.Types.VARCHAR);\n" + string5 + "} else {\n" + string5 + dent1 + string6 + string4 + ");\n" + string5 + "}" : string6 + string4 + ")"))))))));
        }
        return string6;
    }

    protected abstract String methodCodeSnip(EJBMethodPartInfo var1);

    public void setGenPackage(String string) {
        this.genPackage = string;
    }

    public void setGenPackageStatement(boolean bl) {
        this.genPackageStatement = bl;
    }

    public static final void trace(String string) {
        if (traceOn) {
            System.out.println(string);
        }
    }

    public static final void trace(String string, Exception exception) {
        if (traceOn) {
            System.err.println(string);
            System.err.println(">>>>> Exception Message: " + exception.getMessage());
            System.err.println(">>>>> Stack trace:");
            exception.printStackTrace();
        }
    }

    public static final void traceOn(boolean bl) {
        traceOn = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        typeSetterMap.put("java.lang.String", "setString");
        typeSetterMap.put("boolean", "setShort");
        typeSetterMap.put("short", "setShort");
        typeSetterMap.put("int", "setInt");
        typeSetterMap.put("long", "setString");
        typeSetterMap.put("float", "setFloat");
        typeSetterMap.put("double", "setDouble");
        typeSetterMap.put("byte", "setShort");
        typeSetterMap.put("char", "setString");
        typeSetterMap.put("java.lang.Boolean", "setShort");
        typeSetterMap.put("java.lang.Short", "setObject");
        typeSetterMap.put("java.lang.Integer", "setObject");
        typeSetterMap.put("java.lang.Long", "setString");
        typeSetterMap.put("java.lang.Float", "setObject");
        typeSetterMap.put("java.lang.Double", "setObject");
        typeSetterMap.put("java.lang.Character", "setString");
        typeSetterMap.put("java.lang.Byte", "setShort");
        typeSetterMap.put("java.lang.BigDecimal", "setBigDecimal");
        typeSetterMap.put("java.sql.Date", "setDate");
        typeSetterMap.put("java.sql.Time", "setTime");
        typeSetterMap.put("java.sql.Timestamp", "setTimestamp");
        typeGetterMap = new Hashtable();
        typeGetterMap.put("java.lang.String", "getString");
        typeGetterMap.put("boolean", "getShort");
        typeGetterMap.put("short", "getShort");
        typeGetterMap.put("int", "getInt");
        typeGetterMap.put("long", "getString");
        typeGetterMap.put("float", "getFloat");
        typeGetterMap.put("double", "getDouble");
        typeGetterMap.put("byte", "getShort");
        typeGetterMap.put("char", "getString");
        typeGetterMap.put("java.lang.Boolean", "getShort");
        typeGetterMap.put("java.lang.Short", "getObject");
        typeGetterMap.put("java.lang.Integer", "getObject");
        typeGetterMap.put("java.lang.Long", "getString");
        typeGetterMap.put("java.lang.Float", "getObject");
        typeGetterMap.put("java.lang.Double", "getObject");
        typeGetterMap.put("java.lang.Character", "getString");
        typeGetterMap.put("java.lang.Byte", "getShort");
        typeGetterMap.put("java.lang.BigDecimal", "getBigDecimal");
        typeGetterMap.put("java.sql.Date", "getDate");
        typeGetterMap.put("java.sql.Time", "getTime");
        typeGetterMap.put("java.sql.Timestamp", "getTimestamp");
        uncheckedExceptions = new Hashtable();
        uncheckedExceptions.put("java.rmi.RemoteException", "");
        uncheckedExceptions.put("java.lang.Exception", "");
        uncheckedExceptions.put("java.lang.Throwable", "");
        resH = new EJBCodegenResourceHandler(Locale.getDefault());
    }
}

