/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.deployment;

import com.ibm.ejs.util.deployment.codeGenerator.EJBGenerator;
import com.ibm.ejs.util.deployment.deployment.EJBDeployResourceHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class EJBDBTable {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Hashtable jdbcDriverMap = new Hashtable();
    private static final String PNS_TABLE1_CREATESTRING = "create table ejb.bindingbeantbl (name VARCHAR(64) not null, kind VARCHAR(64),contextId VARCHAR(100) not null, ior VARCHAR(2000), objectType SMALLINT,PRIMARY KEY (name, contextId))";
    private static final String PNS_TABLE2_CREATESTRING = "create table ejb.contextbeantbl (contextId VARCHAR(100) not null, parentId VARCHAR(100), name VARCHAR(64), PRIMARY KEY (contextId))";
    private Connection connection = null;
    private String url;
    private String user;
    private String tid;
    private String passwd;
    private final int defaultPreparedStmtCacheSize = 25;
    private Hashtable preparedStmtCache;
    private static Vector messages;
    private static boolean traceOn;
    private static boolean callFromVAJ;
    private static EJBDeployResourceHandler resH;

    public EJBDBTable(String string, String string2, String string3) {
        this.url = string;
        this.user = string2;
        this.passwd = string3;
        messages = new Vector();
    }

    private static final void addMessage(String string) {
        messages.addElement(string);
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public static final String createPNSTable(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(PNS_TABLE1_CREATESTRING);
        vector.addElement(PNS_TABLE2_CREATESTRING);
        EJBDBTable.traceOn(false);
        callFromVAJ = true;
        EJBDBTable eJBDBTable = new EJBDBTable(string, string2, string3);
        eJBDBTable.createTables(vector);
        return eJBDBTable.getMessagesForVAJ();
    }

    public static final String createTables(String[] stringArray, String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        EJBDBTable.traceOn(false);
        callFromVAJ = true;
        EJBDBTable eJBDBTable = new EJBDBTable(string, string2, string3);
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = EJBGenerator.getPackageNameWithDot(stringArray[i]) + "EJSJDBCPersister" + EJBGenerator.getShortJavaName(stringArray[i]);
            try {
                Class<?> clazz = Class.forName(string4);
                Method method = clazz.getDeclaredMethod("getCreateTableSQLString", null);
                vector.addElement((String)method.invoke(null, null));
                continue;
            }
            catch (Exception exception) {
                EJBDBTable.trace("EJBDBTable: createTables(): Exception occurred", exception);
                EJBDBTable.addMessage(resH.getMessage("DP_DB_PERSISTER_EXCEPTION", string4));
            }
        }
        eJBDBTable.createTables(vector);
        return eJBDBTable.getMessagesForVAJ();
    }

    public boolean createTables(Vector vector) {
        Statement statement = null;
        boolean bl = false;
        boolean bl2 = true;
        try {
            this.open();
            if (this.connection != null) {
                statement = this.connection.createStatement();
                for (int i = 0; i < vector.size(); ++i) {
                    String string = (String)vector.elementAt(i);
                    String string2 = string.replace('\"', ' ').replace('+', ' ');
                    EJBDBTable.trace("\n     SQL Statement = " + string2);
                    try {
                        statement.execute(string2);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        EJBDBTable.trace("EJBDBTable: createTable(): SQLException while creating table", sQLException);
                        if (sQLException.getErrorCode() == -601) {
                            if (callFromVAJ) continue;
                            EJBDBTable.addMessage(resH.getMessage("DP_DB_TABLE_EXISTS", this.url));
                            continue;
                        }
                        EJBDBTable.addMessage(resH.getMessage("DP_DB_EXCEPTION", this.url, sQLException.getMessage()));
                        bl2 = false;
                    }
                }
            } else {
                EJBDBTable.trace("EJBDBTable: createTable(): Could not connect to database");
                bl = true;
                bl2 = false;
            }
        }
        catch (SQLException sQLException) {
            EJBDBTable.trace("EJBDBTable: createTable(): SQLException occurred while connecting to database", sQLException);
            EJBDBTable.addMessage(resH.getMessage("DP_DB_PROBLEM", this.url, sQLException.getMessage()));
            bl = true;
            bl2 = false;
        }
        try {
            if (!bl) {
                if (statement != null) {
                    statement.close();
                }
                this.commit();
                this.close();
            }
        }
        catch (SQLException sQLException) {
            EJBDBTable.trace("EJBDBTable: creaTable(): SQLException occurred while closing database", sQLException);
        }
        return bl2;
    }

    public static final String[] getMessages() {
        Object[] objectArray = null;
        if (messages.size() > 0) {
            objectArray = new String[messages.size()];
            messages.copyInto(objectArray);
        }
        return objectArray;
    }

    public static final String getMessagesForVAJ() {
        String string = null;
        if (messages.size() > 0) {
            string = "";
        }
        for (int i = 0; i < messages.size(); ++i) {
            string = string + (String)messages.elementAt(i) + "\n";
        }
        return string;
    }

    public void open() throws SQLException {
        String[] stringArray = null;
        Enumeration enumeration = jdbcDriverMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.url.startsWith(string)) continue;
            stringArray = (String[])jdbcDriverMap.get(string);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Class.forName(stringArray[i]);
                    EJBDBTable.trace("EJBDBTable: open(): JDBC driver " + stringArray[i] + " loaded");
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    EJBDBTable.trace("EJBDBTable: open(): Cannot load JDBC driver " + stringArray[i], classNotFoundException);
                }
            }
        }
        if (stringArray == null) {
            EJBDBTable.trace("EJBDBTable: open(): Could not determine a suitable JDBC driver for URL " + this.url);
        }
        if (this.url != null) {
            Connection connection = this.connection = this.user != null ? DriverManager.getConnection(this.url, this.user, this.passwd) : DriverManager.getConnection(this.url);
        }
        if (this.connection != null) {
            this.connection.setTransactionIsolation(8);
        }
    }

    private static final void trace(String string) {
        if (traceOn) {
            System.err.println(string);
        }
    }

    private static final void trace(String string, Exception exception) {
        if (traceOn) {
            System.err.println(string);
            System.err.println(">>>>> Exception Message: " + exception.getMessage());
            System.err.println(">>>>> Stack trace:");
            exception.printStackTrace();
        }
    }

    public static final void traceOn(boolean bl) {
        traceOn = bl;
    }

    static {
        jdbcDriverMap.put("txjdbc:odbc", new String[]{"com.ibm.ejs.jts.txjdbc.odbc.TxJdbcOdbcDriver"});
        jdbcDriverMap.put("jdbc:odbc", new String[]{"sun.jdbc.odbc.JdbcOdbcDriver"});
        jdbcDriverMap.put("jdbc:db2", new String[]{"COM.ibm.db2.jdbc.app.DB2Driver", "com.ibm.db2.jdbc.app.DB2Driver"});
        messages = null;
        traceOn = false;
        callFromVAJ = false;
        resH = new EJBDeployResourceHandler(Locale.getDefault());
    }
}

