/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.deployment;

import com.ibm.ejs.util.deployment.analyzer.EJBVerify;
import com.ibm.ejs.util.deployment.analyzer.EJBean;
import com.ibm.ejs.util.deployment.codeGenerator.EJBCodegenException;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenFinderIntf;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenHomeEntity;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenHomeSession;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenPersister;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenRemoteEntity;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenRemoteHome;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenRemoteSession;
import com.ibm.ejs.util.deployment.codeGenerator.EJBGenerator;
import com.ibm.ejs.util.deployment.deployment.EJBDBTable;
import com.ibm.ejs.util.deployment.deployment.EJBDeployException;
import com.ibm.ejs.util.deployment.deployment.EJBDeployResourceHandler;
import com.ibm.ejs.util.deployment.deployment.EJBJar;
import com.ibm.ejs.util.deployment.utilities.FileUtils;
import com.ibm.ejs.util.deployment.utilities.JarEntry;
import com.ibm.ejs.util.deployment.utilities.JarUtils;
import com.ibm.ejs.util.deployment.utilities.UtilsTrace;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.ejb.deployment.DeploymentDescriptor;
import sun.tools.javac.Main;

public class EJBDeploy {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String ROOTDIR = "__ejbjar";
    private static final int MAXCOMPILECLASSES = 20;
    private String srcJarFile = null;
    private String workingDir = null;
    private String dstJarFile = null;
    private String url = null;
    private String userId = null;
    private String password = null;
    private EJBean[] ejbeans = null;
    private Vector ejsJarEntries = new Vector();
    private Hashtable ejsJarEntryNames = new Hashtable();
    private Hashtable srcFiles = new Hashtable();
    private Vector interfaceClasses = new Vector();
    private Vector remoteImplClasses = new Vector();
    private static EJBDeployResourceHandler resH = new EJBDeployResourceHandler(Locale.getDefault());
    private Vector messages = new Vector();
    private boolean ejbJarProcessed = false;
    private boolean ejsJarCreated = false;
    private boolean ejbJarPreDeployed = false;
    private boolean reDeployJar = true;
    private static boolean analyzeOnly = false;
    private static boolean codegenOnly = false;
    private static boolean doNotClean = false;
    private static boolean ignoreErrors = false;
    private static boolean noCompressJar = false;
    private static boolean traceOn = false;
    private Vector createTableStrings = new Vector();

    private void addEJSJarEntry(JarEntry jarEntry) {
        String string = jarEntry.getZipEntry().getName();
        if (this.ejsJarEntryNames.containsKey(string)) {
            for (int i = 0; i < this.ejsJarEntries.size(); ++i) {
                String string2 = ((JarEntry)this.ejsJarEntries.elementAt(i)).getZipEntry().getName();
                if (!string2.equals(string)) continue;
                this.ejsJarEntries.setElementAt(jarEntry, i);
            }
        } else {
            this.ejsJarEntryNames.put(string, "");
            this.ejsJarEntries.addElement(jarEntry);
        }
    }

    private void addEJSJarEntry(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.addEJSJarEntry((JarEntry)vector.elementAt(i));
        }
    }

    private void addMessage(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addMessage(stringArray[i]);
            }
        }
    }

    private void addMessage(String string) {
        this.messages.addElement(string);
    }

    public void close() {
        if (!this.ejbJarProcessed || !this.ejsJarCreated || doNotClean) {
            return;
        }
        String string = this.getWorkingDir();
        EJBDeploy.trace("\nEJBDeploy: close(): Cleaning up working directory " + string);
        try {
            File file = new File(string);
            FileUtils.deleteDirTree(file);
        }
        catch (IOException iOException) {
            EJBDeploy.trace("EJBDeploy: close(): Exception during removal of working directory " + string, iOException);
        }
        this.ejbJarProcessed = false;
        this.ejsJarCreated = false;
    }

    private void compileClasses() throws EJBDeployException {
        EJBDeploy.trace("\nEJBDeploy: compileClasses(): Searching for source files...");
        try {
            this.findSrcFiles(new File(this.getWorkingDir()), null);
        }
        catch (Exception exception) {
            EJBDeploy.trace("EJBDeploy: compileClasses(): Exception occured while searching for source files", exception);
        }
        if (this.srcFiles.size() == 0) {
            return;
        }
        EJBDeploy.trace("\nEJBDeploy: compileClasses(): Compiling generated classes...");
        String[] stringArray = new String[]{this.getExtraCommandLineOptions(), "-d", this.getWorkingDir(), "-classpath", this.getWorkingDir() + System.getProperty("path.separator") + System.getProperty("path.separator") + System.getProperty("java.class.path").replace(' ', '_')};
        String[] stringArray2 = new String[stringArray.length + this.srcFiles.size()];
        String string = "sun.tools.javac.Main";
        int n = stringArray.length;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
            string = string + " " + stringArray[i];
        }
        Main main = this.srcFiles.keys();
        while (main.hasMoreElements()) {
            stringArray2[n] = (String)main.nextElement();
            string = string + "\n          " + stringArray2[n];
            ++n;
        }
        EJBDeploy.trace("     javac command line:");
        EJBDeploy.trace("          " + string);
        try {
            main = new Main((OutputStream)System.err, "javac");
            if (!main.compile(stringArray2)) {
                throw new EJBDeployException("DP_COMPILE_ERROR");
            }
        }
        catch (Exception exception) {
            throw new EJBDeployException("DP_COMPILE_ERROR");
        }
    }

    private void compileClasses_OLD() throws EJBDeployException {
        EJBDeploy.trace("\nEJBDeploy: compileClasses(): Searching for source files...");
        try {
            this.findSrcFiles(new File(this.getWorkingDir()), null);
        }
        catch (Exception exception) {
            EJBDeploy.trace("EJBDeploy: compileClasses(): Exception occured while searching for source files", exception);
        }
        if (this.srcFiles.size() == 0) {
            return;
        }
        EJBDeploy.trace("\nEJBDeploy: compileClasses(): Compiling generated classes...");
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        Enumeration enumeration = this.srcFiles.keys();
        while (enumeration.hasMoreElements()) {
            String string = "java";
            string = string + this.getExtraCommandLineOptions();
            string = string + " -classpath ";
            string = string + this.getWorkingDir() + System.getProperty("path.separator") + System.getProperty("java.home") + File.separator + "lib" + File.separator + "classes.zip" + System.getProperty("path.separator") + System.getProperty("java.class.path").replace(' ', '_');
            string = string + " sun.tools.javac.Main -d " + this.getWorkingDir();
            EJBDeploy.trace("     javac command line:");
            EJBDeploy.trace("          " + string);
            for (int i = 1; i <= 20 && enumeration.hasMoreElements(); ++i) {
                String string2 = (String)enumeration.nextElement();
                string = string + " " + string2;
                EJBDeploy.trace("          " + string2);
            }
            try {
                String string3;
                process = runtime.exec(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    EJBDeploy.trace("     " + string3);
                }
                bufferedReader.close();
                process.waitFor();
                int n = process.exitValue();
                EJBDeploy.trace("     javac return code = " + n);
                if (n == 0) continue;
                throw new EJBDeployException("DP_COMPILE_ERROR");
            }
            catch (InterruptedException interruptedException) {
                if (process != null) {
                    process.destroy();
                }
                EJBDeploy.trace("EJBDeploy: compileClasses(): InterruptedException occured during javac execution", interruptedException);
                throw new EJBDeployException("DP_COMPILE_EXCEPTION");
            }
            catch (IOException iOException) {
                if (process != null) {
                    process.destroy();
                }
                EJBDeploy.trace("EJBDeploy: compileClasses(): IOException occured during javac execution", iOException);
                throw new EJBDeployException("DP_COMPILE_EXCEPTION");
            }
        }
    }

    public boolean createDatabaseTable() {
        if (this.ejsJarCreated && this.createTableStrings.size() == 0) {
            return true;
        }
        if (!this.ejsJarCreated) {
            return false;
        }
        EJBDeploy.trace("\nEJBDeploy: createDatabaseTable(): Creating database tables for container managed EJB's");
        EJBDeploy.trace("     DB URL = " + this.url);
        EJBDeploy.trace("     DB userID = " + this.userId);
        EJBDBTable eJBDBTable = new EJBDBTable(this.url, this.userId, this.password);
        boolean bl = eJBDBTable.createTables(this.createTableStrings);
        this.addMessage(eJBDBTable.getMessages());
        return bl;
    }

    public boolean createEJSJar() {
        try {
            if (!this.getReDeployJar()) {
                try {
                    FileUtils.copyFile(this.getEJBJarFilename(), this.getEJSJarFilename());
                }
                catch (Exception exception) {
                    EJBDeploy.trace("EJBDeploy: createEJSJar(): Exception occured during jar copy", exception);
                    throw new EJBDeployException("DP_JAR_CREATION_FAILED", this.getEJSJarFilename());
                }
                this.ejsJarCreated = true;
                this.setCreateTableStringsFromDeployedPersisters();
                return true;
            }
            if (!this.ejbJarProcessed) {
                return false;
            }
            if (codegenOnly) {
                this.generateClasses();
                return true;
            }
            this.generateClasses();
            this.generateStubs();
            this.generateTies();
            this.compileClasses();
            try {
                JarUtils.createJar(this.getEJSJarFilename(), this.ejsJarEntries, this.getWorkingDir(), noCompressJar);
            }
            catch (Exception exception) {
                EJBDeploy.trace("EJBDeploy: createEJSJar(): Exception occured during jar creation", exception);
                throw new EJBDeployException("DP_JAR_CREATION_FAILED", this.getEJSJarFilename());
            }
            this.ejsJarCreated = true;
            return true;
        }
        catch (Exception exception) {
            this.addMessage(exception.getLocalizedMessage());
            return false;
        }
    }

    private void findSrcFiles(File file, String string) throws IOException {
        if (!file.exists()) {
            return;
        }
        String string2 = file.getName();
        if (file.isDirectory()) {
            string = string == null ? " @ " : (string.equals(" @ ") ? string2 : string + "/" + string2);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.findSrcFiles(new File(file, stringArray[i]), string);
            }
        } else if (string2.endsWith(".java")) {
            String string3 = file.getAbsolutePath();
            EJBDeploy.trace("     Found " + string3);
            this.srcFiles.put(string3, "");
            string2 = string2.substring(0, string2.lastIndexOf(".java")) + ".class";
            string3 = string3.substring(0, string3.lastIndexOf(".java")) + ".class";
            this.addEJSJarEntry(new JarEntry(string + "/" + string2, string3));
        }
    }

    private void generateClasses() throws EJBCodegenException {
        String string = this.getWorkingDir();
        for (int i = 0; i < this.ejbeans.length; ++i) {
            DeploymentDescriptor deploymentDescriptor = this.ejbeans[i].getDeploymentDescriptor();
            String string2 = deploymentDescriptor.getEnterpriseBeanClassName();
            String string3 = deploymentDescriptor.getHomeInterfaceClassName();
            String string4 = deploymentDescriptor.getRemoteInterfaceClassName();
            String string5 = EJBGenerator.getPackageName(string3);
            String string6 = EJBGenerator.getPackageName(string4);
            String string7 = string + File.separator + EJBGenerator.getPackageName(string2).replace('.', File.separatorChar);
            String string8 = string + File.separator + EJBGenerator.getPackageName(string3).replace('.', File.separatorChar);
            String string9 = string + File.separator + EJBGenerator.getPackageName(string4).replace('.', File.separatorChar);
            EJBDeploy.trace("\nEJBDeploy: generateClasses(): Generating home remote implementation class for bean " + string2);
            EJBGenerator eJBGenerator = new EJBGenRemoteHome(this.ejbeans[i], string9);
            eJBGenerator.generate();
            this.remoteImplClasses.addElement(string6 + "." + eJBGenerator.getEJSClassName());
            EJBDeploy.trace("     Class name: " + eJBGenerator.getEJSClassName());
            if (this.ejbeans[i].isSessionBean()) {
                EJBDeploy.trace("\nEJBDeploy: generateClasses(): Generating home implementation class for session bean " + string2);
                eJBGenerator = new EJBGenHomeSession(this.ejbeans[i], string8);
                eJBGenerator.generate();
                EJBDeploy.trace("     Class name: " + eJBGenerator.getEJSClassName());
                EJBDeploy.trace("\nEJBDeploy: generateClasses(): Generating remote implementation class for session bean " + string2);
                eJBGenerator = new EJBGenRemoteSession(this.ejbeans[i], string9);
                eJBGenerator.generate();
                this.remoteImplClasses.addElement(string6 + "." + eJBGenerator.getEJSClassName());
                EJBDeploy.trace("     Class name: " + eJBGenerator.getEJSClassName());
            } else if (this.ejbeans[i].isEntityBean()) {
                EJBDeploy.trace("\nEJBDeploy: generateClasses(): Generating home implementation class for entity bean " + string2);
                eJBGenerator = new EJBGenHomeEntity(this.ejbeans[i], string8);
                eJBGenerator.generate();
                EJBDeploy.trace("     Class name: " + eJBGenerator.getEJSClassName());
                EJBDeploy.trace("\nEJBDeploy: generateClasses(): Generating remote implementation class for entity bean " + string2);
                eJBGenerator = new EJBGenRemoteEntity(this.ejbeans[i], string9);
                eJBGenerator.generate();
                this.remoteImplClasses.addElement(string6 + "." + eJBGenerator.getEJSClassName());
                EJBDeploy.trace("     Class name: " + eJBGenerator.getEJSClassName());
                if (this.ejbeans[i].hasCMPFields()) {
                    EJBDeploy.trace("\nEJBDeploy: generateClasses(): Generating finder interface class for entity bean " + string2);
                    eJBGenerator = new EJBGenFinderIntf(this.ejbeans[i], string7);
                    eJBGenerator.generate();
                    EJBDeploy.trace("     Class name: " + eJBGenerator.getEJSClassName());
                    EJBDeploy.trace("\nEJBDeploy: generateClasses(): Generating persistance manager class for entity bean " + string2);
                    eJBGenerator = new EJBGenPersister(this.ejbeans[i], string7);
                    eJBGenerator.generate();
                    EJBDeploy.trace("     Class name: " + eJBGenerator.getEJSClassName());
                    this.createTableStrings.addElement(((EJBGenPersister)eJBGenerator).getCreateTableString());
                }
            }
            this.interfaceClasses.addElement(string3);
            this.interfaceClasses.addElement(string4);
        }
    }

    private void generateExceptionWrappers() throws EJBDeployException {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        String[][] stringArray = EJBDeploy.getUserExceptions(this.ejbeans);
        if (stringArray.length == 0) {
            EJBDeploy.trace("\nEJBDeploy: generateExceptionWrappers(): No user exceptions found");
            return;
        }
        EJBDeploy.trace("\nEJBDeploy: generateExceptionWrappers(): Generating exception wrapper classes...");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "java " + this.getExtraCommandLineOptions() + "-classpath " + this.getWorkingDir() + System.getProperty("path.separator") + System.getProperty("java.class.path").replace(' ', '_');
            string = string + " com.ibm.CORBA.iiop.emit.ExcWrap";
            string = string + " " + this.getWorkingDir();
            string = string + " " + stringArray[i][0];
            string = string + " " + stringArray[i][1];
            EJBDeploy.trace("     ExcWrap command line: ");
            EJBDeploy.trace("     " + string);
            try {
                String string2;
                process = runtime.exec(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    EJBDeploy.trace("     " + string2);
                }
                bufferedReader.close();
                process.waitFor();
                int n = process.exitValue();
                EJBDeploy.trace("     ExcWrap return code = " + n);
                if (n == 0) continue;
                throw new EJBDeployException("DP_EXCGEN_ERROR");
            }
            catch (InterruptedException interruptedException) {
                if (process != null) {
                    process.destroy();
                }
                EJBDeploy.trace("EJBDeploy: generateExceptionWrappers(): InterruptedException occured during ExcWrap execution", interruptedException);
                throw new EJBDeployException("DP_TOOL_EXCEPTION", "ExcWrap");
            }
            catch (IOException iOException) {
                if (process != null) {
                    process.destroy();
                }
                EJBDeploy.trace("EJBDeploy: generateExceptionWrappers(): IOException occured during ExcWrap execution", iOException);
                throw new EJBDeployException("DP_TOOL_EXCEPTION", "ExcWrap");
            }
        }
    }

    private void generateStubs() throws EJBDeployException {
        if (this.interfaceClasses.size() == 0) {
            return;
        }
        EJBDeploy.trace("\nEJBDeploy: generateStubs(): Generating stubs for interface classes...");
        this.invokeStubCompiler(this.interfaceClasses);
    }

    private void generateTies() throws EJBDeployException {
        if (this.remoteImplClasses.size() == 0) {
            return;
        }
        EJBDeploy.trace("\nEJBDeploy: generateTies(): Generating ties for implementation classes...");
        this.invokeStubCompiler(this.remoteImplClasses);
    }

    public String getDBPassword() {
        return this.password;
    }

    public String getDBURL() {
        return this.url;
    }

    public String getDBUserId() {
        return this.userId;
    }

    public DeploymentDescriptor[] getEJBeans() {
        if (this.ejbeans == null) {
            return null;
        }
        DeploymentDescriptor[] deploymentDescriptorArray = new DeploymentDescriptor[this.ejbeans.length];
        for (int i = 0; i < this.ejbeans.length; ++i) {
            deploymentDescriptorArray[i] = this.ejbeans[i].getDeploymentDescriptor();
        }
        return deploymentDescriptorArray;
    }

    public String getEJBJarFilename() {
        return this.srcJarFile;
    }

    public String getEJSJarFilename() {
        return this.dstJarFile;
    }

    public String[] getMessages() {
        Object[] objectArray = new String[this.messages.size()];
        this.messages.trimToSize();
        this.messages.copyInto(objectArray);
        return objectArray;
    }

    public boolean getReDeployJar() {
        return this.reDeployJar;
    }

    public static final String[][] getUserExceptions(EJBean[] eJBeanArray) {
        Class<?>[] classArray;
        int n;
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        for (int i = 0; i < eJBeanArray.length; ++i) {
            String[] stringArray;
            int n2;
            DeploymentDescriptor deploymentDescriptor = eJBeanArray[i].getDeploymentDescriptor();
            Method[] methodArray = eJBeanArray[i].getHomeInterfaceMethods();
            Method[] methodArray2 = eJBeanArray[i].getRemoteInterfaceMethods();
            for (n = 0; n < methodArray.length; ++n) {
                classArray = methodArray[n].getExceptionTypes();
                for (n2 = 0; n2 < classArray.length; ++n2) {
                    if (!EJBDeploy.isUserException(classArray[n2])) continue;
                    stringArray = new String[]{"com.ibm.CORBA.java.Exception", classArray[n2].getName()};
                    hashtable.put(classArray[n2].getName(), stringArray);
                }
            }
            for (n = 0; n < methodArray2.length; ++n) {
                classArray = methodArray2[n].getExceptionTypes();
                for (n2 = 0; n2 < classArray.length; ++n2) {
                    if (!EJBDeploy.isUserException(classArray[n2])) continue;
                    stringArray = new String[]{"com.ibm.CORBA.java.Exception", classArray[n2].getName()};
                    hashtable.put(classArray[n2].getName(), stringArray);
                }
            }
        }
        String[][] stringArray = new String[hashtable.size()][];
        n = 0;
        classArray = hashtable.elements();
        while (classArray.hasMoreElements()) {
            stringArray[n] = (String[])classArray.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public static final void ignoreEJBErrorsOff() {
        ignoreErrors = false;
    }

    public static final void ignoreEJBErrorsOn() {
        ignoreErrors = true;
    }

    private void invokeStubCompiler(Vector vector) throws EJBDeployException {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        String string = null;
        String string2 = null;
        String string3 = "java " + this.getExtraCommandLineOptions() + "-classpath " + this.getWorkingDir() + System.getProperty("path.separator") + System.getProperty("java.class.path").replace(' ', '_');
        string3 = string3 + " sun.rmi.rmic.Main";
        string3 = string3 + " -keep -iiop -g -d " + this.getWorkingDir();
        for (int i = 0; i < vector.size(); ++i) {
            try {
                String string4 = string3 + " " + (String)vector.elementAt(i);
                EJBDeploy.trace("     rmic command line: ");
                EJBDeploy.trace("     " + string4);
                process = runtime.exec(string4);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((string = bufferedReader.readLine()) != null || (string2 = bufferedReader2.readLine()) != null) {
                    if (string != null) {
                        EJBDeploy.trace("     " + string);
                    }
                    if (string2 == null) continue;
                    EJBDeploy.trace("     " + string2);
                }
                bufferedReader.close();
                bufferedReader2.close();
                process.waitFor();
                int n = process.exitValue();
                EJBDeploy.trace("     rmic return code = " + n);
                if (n == 0) continue;
                throw new EJBDeployException("DP_STUBSGEN_ERROR");
            }
            catch (InterruptedException interruptedException) {
                if (process != null) {
                    process.destroy();
                }
                EJBDeploy.trace("EJBDeploy: generateTies(): InterruptedException occured during rmic execution", interruptedException);
                throw new EJBDeployException("DP_TOOL_EXCEPTION", "rmic");
            }
            catch (IOException iOException) {
                if (process != null) {
                    process.destroy();
                }
                EJBDeploy.trace("EJBDeploy: generateTies(): IOException occured during rmic execution", iOException);
                throw new EJBDeployException("DP_TOOL_EXCEPTION", "rmic");
            }
        }
    }

    private void invokeStubCompiler_NEW(Vector vector) throws EJBDeployException {
        int n;
        String[] stringArray = new String[]{"-d", this.getWorkingDir(), "-classpath", this.getWorkingDir() + System.getProperty("path.separator") + System.getProperty("java.class.path").replace(' ', '_'), "-g", "-keep", "-iiop"};
        String[] stringArray2 = new String[stringArray.length + 1];
        String string = "rmic";
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
            string = string + " " + stringArray[n];
        }
        for (n = 0; n < vector.size(); ++n) {
            stringArray2[stringArray.length] = (String)vector.elementAt(n);
            EJBDeploy.trace("     rmic command line:");
            EJBDeploy.trace("          " + string + " " + (String)vector.elementAt(n));
            String[] stringArray3 = new String[stringArray2.length];
            System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
            try {
                sun.rmi.rmic.Main main = new sun.rmi.rmic.Main((OutputStream)System.err, "rmic");
                if (main.compile(stringArray3)) continue;
                throw new EJBDeployException("DP_STUBSGEN_ERROR");
            }
            catch (Exception exception) {
                throw new EJBDeployException("DP_STUBSGEN_ERROR");
            }
        }
    }

    public boolean isDeployed() {
        return this.ejbJarPreDeployed;
    }

    private static final boolean isUserException(Class clazz) {
        boolean bl = true;
        String string = clazz.getName();
        if (string.startsWith("java.") || string.startsWith("javax.")) {
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        int n;
        boolean bl = false;
        boolean bl2 = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl3 = true;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("-t")) {
                EJBDeploy.traceOn(true);
                continue;
            }
            if (stringArray[n].startsWith("-analyze")) {
                analyzeOnly = true;
                codegenOnly = false;
                continue;
            }
            if (stringArray[n].startsWith("-codegen")) {
                codegenOnly = true;
                analyzeOnly = false;
                continue;
            }
            if (stringArray[n].startsWith("-dburl")) {
                bl = true;
                if (n >= stringArray.length - 1) continue;
                string = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].startsWith("-dbuid")) {
                if (n >= stringArray.length - 1) continue;
                string2 = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].startsWith("-dbpass")) {
                if (n >= stringArray.length - 1) continue;
                string3 = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].startsWith("-noclean")) {
                doNotClean = true;
                continue;
            }
            if (stringArray[n].startsWith("-force")) {
                ignoreErrors = true;
                continue;
            }
            if (stringArray[n].startsWith("-nodeploy")) {
                bl2 = false;
                continue;
            }
            if (stringArray[n].startsWith("-nocompress")) {
                noCompressJar = true;
                continue;
            }
            if (n == 0) {
                string4 = stringArray[n];
                continue;
            }
            if (n == 1) {
                string5 = stringArray[n];
                continue;
            }
            if (n != 2) continue;
            string6 = stringArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!(analyzeOnly && n <= 0 && stringArray[n].startsWith("-") || codegenOnly && n <= 1 && stringArray[n].startsWith("-")) && (analyzeOnly || codegenOnly || n > 2 || !stringArray[n].startsWith("-"))) continue;
            System.err.println(resH.getMessage("DP_USAGE"));
            return;
        }
        if (analyzeOnly && stringArray.length < 1 || codegenOnly && stringArray.length < 2 || !analyzeOnly && !codegenOnly && stringArray.length < 3) {
            System.err.println(resH.getMessage("DP_USAGE"));
            return;
        }
        EJBDeploy eJBDeploy = new EJBDeploy();
        eJBDeploy.setEJBJarFilename(string4);
        eJBDeploy.setWorkingDir(string5);
        eJBDeploy.setEJSJarFilename(string6);
        bl3 = eJBDeploy.open();
        eJBDeploy.setReDeployJar(bl2);
        if (!analyzeOnly) {
            boolean bl4 = bl3 = bl3 && eJBDeploy.createEJSJar();
            if (!codegenOnly && bl) {
                eJBDeploy.setDBURL(string);
                eJBDeploy.setDBUserId(string2);
                eJBDeploy.setDBPassword(string3);
                n = eJBDeploy.createDatabaseTable() ? 1 : 0;
                if (n != 0) {
                    EJBDeploy.trace("\nEJBDeploy: All tables created successfully");
                } else {
                    EJBDeploy.trace("\nEJBDeploy: One or more tables could not be created");
                }
                bl3 = bl3 && n != 0;
            }
            eJBDeploy.close();
        }
        EJBDeploy.trace("\n********** EJBDeploy: Messages:\n");
        String[] stringArray2 = eJBDeploy.getMessages();
        for (n = 0; n < stringArray2.length; ++n) {
            System.err.println(stringArray2[n] + "\n");
        }
        if (!bl3) {
            System.exit(-1);
        }
    }

    public boolean open() {
        String string = this.getEJBJarFilename();
        String string2 = null;
        boolean bl = false;
        this.ejbJarProcessed = false;
        this.ejsJarCreated = false;
        if (!analyzeOnly) {
            try {
                this.setupWorkingDir();
                string2 = this.getWorkingDir();
            }
            catch (EJBDeployException eJBDeployException) {
                this.addMessage(eJBDeployException.getLocalizedMessage());
                return false;
            }
        }
        EJBDeploy.trace("\nEJBDeploy: open(): Processing jar file " + string);
        EJBJar eJBJar = new EJBJar(string, string2);
        this.ejbeans = eJBJar.getEJBeans();
        bl = eJBJar.hasErrors();
        this.addMessage(eJBJar.getMessages());
        if (!bl) {
            this.addEJSJarEntry(eJBJar.getJarEntries());
        }
        if (this.ejbeans != null) {
            String string3;
            int n;
            for (n = 0; n < this.ejbeans.length; ++n) {
                string3 = this.ejbeans[n].getDeploymentDescriptor().getEnterpriseBeanClassName();
                String string4 = this.ejbeans[n].getDeploymentDescriptor().getRemoteInterfaceClassName();
                string4 = EJBGenerator.getPackageNameWithDot(string3) + EJBGenRemoteSession.getEJSClassName(string4);
                if (!this.ejsJarEntryNames.containsKey(string4 = string4.replace('.', '/') + ".class")) continue;
                this.ejbJarPreDeployed = true;
            }
            if (this.isDeployed()) {
                EJBDeploy.trace("\nEJBDeploy: open(): EJB .jar file is already possibly deployed...");
            }
            for (n = 0; n < this.ejbeans.length; ++n) {
                string3 = this.ejbeans[n].getDeploymentDescriptor().getEnterpriseBeanClassName();
                EJBDeploy.trace("\nEJBDeploy: open(): Verifying EJB " + string3);
                if (!this.ejbeans[n].verify()) {
                    bl = true;
                }
                this.addMessage(this.ejbeans[n].getMessages());
            }
        }
        if (bl && !ignoreErrors) {
            return false;
        }
        this.ejbJarProcessed = true;
        return true;
    }

    private void setCreateTableStringsFromDeployedPersisters() {
        EJBDeploy.trace("\nEJBDeploy: Getting table creation SQL strings from deployed persisters");
        for (int i = 0; i < this.ejbeans.length; ++i) {
            if (!this.ejbeans[i].hasCMPFields()) continue;
            String string = this.ejbeans[i].getDeploymentDescriptor().getEnterpriseBeanClassName();
            String string2 = EJBGenerator.getPackageName(string) + "." + EJBGenPersister.getEJSClassName(string);
            Class<?> clazz = null;
            try {
                EJBDeploy.trace("     Loading " + string2);
                clazz = EJBJar.bcl != null ? EJBJar.bcl.loadClass(string2) : Class.forName(string2);
                if (clazz != null) {
                    Method method = clazz.getDeclaredMethod("getCreateTableSQLString", new Class[0]);
                    String string3 = (String)method.invoke(null, new Object[0]);
                    EJBDeploy.trace("     SQL String = " + string3);
                    this.createTableStrings.addElement(string3);
                    continue;
                }
                EJBDeploy.trace("     " + string + " could not be loaded");
                continue;
            }
            catch (Exception exception) {
                EJBDeploy.trace("EJBDeploy: Exception occurred during loading of persister class", exception);
            }
        }
    }

    public void setDBPassword(String string) {
        this.password = string;
    }

    public void setDBURL(String string) {
        this.url = string;
    }

    public void setDBUserId(String string) {
        this.userId = string;
    }

    public void setEJBJarFilename(String string) {
        this.srcJarFile = string;
    }

    public void setEJSJarFilename(String string) {
        this.dstJarFile = string;
    }

    public void setNoCompressJar(boolean bl) {
        noCompressJar = bl;
    }

    public void setReDeployJar(boolean bl) {
        this.reDeployJar = bl;
    }

    private void setupWorkingDir() throws EJBDeployException {
        String string = this.getWorkingDir();
        EJBDeploy.trace("EJBDeploy: setupWorkingDir(): Setting up working directory " + string);
        File file = new File(string);
        if (!file.isDirectory()) {
            EJBDeploy.trace("EJBDeploy: setupWorkingDir(): Directory " + string + " is invalid");
            throw new EJBDeployException("DP_INVALID_WORKING_DIR", string);
        }
        if (!file.canWrite()) {
            EJBDeploy.trace("EJBDeploy: setupWorkingDir(): Cannot write to directory " + string);
            throw new EJBDeployException("DP_WORKING_DIR_WRITE", string);
        }
        try {
            string = string + File.separator + ROOTDIR;
            file = new File(string);
            if (file.exists()) {
                EJBDeploy.trace("EJBDeploy: setupWorkingDir(): Deleting directory " + string);
                FileUtils.deleteDirTree(file);
            }
            if (!file.mkdir()) {
                EJBDeploy.trace("EJBDeploy: setupWorkingDir(): Cannot create temporary directory " + string);
                throw new EJBDeployException("DP_WORKING_DIR_WRITE", string);
            }
        }
        catch (IOException iOException) {
            EJBDeploy.trace("EJBDeploy: setupWorkingDir(): Exception during directory creation", iOException);
            throw new EJBDeployException("DP_WORKING_DIR_WRITE", string);
        }
        this.setWorkingDir(string);
    }

    public void setWorkingDir(String string) {
        this.workingDir = string;
    }

    private static final void trace(String string) {
        if (traceOn) {
            System.err.println(string);
        }
    }

    private static final void trace(String string, Exception exception) {
        if (traceOn) {
            System.err.println(string);
            System.err.println(">>>>> Exception Message: " + exception.getMessage());
            System.err.println(">>>>> Stack trace:");
            exception.printStackTrace();
        }
    }

    public static final void traceOn(boolean bl) {
        traceOn = bl;
        EJBJar.traceOn(bl);
        EJBean.traceOn(bl);
        EJBVerify.traceOn(bl);
        EJBGenerator.traceOn(bl);
        UtilsTrace.traceOn(bl);
        EJBDBTable.traceOn(bl);
    }

    public String getExtraCommandLineOptions() {
        String string = System.getProperty("os.name");
        if (string.equalsIgnoreCase("HP-UX")) {
            return " -classic ";
        }
        return "";
    }
}

