/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.deployment;

import com.ibm.ejs.util.deployment.analyzer.EJBean;
import com.ibm.ejs.util.deployment.deployment.EJBDeployResourceHandler;
import com.ibm.ejs.util.deployment.utilities.ByteArraySetClassLoader;
import com.ibm.ejs.util.deployment.utilities.JarEntry;
import com.ibm.ejs.util.deployment.utilities.JarUtils;
import com.ibm.ejs.util.deployment.utilities.ObjectInputStreamCustomResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.ZipException;
import javax.ejb.deployment.DeploymentDescriptor;

public class EJBJar {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector ejBeans = new Vector();
    private Vector jarEntries = null;
    private Hashtable jarEntriesHash = new Hashtable();
    public static ByteArraySetClassLoader bcl = null;
    private Vector messages = new Vector();
    private boolean hasErrors = false;
    private static EJBDeployResourceHandler resH = new EJBDeployResourceHandler(Locale.getDefault());
    private static boolean traceOn = false;

    public EJBJar(String string) {
        this.processJar(string, null);
    }

    public EJBJar(String string, String string2) {
        this.processJar(string, string2);
    }

    private void addMessage(String string) {
        this.messages.addElement(string);
    }

    public EJBean[] getEJBeans() {
        if (this.ejBeans.size() == 0) {
            return null;
        }
        Object[] objectArray = new EJBean[this.ejBeans.size()];
        this.ejBeans.trimToSize();
        this.ejBeans.copyInto(objectArray);
        return objectArray;
    }

    public Vector getJarEntries() {
        return this.jarEntries;
    }

    public String[] getMessages() {
        Object[] objectArray = new String[this.messages.size()];
        this.messages.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private ByteArraySetClassLoader loadJarClasses() {
        ByteArraySetClassLoader byteArraySetClassLoader = new ByteArraySetClassLoader();
        EJBJar.trace("\nEJBJar: loadJarClasses(): Adding all classes in .jar file to custom class loader");
        try {
            for (int i = 0; i < this.jarEntries.size(); ++i) {
                JarEntry jarEntry = (JarEntry)this.jarEntries.elementAt(i);
                String string = jarEntry.getZipEntry().getName();
                if (!string.endsWith(".class")) continue;
                string = string.substring(0, string.lastIndexOf(".class"));
                string = string.replace('/', '.');
                ByteArraySetClassLoader.addClass(string, jarEntry.getByteArray());
            }
        }
        catch (Exception exception) {
            EJBJar.trace("EJBJar: loadJarClasses(): Exception occurred during addition of classes to class loader", exception);
        }
        return byteArraySetClassLoader;
    }

    private String[] parseDDNames(DataInputStream dataInputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector<String> vector = new Vector<String>();
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                if (string.equals("")) {
                    string2 = null;
                    string3 = null;
                }
                if (string.toLowerCase().startsWith("name:")) {
                    string2 = string.substring(string.indexOf(" ") + 1, string.length());
                }
                if (string.toLowerCase().startsWith("enterprise-bean: true")) {
                    string3 = string;
                }
                if (string2 != null && string3 != null) {
                    vector.addElement(string2);
                    EJBJar.trace("     Found " + string2);
                    Object v = this.jarEntriesHash.get(string2);
                    if (v != null) {
                        ((JarEntry)v).setManifestHeader(string3);
                    }
                    string2 = null;
                    string3 = null;
                }
                string = bufferedReader.readLine();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            this.addMessage(resH.getMessage("EJBJAR_IO_EXCEPTION_MANIF"));
            EJBJar.trace("EJBJar: parseDDNames(): IOException occured when parsing manifest file", iOException);
            this.hasErrors = true;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void processJar(String string) {
        DataInputStream dataInputStream = null;
        byte[] byArray = null;
        ObjectInputStream objectInputStream = null;
        String[] stringArray = null;
        try {
            JarEntry jarEntry;
            int n;
            for (n = 0; n < this.jarEntries.size(); ++n) {
                jarEntry = (JarEntry)this.jarEntries.elementAt(n);
                this.jarEntriesHash.put(jarEntry.getZipEntry().getName(), jarEntry);
            }
            dataInputStream = JarUtils.locateInJar(string, "META-INF/MANIFEST.MF");
            if (dataInputStream == null) {
                this.addMessage(resH.getMessage("EJBJAR_MANIFEST_NOT_FOUND", string));
                EJBJar.trace("EJBJar: processJar(): Manifest file not found in jar file " + string);
                this.hasErrors = true;
                return;
            }
            EJBJar.trace("EJBJar: processJar(): Parsing manifest file for deployment descriptors");
            stringArray = this.parseDDNames(dataInputStream);
            if (dataInputStream != null) {
                dataInputStream.close();
            }
            if (stringArray.length == 0 || stringArray == null) {
                this.addMessage(resH.getMessage("EJBJAR_NO_EJBEANS", string));
                EJBJar.trace("EJBJar: processJar(): Jar file " + string + " contains no EJB Beans");
                this.hasErrors = true;
                return;
            }
            bcl = this.loadJarClasses();
            EJBJar.trace("\nEJBJar: processJar(): Deserializing deployment descriptors ");
            for (n = 0; n < stringArray.length; ++n) {
                EJBJar.trace("     " + stringArray[n]);
                jarEntry = this.jarEntriesHash.get(stringArray[n]);
                if (jarEntry != null) {
                    byArray = jarEntry.getByteArray();
                }
                if (byArray != null) {
                    try {
                        objectInputStream = new ObjectInputStreamCustomResolver(new ByteArrayInputStream(byArray), bcl);
                        DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)objectInputStream.readObject();
                        objectInputStream.close();
                        this.ejBeans.addElement(new EJBean(deploymentDescriptor));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                        this.addMessage(resH.getMessage("EJBJAR_CLASS_EXCEPTION", stringArray[n]));
                        this.hasErrors = true;
                        EJBJar.trace("ClassNotFoundException occured when attempting to deserialize the Deployment Descriptor " + stringArray[n], classNotFoundException);
                    }
                    catch (IOException iOException) {
                        this.addMessage(resH.getMessage("EJBJAR_IO_EXCEPTION_SER", stringArray[n]));
                        this.hasErrors = true;
                        EJBJar.trace("IOException occured when attempting to deserialize the Deployment Descriptor " + stringArray[n], iOException);
                    }
                    continue;
                }
                this.addMessage(resH.getMessage("EJBJAR_NO_DEPLOYMENT_DESC", stringArray[n], string));
                this.hasErrors = true;
                EJBJar.trace("EJBJar: processJar(): Deployment Descriptor " + stringArray[n] + " cannot be found in jar file " + string);
            }
        }
        catch (ZipException zipException) {
            this.addMessage(resH.getMessage("EJBJAR_ZIP_EXCEPTION", string));
            EJBJar.trace("EJBJar: processJar(): ZipException occured when processing jar file " + string, zipException);
            this.hasErrors = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.addMessage(resH.getMessage("EJBJAR_JAR_FILE_NOT_FOUND", string));
            EJBJar.trace("EJBJar: processJar(): FileNotFoundException occured when processing jar file", fileNotFoundException);
            this.hasErrors = true;
        }
        catch (IOException iOException) {
            this.addMessage(resH.getMessage("EJBJAR_IO_EXCEPTION_JAR", string));
            EJBJar.trace("EJBJar: processJar(): IOException occurred when processing jar file", iOException);
            this.hasErrors = true;
        }
    }

    private void processJar(String string, String string2) {
        try {
            if (string2 != null) {
                EJBJar.trace("\nEJBJar: processJar(): Extracting jar file " + string + " to directory " + string2);
            }
            this.jarEntries = JarUtils.extractJar(string, string2, ".java");
            this.processJar(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.addMessage(resH.getMessage("EJBJAR_JAR_FILE_NOT_FOUND", string));
            EJBJar.trace("EJBJar: processJar(): FileNotFoundException occured when processing jar file " + string, fileNotFoundException);
            this.hasErrors = true;
        }
        catch (IOException iOException) {
            this.addMessage(resH.getMessage("EJBJAR_IO_EXCEPTION_JAR", string));
            EJBJar.trace("EJBJar: processJar(): IOException occured when processing jar file " + string, iOException);
            this.hasErrors = true;
        }
    }

    public static final void trace(String string) {
        if (traceOn) {
            System.err.println(string);
        }
    }

    public static final void trace(String string, Exception exception) {
        if (traceOn) {
            System.err.println(string);
            System.err.println(">>>>> Exception Message: " + exception.getMessage());
            System.err.println(">>>>> Stack trace:");
            exception.printStackTrace();
        }
    }

    public static final void traceOn(boolean bl) {
        traceOn = bl;
    }
}

