/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.utilities;

import com.ibm.ejs.util.deployment.utilities.JarEntry;
import com.ibm.ejs.util.deployment.utilities.UtilsTrace;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JarUtils {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final char[] radix64Digits = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static final void createJar(String string, Vector vector, String string2, boolean bl) throws Exception {
        JarEntry jarEntry;
        int n;
        PrintWriter printWriter = null;
        File file = null;
        File file2 = null;
        String string3 = null;
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        CRC32 cRC32 = new CRC32();
        file = new File(string);
        string3 = file.getParent();
        if (string3 != null && !(file2 = new File(string3)).exists()) {
            file2.mkdirs();
        }
        if (file.isDirectory()) {
            throw new Exception();
        }
        String string4 = string2 + File.separator + "META-INF" + File.separator + "MANIFEST.MF";
        UtilsTrace.trace("\nJarUtils: createJar(): Creating manifest file " + string4);
        File file3 = new File(string4);
        if (file3.exists()) {
            file3.delete();
        }
        printWriter = new PrintWriter(new FileOutputStream(file3));
        printWriter.println("Manifest-Version: 1.0");
        for (n = 0; n < vector.size(); ++n) {
            jarEntry = (JarEntry)vector.elementAt(n);
            String string5 = jarEntry.getZipEntry().getName();
            String string6 = jarEntry.getManifestHeader();
            String[] stringArray = JarUtils.getDigestManifestHeaders(jarEntry.getByteArray());
            printWriter.println();
            printWriter.println("Name: " + string5);
            if (string6 != null) {
                printWriter.println(string6);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println(stringArray[i]);
            }
        }
        if (printWriter != null) {
            printWriter.close();
        }
        jarEntry = new JarEntry("META-INF/MANIFEST.MF", string4);
        ZipEntry zipEntry = jarEntry.getZipEntry();
        UtilsTrace.trace("\nJarUtils: createJar(): Creating jar file " + string);
        fileOutputStream = new FileOutputStream(file);
        zipOutputStream = new ZipOutputStream(fileOutputStream);
        if (bl) {
            zipOutputStream.setMethod(0);
            zipEntry.setMethod(0);
            zipEntry.setSize(jarEntry.getByteArray().length);
            cRC32.reset();
            cRC32.update(jarEntry.getByteArray());
            zipEntry.setCrc(cRC32.getValue());
        }
        UtilsTrace.trace("     adding META-INF/MANIFEST.MF");
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = jarEntry.getByteArray();
        zipOutputStream.write(byArray, 0, byArray.length);
        zipOutputStream.closeEntry();
        for (n = 0; n < vector.size(); ++n) {
            jarEntry = (JarEntry)vector.elementAt(n);
            zipEntry = jarEntry.getZipEntry();
            if (bl) {
                zipEntry.setMethod(0);
                zipEntry.setSize(jarEntry.getByteArray().length);
                cRC32.reset();
                cRC32.update(jarEntry.getByteArray());
                zipEntry.setCrc(cRC32.getValue());
            }
            UtilsTrace.trace("     adding " + zipEntry.getName());
            zipOutputStream.putNextEntry(zipEntry);
            if (!zipEntry.isDirectory()) {
                byArray = jarEntry.getByteArray();
                zipOutputStream.write(byArray, 0, byArray.length);
            }
            zipOutputStream.closeEntry();
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
    }

    private static final String encode64(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = byArray.length;
        for (int i = 0; i < n; i += 3) {
            byte by;
            byte by2;
            byte by3;
            if (n - i == 1) {
                by3 = byArray[i];
                by2 = 0;
                by = 0;
                stringBuffer.append(radix64Digits[by3 >>> 2 & 0x3F]);
                stringBuffer.append(radix64Digits[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)]);
                stringBuffer.append("==");
                continue;
            }
            if (n - i == 2) {
                by3 = byArray[i];
                by2 = byArray[i + 1];
                by = 0;
                stringBuffer.append(radix64Digits[by3 >>> 2 & 0x3F]).toString();
                stringBuffer.append(radix64Digits[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)]);
                stringBuffer.append(radix64Digits[(by2 << 2 & 0x3C) + (by >>> 6 & 3)]);
                stringBuffer.append('=');
                continue;
            }
            by3 = byArray[i];
            by2 = byArray[i + 1];
            by = byArray[i + 2];
            stringBuffer.append(radix64Digits[by3 >>> 2 & 0x3F]);
            stringBuffer.append(radix64Digits[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)]);
            stringBuffer.append(radix64Digits[(by2 << 2 & 0x3C) + (by >>> 6 & 3)]);
            stringBuffer.append(radix64Digits[by & 0x3F]);
        }
        return new String(stringBuffer);
    }

    public static final Vector extractJar(String string, String string2, String string3) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = null;
        Vector<JarEntry> vector = new Vector<JarEntry>();
        boolean bl = true;
        File file = null;
        File file2 = null;
        if (string2 == null) {
            bl = false;
        }
        try {
            ZipEntry zipEntry;
            fileInputStream = new FileInputStream(string);
            zipInputStream = new ZipInputStream(fileInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string4 = zipEntry.getName();
                boolean bl2 = false;
                if (string3 != null && string4.endsWith(string3)) {
                    bl2 = true;
                }
                String string5 = string4;
                string5 = string2 + File.separator + string5.replace('/', File.separatorChar);
                if (bl && !bl2 && !(file2 = new File((file = new File(string5)).getParent())).exists()) {
                    file2.mkdirs();
                }
                if (!zipEntry.isDirectory()) {
                    if (bl && !bl2) {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n = bufferedInputStream.read();
                    while (n != -1) {
                        if (bl && !bl2) {
                            fileOutputStream.write(n);
                        }
                        byteArrayOutputStream.write(n);
                        n = bufferedInputStream.read();
                    }
                    if (fileOutputStream != null && bl && !bl2) {
                        fileOutputStream.close();
                    }
                    if (byteArrayOutputStream != null) {
                        byArray = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.close();
                    }
                }
                if (string4.startsWith("META-INF/MANIFEST.MF") || zipEntry.isDirectory()) continue;
                vector.addElement(new JarEntry(string4, string5, byArray));
            }
            return vector;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (zipInputStream != null) {
                zipInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw iOException;
        }
    }

    private static final String[] getDigestManifestHeaders(byte[] byArray) throws NoSuchAlgorithmException {
        String[] stringArray = new String[3];
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
        if (byArray != null) {
            messageDigest.reset();
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            messageDigest2.reset();
            messageDigest2.update(byArray);
            byte[] byArray3 = messageDigest2.digest();
            stringArray[0] = "Digest-Algorithms: SHA MD5";
            stringArray[1] = "SHA-Digest: " + JarUtils.encode64(byArray2);
            stringArray[2] = "MD5-Digest: " + JarUtils.encode64(byArray3);
        }
        return stringArray;
    }

    public static final DataInputStream locateInJar(String string, String string2) throws FileNotFoundException, IOException, ZipException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null && !zipEntry.getName().equals(string2)) {
            zipEntry = zipInputStream.getNextEntry();
        }
        if (!zipEntry.getName().equals(string2)) {
            zipInputStream.close();
            return null;
        }
        return new DataInputStream(zipInputStream);
    }
}

