/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.ccache.b;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;

public class HostAddresses
implements Cloneable {
    public HostAddress[] addresses;

    public HostAddresses(HostAddress[] hostAddressArray) {
        this.addresses = hostAddressArray;
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new HostAddress[1];
        this.addresses[0] = new HostAddress();
    }

    private HostAddresses(int n2) {
    }

    public HostAddresses(PrincipalName principalName) throws UnknownHostException, KrbException {
        String[] stringArray = principalName.getNameStrings();
        if (principalName.getNameType() != 3 || stringArray.length < 2) {
            throw new KrbException(HostAddresses.a("3\"(\u00161\u000f;5&13,1 "), null);
        }
        String string = stringArray[1];
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
        int n2 = 0;
        while (n2 < inetAddressArray.length) {
            hostAddressArray[n2] = new HostAddress(inetAddressArray[n2]);
            ++n2;
        }
        this.addresses = hostAddressArray;
    }

    public Object clone() {
        HostAddresses hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            hostAddresses.addresses = new HostAddress[this.addresses.length];
            int n2 = 0;
            while (n2 < this.addresses.length) {
                hostAddresses.addresses[n2] = (HostAddress)this.addresses[n2].clone();
                ++n2;
            }
        }
        return hostAddresses;
    }

    public boolean inList(HostAddress hostAddress) {
        if (this.addresses != null) {
            int n2 = 0;
            while (n2 < this.addresses.length) {
                if (this.addresses[n2].equals(hostAddress)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean equals(HostAddresses hostAddresses) {
        if (this.addresses == null && hostAddresses.addresses != null || this.addresses != null && hostAddresses.addresses == null) {
            return false;
        }
        if (this.addresses != null && hostAddresses.addresses != null) {
            if (this.addresses.length != hostAddresses.addresses.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.addresses.length) {
                if (!this.addresses[n2].equals(hostAddresses.addresses[n2])) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public HostAddresses(DerValue derValue) throws Asn1Exception, IOException {
        Vector<HostAddress> vector = new Vector<HostAddress>();
        DerValue derValue2 = null;
        while (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            vector.addElement(new HostAddress(derValue2));
        }
        if (vector.size() > 0) {
            this.addresses = new HostAddress[vector.size()];
            vector.copyInto(this.addresses);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.addresses != null && this.addresses.length > 0) {
            int n2 = 0;
            while (n2 < this.addresses.length) {
                derOutputStream.write(this.addresses[n2].asn1Encode());
                ++n2;
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddresses parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddresses(derValue2);
    }

    public void writeAddrs(b b2) throws IOException {
        b2.a(this.addresses.length);
        int n2 = 0;
        while (n2 < this.addresses.length) {
            b2.b(this.addresses[n2].addrType);
            b2.a(this.addresses[n2].address.length);
            b2.write(this.addresses[n2].address, 0, this.addresses[n2].address.length);
            ++n2;
        }
    }

    public InetAddress[] getInetAddresses() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(this.addresses.length);
        int n2 = 0;
        while (n2 < this.addresses.length) {
            try {
                if (this.addresses[n2].addrType == 2) {
                    arrayList.add(this.addresses[n2].getInetAddress());
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            ++n2;
        }
        InetAddress[] inetAddressArray = new InetAddress[arrayList.size()];
        return arrayList.toArray(inetAddressArray);
    }

    public static HostAddresses getLocalAddresses() throws IOException {
        Object object;
        String string = null;
        InetAddress[] inetAddressArray = null;
        HostAddresses hostAddresses = null;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
            inetAddressArray = InetAddress.getAllByName(string);
            HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
            int n2 = 0;
            while (n2 < inetAddressArray.length) {
                hostAddressArray[n2] = new HostAddress(inetAddressArray[n2]);
                ++n2;
            }
            hostAddresses = new HostAddresses(hostAddressArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        if (Krb5Debug.on(9)) {
            object = new Krb5Debug(HostAddresses.a("5\"/1\u0015\u0019). '\u000e(/\u007f") + Thread.currentThread().getName() + HostAddresses.a("Gm"));
            ((Krb5Debug)object).out(9, HostAddresses.a("Csbe\u001f\u000f/\u0017!7/(-e8\u0012.=)t\u001c)871\u000e>96t\u001b\".e") + string + HostAddresses.a("],. n]"));
            int n3 = 0;
            while (n3 < inetAddressArray.length) {
                ((Krb5Debug)object).out(9, HostAddresses.a("wD") + inetAddressArray[n3]);
                ++n3;
            }
        }
        return hostAddresses;
    }

    public HostAddresses(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new HostAddress[inetAddressArray.length];
        int n2 = 0;
        while (n2 < inetAddressArray.length) {
            this.addresses[n2] = new HostAddress(inetAddressArray[n2]);
            ++n2;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 125;
                        break;
                    }
                    case 1: {
                        n5 = 77;
                        break;
                    }
                    case 2: {
                        n5 = 92;
                        break;
                    }
                    case 3: {
                        n5 = 69;
                        break;
                    }
                    default: {
                        n5 = 84;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

