/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.KDCReqBody;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.PAData;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class KDCReq {
    private int a;
    private int b;
    private PAData[] c;
    private KDCReqBody d;

    public KDCReq(PAData[] pADataArray, KDCReqBody kDCReqBody, int n2) {
        this.a = 5;
        this.b = n2;
        this.c = pADataArray;
        this.d = kDCReqBody;
    }

    public KDCReq() {
    }

    public KDCReq(byte[] byArray, int n2) throws Asn1Exception, IOException, KrbException {
        this.a(new DerValue(byArray), n2);
    }

    public KDCReq(DerValue derValue, int n2) throws Asn1Exception, IOException, KrbException {
        this.a(derValue, n2);
    }

    protected void a(DerValue derValue, int n2) throws Asn1Exception, IOException, KrbException {
        DerValue derValue2;
        BigInteger bigInteger;
        if ((derValue.getTag() & 0x1F) != n2) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue.getData().getDerValue();
        if (derValue3.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue4 = derValue3.getData().getDerValue();
        if ((derValue4.getTag() & 0x1F) == 1) {
            bigInteger = derValue4.getData().getBigInteger();
            this.a = bigInteger.intValue();
            if (this.a != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue4 = derValue3.getData().getDerValue();
        if ((derValue4.getTag() & 0x1F) == 2) {
            bigInteger = derValue4.getData().getBigInteger();
            this.b = bigInteger.intValue();
            if (this.b != n2) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if ((derValue3.getData().peekByte() & 0x1F) == 3) {
            derValue4 = derValue3.getData().getDerValue();
            derValue2 = derValue4.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            Vector<PAData> vector = new Vector<PAData>();
            while (derValue2.getData().available() > 0) {
                vector.addElement(new PAData(derValue2.getData().getDerValue()));
            }
            if (vector.size() > 0) {
                this.c = new PAData[vector.size()];
                vector.copyInto(this.c);
            }
        } else {
            this.c = null;
        }
        derValue4 = derValue3.getData().getDerValue();
        if ((derValue4.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue4.getData().getDerValue();
        this.d = new KDCReqBody(derValue2, this.b);
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.a));
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.b));
        derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream2);
        if (this.c != null && this.c.length > 0) {
            derOutputStream2 = new DerOutputStream();
            int n2 = 0;
            while (n2 < this.c.length) {
                derOutputStream2.write(this.c[n2].asn1Encode());
                ++n2;
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream2);
            derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.d.asn1Encode(this.b));
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream3);
        derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)64, (boolean)true, (byte)((byte)this.b)), derOutputStream);
        return derOutputStream3.toByteArray();
    }

    public byte[] asn1EncodeReqBody() throws Asn1Exception, IOException {
        return this.d.asn1Encode(this.b);
    }

    public PAData[] getPAData() {
        return this.c;
    }

    public KDCReqBody getRequestBody() {
        return this.d;
    }

    public int getMessageType() {
        return this.b;
    }

    public int getProtocolVersionNumber() {
        return this.a;
    }
}

