/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.internal.LoginOptions;
import com.ibm.security.krb5.internal.util.c;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class TicketFlags
extends c {
    public TicketFlags() {
        super(32);
    }

    public TicketFlags(boolean[] blArray) throws Asn1Exception {
        super(blArray);
        if (blArray.length > 32) {
            throw new Asn1Exception(502);
        }
    }

    public TicketFlags(int n2, byte[] byArray) throws Asn1Exception {
        super(n2, byArray);
        if (n2 > byArray.length * 8 || n2 > 32) {
            throw new Asn1Exception(502);
        }
    }

    public TicketFlags(DerValue derValue) throws IOException, Asn1Exception {
        this(derValue.getUnalignedBitString(true).toBooleanArray());
    }

    public static TicketFlags parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new TicketFlags(derValue2);
    }

    public byte[] asn1Encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUnalignedBitString(new BitArray(this.a()));
        return derOutputStream.toByteArray();
    }

    public Object clone() {
        try {
            return new TicketFlags(this.a());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean match(LoginOptions loginOptions) {
        boolean bl2 = false;
        if (this.get(1) == loginOptions.get(1) && this.get(3) == loginOptions.get(3) && this.get(8) == loginOptions.get(8)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean match(TicketFlags ticketFlags) {
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < 12) {
            if (this.get(n2) != ticketFlags.get(n2)) {
                return false;
            }
            ++n2;
        }
        return bl2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = this.a();
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                switch (n2) {
                    case 0: {
                        stringBuffer.append(TicketFlags.a("NXh\u0005=JX\u007f{"));
                        break;
                    }
                    case 1: {
                        stringBuffer.append(TicketFlags.a("ZRi\u0017.NYz\u0002#Y&"));
                        break;
                    }
                    case 2: {
                        stringBuffer.append(TicketFlags.a("ZRi\u0017.NY~\u0004T"));
                        break;
                    }
                    case 3: {
                        stringBuffer.append(TicketFlags.a("LOt\u0018&]_w\u0005T"));
                        break;
                    }
                    case 4: {
                        stringBuffer.append(TicketFlags.a("LOt\u00186'"));
                        break;
                    }
                    case 5: {
                        stringBuffer.append(TicketFlags.a("Q\\bm?SNo\u0004.HX\u0000"));
                        break;
                    }
                    case 6: {
                        stringBuffer.append(TicketFlags.a("LRh\u0014+]I~\u0004T"));
                        break;
                    }
                    case 7: {
                        stringBuffer.append(TicketFlags.a("USm\u0001#UY\u0000"));
                        break;
                    }
                    case 8: {
                        stringBuffer.append(TicketFlags.a("NXu\u00058]_w\u0005T"));
                        break;
                    }
                    case 9: {
                        stringBuffer.append(TicketFlags.a("USr\u0014&]Q\u0000"));
                        break;
                    }
                    case 10: {
                        stringBuffer.append(TicketFlags.a("LO~m.IIs\u0005!H&"));
                        break;
                    }
                    case 11: {
                        stringBuffer.append(TicketFlags.a("TJ\u0016\u0001:HU~\u000e;'"));
                    }
                }
            }
            ++n2;
        }
        String string = stringBuffer.toString();
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 28;
                        break;
                    }
                    case 1: {
                        n5 = 29;
                        break;
                    }
                    case 2: {
                        n5 = 59;
                        break;
                    }
                    case 3: {
                        n5 = 64;
                        break;
                    }
                    default: {
                        n5 = 111;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

