/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi;

import com.ibm.oti.rmi.EndpointID;
import com.ibm.oti.rmi.RefInfo;
import com.ibm.oti.rmi.util.Msg;
import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.Hashtable;

public class RMIClientTable {
    private static final RMIClientTable[] tables;
    private static final int tablesSize;
    private static final RMIClientTable shortLeaseObjects;
    private static final RMIClientTable unrefObjs;
    private static final int timeInterval = 30000;
    private static final int maxDelta = 3;
    private static int currentTableIndex;
    private Hashtable endpointTo_idToRefInfo;
    private long deathTime;
    public int index;

    static {
        tablesSize = 10;
        currentTableIndex = 0;
        tables = new RMIClientTable[tablesSize];
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < tablesSize) {
            RMIClientTable.tables[i] = new RMIClientTable(time, i);
            time += 30000L;
            ++i;
        }
        shortLeaseObjects = new RMIClientTable(0L, -1);
        unrefObjs = new RMIClientTable(0L, -2);
    }

    public static RMIClientTable nextTable() {
        RMIClientTable[] rMIClientTableArray = tables;
        synchronized (tables) {
            RMIClientTable objs = tables[currentTableIndex];
            if (System.currentTimeMillis() > objs.deathTime) {
                objs.deathTime += (long)(30000 * tablesSize);
                ++currentTableIndex;
                currentTableIndex %= tablesSize;
                // ** MonitorExit[var0] (shouldn't be in output)
                return objs;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public static RMIClientTable shortLeaseObjects() {
        return shortLeaseObjects;
    }

    public static RMIClientTable unrefObjs() {
        return unrefObjs;
    }

    public static RMIClientTable resetUnrefObjs() {
        RMIClientTable rMIClientTable = unrefObjs;
        synchronized (rMIClientTable) {
            RMIClientTable copy = new RMIClientTable(0L, -2, RMIClientTable.unrefObjs.endpointTo_idToRefInfo);
            RMIClientTable.unrefObjs.endpointTo_idToRefInfo = new Hashtable();
            return copy;
        }
    }

    public static RMIClientTable tableAt(int i) {
        if (i >= 0) {
            return tables[i];
        }
        if (i == -1) {
            return shortLeaseObjects;
        }
        if (i == -2) {
            return unrefObjs;
        }
        throw new Error(Msg.getString("R0003"));
    }

    public static synchronized RefInfo putClient(EndpointID epid, ObjID id, long newDeathTime) {
        RMIClientTable rMIClientTable;
        RMIClientTable t;
        int i2 = -2;
        while (i2 < tablesSize) {
            rMIClientTable = t = RMIClientTable.tableAt(i2);
            synchronized (rMIClientTable) {
                RefInfo refInfo = t.getRefInfo(epid, id);
                if (refInfo != null) {
                    refInfo.incRefCount();
                    t.repositionObj(epid, id, newDeathTime);
                    return refInfo;
                }
            }
            ++i2;
        }
        if (newDeathTime < 30000L) {
            RMIClientTable i2 = shortLeaseObjects;
            synchronized (i2) {
                return shortLeaseObjects.putObjID(epid, id);
            }
        }
        int newIndex = (int)(newDeathTime % (long)(30000 * tablesSize * 2)) + currentTableIndex;
        rMIClientTable = t = RMIClientTable.tableAt(newIndex %= tablesSize);
        synchronized (rMIClientTable) {
            return t.putObjID(epid, id);
        }
    }

    public static void repositionObj(EndpointID epid, ObjID id, RefInfo refInfo) {
        RMIClientTable objs;
        RMIClientTable rMIClientTable = objs = RMIClientTable.tableAt(refInfo.getIndex());
        synchronized (rMIClientTable) {
            objs.repositionObj(epid, id, -1L);
        }
    }

    private RMIClientTable(long deathTime, int index) {
        this(deathTime, index, new Hashtable());
    }

    private RMIClientTable(long deathTime, int index, Hashtable endpointTo_idToRefInfo) {
        this.deathTime = deathTime;
        this.index = index;
        this.endpointTo_idToRefInfo = endpointTo_idToRefInfo;
    }

    public void repositionObj(EndpointID epid, ObjID id, long newDeathTime) {
        if (newDeathTime == -1L) {
            RMIClientTable objs;
            RMIClientTable rMIClientTable = objs = RMIClientTable.unrefObjs();
            synchronized (rMIClientTable) {
                this.repositionObj(epid, id, objs);
            }
            return;
        }
        if (newDeathTime < 30000L) {
            RMIClientTable objs = shortLeaseObjects;
            synchronized (objs) {
                this.repositionObj(epid, id, shortLeaseObjects);
            }
            return;
        }
        int newIndex = (int)(newDeathTime % (long)(30000 * tablesSize * 2)) + currentTableIndex;
        newIndex %= tablesSize;
        if (this == shortLeaseObjects) {
            RMIClientTable t;
            newIndex = newIndex == 0 ? tablesSize - 1 : newIndex - 1;
            RMIClientTable rMIClientTable = t = RMIClientTable.tableAt(newIndex);
            synchronized (rMIClientTable) {
                this.repositionObj(epid, id, t);
            }
        }
        if (newIndex != this.index) {
            int delta = newIndex > this.index ? newIndex - this.index : this.index - newIndex;
            int n = delta = tablesSize - delta >= delta ? delta : tablesSize - delta;
            if (delta > 3) {
                RMIClientTable t;
                RMIClientTable rMIClientTable = t = RMIClientTable.tableAt(newIndex);
                synchronized (rMIClientTable) {
                    this.repositionObj(epid, id, t);
                }
            }
        }
    }

    private void repositionObj(EndpointID epid, ObjID id, RMIClientTable newTable) {
        RefInfo refInfo;
        if (this == newTable) {
            return;
        }
        Hashtable oldIdToRefInfo = (Hashtable)this.endpointTo_idToRefInfo.get(epid);
        Hashtable<ObjID, RefInfo> newIdToRefInfo = (Hashtable<ObjID, RefInfo>)newTable.endpointTo_idToRefInfo.get(epid);
        if (oldIdToRefInfo.size() > 1) {
            refInfo = (RefInfo)oldIdToRefInfo.remove(id);
            if (newIdToRefInfo == null) {
                newIdToRefInfo = new Hashtable<ObjID, RefInfo>();
                newTable.endpointTo_idToRefInfo.put(epid, newIdToRefInfo);
            }
            newIdToRefInfo.put(id, refInfo);
        } else {
            if (newIdToRefInfo == null) {
                refInfo = (RefInfo)oldIdToRefInfo.get(id);
                newTable.endpointTo_idToRefInfo.put(epid, oldIdToRefInfo);
            } else {
                refInfo = (RefInfo)oldIdToRefInfo.remove(id);
                newIdToRefInfo.put(id, refInfo);
            }
            this.endpointTo_idToRefInfo.remove(epid);
        }
        refInfo.setIndex(newTable.index);
    }

    public int size() {
        return this.endpointTo_idToRefInfo.size();
    }

    private RefInfo putObjID(EndpointID epid, ObjID id) {
        RefInfo refInfo = null;
        Hashtable<ObjID, RefInfo> idToRefInfo = (Hashtable<ObjID, RefInfo>)this.endpointTo_idToRefInfo.get(epid);
        if (idToRefInfo == null) {
            idToRefInfo = new Hashtable<ObjID, RefInfo>();
            this.endpointTo_idToRefInfo.put(epid, idToRefInfo);
        } else {
            refInfo = (RefInfo)idToRefInfo.get(id);
        }
        if (refInfo == null) {
            refInfo = new RefInfo();
        }
        refInfo.incRefCount();
        idToRefInfo.put(id, refInfo);
        refInfo.setIndex(this.index);
        return refInfo;
    }

    public RefInfo getRefInfo(EndpointID epid, ObjID id) {
        Hashtable idToRefInfo = (Hashtable)this.endpointTo_idToRefInfo.get(epid);
        if (idToRefInfo == null) {
            return null;
        }
        return (RefInfo)idToRefInfo.get(id);
    }

    public Hashtable getReferencedObjIDs(EndpointID epid) {
        Hashtable idToRefInfo = (Hashtable)this.endpointTo_idToRefInfo.get(epid);
        if (idToRefInfo == null) {
            return new Hashtable();
        }
        return idToRefInfo;
    }

    public Enumeration getEndpoints() {
        return this.endpointTo_idToRefInfo.keys();
    }
}

