/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class RMIObjectOutputStream
extends ObjectOutputStream {
    public RMIObjectOutputStream(OutputStream output) throws IOException {
        super(output);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return RMIObjectOutputStream.this.enable();
            }
        });
    }

    private Object enable() {
        this.enableReplaceObject(true);
        return null;
    }

    protected void annotateClass(Class aClass) throws IOException {
        String urls = RMIClassLoader.getClassAnnotation(aClass);
        this.writeObject(urls);
    }

    protected Object replaceObject(Object object) throws IOException {
        if (object instanceof Remote) {
            return RemoteObject.toStub((Remote)object);
        }
        return object;
    }
}

