/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi;

import com.ibm.oti.rmi.UnicastRef;
import com.ibm.oti.rmi.util.RMIUtil;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteStub;
import java.util.Enumeration;
import java.util.Hashtable;

public class RMIServerTable {
    public static final int tablesSize = 10;
    private static final int timeInterval = 60000;
    private static final RMIServerTable[] tables = new RMIServerTable[10];
    private static final ReferenceQueue refQueue;
    private static int currentTableIndex;
    private static final Hashtable roToStub;
    private static final Hashtable classToInterfaces;
    private static final Hashtable interfacesToMths;
    private final Hashtable idToRO;
    private long deathTime;
    private long nextDeathTime;
    public int index;
    private final Hashtable idToMethodCallCount;

    static {
        long time = System.currentTimeMillis();
        int index = 0;
        int i = 0;
        while (i < 10) {
            index = (int)(time / 60000L % 10L);
            RMIServerTable.tables[index] = new RMIServerTable(time, index);
            time += 60000L;
            ++i;
        }
        currentTableIndex = (index + 1) % 10;
        roToStub = new Hashtable();
        classToInterfaces = new Hashtable();
        interfacesToMths = new Hashtable();
        refQueue = new ReferenceQueue();
        RMIWeakReferenceCollector refGC = new RMIWeakReferenceCollector("RMI-Ref GC");
        refGC.setDaemon(true);
        refGC.start();
    }

    public static RMIServerTable nextTable() {
        RMIServerTable[] rMIServerTableArray = tables;
        synchronized (tables) {
            RMIServerTable objs = tables[currentTableIndex];
            if (System.currentTimeMillis() > objs.deathTime) {
                ++currentTableIndex;
                currentTableIndex %= 10;
                // ** MonitorExit[var0] (shouldn't be in output)
                return objs;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public static void putServer(Remote ro, RemoteStub stub, ObjID id) throws IOException {
        RMIServerTable t = RMIServerTable.tableFor(id);
        Hashtable idToRO = t.idToRO;
        RemoteWrapper rw = new RemoteWrapper(ro);
        idToRO.put(id, rw);
        roToStub.put(rw, stub);
        RMIServerTable.addMethods(ro.getClass());
    }

    public static boolean removeServer(Remote ro, boolean force) {
        Hashtable hashtable = roToStub;
        synchronized (hashtable) {
            RemoteWrapper temp_rw = new RemoteWrapper(ro);
            RemoteStub stub = (RemoteStub)roToStub.get(temp_rw);
            if (stub != null) {
                ObjID id = ((UnicastRef)stub.getRef()).getID();
                RMIServerTable t = RMIServerTable.tableFor(id);
                Hashtable idToRO = t.idToRO;
                boolean canremove = true;
                Hashtable idToCount = t.idToMethodCallCount;
                Long callcount = (Long)idToCount.get(id);
                if (callcount != null && callcount > 0L) {
                    canremove = false;
                }
                if (canremove || force) {
                    RemoteWrapper rw = (RemoteWrapper)idToRO.get(id);
                    rw.makeWeak();
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public static void increaseCallCount(ObjID id) {
        RMIServerTable t = RMIServerTable.tableFor(id);
        Hashtable idToCount = t.idToMethodCallCount;
        Long callcount = (Long)idToCount.get(id);
        if (callcount == null) {
            idToCount.put(id, new Long(1L));
        } else {
            idToCount.put(id, new Long(callcount + 1L));
        }
    }

    public static void decreaseCallCount(ObjID id) {
        RMIServerTable t = RMIServerTable.tableFor(id);
        Hashtable idToCount = t.idToMethodCallCount;
        Long callcount = (Long)idToCount.get(id);
        if (callcount != null) {
            idToCount.put(id, new Long(callcount - 1L));
        }
    }

    public static Remote getObj(ObjID id) {
        RMIServerTable t = RMIServerTable.tableFor(id);
        return t.getRemoteObj(id, false);
    }

    public static RMIServerTable tableFor(ObjID id) {
        int i = id.hashCode();
        i = i / 10 % 10;
        return tables[i];
    }

    public static int idIndex() {
        return (int)(System.currentTimeMillis() / 60000L % 10L);
    }

    public static RemoteStub getStub(Remote ro) {
        if (ro == null) {
            return null;
        }
        RemoteWrapper temp_rw = new RemoteWrapper(ro);
        return (RemoteStub)roToStub.get(temp_rw);
    }

    public static void makeStrong(ObjID id) {
        RMIServerTable t = RMIServerTable.tableFor(id);
        RemoteWrapper rw = (RemoteWrapper)t.idToRO.get(id);
        if (rw != null) {
            rw.makeStrong();
        }
    }

    private static void addMethods(Class roClass) throws IOException {
        Hashtable hashtable = classToInterfaces;
        synchronized (hashtable) {
            if (classToInterfaces.get(roClass) != null) {
                return;
            }
            Class[] remoteInterfaces = RMIUtil.getAllRemoteInterfaces(roClass);
            classToInterfaces.put(roClass, remoteInterfaces);
            int i = 0;
            int length = remoteInterfaces.length;
            while (i < length) {
                if (interfacesToMths.get(remoteInterfaces[i]) == null) {
                    interfacesToMths.put(remoteInterfaces[i], RMIServerTable.hashToMthFor(remoteInterfaces[i]));
                }
                ++i;
            }
        }
    }

    private static Hashtable hashToMthFor(Class c) throws IOException {
        Hashtable<Long, Method> result = new Hashtable<Long, Method>();
        Method[] mths = c.getDeclaredMethods();
        int i = 0;
        int length = mths.length;
        while (i < length) {
            result.put(new Long(RMIUtil.hashFor(mths[i])), mths[i]);
            ++i;
        }
        return result;
    }

    public static Method getMethod(Remote ro, long hash) {
        Hashtable hashtable = classToInterfaces;
        synchronized (hashtable) {
            Class[] interf = (Class[])classToInterfaces.get(ro.getClass());
            if (interf != null) {
                Long h = new Long(hash);
                int i = 0;
                int length = interf.length;
                while (i < length) {
                    Hashtable hashToMth = (Hashtable)interfacesToMths.get(interf[i]);
                    Method m = (Method)hashToMth.get(h);
                    if (m != null) {
                        return m;
                    }
                    ++i;
                }
            }
            return null;
        }
    }

    private RMIServerTable(long deathTime, int index) {
        this.deathTime = deathTime;
        this.nextDeathTime = deathTime + 600000L;
        this.index = index;
        this.idToRO = new Hashtable();
        this.idToMethodCallCount = new Hashtable();
    }

    public long deathTime() {
        return this.deathTime;
    }

    public void updateDeathTime() {
        this.deathTime = this.nextDeathTime;
        this.nextDeathTime += 600000L;
    }

    public long nextDeathTime() {
        return this.nextDeathTime;
    }

    public Enumeration getExportedObjIDs() {
        return this.idToRO.keys();
    }

    public Remote getRemoteObj(ObjID id, boolean makeStrong) {
        Hashtable hashtable = this.idToRO;
        synchronized (hashtable) {
            RemoteWrapper rw = (RemoteWrapper)this.idToRO.get(id);
            if (rw == null) {
                return null;
            }
            if (makeStrong) {
                rw.makeStrong();
            }
            return (Remote)rw.get();
        }
    }

    static class RMIWeakReferenceCollector
    extends Thread {
        public RMIWeakReferenceCollector(String name) {
            super(name);
        }

        public void run() {
            while (true) {
                try {
                    Reference ro = refQueue.remove();
                    Hashtable hashtable = roToStub;
                    synchronized (hashtable) {
                        RemoteStub stub = (RemoteStub)roToStub.get(ro);
                        if (stub != null) {
                            ObjID id = ((UnicastRef)stub.getRef()).getID();
                            RMIServerTable t = RMIServerTable.tableFor(id);
                            Hashtable idToRO = t.idToRO;
                            idToRO.remove(id);
                            roToStub.remove(ro);
                        }
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static class RemoteWrapper
    extends WeakReference {
        int hashCode;
        Object remote;

        public RemoteWrapper(Object o) {
            super(o, refQueue);
            this.remote = o;
            this.hashCode = o.hashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RemoteWrapper)) {
                return false;
            }
            Object r = this.get();
            if (r == null) {
                return false;
            }
            Object ro = ((RemoteWrapper)obj).get();
            return r.equals(ro);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "RemoteWrapper: [" + this.get() + "]";
        }

        public void makeStrong() {
            this.remote = this.get();
        }

        public void makeWeak() {
            this.remote = null;
            this.clear();
        }
    }
}

