/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi;

import com.ibm.oti.rmi.RemoteCallImpl;
import com.ibm.oti.rmi.UnicastRef;
import com.ibm.oti.rmi.wire.ProtocolClient;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteObject;

public class RemoteCallClient
extends RemoteCallImpl {
    ProtocolClient protocol;
    RemoteObject obj;
    Operation[] ops;
    int opnum;
    long hash;
    ObjectOutput oos;
    ObjectInput ois;

    public RemoteCallClient(RemoteObject obj, Operation[] ops, int opnum, long hash) throws RemoteException {
        this.obj = obj;
        this.ops = ops;
        this.opnum = opnum;
        this.hash = hash;
        UnicastRef ref = (UnicastRef)obj.getRef();
        try {
            this.protocol = ProtocolClient.clientFor(ref.getEndpoint(), (byte)75, ref.getClientSocketFactory());
            this.protocol.sendMessageCallHeader();
            this.oos = this.protocol.createObjectOutput();
            this.protocol.sendMessageReceiver(this.oos, ((UnicastRef)obj.getRef()).getID(), opnum, hash);
        }
        catch (ConnectException ex) {
            throw new java.rmi.ConnectException(String.valueOf(ref.getHost()) + ":" + ref.getPort(), ex);
        }
        catch (java.net.UnknownHostException ex) {
            throw new UnknownHostException(ref.getHost(), ex);
        }
        catch (IOException ex) {
            throw new ConnectIOException(String.valueOf(ref.getHost()) + ":" + ref.getPort(), ex);
        }
    }

    public ObjectInput getInputStream() throws IOException {
        return this.ois;
    }

    public void invoke() throws Exception {
        if (this.oos == null) {
            this.protocol.flushOutputStream();
        } else {
            this.oos.flush();
        }
        this.protocol.waitReturnHeader();
        this.ois = this.protocol.createObjectInput();
        this.protocol.waitReturnValueHeader(this.ois);
    }

    public ObjectOutput getOutputStream() throws IOException {
        return this.oos;
    }

    public ObjectOutput getResultStream(boolean success) throws IOException {
        return null;
    }

    public void done() throws IOException {
        this.protocol.release();
    }

    public void flush() throws Exception {
        if (this.oos == null) {
            this.protocol.flushOutputStream();
        } else {
            this.oos.flush();
        }
    }
}

