/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi;

import com.ibm.oti.rmi.EndpointID;
import com.ibm.oti.rmi.RMIClientTable;
import com.ibm.oti.rmi.RMIServerTable;
import com.ibm.oti.rmi.RefInfo;
import com.ibm.oti.rmi.RemoteCallClient;
import com.ibm.oti.rmi.dgc.DGCClient;
import com.ibm.oti.rmi.util.Msg;
import com.ibm.oti.rmi.wire.ProtocolClient;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;

public class UnicastRef
implements RemoteRef {
    protected EndpointID endpoint;
    protected transient byte endPointFormat;
    protected ObjID id;
    protected transient RefInfo refInfo;
    public static final UID LocalUID = new UID();
    static /* synthetic */ Class class$0;

    public UnicastRef() {
    }

    public UnicastRef(EndpointID ep, ObjID id) {
        this.endpoint = ep;
        this.id = id;
        this.refInfo = new RefInfo();
        RMIServerTable t = RMIServerTable.tableFor(id);
        this.setDeathTime(t.nextDeathTime());
    }

    public UnicastRef(int port, ObjID id) throws UnknownHostException {
        this(new EndpointID(InetAddress.getLocalHost().getHostAddress(), port), id);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public String getHost() {
        return this.endpoint.getHost();
    }

    public EndpointID getEndpoint() {
        return this.endpoint;
    }

    public ObjID getID() {
        return this.id;
    }

    private String getRefClass() {
        String clName = this.getClass().getName();
        return clName.substring(clName.lastIndexOf(46) + 1);
    }

    public String getRefClass(ObjectOutput out) {
        return this.getRefClass();
    }

    public Object invoke(Remote receiver, Method mth, Object[] params, long opHash) throws Exception {
        ProtocolClient pc = ProtocolClient.clientFor(this.endpoint, (byte)75, this.getClientSocketFactory());
        pc.sendMessageCallHeader();
        ObjectOutput oos = pc.createObjectOutput();
        pc.sendMessageReceiver(oos, this.id, -1, opHash);
        Class<?>[] paramTypes = mth.getParameterTypes();
        if (params != null) {
            if (paramTypes.length != params.length) {
                throw new RuntimeException(mth + " is inconsistent with " + params);
            }
            try {
                int i = 0;
                while (i < params.length) {
                    pc.writeObject(paramTypes[i], params[i], oos);
                    ++i;
                }
            }
            catch (IOException e) {
                pc.markInvalid();
                throw new MarshalException(Msg.getString("R0010"), e);
            }
        }
        oos.flush();
        pc.waitReturnHeader();
        ObjectInput ois = pc.createObjectInput();
        pc.waitReturnValueHeader(ois);
        Class<?> returnType = mth.getReturnType();
        if (returnType != Void.TYPE) {
            try {
                Object result = pc.readObject(returnType, ois);
                pc.release();
                return result;
            }
            catch (Exception e) {
                pc.markInvalid();
                throw new UnmarshalException(Msg.getString("R0012"), e);
            }
        }
        pc.release();
        return null;
    }

    protected RMIClientSocketFactory getClientSocketFactory() {
        if (RMISocketFactory.getSocketFactory() != null) {
            return RMISocketFactory.getSocketFactory();
        }
        return RMISocketFactory.getDefaultSocketFactory();
    }

    public int remoteHashCode() {
        return this.id.hashCode();
    }

    public boolean remoteEquals(RemoteRef obj) {
        if (obj instanceof UnicastRef) {
            UnicastRef o = (UnicastRef)obj;
            return this.endpoint.equals(o.endpoint) && this.id.equals(o.id);
        }
        return false;
    }

    public String remoteToString() {
        return String.valueOf(this.getClass().getName()) + ":[" + this.getHost() + ":" + this.getPort() + "||" + this.id + "]";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeEndpointFormat(out);
        out.writeUTF(this.getHost());
        out.writeInt(this.getPort());
        this.writeSocketFactory(out);
        this.id.write(out);
        out.writeBoolean(false);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readEndpointFormat(in);
        String hostname = in.readUTF();
        this.endpoint = new EndpointID(hostname, in.readInt());
        this.readSocketFactory(in);
        this.id = ObjID.read(in);
        this.ensureDGCStubCreation(this.endpoint);
        this.refInfo = DGCClient.sendDirty(this.endpoint, this.id);
        in.readBoolean();
    }

    protected void ensureDGCStubCreation(EndpointID endpoint) {
        DGCClient.createDGCStubFor(endpoint, null);
    }

    protected void readEndpointFormat(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    protected void writeEndpointFormat(ObjectOutput out) throws IOException {
    }

    protected void readSocketFactory(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    protected void writeSocketFactory(ObjectOutput out) throws IOException {
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] ops, int opnum, long hash) throws RemoteException {
        return new RemoteCallClient(obj, ops, opnum, hash);
    }

    public void invoke(RemoteCall call) throws Exception {
        ((RemoteCallClient)call).invoke();
    }

    public void done(RemoteCall call) throws RemoteException {
        try {
            call.done();
        }
        catch (IOException iOException) {}
    }

    public void addReference(VMID vmid) {
        this.refInfo.addReference(vmid);
    }

    public boolean removeReference(VMID vmid) {
        return this.refInfo.removeReference(vmid);
    }

    public long getDeathTime() {
        return this.refInfo.getDeathTime();
    }

    public void setDeathTime(long time) {
        this.refInfo.setDeathTime(time);
    }

    protected void finalize() throws Throwable {
        try {
            this.refInfo.decRefCount();
            if (this.refInfo.referenceCount() == 0) {
                RMIClientTable.repositionObj(this.endpoint, this.id, this.refInfo);
            }
        }
        catch (Exception exception) {}
    }

    public String toString() {
        return String.valueOf(this.getRefClass()) + "[" + this.id.toString() + "]::" + super.toString();
    }
}

