/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi;

import com.ibm.oti.rmi.EndpointID;
import com.ibm.oti.rmi.UnicastRef;
import com.ibm.oti.rmi.dgc.DGCClient;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.UnknownHostException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;

public class UnicastRef2
extends UnicastRef {
    private RMIClientSocketFactory csFactory;

    public UnicastRef2() {
    }

    protected void ensureDGCStubCreation(EndpointID endpoint) {
        DGCClient.createDGCStubFor(endpoint, this.csFactory);
    }

    protected RMIClientSocketFactory getClientSocketFactory() {
        return this.csFactory;
    }

    public UnicastRef2(EndpointID ep, ObjID id, RMIClientSocketFactory csf) {
        super(ep, id);
        this.csFactory = csf;
    }

    public UnicastRef2(int port, ObjID id, RMIClientSocketFactory csf) throws UnknownHostException {
        super(port, id);
        this.csFactory = csf;
    }

    protected void readEndpointFormat(ObjectInput in) throws IOException, ClassNotFoundException {
        this.endPointFormat = in.readByte();
    }

    protected void writeEndpointFormat(ObjectOutput out) throws IOException {
        if (this.csFactory != null) {
            this.endPointFormat = 1;
            out.writeByte(1);
        } else {
            out.writeByte(0);
        }
    }

    protected void readSocketFactory(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this.endPointFormat == 1) {
            this.csFactory = (RMIClientSocketFactory)in.readObject();
        }
    }

    protected void writeSocketFactory(ObjectOutput out) throws IOException {
        if (this.csFactory != null) {
            out.writeObject(this.csFactory);
        }
    }
}

