/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.dgc;

import com.ibm.oti.rmi.EndpointID;
import com.ibm.oti.rmi.RMIClientTable;
import com.ibm.oti.rmi.RefInfo;
import com.ibm.oti.rmi.UnicastRef;
import com.ibm.oti.rmi.UnicastRef2;
import com.ibm.oti.rmi.dgc.DGCImpl;
import com.ibm.oti.rmi.util.Msg;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Enumeration;
import java.util.Hashtable;

public class DGCClient
extends Thread {
    static VMID localHostVMID;
    static Lease dirtyLease;
    static DGCClient defaultDGCClient;
    static long sequenceNumber;
    static final long defaultSleepTime = 10000L;
    long sleepTime = 10000L;
    private static Hashtable dgcStubs;
    static /* synthetic */ Class class$0;

    static {
        sequenceNumber = 0L;
        if (VMID.isUnique()) {
            localHostVMID = new VMID();
        }
        dirtyLease = new Lease(localHostVMID, DGCImpl.getLeaseValue());
        defaultDGCClient = new DGCClient("RMI-Leaser");
        defaultDGCClient.setDaemon(true);
        defaultDGCClient.setPriority(9);
        defaultDGCClient.start();
        dgcStubs = new Hashtable();
    }

    private DGCClient(String threadName) {
        super(threadName);
    }

    public void run() {
        while (Thread.currentThread() == defaultDGCClient) {
            RMIClientTable objs = RMIClientTable.resetUnrefObjs();
            this.handleObjects(false, objs);
            this.handleObjects(true, RMIClientTable.shortLeaseObjects());
            objs = RMIClientTable.nextTable();
            if (objs != null) {
                this.handleObjects(true, objs);
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void handleObjects(boolean sendDirty, RMIClientTable objs) {
        if (objs.size() == 0) {
            return;
        }
        RMIClientTable rMIClientTable = objs;
        synchronized (rMIClientTable) {
            if (objs.size() == 0) {
                return;
            }
            Enumeration endpoints = objs.getEndpoints();
            while (endpoints.hasMoreElements()) {
                EndpointID epid = (EndpointID)endpoints.nextElement();
                Hashtable objIDsTable = objs.getReferencedObjIDs(epid);
                if (objIDsTable.size() <= 0) continue;
                Enumeration objIDs = objIDsTable.keys();
                ObjID[] ids = new ObjID[objIDsTable.size()];
                int i = 0;
                while (i < ids.length) {
                    ids[i] = (ObjID)objIDs.nextElement();
                    ++i;
                }
                if (sendDirty) {
                    this.sendDirty(epid, ids, objs);
                    continue;
                }
                this.sendClean(epid, ids);
            }
        }
    }

    private void sendDirty(EndpointID epid, ObjID[] ids, RMIClientTable objs) {
        if (ids.length == 0) {
            return;
        }
        try {
            DGC dgc = DGCClient.dgcStubFor(epid);
            Lease l = dgc.dirty(ids, sequenceNumber, dirtyLease);
            if (localHostVMID == null) {
                localHostVMID = l.getVMID();
                dirtyLease = new Lease(localHostVMID, DGCImpl.getLeaseValue());
            }
            RMIClientTable rMIClientTable = objs;
            synchronized (rMIClientTable) {
                int i = 0;
                while (i < ids.length) {
                    objs.repositionObj(epid, ids[i], l.getValue());
                    ++i;
                }
            }
        }
        catch (RemoteException remoteException) {
            try {
                DGC dgc = DGCClient.dgcStubFor(epid);
                dgc.clean(ids, sequenceNumber, localHostVMID, true);
            }
            catch (ConnectIOException connectIOException) {
            }
            catch (ConnectException connectException) {
            }
            catch (RemoteException remoteException2) {}
        }
    }

    private RefInfo sendDirty0(EndpointID epid, ObjID id) {
        try {
            DGC dgc = DGCClient.dgcStubFor(epid);
            Lease l = dgc.dirty(new ObjID[]{id}, sequenceNumber, dirtyLease);
            if (localHostVMID == null) {
                localHostVMID = l.getVMID();
                dirtyLease = new Lease(localHostVMID, DGCImpl.getLeaseValue());
            }
            return RMIClientTable.putClient(epid, id, l.getValue());
        }
        catch (RemoteException remoteException) {
            try {
                DGC dgc = DGCClient.dgcStubFor(epid);
                Lease l = dgc.dirty(new ObjID[]{id}, sequenceNumber, dirtyLease);
                if (localHostVMID == null) {
                    localHostVMID = l.getVMID();
                    dirtyLease = new Lease(localHostVMID, DGCImpl.getLeaseValue());
                }
                return RMIClientTable.putClient(epid, id, l.getValue());
            }
            catch (ConnectIOException connectIOException) {
            }
            catch (ConnectException connectException) {
            }
            catch (RemoteException remoteException2) {}
            return null;
        }
    }

    public static RefInfo sendDirty(EndpointID epid, ObjID id) {
        return defaultDGCClient.sendDirty0(epid, id);
    }

    private void sendClean(EndpointID epid, ObjID[] ids) {
        if (ids.length == 0) {
            return;
        }
        try {
            DGC dgc = DGCClient.dgcStubFor(epid);
            dgc.clean(ids, sequenceNumber, localHostVMID, false);
        }
        catch (ConnectIOException connectIOException) {
        }
        catch (ConnectException connectException) {
        }
        catch (RemoteException remoteException) {}
    }

    public static DGC createDGCStubFor(EndpointID epid, RMIClientSocketFactory csf) {
        Hashtable hashtable = dgcStubs;
        synchronized (hashtable) {
            DGC stub = DGCClient.dgcStubFor(epid);
            if (stub != null) {
                return stub;
            }
            ObjID id = new ObjID(2);
            UnicastRef r = csf == null ? new UnicastRef(epid, id) : new UnicastRef2(epid, id, csf);
            try {
                Class<?> c = Class.forName("com.ibm.oti.rmi.dgc.DGCImpl_Stub");
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.rmi.server.RemoteRef");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Constructor<?> constructor = c.getConstructor(classArray);
                stub = (DGC)constructor.newInstance(r);
                dgcStubs.put(epid, stub);
                return stub;
            }
            catch (ClassNotFoundException ex) {
                throw new InternalError(String.valueOf(Msg.getString("R0004", "DGCImpl_Stub")) + ": " + ex);
            }
            catch (NoSuchMethodException ex) {
                throw new InternalError(String.valueOf(Msg.getString("R0004", "DGCImpl_Stub(RemoteRef r)")) + ": " + ex);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError(String.valueOf(Msg.getString("R0005", "DGCImpl_Stub(RemoteRef r)")) + ": " + ex);
            }
            catch (InstantiationException ex) {
                throw new InternalError(String.valueOf(Msg.getString("R0006", "DGCImpl_Stub")) + ": " + ex);
            }
            catch (InvocationTargetException ex) {
                throw new InternalError(String.valueOf(Msg.getString("R0006", "DGCImpl_Stub")) + ": " + ex.getTargetException());
            }
        }
    }

    private static DGC dgcStubFor(EndpointID epid) {
        Hashtable hashtable = dgcStubs;
        synchronized (hashtable) {
            DGC stub = (DGC)dgcStubs.get(epid);
            if (stub != null) {
                return stub;
            }
            return null;
        }
    }
}

