/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.rmi.dgc;

import com.ibm.oti.rmi.RMIServerTable;
import com.ibm.oti.rmi.UnicastRef;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;

public class DGCImpl
extends UnicastRemoteObject
implements DGC,
Runnable {
    private static long leaseValue = -1L;
    private static boolean initialized = false;
    static AsyncUnrefSender unrefSender = null;

    public Lease dirty(ObjID[] ids, long count, Lease lease) {
        VMID vmid = lease.getVMID();
        if (vmid == null) {
            vmid = new VMID();
        }
        long value = Long.MAX_VALUE;
        int i = 0;
        while (i < ids.length) {
            RMIServerTable t = RMIServerTable.tableFor(ids[i]);
            Remote ro = t.getRemoteObj(ids[i], true);
            if (ro != null) {
                UnicastRef r = (UnicastRef)RMIServerTable.getStub(ro).getRef();
                r.addReference(vmid);
                r.setDeathTime(t.nextDeathTime());
                value = value < t.nextDeathTime() ? value : t.nextDeathTime();
            }
            ++i;
        }
        value = (value -= System.currentTimeMillis()) < lease.getValue() ? value : lease.getValue();
        Lease l = new Lease(vmid, value);
        return l;
    }

    public void clean(ObjID[] ids, long p2, VMID vmid, boolean strong) {
        int i = 0;
        while (i < ids.length) {
            UnicastRef r;
            Remote ro = RMIServerTable.getObj(ids[i]);
            if (ro != null && (r = (UnicastRef)RMIServerTable.getStub(ro).getRef()).removeReference(vmid)) {
                try {
                    UnicastRemoteObject.unexportObject(ro, true);
                    if (ro instanceof Unreferenced) {
                        DGCImpl.unrefSender().add(ro);
                    }
                }
                catch (NoSuchObjectException noSuchObjectException) {}
            }
            ++i;
        }
    }

    public void run() {
        long sleepTime = DGCImpl.getLeaseValue() / 10L;
        while (true) {
            RMIServerTable t;
            block10: {
                t = RMIServerTable.nextTable();
                try {
                    if (t != null) break block10;
                    DGCImpl dGCImpl = this;
                    synchronized (dGCImpl) {
                        Thread.sleep(sleepTime);
                        while (t == null) {
                            Thread.sleep(sleepTime / 10L);
                            t = RMIServerTable.nextTable();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            Enumeration ids = t.getExportedObjIDs();
            while (ids.hasMoreElements()) {
                UnicastRef r;
                ObjID id = (ObjID)ids.nextElement();
                Remote ro = t.getRemoteObj(id, false);
                RemoteStub rs = RMIServerTable.getStub(ro);
                if (rs == null || (r = (UnicastRef)rs.getRef()).getDeathTime() > t.deathTime()) continue;
                try {
                    UnicastRemoteObject.unexportObject(ro, true);
                    if (!(ro instanceof Unreferenced)) continue;
                    DGCImpl.unrefSender().add(ro);
                }
                catch (NoSuchObjectException noSuchObjectException) {}
            }
            t.updateDeathTime();
        }
    }

    public static synchronized void initDGC() {
        if (!initialized) {
            try {
                initialized = true;
                Thread t = new Thread((Runnable)new DGCImpl(), "RMI-DGC");
                t.setPriority(9);
                t.start();
            }
            catch (RemoteException remoteException) {}
        }
    }

    static AsyncUnrefSender unrefSender() {
        if (unrefSender == null) {
            unrefSender = new AsyncUnrefSender("RMI-Unreferenced sender");
            unrefSender.start();
        }
        return unrefSender;
    }

    static long getLeaseValue() {
        if (leaseValue == -1L) {
            String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.rmi.dgc.leaseValue", "600000");
                }
            });
            try {
                leaseValue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                leaseValue = 600000L;
            }
        }
        return leaseValue;
    }

    static class AsyncUnrefSender
    extends Thread {
        Vector queue = new Vector();
        Object sync = new Object();

        public AsyncUnrefSender(String name) {
            super(name);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                Unreferenced unref;
                Object object = this.sync;
                synchronized (object) {
                    while (true) {
                        if (this.queue.size() != 0) {
                            unref = (Unreferenced)this.queue.remove(0);
                            break;
                        }
                        try {
                            this.sync.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                unref.unreferenced();
            }
        }

        public void add(Object ro) {
            Object object = this.sync;
            synchronized (object) {
                this.queue.add(ro);
                this.sync.notify();
            }
        }
    }
}

